/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.action;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Struct;
import java.util.Arrays;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.ChildPartitionsRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.DataChangeRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.HeartbeatRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.QueryChangeStreamAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.ChangeStreamDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.ChangeStreamResultSet;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.ChangeStreamResultSetMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.ChangeStreamRecordMapper;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.PartitionMetadataMapper;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChildPartitionsRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.DataChangeRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.HeartbeatRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.ThroughputEstimator;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class QueryChangeStreamActionTest {
    private static final String PARTITION_TOKEN = "partitionToken";
    private static final Timestamp PARTITION_START_TIMESTAMP = Timestamp.ofTimeMicroseconds((long)10L);
    private static final Timestamp PARTITION_END_TIMESTAMP = Timestamp.ofTimeMicroseconds((long)30L);
    private static final long PARTITION_HEARTBEAT_MILLIS = 30000L;
    private static final Instant WATERMARK = Instant.now();
    private static final Timestamp WATERMARK_TIMESTAMP = Timestamp.ofTimeMicroseconds((long)(WATERMARK.getMillis() * 1000L));
    private ChangeStreamDao changeStreamDao;
    private PartitionMetadataDao partitionMetadataDao;
    private PartitionMetadata partition;
    private ChangeStreamMetrics metrics;
    private ThroughputEstimator throughputEstimator;
    private TimestampRange restriction;
    private RestrictionTracker<TimestampRange, Timestamp> restrictionTracker;
    private DoFn.OutputReceiver<DataChangeRecord> outputReceiver;
    private ChangeStreamRecordMapper changeStreamRecordMapper;
    private PartitionMetadataMapper partitionMetadataMapper;
    private ManualWatermarkEstimator<Instant> watermarkEstimator;
    private DoFn.BundleFinalizer bundleFinalizer;
    private DataChangeRecordAction dataChangeRecordAction;
    private HeartbeatRecordAction heartbeatRecordAction;
    private ChildPartitionsRecordAction childPartitionsRecordAction;
    private QueryChangeStreamAction action;

    @Before
    public void setUp() throws Exception {
        this.changeStreamDao = (ChangeStreamDao)Mockito.mock(ChangeStreamDao.class);
        this.partitionMetadataDao = (PartitionMetadataDao)Mockito.mock(PartitionMetadataDao.class);
        this.changeStreamRecordMapper = (ChangeStreamRecordMapper)Mockito.mock(ChangeStreamRecordMapper.class);
        this.partitionMetadataMapper = (PartitionMetadataMapper)Mockito.mock(PartitionMetadataMapper.class);
        this.dataChangeRecordAction = (DataChangeRecordAction)Mockito.mock(DataChangeRecordAction.class);
        this.heartbeatRecordAction = (HeartbeatRecordAction)Mockito.mock(HeartbeatRecordAction.class);
        this.childPartitionsRecordAction = (ChildPartitionsRecordAction)Mockito.mock(ChildPartitionsRecordAction.class);
        this.metrics = (ChangeStreamMetrics)Mockito.mock(ChangeStreamMetrics.class);
        this.throughputEstimator = (ThroughputEstimator)Mockito.mock(ThroughputEstimator.class);
        this.action = new QueryChangeStreamAction(this.changeStreamDao, this.partitionMetadataDao, this.changeStreamRecordMapper, this.partitionMetadataMapper, this.dataChangeRecordAction, this.heartbeatRecordAction, this.childPartitionsRecordAction, this.metrics, this.throughputEstimator);
        Struct row = (Struct)Mockito.mock(Struct.class);
        this.partition = PartitionMetadata.newBuilder().setPartitionToken(PARTITION_TOKEN).setParentTokens(Sets.newHashSet((Object[])new String[]{"parentToken"})).setStartTimestamp(PARTITION_START_TIMESTAMP).setEndTimestamp(PARTITION_END_TIMESTAMP).setHeartbeatMillis(30000L).setState(PartitionMetadata.State.SCHEDULED).setWatermark(WATERMARK_TIMESTAMP).setScheduledAt(Timestamp.now()).build();
        this.restriction = (TimestampRange)Mockito.mock(TimestampRange.class);
        this.restrictionTracker = (RestrictionTracker)Mockito.mock(RestrictionTracker.class);
        this.outputReceiver = (DoFn.OutputReceiver)Mockito.mock(DoFn.OutputReceiver.class);
        this.watermarkEstimator = (ManualWatermarkEstimator)Mockito.mock(ManualWatermarkEstimator.class);
        this.bundleFinalizer = new BundleFinalizerStub();
        Mockito.when((Object)((TimestampRange)this.restrictionTracker.currentRestriction())).thenReturn((Object)this.restriction);
        Mockito.when((Object)this.restriction.getFrom()).thenReturn((Object)PARTITION_START_TIMESTAMP);
        Mockito.when((Object)this.restriction.getTo()).thenReturn((Object)PARTITION_END_TIMESTAMP);
        Mockito.when((Object)this.partitionMetadataDao.getPartition(PARTITION_TOKEN)).thenReturn((Object)row);
        Mockito.when((Object)this.partitionMetadataMapper.from(row)).thenReturn((Object)this.partition);
    }

    @Test
    public void testQueryChangeStreamWithDataChangeRecord() {
        Struct rowAsStruct = (Struct)Mockito.mock(Struct.class);
        ChangeStreamResultSetMetadata resultSetMetadata = (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class);
        ChangeStreamResultSet resultSet = (ChangeStreamResultSet)Mockito.mock(ChangeStreamResultSet.class);
        DataChangeRecord record1 = (DataChangeRecord)Mockito.mock(DataChangeRecord.class);
        DataChangeRecord record2 = (DataChangeRecord)Mockito.mock(DataChangeRecord.class);
        Mockito.when((Object)record1.getRecordTimestamp()).thenReturn((Object)PARTITION_START_TIMESTAMP);
        Mockito.when((Object)record2.getRecordTimestamp()).thenReturn((Object)PARTITION_START_TIMESTAMP);
        Mockito.when((Object)this.changeStreamDao.changeStreamQuery(PARTITION_TOKEN, PARTITION_START_TIMESTAMP, PARTITION_END_TIMESTAMP, 30000L)).thenReturn((Object)resultSet);
        Mockito.when((Object)resultSet.next()).thenReturn((Object)true);
        Mockito.when((Object)resultSet.getCurrentRowAsStruct()).thenReturn((Object)rowAsStruct);
        Mockito.when((Object)resultSet.getMetadata()).thenReturn((Object)resultSetMetadata);
        Mockito.when((Object)this.changeStreamRecordMapper.toChangeStreamRecords(this.partition, rowAsStruct, resultSetMetadata)).thenReturn(Arrays.asList(record1, record2));
        Mockito.when((Object)this.dataChangeRecordAction.run(this.partition, record1, this.restrictionTracker, this.outputReceiver, this.watermarkEstimator)).thenReturn(Optional.empty());
        Mockito.when((Object)this.dataChangeRecordAction.run(this.partition, record2, this.restrictionTracker, this.outputReceiver, this.watermarkEstimator)).thenReturn(Optional.of(DoFn.ProcessContinuation.stop()));
        Mockito.when((Object)this.watermarkEstimator.currentWatermark()).thenReturn((Object)WATERMARK);
        DoFn.ProcessContinuation result = this.action.run(this.partition, this.restrictionTracker, this.outputReceiver, this.watermarkEstimator, this.bundleFinalizer);
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)result);
        ((DataChangeRecordAction)Mockito.verify((Object)this.dataChangeRecordAction)).run(this.partition, record1, this.restrictionTracker, this.outputReceiver, this.watermarkEstimator);
        ((DataChangeRecordAction)Mockito.verify((Object)this.dataChangeRecordAction)).run(this.partition, record2, this.restrictionTracker, this.outputReceiver, this.watermarkEstimator);
        ((PartitionMetadataDao)Mockito.verify((Object)this.partitionMetadataDao)).updateWatermark(PARTITION_TOKEN, WATERMARK_TIMESTAMP);
        ((HeartbeatRecordAction)Mockito.verify((Object)this.heartbeatRecordAction, (VerificationMode)Mockito.never())).run((PartitionMetadata)ArgumentMatchers.any(), (HeartbeatRecord)ArgumentMatchers.any(), (RestrictionTracker)ArgumentMatchers.any(), (ManualWatermarkEstimator)ArgumentMatchers.any());
        ((ChildPartitionsRecordAction)Mockito.verify((Object)this.childPartitionsRecordAction, (VerificationMode)Mockito.never())).run((PartitionMetadata)ArgumentMatchers.any(), (ChildPartitionsRecord)ArgumentMatchers.any(), (RestrictionTracker)ArgumentMatchers.any(), (ManualWatermarkEstimator)ArgumentMatchers.any());
        ((RestrictionTracker)Mockito.verify(this.restrictionTracker, (VerificationMode)Mockito.never())).tryClaim((Object)((Timestamp)ArgumentMatchers.any()));
    }

    @Test
    public void testQueryChangeStreamWithHeartbeatRecord() {
        Struct rowAsStruct = (Struct)Mockito.mock(Struct.class);
        ChangeStreamResultSetMetadata resultSetMetadata = (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class);
        ChangeStreamResultSet resultSet = (ChangeStreamResultSet)Mockito.mock(ChangeStreamResultSet.class);
        HeartbeatRecord record1 = (HeartbeatRecord)Mockito.mock(HeartbeatRecord.class);
        HeartbeatRecord record2 = (HeartbeatRecord)Mockito.mock(HeartbeatRecord.class);
        Mockito.when((Object)record1.getRecordTimestamp()).thenReturn((Object)PARTITION_START_TIMESTAMP);
        Mockito.when((Object)record2.getRecordTimestamp()).thenReturn((Object)PARTITION_START_TIMESTAMP);
        Mockito.when((Object)this.changeStreamDao.changeStreamQuery(PARTITION_TOKEN, PARTITION_START_TIMESTAMP, PARTITION_END_TIMESTAMP, 30000L)).thenReturn((Object)resultSet);
        Mockito.when((Object)resultSet.next()).thenReturn((Object)true);
        Mockito.when((Object)resultSet.getCurrentRowAsStruct()).thenReturn((Object)rowAsStruct);
        Mockito.when((Object)resultSet.getMetadata()).thenReturn((Object)resultSetMetadata);
        Mockito.when((Object)this.changeStreamRecordMapper.toChangeStreamRecords(this.partition, rowAsStruct, resultSetMetadata)).thenReturn(Arrays.asList(record1, record2));
        Mockito.when((Object)this.heartbeatRecordAction.run(this.partition, record1, this.restrictionTracker, this.watermarkEstimator)).thenReturn(Optional.empty());
        Mockito.when((Object)this.heartbeatRecordAction.run(this.partition, record2, this.restrictionTracker, this.watermarkEstimator)).thenReturn(Optional.of(DoFn.ProcessContinuation.stop()));
        Mockito.when((Object)this.watermarkEstimator.currentWatermark()).thenReturn((Object)WATERMARK);
        DoFn.ProcessContinuation result = this.action.run(this.partition, this.restrictionTracker, this.outputReceiver, this.watermarkEstimator, this.bundleFinalizer);
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)result);
        ((HeartbeatRecordAction)Mockito.verify((Object)this.heartbeatRecordAction)).run(this.partition, record1, this.restrictionTracker, this.watermarkEstimator);
        ((HeartbeatRecordAction)Mockito.verify((Object)this.heartbeatRecordAction)).run(this.partition, record2, this.restrictionTracker, this.watermarkEstimator);
        ((PartitionMetadataDao)Mockito.verify((Object)this.partitionMetadataDao)).updateWatermark(PARTITION_TOKEN, WATERMARK_TIMESTAMP);
        ((DataChangeRecordAction)Mockito.verify((Object)this.dataChangeRecordAction, (VerificationMode)Mockito.never())).run((PartitionMetadata)ArgumentMatchers.any(), (DataChangeRecord)ArgumentMatchers.any(), (RestrictionTracker)ArgumentMatchers.any(), (DoFn.OutputReceiver)ArgumentMatchers.any(), (ManualWatermarkEstimator)ArgumentMatchers.any());
        ((ChildPartitionsRecordAction)Mockito.verify((Object)this.childPartitionsRecordAction, (VerificationMode)Mockito.never())).run((PartitionMetadata)ArgumentMatchers.any(), (ChildPartitionsRecord)ArgumentMatchers.any(), (RestrictionTracker)ArgumentMatchers.any(), (ManualWatermarkEstimator)ArgumentMatchers.any());
        ((RestrictionTracker)Mockito.verify(this.restrictionTracker, (VerificationMode)Mockito.never())).tryClaim((Object)((Timestamp)ArgumentMatchers.any()));
    }

    @Test
    public void testQueryChangeStreamWithChildPartitionsRecord() {
        Struct rowAsStruct = (Struct)Mockito.mock(Struct.class);
        ChangeStreamResultSetMetadata resultSetMetadata = (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class);
        ChangeStreamResultSet resultSet = (ChangeStreamResultSet)Mockito.mock(ChangeStreamResultSet.class);
        ChildPartitionsRecord record1 = (ChildPartitionsRecord)Mockito.mock(ChildPartitionsRecord.class);
        ChildPartitionsRecord record2 = (ChildPartitionsRecord)Mockito.mock(ChildPartitionsRecord.class);
        Mockito.when((Object)record1.getRecordTimestamp()).thenReturn((Object)PARTITION_START_TIMESTAMP);
        Mockito.when((Object)record2.getRecordTimestamp()).thenReturn((Object)PARTITION_START_TIMESTAMP);
        Mockito.when((Object)this.changeStreamDao.changeStreamQuery(PARTITION_TOKEN, PARTITION_START_TIMESTAMP, PARTITION_END_TIMESTAMP, 30000L)).thenReturn((Object)resultSet);
        Mockito.when((Object)resultSet.next()).thenReturn((Object)true);
        Mockito.when((Object)resultSet.getCurrentRowAsStruct()).thenReturn((Object)rowAsStruct);
        Mockito.when((Object)resultSet.getMetadata()).thenReturn((Object)resultSetMetadata);
        Mockito.when((Object)this.changeStreamRecordMapper.toChangeStreamRecords(this.partition, rowAsStruct, resultSetMetadata)).thenReturn(Arrays.asList(record1, record2));
        Mockito.when((Object)this.childPartitionsRecordAction.run(this.partition, record1, this.restrictionTracker, this.watermarkEstimator)).thenReturn(Optional.empty());
        Mockito.when((Object)this.childPartitionsRecordAction.run(this.partition, record2, this.restrictionTracker, this.watermarkEstimator)).thenReturn(Optional.of(DoFn.ProcessContinuation.stop()));
        Mockito.when((Object)this.watermarkEstimator.currentWatermark()).thenReturn((Object)WATERMARK);
        DoFn.ProcessContinuation result = this.action.run(this.partition, this.restrictionTracker, this.outputReceiver, this.watermarkEstimator, this.bundleFinalizer);
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)result);
        ((ChildPartitionsRecordAction)Mockito.verify((Object)this.childPartitionsRecordAction)).run(this.partition, record1, this.restrictionTracker, this.watermarkEstimator);
        ((ChildPartitionsRecordAction)Mockito.verify((Object)this.childPartitionsRecordAction)).run(this.partition, record2, this.restrictionTracker, this.watermarkEstimator);
        ((PartitionMetadataDao)Mockito.verify((Object)this.partitionMetadataDao)).updateWatermark(PARTITION_TOKEN, WATERMARK_TIMESTAMP);
        ((DataChangeRecordAction)Mockito.verify((Object)this.dataChangeRecordAction, (VerificationMode)Mockito.never())).run((PartitionMetadata)ArgumentMatchers.any(), (DataChangeRecord)ArgumentMatchers.any(), (RestrictionTracker)ArgumentMatchers.any(), (DoFn.OutputReceiver)ArgumentMatchers.any(), (ManualWatermarkEstimator)ArgumentMatchers.any());
        ((HeartbeatRecordAction)Mockito.verify((Object)this.heartbeatRecordAction, (VerificationMode)Mockito.never())).run((PartitionMetadata)ArgumentMatchers.any(), (HeartbeatRecord)ArgumentMatchers.any(), (RestrictionTracker)ArgumentMatchers.any(), (ManualWatermarkEstimator)ArgumentMatchers.any());
        ((RestrictionTracker)Mockito.verify(this.restrictionTracker, (VerificationMode)Mockito.never())).tryClaim((Object)((Timestamp)ArgumentMatchers.any()));
    }

    @Test
    public void testQueryChangeStreamWithRestrictionFromAfterPartitionStart() {
        Struct rowAsStruct = (Struct)Mockito.mock(Struct.class);
        ChangeStreamResultSetMetadata resultSetMetadata = (ChangeStreamResultSetMetadata)Mockito.mock(ChangeStreamResultSetMetadata.class);
        ChangeStreamResultSet resultSet = (ChangeStreamResultSet)Mockito.mock(ChangeStreamResultSet.class);
        ChildPartitionsRecord record1 = (ChildPartitionsRecord)Mockito.mock(ChildPartitionsRecord.class);
        ChildPartitionsRecord record2 = (ChildPartitionsRecord)Mockito.mock(ChildPartitionsRecord.class);
        Mockito.when((Object)this.restriction.getFrom()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)15L));
        Mockito.when((Object)record1.getRecordTimestamp()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)15L));
        Mockito.when((Object)record2.getRecordTimestamp()).thenReturn((Object)Timestamp.ofTimeMicroseconds((long)25L));
        Mockito.when((Object)this.changeStreamDao.changeStreamQuery(PARTITION_TOKEN, Timestamp.ofTimeMicroseconds((long)15L), PARTITION_END_TIMESTAMP, 30000L)).thenReturn((Object)resultSet);
        Mockito.when((Object)resultSet.next()).thenReturn((Object)true);
        Mockito.when((Object)resultSet.getCurrentRowAsStruct()).thenReturn((Object)rowAsStruct);
        Mockito.when((Object)resultSet.getMetadata()).thenReturn((Object)resultSetMetadata);
        Mockito.when((Object)this.changeStreamRecordMapper.toChangeStreamRecords(this.partition, rowAsStruct, resultSetMetadata)).thenReturn(Arrays.asList(record1, record2));
        Mockito.when((Object)this.childPartitionsRecordAction.run(this.partition, record2, this.restrictionTracker, this.watermarkEstimator)).thenReturn(Optional.of(DoFn.ProcessContinuation.stop()));
        Mockito.when((Object)this.watermarkEstimator.currentWatermark()).thenReturn((Object)WATERMARK);
        DoFn.ProcessContinuation result = this.action.run(this.partition, this.restrictionTracker, this.outputReceiver, this.watermarkEstimator, this.bundleFinalizer);
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)result);
        ((ChildPartitionsRecordAction)Mockito.verify((Object)this.childPartitionsRecordAction)).run(this.partition, record1, this.restrictionTracker, this.watermarkEstimator);
        ((ChildPartitionsRecordAction)Mockito.verify((Object)this.childPartitionsRecordAction)).run(this.partition, record2, this.restrictionTracker, this.watermarkEstimator);
        ((PartitionMetadataDao)Mockito.verify((Object)this.partitionMetadataDao)).updateWatermark(PARTITION_TOKEN, WATERMARK_TIMESTAMP);
        ((DataChangeRecordAction)Mockito.verify((Object)this.dataChangeRecordAction, (VerificationMode)Mockito.never())).run((PartitionMetadata)ArgumentMatchers.any(), (DataChangeRecord)ArgumentMatchers.any(), (RestrictionTracker)ArgumentMatchers.any(), (DoFn.OutputReceiver)ArgumentMatchers.any(), (ManualWatermarkEstimator)ArgumentMatchers.any());
        ((HeartbeatRecordAction)Mockito.verify((Object)this.heartbeatRecordAction, (VerificationMode)Mockito.never())).run((PartitionMetadata)ArgumentMatchers.any(), (HeartbeatRecord)ArgumentMatchers.any(), (RestrictionTracker)ArgumentMatchers.any(), (ManualWatermarkEstimator)ArgumentMatchers.any());
        ((RestrictionTracker)Mockito.verify(this.restrictionTracker, (VerificationMode)Mockito.never())).tryClaim((Object)((Timestamp)ArgumentMatchers.any()));
    }

    @Test
    public void testQueryChangeStreamWithStreamFinished() {
        ChangeStreamResultSet changeStreamResultSet = (ChangeStreamResultSet)Mockito.mock(ChangeStreamResultSet.class);
        Mockito.when((Object)this.changeStreamDao.changeStreamQuery(PARTITION_TOKEN, PARTITION_START_TIMESTAMP, PARTITION_END_TIMESTAMP, 30000L)).thenReturn((Object)changeStreamResultSet);
        Mockito.when((Object)changeStreamResultSet.next()).thenReturn((Object)false);
        Mockito.when((Object)this.watermarkEstimator.currentWatermark()).thenReturn((Object)WATERMARK);
        Mockito.when((Object)this.restrictionTracker.tryClaim((Object)PARTITION_END_TIMESTAMP)).thenReturn((Object)true);
        DoFn.ProcessContinuation result = this.action.run(this.partition, this.restrictionTracker, this.outputReceiver, this.watermarkEstimator, this.bundleFinalizer);
        Assert.assertEquals((Object)DoFn.ProcessContinuation.stop(), (Object)result);
        ((PartitionMetadataDao)Mockito.verify((Object)this.partitionMetadataDao)).updateWatermark(PARTITION_TOKEN, WATERMARK_TIMESTAMP);
        ((PartitionMetadataDao)Mockito.verify((Object)this.partitionMetadataDao)).updateToFinished(PARTITION_TOKEN);
        ((DataChangeRecordAction)Mockito.verify((Object)this.dataChangeRecordAction, (VerificationMode)Mockito.never())).run((PartitionMetadata)ArgumentMatchers.any(), (DataChangeRecord)ArgumentMatchers.any(), (RestrictionTracker)ArgumentMatchers.any(), (DoFn.OutputReceiver)ArgumentMatchers.any(), (ManualWatermarkEstimator)ArgumentMatchers.any());
        ((HeartbeatRecordAction)Mockito.verify((Object)this.heartbeatRecordAction, (VerificationMode)Mockito.never())).run((PartitionMetadata)ArgumentMatchers.any(), (HeartbeatRecord)ArgumentMatchers.any(), (RestrictionTracker)ArgumentMatchers.any(), (ManualWatermarkEstimator)ArgumentMatchers.any());
        ((ChildPartitionsRecordAction)Mockito.verify((Object)this.childPartitionsRecordAction, (VerificationMode)Mockito.never())).run((PartitionMetadata)ArgumentMatchers.any(), (ChildPartitionsRecord)ArgumentMatchers.any(), (RestrictionTracker)ArgumentMatchers.any(), (ManualWatermarkEstimator)ArgumentMatchers.any());
    }

    private static class BundleFinalizerStub
    implements DoFn.BundleFinalizer {
        private BundleFinalizerStub() {
        }

        public void afterBundleCommit(Instant callbackExpiry, DoFn.BundleFinalizer.Callback callback) {
            try {
                callback.onBundleSuccess();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

