/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.action;

import com.google.cloud.Timestamp;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.HeartbeatRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.HeartbeatRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class HeartbeatRecordActionTest {
    private HeartbeatRecordAction action;
    private PartitionMetadata partition;
    private RestrictionTracker<TimestampRange, Timestamp> tracker;
    private ManualWatermarkEstimator<Instant> watermarkEstimator;

    @Before
    public void setUp() {
        ChangeStreamMetrics metrics = (ChangeStreamMetrics)Mockito.mock(ChangeStreamMetrics.class);
        this.action = new HeartbeatRecordAction(metrics);
        this.partition = (PartitionMetadata)Mockito.mock(PartitionMetadata.class);
        this.tracker = (RestrictionTracker)Mockito.mock(RestrictionTracker.class);
        this.watermarkEstimator = (ManualWatermarkEstimator)Mockito.mock(ManualWatermarkEstimator.class);
    }

    @Test
    public void testRestrictionClaimed() {
        String partitionToken = "partitionToken";
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)10L);
        Mockito.when((Object)this.tracker.tryClaim((Object)timestamp)).thenReturn((Object)true);
        Mockito.when((Object)this.partition.getPartitionToken()).thenReturn((Object)"partitionToken");
        Optional maybeContinuation = this.action.run(this.partition, new HeartbeatRecord(timestamp, null), this.tracker, this.watermarkEstimator);
        Assert.assertEquals(Optional.empty(), (Object)maybeContinuation);
        ((ManualWatermarkEstimator)Mockito.verify(this.watermarkEstimator)).setWatermark(new Instant(timestamp.toSqlTimestamp().getTime()));
    }

    @Test
    public void testRestrictionNotClaimed() {
        String partitionToken = "partitionToken";
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)10L);
        Mockito.when((Object)this.tracker.tryClaim((Object)timestamp)).thenReturn((Object)false);
        Mockito.when((Object)this.partition.getPartitionToken()).thenReturn((Object)"partitionToken");
        Optional maybeContinuation = this.action.run(this.partition, new HeartbeatRecord(timestamp, null), this.tracker, this.watermarkEstimator);
        Assert.assertEquals(Optional.of(DoFn.ProcessContinuation.stop()), (Object)maybeContinuation);
        ((ManualWatermarkEstimator)Mockito.verify(this.watermarkEstimator, (VerificationMode)Mockito.never())).setWatermark((Instant)ArgumentMatchers.any());
    }
}

