/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.action;

import com.google.cloud.Timestamp;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.DataChangeRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.DataChangeRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.TimestampRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class DataChangeRecordActionTest {
    private DataChangeRecordAction action;
    private PartitionMetadata partition;
    private RestrictionTracker<TimestampRange, Timestamp> tracker;
    private DoFn.OutputReceiver<DataChangeRecord> outputReceiver;
    private ManualWatermarkEstimator<Instant> watermarkEstimator;

    @Before
    public void setUp() {
        this.action = new DataChangeRecordAction();
        this.partition = (PartitionMetadata)Mockito.mock(PartitionMetadata.class);
        this.tracker = (RestrictionTracker)Mockito.mock(RestrictionTracker.class);
        this.outputReceiver = (DoFn.OutputReceiver)Mockito.mock(DoFn.OutputReceiver.class);
        this.watermarkEstimator = (ManualWatermarkEstimator)Mockito.mock(ManualWatermarkEstimator.class);
    }

    @Test
    public void testRestrictionClaimed() {
        String partitionToken = "partitionToken";
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)10L);
        Instant instant = new Instant(timestamp.toSqlTimestamp().getTime());
        DataChangeRecord record = (DataChangeRecord)Mockito.mock(DataChangeRecord.class);
        Mockito.when((Object)record.getCommitTimestamp()).thenReturn((Object)timestamp);
        Mockito.when((Object)this.tracker.tryClaim((Object)timestamp)).thenReturn((Object)true);
        Mockito.when((Object)this.partition.getPartitionToken()).thenReturn((Object)"partitionToken");
        Optional maybeContinuation = this.action.run(this.partition, record, this.tracker, this.outputReceiver, this.watermarkEstimator);
        Assert.assertEquals(Optional.empty(), (Object)maybeContinuation);
        ((DoFn.OutputReceiver)Mockito.verify(this.outputReceiver)).outputWithTimestamp((Object)record, instant);
        ((ManualWatermarkEstimator)Mockito.verify(this.watermarkEstimator)).setWatermark(instant);
    }

    @Test
    public void testRestrictionNotClaimed() {
        String partitionToken = "partitionToken";
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)10L);
        DataChangeRecord record = (DataChangeRecord)Mockito.mock(DataChangeRecord.class);
        Mockito.when((Object)record.getCommitTimestamp()).thenReturn((Object)timestamp);
        Mockito.when((Object)this.tracker.tryClaim((Object)timestamp)).thenReturn((Object)false);
        Mockito.when((Object)this.partition.getPartitionToken()).thenReturn((Object)"partitionToken");
        Optional maybeContinuation = this.action.run(this.partition, record, this.tracker, this.outputReceiver, this.watermarkEstimator);
        Assert.assertEquals(Optional.of(DoFn.ProcessContinuation.stop()), (Object)maybeContinuation);
        ((DoFn.OutputReceiver)Mockito.verify(this.outputReceiver, (VerificationMode)Mockito.never())).outputWithTimestamp((Object)((DataChangeRecord)ArgumentMatchers.any()), (Instant)ArgumentMatchers.any());
        ((ManualWatermarkEstimator)Mockito.verify(this.watermarkEstimator, (VerificationMode)Mockito.never())).setWatermark((Instant)ArgumentMatchers.any());
    }
}

