/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Type;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpannerSchemaTest {
    @Test
    public void testSingleTable() throws Exception {
        SpannerSchema schema = SpannerSchema.builder().addColumn("test", "pk", "STRING(48)").addKeyPart("test", "pk", false).addColumn("test", "maxKey", "STRING(MAX)").addColumn("test", "numericVal", "NUMERIC").addColumn("test", "jsonVal", "JSON").build();
        Assert.assertEquals((long)1L, (long)schema.getTables().size());
        Assert.assertEquals((long)4L, (long)schema.getColumns("test").size());
        Assert.assertEquals((long)1L, (long)schema.getKeyParts("test").size());
        Assert.assertEquals((Object)Type.json(), (Object)((SpannerSchema.Column)schema.getColumns("test").get(3)).getType());
    }

    @Test
    public void testTwoTables() throws Exception {
        SpannerSchema schema = SpannerSchema.builder().addColumn("test", "pk", "STRING(48)").addKeyPart("test", "pk", false).addColumn("test", "maxKey", "STRING(MAX)").addColumn("other", "pk", "INT64").addKeyPart("other", "pk", true).addColumn("other", "maxKey", "STRING(MAX)").build();
        Assert.assertEquals((long)2L, (long)schema.getTables().size());
        Assert.assertEquals((long)2L, (long)schema.getColumns("test").size());
        Assert.assertEquals((long)1L, (long)schema.getKeyParts("test").size());
        Assert.assertEquals((long)2L, (long)schema.getColumns("other").size());
        Assert.assertEquals((long)1L, (long)schema.getKeyParts("other").size());
    }

    @Test
    public void testSinglePgTable() throws Exception {
        SpannerSchema schema = SpannerSchema.builder((Dialect)Dialect.POSTGRESQL).addColumn("test", "pk", "character varying(48)").addKeyPart("test", "pk", false).addColumn("test", "maxKey", "character varying").addColumn("test", "numericVal", "numeric").build();
        Assert.assertEquals((long)1L, (long)schema.getTables().size());
        Assert.assertEquals((long)3L, (long)schema.getColumns("test").size());
        Assert.assertEquals((long)1L, (long)schema.getKeyParts("test").size());
    }

    @Test
    public void testTwoPgTables() throws Exception {
        SpannerSchema schema = SpannerSchema.builder((Dialect)Dialect.POSTGRESQL).addColumn("test", "pk", "character varying(48)").addKeyPart("test", "pk", false).addColumn("test", "maxKey", "character varying").addColumn("other", "pk", "bigint").addKeyPart("other", "pk", true).addColumn("other", "maxKey", "character varying").build();
        Assert.assertEquals((long)2L, (long)schema.getTables().size());
        Assert.assertEquals((long)2L, (long)schema.getColumns("test").size());
        Assert.assertEquals((long)1L, (long)schema.getKeyParts("test").size());
        Assert.assertEquals((long)2L, (long)schema.getColumns("other").size());
        Assert.assertEquals((long)1L, (long)schema.getKeyParts("other").size());
    }
}

