/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.BatchClient;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.TimestampBound;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.spanner.CreateTransactionFn;
import org.apache.beam.sdk.io.gcp.spanner.RandomUtils;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.SpannerWriteIT;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpannerReadIT {
    private static final int MAX_DB_NAME_LENGTH = 30;
    @Rule
    public final transient TestPipeline p = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();
    private Spanner spanner;
    private DatabaseAdminClient databaseAdminClient;
    private SpannerTestPipelineOptions options;
    private String databaseName;
    private String pgDatabaseName;
    private String project;

    @Before
    public void setUp() throws Exception {
        PipelineOptionsFactory.register(SpannerTestPipelineOptions.class);
        this.options = (SpannerTestPipelineOptions)TestPipeline.testingPipelineOptions().as(SpannerTestPipelineOptions.class);
        this.project = this.options.getInstanceProjectId();
        if (this.project == null) {
            this.project = ((GcpOptions)this.options.as(GcpOptions.class)).getProject();
        }
        this.spanner = (Spanner)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(this.project)).build().getService();
        this.databaseName = this.generateDatabaseName();
        this.pgDatabaseName = "pg-" + this.databaseName;
        this.databaseAdminClient = this.spanner.getDatabaseAdminClient();
        this.databaseAdminClient.dropDatabase(this.options.getInstanceId(), this.databaseName);
        this.databaseAdminClient.dropDatabase(this.options.getInstanceId(), this.pgDatabaseName);
        OperationFuture op = this.databaseAdminClient.createDatabase(this.options.getInstanceId(), this.databaseName, Collections.singleton("CREATE TABLE " + this.options.getTable() + " (  Key           INT64,  Value         STRING(MAX),) PRIMARY KEY (Key)"));
        op.get();
        this.databaseAdminClient.createDatabase(this.databaseAdminClient.newDatabaseBuilder(DatabaseId.of((String)this.project, (String)this.options.getInstanceId(), (String)this.pgDatabaseName)).setDialect(Dialect.POSTGRESQL).build(), Collections.emptyList()).get();
        this.databaseAdminClient.updateDatabaseDdl(this.options.getInstanceId(), this.pgDatabaseName, Collections.singleton("CREATE TABLE " + this.options.getTable() + " (  Key           bigint,  Value         character varying,  PRIMARY KEY (Key))"), null).get();
        this.makeTestData();
    }

    @Test
    public void testRead() throws Exception {
        SpannerConfig spannerConfig = this.createSpannerConfig();
        PCollectionView tx = (PCollectionView)this.p.apply("Create tx", (PTransform)SpannerIO.createTransaction().withSpannerConfig(spannerConfig).withTimestampBound(TimestampBound.strong()));
        PCollection output = (PCollection)this.p.apply("read db", (PTransform)SpannerIO.read().withSpannerConfig(spannerConfig).withTable(this.options.getTable()).withColumns(new String[]{"Key", "Value"}).withTransaction(tx));
        PAssert.thatSingleton((PCollection)((PCollection)output.apply("Count rows", Count.globally()))).isEqualTo((Object)5L);
        this.p.run().waitUntilFinish();
    }

    @Test
    public void testReadFailsBadTable() throws Exception {
        this.thrown.expect((Matcher)new SpannerWriteIT.StackTraceContainsString("SpannerException"));
        this.thrown.expect((Matcher)new SpannerWriteIT.StackTraceContainsString("NOT_FOUND: Table not found"));
        SpannerConfig spannerConfig = this.createSpannerConfig();
        PCollectionView tx = (PCollectionView)this.p.apply("Create tx", (PTransform)SpannerIO.createTransaction().withSpannerConfig(spannerConfig).withTimestampBound(TimestampBound.strong()));
        this.p.apply("read db", (PTransform)SpannerIO.read().withSpannerConfig(spannerConfig).withTable("IncorrectTableName").withColumns(new String[]{"Key", "Value"}).withTransaction(tx));
        this.p.run().waitUntilFinish();
    }

    @Test
    public void testReadFailsBadSession() throws Exception {
        this.thrown.expect((Matcher)new SpannerWriteIT.StackTraceContainsString("SpannerException"));
        this.thrown.expect((Matcher)new SpannerWriteIT.StackTraceContainsString("NOT_FOUND: Session not found"));
        SpannerConfig spannerConfig = this.createSpannerConfig();
        PCollectionView tx = (PCollectionView)((PCollection)((PCollection)((PCollection)this.p.apply("Transaction seed", (PTransform)Create.of((Object)1, (Object[])new Integer[0]))).apply("Create transaction", (PTransform)ParDo.of((DoFn)new CreateTransactionFn(spannerConfig, TimestampBound.strong())))).apply("Close Transaction", (PTransform)MapElements.via((SimpleFunction)new CloseTransactionFn(spannerConfig)))).apply("As PCollectionView", (PTransform)View.asSingleton());
        this.p.apply("read db", (PTransform)SpannerIO.read().withSpannerConfig(spannerConfig).withTable(this.options.getTable()).withColumns(new String[]{"Key", "Value"}).withTransaction(tx));
        this.p.run().waitUntilFinish();
    }

    @Test
    public void testQuery() throws Exception {
        SpannerConfig spannerConfig = this.createSpannerConfig();
        SpannerConfig pgSpannerConfig = this.createPgSpannerConfig();
        PCollectionView tx = (PCollectionView)this.p.apply("Create tx", (PTransform)SpannerIO.createTransaction().withSpannerConfig(spannerConfig).withTimestampBound(TimestampBound.strong()));
        PCollection output = (PCollection)this.p.apply("Read db", (PTransform)SpannerIO.read().withSpannerConfig(spannerConfig).withQuery("SELECT * FROM " + this.options.getTable()).withTransaction(tx));
        PAssert.thatSingleton((PCollection)((PCollection)output.apply("Count rows", Count.globally()))).isEqualTo((Object)5L);
        PCollectionView pgTx = (PCollectionView)this.p.apply("Create PG tx", (PTransform)SpannerIO.createTransaction().withSpannerConfig(pgSpannerConfig).withTimestampBound(TimestampBound.strong()));
        PCollection pgOutput = (PCollection)this.p.apply("Read PG db", (PTransform)SpannerIO.read().withSpannerConfig(pgSpannerConfig).withQuery("SELECT * FROM " + this.options.getTable()).withTransaction(pgTx));
        PAssert.thatSingleton((PCollection)((PCollection)pgOutput.apply("Count PG rows", Count.globally()))).isEqualTo((Object)5L);
        this.p.run();
    }

    @Test
    public void testReadAllRecordsInDb() throws Exception {
        SpannerConfig spannerConfig = this.createSpannerConfig();
        SpannerConfig pgSpannerConfig = this.createPgSpannerConfig();
        PCollectionView tx = (PCollectionView)this.p.apply("Create tx", (PTransform)SpannerIO.createTransaction().withSpannerConfig(spannerConfig).withTimestampBound(TimestampBound.strong()));
        PCollection allRecords = (PCollection)((PCollection)((PCollection)this.p.apply("Scan schema", (PTransform)SpannerIO.read().withSpannerConfig(spannerConfig).withBatching(false).withQuery("SELECT t.table_name FROM information_schema.tables AS t WHERE t.table_catalog = '' AND t.table_schema = ''"))).apply("Build query", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(ReadOperation.class)).via((SerializableFunction & Serializable)input -> {
            String tableName = input.getString(0);
            return ReadOperation.create().withQuery("SELECT * FROM " + tableName);
        }))).apply("Read db", (PTransform)SpannerIO.readAll().withTransaction(tx).withSpannerConfig(spannerConfig));
        PAssert.thatSingleton((PCollection)((PCollection)allRecords.apply("Count rows", Count.globally()))).isEqualTo((Object)5L);
        PCollectionView pgTx = (PCollectionView)this.p.apply("Create PG tx", (PTransform)SpannerIO.createTransaction().withSpannerConfig(pgSpannerConfig).withTimestampBound(TimestampBound.strong()));
        PCollection allPgRecords = (PCollection)((PCollection)((PCollection)this.p.apply("Scan PG schema", (PTransform)SpannerIO.read().withSpannerConfig(pgSpannerConfig).withBatching(false).withQuery("SELECT t.table_name FROM information_schema.tables AS t WHERE t.table_schema = 'public'"))).apply("Build PG query", (PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(ReadOperation.class)).via((SerializableFunction & Serializable)input -> {
            String tableName = input.getString(0);
            return ReadOperation.create().withQuery("SELECT * FROM " + tableName);
        }))).apply("Read PG db", (PTransform)SpannerIO.readAll().withTransaction(pgTx).withSpannerConfig(pgSpannerConfig));
        PAssert.thatSingleton((PCollection)((PCollection)allPgRecords.apply("Count PG rows", Count.globally()))).isEqualTo((Object)5L);
        this.p.run();
    }

    private void makeTestData() {
        DatabaseClient databaseClient = this.getDatabaseClient();
        DatabaseClient pgDatabaseClient = this.getPgDatabaseClient();
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        int i = 0;
        while ((long)i < 5L) {
            mutations.add(((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)this.options.getTable()).set("key").to((long)i)).set("value").to(RandomUtils.randomAlphaNumeric(100))).build());
            ++i;
        }
        databaseClient.writeAtLeastOnce(mutations);
        pgDatabaseClient.writeAtLeastOnce(mutations);
    }

    private SpannerConfig createSpannerConfig() {
        return SpannerConfig.create().withProjectId(this.project).withInstanceId(this.options.getInstanceId()).withDatabaseId(this.databaseName);
    }

    private SpannerConfig createPgSpannerConfig() {
        return SpannerConfig.create().withProjectId(this.project).withInstanceId(this.options.getInstanceId()).withDatabaseId(this.pgDatabaseName);
    }

    private DatabaseClient getDatabaseClient() {
        return this.spanner.getDatabaseClient(DatabaseId.of((String)this.project, (String)this.options.getInstanceId(), (String)this.databaseName));
    }

    private DatabaseClient getPgDatabaseClient() {
        return this.spanner.getDatabaseClient(DatabaseId.of((String)this.project, (String)this.options.getInstanceId(), (String)this.pgDatabaseName));
    }

    @After
    public void tearDown() throws Exception {
        this.databaseAdminClient.dropDatabase(this.options.getInstanceId(), this.databaseName);
        this.databaseAdminClient.dropDatabase(this.options.getInstanceId(), this.pgDatabaseName);
        this.spanner.close();
    }

    private String generateDatabaseName() {
        String random = RandomUtils.randomAlphaNumeric(26 - this.options.getDatabaseIdPrefix().length());
        return this.options.getDatabaseIdPrefix() + "-" + random;
    }

    private static class CloseTransactionFn
    extends SimpleFunction<Transaction, Transaction> {
        private final SpannerConfig spannerConfig;

        private CloseTransactionFn(SpannerConfig spannerConfig) {
            this.spannerConfig = spannerConfig;
        }

        public Transaction apply(Transaction tx) {
            BatchClient batchClient = SpannerAccessor.getOrCreate((SpannerConfig)this.spannerConfig).getBatchClient();
            batchClient.batchReadOnlyTransaction(tx.transactionId()).cleanup();
            return tx;
        }
    }

    public static interface SpannerTestPipelineOptions
    extends TestPipelineOptions {
        @Description(value="Project that hosts Spanner instance")
        public @Nullable String getInstanceProjectId();

        public void setInstanceProjectId(String var1);

        @Description(value="Instance ID to write to in Spanner")
        @Default.String(value="beam-test")
        public String getInstanceId();

        public void setInstanceId(String var1);

        @Description(value="Database ID prefix to write to in Spanner")
        @Default.String(value="beam-testdb")
        public String getDatabaseIdPrefix();

        public void setDatabaseIdPrefix(String var1);

        @Description(value="Table name")
        @Default.String(value="users")
        public String getTable();

        public void setTable(String var1);
    }
}

