/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ServiceFactory;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.SpannerExceptionFactory;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.spanner.FakeServiceFactory;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroup;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIOWriteTest;
import org.apache.beam.sdk.io.gcp.spanner.SpannerWriteResult;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=Parameterized.class)
public class SpannerIOWriteExceptionHandlingTest {
    private static final long CELLS_PER_KEY = 7L;
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();
    private FakeServiceFactory serviceFactory;
    @Captor
    public transient ArgumentCaptor<Iterable<Mutation>> mutationBatchesCaptor;
    @Captor
    public transient ArgumentCaptor<Options.ReadQueryUpdateTransactionOption> optionsCaptor;
    private final ErrorCode exceptionErrorcode;
    private final String errorString;
    private final Integer callsToSleeper;
    private final Integer callsToWrite;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({ErrorCode.DEADLINE_EXCEEDED, "deadline passed!", 9, 10}, {ErrorCode.ABORTED, "transaction aborted!", 0, 1}, {ErrorCode.PERMISSION_DENIED, "permission denied, buddy!", 0, 1}, {ErrorCode.INTERNAL, "internal error. idk!", 0, 1}, {ErrorCode.RESOURCE_EXHAUSTED, "resource exhausted very tired!", 0, 1}, {ErrorCode.UNAUTHENTICATED, "authenticate!", 0, 1}, {ErrorCode.NOT_FOUND, "not found the thing", 0, 1}, {ErrorCode.FAILED_PRECONDITION, "conditions prestart are failed", 0, 1});
    }

    public SpannerIOWriteExceptionHandlingTest(ErrorCode exceptionErrorcode, String errorString, Integer callsToSleeper, Integer callsToWrite) {
        this.exceptionErrorcode = exceptionErrorcode;
        this.errorString = errorString;
        this.callsToSleeper = callsToSleeper;
        this.callsToWrite = callsToWrite;
    }

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.serviceFactory = new FakeServiceFactory();
        ReadOnlyTransaction tx = (ReadOnlyTransaction)Mockito.mock(ReadOnlyTransaction.class);
        Mockito.when((Object)this.serviceFactory.mockDatabaseClient().readOnlyTransaction()).thenReturn((Object)tx);
        Mockito.when((Object)this.serviceFactory.mockDatabaseClient().writeAtLeastOnceWithOptions((Iterable)this.mutationBatchesCaptor.capture(), new Options.TransactionOption[]{(Options.TransactionOption)this.optionsCaptor.capture()})).thenReturn(null);
        SpannerIOWriteTest.preparePkMetadata(tx, Arrays.asList(SpannerIOWriteTest.pkMetadata("tEsT", "key", "ASC")));
        SpannerIOWriteTest.prepareColumnMetadata(tx, Arrays.asList(SpannerIOWriteTest.columnMetadata("tEsT", "key", "INT64", 7L)));
        SpannerIOWriteTest.preparePgColumnMetadata(tx, Arrays.asList(SpannerIOWriteTest.columnMetadata("tEsT", "key", "bigint", 7L)));
        MetricsContainerImpl container = new MetricsContainerImpl(null);
        MetricsEnvironment.setProcessWideContainer((MetricsContainer)container);
    }

    @Test
    public void testExceptionHandlingForSimpleWrite() throws InterruptedException {
        List<Mutation> mutationList = Arrays.asList(SpannerIOWriteTest.buildUpsertMutation(1L));
        SpannerIO.WriteToSpannerFn.sleeper = (Sleeper)Mockito.mock(Sleeper.class);
        Mockito.when((Object)this.serviceFactory.mockDatabaseClient().writeAtLeastOnceWithOptions((Iterable)ArgumentMatchers.any(), new Options.TransactionOption[]{(Options.TransactionOption)ArgumentMatchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)this.exceptionErrorcode, (String)this.errorString)});
        this.thrown.expect(Pipeline.PipelineExecutionException.class);
        this.thrown.expectMessage(this.errorString);
        SpannerWriteResult result = (SpannerWriteResult)((PCollection)this.pipeline.apply((PTransform)Create.of(mutationList))).apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).withBatchSizeBytes(0L).withFailureMode(SpannerIO.FailureMode.FAIL_FAST));
        PAssert.that((PCollection)result.getFailedMutations()).satisfies((SerializableFunction & Serializable)m -> {
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)m));
            return null;
        });
        try {
            this.pipeline.run().waitUntilFinish();
        }
        catch (Throwable throwable) {
            ((Sleeper)Mockito.verify((Object)SpannerIO.WriteToSpannerFn.sleeper, (VerificationMode)Mockito.times((int)this.callsToSleeper))).sleep(ArgumentMatchers.anyLong());
            ((DatabaseClient)Mockito.verify((Object)this.serviceFactory.mockDatabaseClient(), (VerificationMode)Mockito.times((int)this.callsToWrite))).writeAtLeastOnceWithOptions((Iterable)ArgumentMatchers.any(), new Options.TransactionOption[]{(Options.TransactionOption)ArgumentMatchers.any(Options.ReadQueryUpdateTransactionOption.class)});
            throw throwable;
        }
        ((Sleeper)Mockito.verify((Object)SpannerIO.WriteToSpannerFn.sleeper, (VerificationMode)Mockito.times((int)this.callsToSleeper))).sleep(ArgumentMatchers.anyLong());
        ((DatabaseClient)Mockito.verify((Object)this.serviceFactory.mockDatabaseClient(), (VerificationMode)Mockito.times((int)this.callsToWrite))).writeAtLeastOnceWithOptions((Iterable)ArgumentMatchers.any(), new Options.TransactionOption[]{(Options.TransactionOption)ArgumentMatchers.any(Options.ReadQueryUpdateTransactionOption.class)});
    }

    @Test
    public void testExceptionHandlingForWriteGrouped() throws InterruptedException {
        List<MutationGroup> mutationList = Arrays.asList(SpannerIOWriteTest.buildMutationGroup(SpannerIOWriteTest.buildUpsertMutation(1L), new Mutation[0]));
        SpannerIO.WriteToSpannerFn.sleeper = (Sleeper)Mockito.mock(Sleeper.class);
        Mockito.when((Object)this.serviceFactory.mockDatabaseClient().writeAtLeastOnceWithOptions((Iterable)ArgumentMatchers.any(), new Options.TransactionOption[]{(Options.TransactionOption)ArgumentMatchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)this.exceptionErrorcode, (String)this.errorString)});
        this.thrown.expect(Pipeline.PipelineExecutionException.class);
        this.thrown.expectMessage(this.errorString);
        SpannerWriteResult result = (SpannerWriteResult)((PCollection)this.pipeline.apply((PTransform)Create.of(mutationList))).apply((PTransform)SpannerIO.write().withProjectId("test-project").withInstanceId("test-instance").withDatabaseId("test-database").withServiceFactory((ServiceFactory)this.serviceFactory).withBatchSizeBytes(0L).withFailureMode(SpannerIO.FailureMode.FAIL_FAST).grouped());
        PAssert.that((PCollection)result.getFailedMutations()).satisfies((SerializableFunction & Serializable)m -> {
            Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)m));
            return null;
        });
        try {
            this.pipeline.run().waitUntilFinish();
        }
        catch (Throwable throwable) {
            ((Sleeper)Mockito.verify((Object)SpannerIO.WriteToSpannerFn.sleeper, (VerificationMode)Mockito.times((int)this.callsToSleeper))).sleep(ArgumentMatchers.anyLong());
            ((DatabaseClient)Mockito.verify((Object)this.serviceFactory.mockDatabaseClient(), (VerificationMode)Mockito.times((int)this.callsToWrite))).writeAtLeastOnceWithOptions((Iterable)ArgumentMatchers.any(), new Options.TransactionOption[]{(Options.TransactionOption)ArgumentMatchers.any(Options.ReadQueryUpdateTransactionOption.class)});
            throw throwable;
        }
        ((Sleeper)Mockito.verify((Object)SpannerIO.WriteToSpannerFn.sleeper, (VerificationMode)Mockito.times((int)this.callsToSleeper))).sleep(ArgumentMatchers.anyLong());
        ((DatabaseClient)Mockito.verify((Object)this.serviceFactory.mockDatabaseClient(), (VerificationMode)Mockito.times((int)this.callsToWrite))).writeAtLeastOnceWithOptions((Iterable)ArgumentMatchers.any(), new Options.TransactionOption[]{(Options.TransactionOption)ArgumentMatchers.any(Options.ReadQueryUpdateTransactionOption.class)});
    }
}

