/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ServiceFactory;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.BatchTransactionId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.FakeBatchTransactionId;
import com.google.cloud.spanner.FakePartitionFactory;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Partition;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.beam.runners.core.metrics.GcpResourceIdentifiers;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.spanner.FakeServiceFactory;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class SpannerIOReadTest
implements Serializable {
    private static final TimestampBound TIMESTAMP_BOUND = TimestampBound.ofReadTimestamp((Timestamp)Timestamp.ofTimeMicroseconds((long)12345L));
    public static final String PROJECT_ID = "1234";
    public static final String INSTANCE_ID = "123";
    public static final String DATABASE_ID = "aaa";
    public static final String TABLE_ID = "users";
    public static final String QUERY_NAME = "My-query";
    public static final String QUERY_STATEMENT = "SELECT * FROM users";
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create().enableAbandonedNodeEnforcement(false);
    private FakeServiceFactory serviceFactory;
    private BatchReadOnlyTransaction mockBatchTx;
    private Partition fakePartition;
    private SpannerConfig spannerConfig;
    private static final Type FAKE_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"id", (Type)Type.int64()), Type.StructField.of((String)"name", (Type)Type.string())});
    private static final List<Struct> FAKE_ROWS = Arrays.asList(((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)1L))).set("name").to("Alice")).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)2L))).set("name").to("Bob")).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)3L))).set("name").to("Carl")).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)4L))).set("name").to("Dan")).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)5L))).set("name").to("Evan")).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)6L))).set("name").to("Floyd")).build());

    @Before
    public void setUp() throws Exception {
        this.serviceFactory = new FakeServiceFactory();
        this.mockBatchTx = (BatchReadOnlyTransaction)Mockito.mock(BatchReadOnlyTransaction.class);
        this.fakePartition = FakePartitionFactory.createFakeQueryPartition(ByteString.copyFromUtf8((String)"one"));
        this.spannerConfig = SpannerConfig.create().withProjectId(PROJECT_ID).withInstanceId(INSTANCE_ID).withDatabaseId(DATABASE_ID).withServiceFactory((ServiceFactory)this.serviceFactory);
        Mockito.when((Object)this.mockBatchTx.getBatchTransactionId()).thenReturn((Object)new FakeBatchTransactionId("runQueryTest"));
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction(TIMESTAMP_BOUND)).thenReturn((Object)this.mockBatchTx);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction((BatchTransactionId)Matchers.any(BatchTransactionId.class))).thenReturn((Object)this.mockBatchTx);
        MetricsContainerImpl container = new MetricsContainerImpl(null);
        MetricsEnvironment.setProcessWideContainer((MetricsContainer)container);
        MetricsEnvironment.setCurrentContainer((MetricsContainer)container);
    }

    @Test
    public void runBatchQueryTestWithProjectId() {
        this.runBatchQueryTest(SpannerIO.read().withSpannerConfig(this.spannerConfig).withQuery(QUERY_STATEMENT).withQueryName(QUERY_NAME).withTimestampBound(TIMESTAMP_BOUND));
    }

    @Test
    public void runBatchQueryTestWithUnspecifiedProject() {
        this.runBatchQueryTest(SpannerIO.read().withSpannerConfig(SpannerConfig.create().withInstanceId(INSTANCE_ID).withDatabaseId(DATABASE_ID).withServiceFactory((ServiceFactory)this.serviceFactory)).withQuery(QUERY_STATEMENT).withQueryName(QUERY_NAME).withTimestampBound(TIMESTAMP_BOUND));
    }

    @Test
    public void runBatchQueryTestWithNullProject() {
        this.runBatchQueryTest(SpannerIO.read().withSpannerConfig(SpannerConfig.create().withProjectId((String)null).withInstanceId(INSTANCE_ID).withDatabaseId(DATABASE_ID).withServiceFactory((ServiceFactory)this.serviceFactory)).withQuery(QUERY_STATEMENT).withQueryName(QUERY_NAME).withTimestampBound(TIMESTAMP_BOUND));
    }

    @Test
    public void runBatchQueryTestWithPriority() {
        SpannerIO.Read readTransform = SpannerIO.read().withSpannerConfig(this.spannerConfig).withQuery(QUERY_STATEMENT).withQueryName(QUERY_NAME).withTimestampBound(TIMESTAMP_BOUND).withHighPriority();
        this.runBatchQueryTest(readTransform);
        Assert.assertEquals((Object)Options.RpcPriority.HIGH, (Object)readTransform.getSpannerConfig().getRpcPriority().get());
    }

    private void runBatchQueryTest(SpannerIO.Read readTransform) {
        PCollection results = (PCollection)this.pipeline.apply("read q", (PTransform)readTransform);
        Mockito.when((Object)this.mockBatchTx.partitionQuery((PartitionOptions)Matchers.any(PartitionOptions.class), (Statement)Matchers.eq((Object)Statement.of((String)QUERY_STATEMENT)), new Options.QueryOption[]{(Options.QueryOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(this.fakePartition, this.fakePartition, this.fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(0, 2)), (Object[])new ResultSet[]{ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(2, 4)), ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(4, 6))});
        PAssert.that((PCollection)results).containsInAnyOrder(FAKE_ROWS);
        this.pipeline.run();
        this.verifyQueryRequestMetricWasSet(readTransform.getSpannerConfig(), QUERY_NAME, "ok", 4L);
    }

    @Test
    public void runBatchQueryTestWithFailures() {
        PCollection results = (PCollection)this.pipeline.apply("read q", (PTransform)SpannerIO.read().withSpannerConfig(this.spannerConfig).withQuery(QUERY_STATEMENT).withQueryName(QUERY_NAME).withTimestampBound(TIMESTAMP_BOUND));
        Mockito.when((Object)this.mockBatchTx.partitionQuery((PartitionOptions)Matchers.any(PartitionOptions.class), (Statement)Matchers.eq((Object)Statement.of((String)QUERY_STATEMENT)), new Options.QueryOption[]{(Options.QueryOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(this.fakePartition, this.fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS)).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.PERMISSION_DENIED, (String)"Simulated Failure")});
        PAssert.that((PCollection)results).containsInAnyOrder(FAKE_ROWS);
        Assert.assertThrows((String)"PERMISSION_DENIED: Simulated Failure", Pipeline.PipelineExecutionException.class, () -> ((TestPipeline)this.pipeline).run());
        this.verifyQueryRequestMetricWasSet(this.spannerConfig, QUERY_NAME, "ok", 2L);
        this.verifyQueryRequestMetricWasSet(this.spannerConfig, QUERY_NAME, "permission_denied", 1L);
    }

    @Test
    public void runNaiveQueryTestWithProjectId() {
        this.runNaiveQueryTest(SpannerIO.read().withSpannerConfig(this.spannerConfig).withQuery(QUERY_STATEMENT).withQueryName(QUERY_NAME).withTimestampBound(TIMESTAMP_BOUND));
    }

    @Test
    public void runNaiveQueryTestWithUnspecifiedProject() {
        this.runNaiveQueryTest(SpannerIO.read().withSpannerConfig(SpannerConfig.create().withInstanceId(INSTANCE_ID).withDatabaseId(DATABASE_ID).withServiceFactory((ServiceFactory)this.serviceFactory)).withQuery(QUERY_STATEMENT).withQueryName(QUERY_NAME).withTimestampBound(TIMESTAMP_BOUND));
    }

    @Test
    public void runNaiveQueryTestWithNullProject() {
        this.runNaiveQueryTest(SpannerIO.read().withSpannerConfig(SpannerConfig.create().withProjectId((String)null).withInstanceId(INSTANCE_ID).withDatabaseId(DATABASE_ID).withServiceFactory((ServiceFactory)this.serviceFactory)).withQuery(QUERY_STATEMENT).withQueryName(QUERY_NAME).withTimestampBound(TIMESTAMP_BOUND));
    }

    @Test
    public void runNaiveQueryTestWithPriority() {
        SpannerIO.Read readTransform = SpannerIO.read().withSpannerConfig(this.spannerConfig).withQuery(QUERY_STATEMENT).withQueryName(QUERY_NAME).withTimestampBound(TIMESTAMP_BOUND).withHighPriority();
        this.runNaiveQueryTest(readTransform);
        Assert.assertEquals((Object)Options.RpcPriority.HIGH, (Object)readTransform.getSpannerConfig().getRpcPriority().get());
    }

    private void runNaiveQueryTest(SpannerIO.Read readTransform) {
        readTransform = readTransform.withBatching(false);
        PCollection results = (PCollection)this.pipeline.apply("read q", (PTransform)readTransform);
        Mockito.when((Object)this.mockBatchTx.executeQuery((Statement)Matchers.eq((Object)Statement.of((String)QUERY_STATEMENT)), new Options.QueryOption[]{(Options.QueryOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS));
        PAssert.that((PCollection)results).containsInAnyOrder(FAKE_ROWS);
        this.pipeline.run();
        this.verifyQueryRequestMetricWasSet(readTransform.getSpannerConfig(), QUERY_NAME, "ok", 1L);
    }

    @Test
    public void runNaiveQueryTestWithAnonymousQuery() {
        SpannerIO.Read readTransform = SpannerIO.read().withSpannerConfig(this.spannerConfig).withQuery(QUERY_STATEMENT).withTimestampBound(TIMESTAMP_BOUND).withHighPriority().withBatching(false);
        PCollection results = (PCollection)this.pipeline.apply("read q", (PTransform)readTransform);
        Mockito.when((Object)this.mockBatchTx.executeQuery((Statement)Matchers.eq((Object)Statement.of((String)QUERY_STATEMENT)), new Options.QueryOption[]{(Options.QueryOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS));
        PAssert.that((PCollection)results).containsInAnyOrder(FAKE_ROWS);
        this.pipeline.run();
        String queryName = String.format("UNNAMED_QUERY#%08x", QUERY_STATEMENT.hashCode());
        this.verifyQueryRequestMetricWasSet(this.spannerConfig, queryName, "ok", 1L);
    }

    @Test
    public void runNaiveQueryTestWithFailures() {
        this.pipeline.apply("read q", (PTransform)SpannerIO.read().withSpannerConfig(this.spannerConfig).withQuery(QUERY_STATEMENT).withQueryName(QUERY_NAME).withTimestampBound(TIMESTAMP_BOUND).withBatching(false));
        Mockito.when((Object)this.mockBatchTx.executeQuery((Statement)Matchers.eq((Object)Statement.of((String)QUERY_STATEMENT)), new Options.QueryOption[]{(Options.QueryOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.PERMISSION_DENIED, (String)"Simulated Failure")});
        Assert.assertThrows((String)"PERMISSION_DENIED: Simulated Failure", Pipeline.PipelineExecutionException.class, () -> ((TestPipeline)this.pipeline).run());
        this.verifyQueryRequestMetricWasSet(this.spannerConfig, QUERY_NAME, "permission_denied", 1L);
    }

    @Test
    public void runBatchReadTestWithProjectId() {
        this.runBatchReadTest(SpannerIO.read().withSpannerConfig(this.spannerConfig).withTable(TABLE_ID).withColumns(new String[]{"id", "name"}).withTimestampBound(TIMESTAMP_BOUND));
    }

    @Test
    public void runBatchReadTestWithUnspecifiedProject() {
        this.runBatchReadTest(SpannerIO.read().withSpannerConfig(SpannerConfig.create().withInstanceId(INSTANCE_ID).withDatabaseId(DATABASE_ID).withServiceFactory((ServiceFactory)this.serviceFactory)).withTable(TABLE_ID).withColumns(new String[]{"id", "name"}).withTimestampBound(TIMESTAMP_BOUND));
    }

    @Test
    public void runBatchReadTestWithNullProject() {
        this.runBatchReadTest(SpannerIO.read().withSpannerConfig(SpannerConfig.create().withProjectId((String)null).withInstanceId(INSTANCE_ID).withDatabaseId(DATABASE_ID).withServiceFactory((ServiceFactory)this.serviceFactory)).withTable(TABLE_ID).withColumns(new String[]{"id", "name"}).withTimestampBound(TIMESTAMP_BOUND));
    }

    @Test
    public void runBatchReadTestWithPriority() {
        SpannerIO.Read readTransform = SpannerIO.read().withSpannerConfig(this.spannerConfig).withTable(TABLE_ID).withColumns(new String[]{"id", "name"}).withTimestampBound(TIMESTAMP_BOUND).withHighPriority();
        this.runBatchReadTest(readTransform);
        Assert.assertEquals((Object)Options.RpcPriority.HIGH, (Object)readTransform.getSpannerConfig().getRpcPriority().get());
    }

    private void runBatchReadTest(SpannerIO.Read readTransform) {
        PCollection results = (PCollection)this.pipeline.apply("read q", (PTransform)readTransform);
        Mockito.when((Object)this.mockBatchTx.partitionRead((PartitionOptions)Matchers.any(PartitionOptions.class), (String)Matchers.eq((Object)TABLE_ID), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[]{(Options.ReadOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(this.fakePartition, this.fakePartition, this.fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(0, 2)), (Object[])new ResultSet[]{ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(2, 4)), ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(4, 6))});
        PAssert.that((PCollection)results).containsInAnyOrder(FAKE_ROWS);
        this.pipeline.run();
        this.verifyTableRequestMetricWasSet(readTransform.getSpannerConfig(), TABLE_ID, "ok", 4L);
    }

    @Test
    public void runBatchReadTestWithFailures() {
        SpannerIO.Read readTransform = SpannerIO.read().withSpannerConfig(this.spannerConfig).withTable(TABLE_ID).withColumns(new String[]{"id", "name"}).withTimestampBound(TIMESTAMP_BOUND);
        this.pipeline.apply("read q", (PTransform)readTransform);
        Mockito.when((Object)this.mockBatchTx.partitionRead((PartitionOptions)Matchers.any(PartitionOptions.class), (String)Matchers.eq((Object)TABLE_ID), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[]{(Options.ReadOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(this.fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.PERMISSION_DENIED, (String)"Simulated Failure")});
        Assert.assertThrows((String)"PERMISSION_DENIED: Simulated Failure", Pipeline.PipelineExecutionException.class, () -> ((TestPipeline)this.pipeline).run());
        this.verifyTableRequestMetricWasSet(this.spannerConfig, TABLE_ID, "ok", 1L);
        this.verifyTableRequestMetricWasSet(this.spannerConfig, TABLE_ID, "permission_denied", 1L);
    }

    @Test
    public void runNaiveReadTestWithProjectId() {
        this.runNaiveReadTest(SpannerIO.read().withSpannerConfig(this.spannerConfig).withTable(TABLE_ID).withColumns(new String[]{"id", "name"}).withTimestampBound(TIMESTAMP_BOUND));
    }

    @Test
    public void runNaiveReadTestWithUnspecifiedProject() {
        this.runNaiveReadTest(SpannerIO.read().withSpannerConfig(SpannerConfig.create().withInstanceId(INSTANCE_ID).withDatabaseId(DATABASE_ID).withServiceFactory((ServiceFactory)this.serviceFactory)).withTable(TABLE_ID).withColumns(new String[]{"id", "name"}).withTimestampBound(TIMESTAMP_BOUND));
    }

    @Test
    public void runNaiveReadTestWithNullProject() {
        this.runNaiveReadTest(SpannerIO.read().withSpannerConfig(SpannerConfig.create().withProjectId((String)null).withInstanceId(INSTANCE_ID).withDatabaseId(DATABASE_ID).withServiceFactory((ServiceFactory)this.serviceFactory)).withTable(TABLE_ID).withColumns(new String[]{"id", "name"}).withTimestampBound(TIMESTAMP_BOUND));
    }

    @Test
    public void runNaiveReadTestWithPriority() {
        SpannerIO.Read readTransform = SpannerIO.read().withSpannerConfig(this.spannerConfig).withTable(TABLE_ID).withColumns(new String[]{"id", "name"}).withTimestampBound(TIMESTAMP_BOUND).withHighPriority();
        this.runNaiveReadTest(readTransform);
        Assert.assertEquals((Object)Options.RpcPriority.HIGH, (Object)readTransform.getSpannerConfig().getRpcPriority().get());
    }

    private void runNaiveReadTest(SpannerIO.Read readTransform) {
        readTransform = readTransform.withBatching(false);
        PCollection results = (PCollection)this.pipeline.apply("read q", (PTransform)readTransform);
        Mockito.when((Object)this.mockBatchTx.read((String)Matchers.eq((Object)TABLE_ID), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[]{(Options.ReadOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS));
        PAssert.that((PCollection)results).containsInAnyOrder(FAKE_ROWS);
        this.pipeline.run();
        this.verifyTableRequestMetricWasSet(readTransform.getSpannerConfig(), TABLE_ID, "ok", 1L);
    }

    @Test
    public void runNaiveReadTestWithFailures() {
        this.pipeline.apply("read q", (PTransform)SpannerIO.read().withSpannerConfig(this.spannerConfig).withTable(TABLE_ID).withColumns(new String[]{"id", "name"}).withTimestampBound(TIMESTAMP_BOUND).withBatching(false));
        Mockito.when((Object)this.mockBatchTx.read((String)Matchers.eq((Object)TABLE_ID), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[]{(Options.ReadOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.PERMISSION_DENIED, (String)"Simulated Failure")});
        Assert.assertThrows((String)"PERMISSION_DENIED: Simulated Failure", Pipeline.PipelineExecutionException.class, () -> ((TestPipeline)this.pipeline).run());
        this.verifyTableRequestMetricWasSet(this.spannerConfig, TABLE_ID, "permission_denied", 1L);
    }

    @Test
    public void runBatchReadUsingIndex() {
        PCollection one = (PCollection)this.pipeline.apply("read q", (PTransform)SpannerIO.read().withTimestamp(Timestamp.now()).withSpannerConfig(this.spannerConfig).withTable(TABLE_ID).withColumns(new String[]{"id", "name"}).withIndex("theindex").withTimestampBound(TIMESTAMP_BOUND));
        Mockito.when((Object)this.mockBatchTx.partitionReadUsingIndex((PartitionOptions)Matchers.any(PartitionOptions.class), (String)Matchers.eq((Object)TABLE_ID), (String)Matchers.eq((Object)"theindex"), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[]{(Options.ReadOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(this.fakePartition, this.fakePartition, this.fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(0, 2)), (Object[])new ResultSet[]{ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(2, 4)), ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(4, 6))});
        PAssert.that((PCollection)one).containsInAnyOrder(FAKE_ROWS);
        this.pipeline.run();
        this.verifyTableRequestMetricWasSet(this.spannerConfig, TABLE_ID, "ok", 4L);
    }

    @Test
    public void runNaiveReadUsingIndex() {
        PCollection results = (PCollection)this.pipeline.apply("read q", (PTransform)SpannerIO.read().withTimestamp(Timestamp.now()).withSpannerConfig(this.spannerConfig).withTable(TABLE_ID).withColumns(new String[]{"id", "name"}).withIndex("theindex").withTimestampBound(TIMESTAMP_BOUND).withBatching(false));
        Mockito.when((Object)this.mockBatchTx.readUsingIndex((String)Matchers.eq((Object)TABLE_ID), (String)Matchers.eq((Object)"theindex"), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[]{(Options.ReadOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS));
        PAssert.that((PCollection)results).containsInAnyOrder(FAKE_ROWS);
        this.pipeline.run();
        this.verifyTableRequestMetricWasSet(this.spannerConfig, TABLE_ID, "ok", 1L);
    }

    @Test
    public void readAllPipeline() {
        PCollectionView tx = (PCollectionView)this.pipeline.apply("tx", (PTransform)SpannerIO.createTransaction().withSpannerConfig(this.spannerConfig).withTimestampBound(TIMESTAMP_BOUND));
        PCollection reads = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)ReadOperation.create().withQuery(QUERY_STATEMENT).withQueryName(QUERY_NAME), (Object[])new ReadOperation[]{ReadOperation.create().withTable(TABLE_ID).withColumns(new String[]{"id", "name"})}));
        PCollection results = (PCollection)reads.apply("read all", (PTransform)SpannerIO.readAll().withSpannerConfig(this.spannerConfig).withTransaction(tx));
        Mockito.when((Object)this.mockBatchTx.partitionQuery((PartitionOptions)Matchers.any(PartitionOptions.class), (Statement)Matchers.eq((Object)Statement.of((String)QUERY_STATEMENT)), new Options.QueryOption[]{(Options.QueryOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(this.fakePartition, this.fakePartition));
        Mockito.when((Object)this.mockBatchTx.partitionRead((PartitionOptions)Matchers.any(PartitionOptions.class), (String)Matchers.eq((Object)TABLE_ID), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[]{(Options.ReadOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Collections.singletonList(this.fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(0, 2)), (Object[])new ResultSet[]{ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(2, 4)), ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(4, 6))});
        PAssert.that((PCollection)results).containsInAnyOrder(FAKE_ROWS);
        this.pipeline.run();
        this.verifyTableRequestMetricWasSet(this.spannerConfig, TABLE_ID, "ok", 2L);
        this.verifyQueryRequestMetricWasSet(this.spannerConfig, QUERY_NAME, "ok", 3L);
    }

    private void verifyTableRequestMetricWasSet(SpannerConfig config, String table, String status, long count) {
        HashMap<String, String> baseLabels = this.getBaseMetricsLabels(config);
        baseLabels.put("METHOD", "Read");
        baseLabels.put("TABLE_ID", table);
        baseLabels.put("RESOURCE", GcpResourceIdentifiers.spannerTable((String)baseLabels.get("SPANNER_PROJECT_ID"), (String)((String)config.getInstanceId().get()), (String)((String)config.getDatabaseId().get()), (String)table));
        baseLabels.put("STATUS", status);
        MonitoringInfoMetricName name = MonitoringInfoMetricName.named((String)MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
        MetricsContainerImpl container = (MetricsContainerImpl)MetricsEnvironment.getCurrentContainer();
        Assert.assertEquals((long)count, (long)container.getCounter((MetricName)name).getCumulative());
    }

    private void verifyQueryRequestMetricWasSet(SpannerConfig config, String queryName, String status, long count) {
        HashMap<String, String> baseLabels = this.getBaseMetricsLabels(config);
        baseLabels.put("METHOD", "Read");
        baseLabels.put("SPANNER_QUERY_NAME", queryName);
        baseLabels.put("RESOURCE", GcpResourceIdentifiers.spannerQuery((String)baseLabels.get("SPANNER_PROJECT_ID"), (String)((String)config.getInstanceId().get()), (String)((String)config.getDatabaseId().get()), (String)queryName));
        baseLabels.put("STATUS", status);
        MonitoringInfoMetricName name = MonitoringInfoMetricName.named((String)MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
        MetricsContainerImpl container = (MetricsContainerImpl)MetricsEnvironment.getCurrentContainer();
        Assert.assertEquals((long)count, (long)container.getCounter((MetricName)name).getCumulative());
    }

    @NotNull
    private HashMap<String, String> getBaseMetricsLabels(SpannerConfig config) {
        HashMap<String, String> baseLabels = new HashMap<String, String>();
        baseLabels.put("PTRANSFORM", "");
        baseLabels.put("SERVICE", "Spanner");
        baseLabels.put("SPANNER_PROJECT_ID", config.getProjectId() == null || config.getProjectId().get() == null ? SpannerOptions.getDefaultProjectId() : (String)config.getProjectId().get());
        baseLabels.put("SPANNER_INSTANCE_ID", (String)config.getInstanceId().get());
        baseLabels.put("SPANNER_DATABASE_ID", (String)config.getDatabaseId().get());
        return baseLabels;
    }
}

