/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.beam.sdk.testing.SerializableMatchers;

final class FakeSerializable {
    private static final AtomicInteger idCounter = new AtomicInteger(0);
    private static final ConcurrentHashMap<Integer, Object> map = new ConcurrentHashMap();

    private FakeSerializable() {
    }

    static <T> Handle<T> put(T value) {
        int id = idCounter.incrementAndGet();
        map.put(id, value);
        return new Handle(id);
    }

    static <T> SerializableMatchers.SerializableSupplier<T> getSupplier(T value) {
        Handle<T> handle = FakeSerializable.put(value);
        return handle::get;
    }

    static class Handle<T>
    implements Serializable {
        private final int id;

        private Handle(int id) {
            this.id = id;
        }

        T get() {
            return (T)map.get(this.id);
        }
    }
}

