/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.pubsub.NestedRowToMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubSchemaIOProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NestedRowToMessageTest {
    private static final PayloadSerializer SERIALIZER = (PayloadSerializer)Mockito.mock(PayloadSerializer.class);
    private static final Map<String, String> ATTRIBUTES = ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2");

    @Test
    public void mapAttributesTransformed() {
        Schema schema = Schema.builder().addByteArrayField("payload").addField("attributes", PubsubSchemaIOProvider.ATTRIBUTE_MAP_FIELD_TYPE).build();
        Row row = Row.withSchema((Schema)schema).attachValues(new Object[]{"abc".getBytes(StandardCharsets.UTF_8), ATTRIBUTES});
        PubsubMessage message = new PubsubMessage("abc".getBytes(StandardCharsets.UTF_8), ATTRIBUTES);
        Assert.assertEquals((Object)message, (Object)new NestedRowToMessage(SERIALIZER, schema).apply(row));
    }

    @Test
    public void entriesAttributesTransformed() {
        Schema schema = Schema.builder().addByteArrayField("payload").addField("attributes", PubsubSchemaIOProvider.ATTRIBUTE_ARRAY_FIELD_TYPE).build();
        Row row = Row.withSchema((Schema)schema).attachValues(new Object[]{"abc".getBytes(StandardCharsets.UTF_8), ImmutableList.of((Object)Row.withSchema((Schema)PubsubSchemaIOProvider.ATTRIBUTE_ARRAY_ENTRY_SCHEMA).attachValues(new Object[]{"k1", "v1"}), (Object)Row.withSchema((Schema)PubsubSchemaIOProvider.ATTRIBUTE_ARRAY_ENTRY_SCHEMA).attachValues(new Object[]{"k2", "v2"}))});
        PubsubMessage message = new PubsubMessage("abc".getBytes(StandardCharsets.UTF_8), ATTRIBUTES);
        Assert.assertEquals((Object)message, (Object)new NestedRowToMessage(SERIALIZER, schema).apply(row));
    }

    @Test
    public void rowPayloadTransformed() {
        Schema payloadSchema = Schema.builder().addStringField("fieldName").build();
        Row payload = Row.withSchema((Schema)payloadSchema).attachValues(new Object[]{"abc"});
        Schema schema = Schema.builder().addRowField("payload", payloadSchema).addField("attributes", PubsubSchemaIOProvider.ATTRIBUTE_MAP_FIELD_TYPE).build();
        Row row = Row.withSchema((Schema)schema).attachValues(new Object[]{payload, ATTRIBUTES});
        Mockito.when((Object)SERIALIZER.serialize(payload)).thenReturn((Object)"abc".getBytes(StandardCharsets.UTF_8));
        PubsubMessage message = new PubsubMessage("abc".getBytes(StandardCharsets.UTF_8), ATTRIBUTES);
        Assert.assertEquals((Object)message, (Object)new NestedRowToMessage(SERIALIZER, schema).apply(row));
    }

    @Test
    public void rowPayloadTransformFailure() {
        Schema payloadSchema = Schema.builder().addStringField("fieldName").build();
        Row payload = Row.withSchema((Schema)payloadSchema).attachValues(new Object[]{"abc"});
        Schema schema = Schema.builder().addRowField("payload", payloadSchema).addField("attributes", PubsubSchemaIOProvider.ATTRIBUTE_MAP_FIELD_TYPE).build();
        Row row = Row.withSchema((Schema)schema).attachValues(new Object[]{payload, ATTRIBUTES});
        Mockito.when((Object)SERIALIZER.serialize(payload)).thenThrow(new Throwable[]{new IllegalArgumentException()});
        Assert.assertThrows(IllegalArgumentException.class, () -> new NestedRowToMessage(SERIALIZER, schema).apply(row));
    }
}

