/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.api.client.util.Base64;
import com.google.api.client.util.Sleeper;
import com.google.api.services.healthcare.v1.model.Message;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2Message;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

class HL7v2IOTestUtil {
    public static final long HL7V2_INDEXING_TIMEOUT_MINUTES = 10L;
    public static final String HEALTHCARE_DATASET_TEMPLATE = "projects/%s/locations/us-central1/datasets/apache-beam-integration-testing";
    static final List<String> MESSAGES_DATA = Arrays.asList("MSH|^~\\&|CERNER|RAL|STREAMS|RAL|20190309132444||ADT^A01|827|T|2.3|||AL||44|ASCII\rEVN|A01|20190309132444|||C184726198^Connell^Alistair^^^Dr.^^^DRNBR^PRSNL^^^ORGDR|\rPID|1|456656825^^^SIMULATOR MRN^MRN|456656825^^^SIMULATOR MRN^MRN~1495641465^^^NHSNBR^NHSNMBR||Doe^Jane^Glynis^^Miss^^CURRENT||19940703010000|2|||73 Alto Road^^London^^HG63 4SN^GBR^HOME||075 6368 2928^HOME|||||||||A^White - British^||||||||\rPD1|||YIEWSLEY FAMILY PRACTICE^^6010|||||\rPV1|1|INPATIENT|Orthopaedic^Bay A^Bed 11^Simulated Hospital^^BED^Orthopaedic ward^1|28b|||C184726198^Connell^Alistair^^^Dr.^^^DRNBR^PRSNL^^^ORGDR|||180|||||||||12611791848783219197^^^^visitid||||||||||||||||||||||ARRIVED|||20190309132444||\rAL1|0|allergy|Z88.0^Personal history of allergy to penicillin^ZAL|SEVERE|Shortness of breath|\rAL1|1|allergy|T63.441A^Toxic effect of venom of bees^ZAL|MODERATE|Vomiting|\rAL1|2|allergy|Z91.013^Personal history of allergy to sea food^ZAL|SEVERE|Swollen face|\rAL1|3|allergy|Z91.040^Latex allergy^ZAL|MODERATE|Raised, itchy, red rash|", "MSH|^~\\&|hl7Integration|hl7Integration|||20190309132544||ADT^A08|||2.5|\rEVN|A01|20130617154644||foo\rPID|1|465 306 5961||407623|Wood^Patrick^^^MR||19700101|1|||High Street^^Oxford^^Ox1 4DP~George St^^Oxford^^Ox1 5AP|||||||\rNK1|1|Wood^John^^^MR|Father||999-9999\rNK1|2|Jones^Georgie^^^MSS|MOTHER||999-9999\rPV1|1||Location||||||||||||||||261938_6_201306171546|||||||||||||||||||||||||20130617134644|||||||||", "MSH|^~\\&|ULTRA|TML|OLIS|OLIS|201905011130||ORU^R01|20169838-v25|T|2.5\rPID|||7005728^^^TML^MR||TEST^RACHEL^DIAMOND||19310313|F|||200 ANYWHERE ST^^TORONTO^ON^M6G 2T9||(416)888-8888||||||1014071185^KR\rPV1|1||OLIS||||OLIST^BLAKE^DONALD^THOR^^^^^921379^^^^OLIST\rORC|RE||T09-100442-RET-0^^OLIS_Site_ID^ISO|||||||||OLIST^BLAKE^DONALD^THOR^^^^L^921379\rOBR|0||T09-100442-RET-0^^OLIS_Site_ID^ISO|RET^RETICULOCYTE COUNT^HL79901 literal|||200905011106|||||||200905011106||OLIST^BLAKE^DONALD^THOR^^^^L^921379||7870279|7870279|T09-100442|MOHLTC|200905011130||B7|F||1^^^200905011106^^R\rOBX|1|ST|||Test Value");
    static final List<HL7v2Message> MESSAGES = MESSAGES_DATA.stream().map(String::getBytes).map(Base64::encodeBase64String).map(data -> {
        Message msg = new Message();
        msg.setData(data);
        return HL7v2Message.fromModel((Message)msg);
    }).collect(Collectors.toList());
    static final long NUM_ADT = 2L;

    HL7v2IOTestUtil() {
    }

    static void deleteAllHL7v2Messages(HealthcareApiClient client, String hl7v2Store) throws IOException {
        for (List page : new HttpHealthcareApiClient.HL7v2MessagePages(client, hl7v2Store, null, null)) {
            for (String msgId : page.stream().map(HL7v2Message::getName).collect(Collectors.toList())) {
                client.deleteHL7v2Message(msgId);
            }
        }
    }

    public static void waitForHL7v2Indexing(HealthcareApiClient client, String hl7v2Store, long expectedNumMessages, Duration timeout) throws InterruptedException, TimeoutException {
        Instant start = Instant.now();
        long sleepMs = 50L;
        long numListedMessages = 0L;
        while (new Duration((ReadableInstant)start, (ReadableInstant)Instant.now()).isShorterThan((ReadableDuration)timeout)) {
            numListedMessages = 0L;
            for (List page : new HttpHealthcareApiClient.HL7v2MessagePages(client, hl7v2Store, null, null)) {
                numListedMessages += (long)page.size();
            }
            if (numListedMessages == expectedNumMessages) {
                return;
            }
            if (new Duration((ReadableInstant)start, (ReadableInstant)Instant.now()).plus((ReadableDuration)Duration.millis((long)(sleepMs *= 2L))).isShorterThan((ReadableDuration)timeout)) {
                Sleeper.DEFAULT.sleep(sleepMs);
                continue;
            }
            throw new TimeoutException(String.format("Timed out waiting for %s to reach %s messages. last list request returned %s messages.", hl7v2Store, expectedNumMessages, numListedMessages));
        }
    }

    static void writeHL7v2Messages(HealthcareApiClient client, String hl7v2Store) throws IOException, InterruptedException, TimeoutException {
        for (HL7v2Message msg : MESSAGES) {
            client.createHL7v2Message(hl7v2Store, msg.toModel());
        }
        HL7v2IOTestUtil.waitForHL7v2Indexing(client, hl7v2Store, MESSAGES.size(), Duration.standardMinutes((long)10L));
    }

    static Message testMessage(String name) {
        Message msg = new Message();
        msg.setName(name);
        return msg;
    }

    static class ListHL7v2MessageIDsFn
    extends DoFn<String, String> {
        private final String filter;
        private transient HealthcareApiClient client;

        ListHL7v2MessageIDsFn(String filter) {
            this.filter = filter;
        }

        @DoFn.Setup
        public void initClient() throws IOException {
            this.client = new HttpHealthcareApiClient();
        }

        @DoFn.ProcessElement
        public void listMessages(DoFn.ProcessContext context) throws IOException {
            String hl7v2Store = (String)context.element();
            HttpHealthcareApiClient.HL7v2MessagePages pages = new HttpHealthcareApiClient.HL7v2MessagePages(this.client, hl7v2Store, null, null, this.filter, "sendTime");
            for (List page : pages) {
                page.stream().map(HL7v2Message::getName).forEach(arg_0 -> ((DoFn.ProcessContext)context).output(arg_0));
            }
        }
    }

    static class ListHL7v2MessageIDs
    extends PTransform<PBegin, PCollection<String>> {
        private final List<String> hl7v2Stores;
        private final String filter;

        ListHL7v2MessageIDs(List<String> hl7v2Stores, String filter) {
            this.hl7v2Stores = hl7v2Stores;
            this.filter = filter;
        }

        ListHL7v2MessageIDs(List<String> hl7v2Stores) {
            this.hl7v2Stores = hl7v2Stores;
            this.filter = null;
        }

        public PCollection<String> expand(PBegin input) {
            return (PCollection)((PCollection)input.apply((PTransform)Create.of(this.hl7v2Stores))).apply((PTransform)ParDo.of((DoFn)new ListHL7v2MessageIDsFn(this.filter)));
        }
    }
}

