/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.api.services.healthcare.v1.model.Message;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2IO;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2Message;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2MessageCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOError;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HL7v2IOTest {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();

    @Test
    public void test_HL7v2IO_failedReads() {
        List<String> badMessageIDs = Arrays.asList("projects/a/locations/b/datasets/c/hl7V2Stores/d/messages/foo", "projects/a/locations/b/datasets/c/hl7V2Stores/d/messages/bar");
        HL7v2IO.Read.Result readResult = (HL7v2IO.Read.Result)((PCollection)this.pipeline.apply((PTransform)Create.of(badMessageIDs))).apply((PTransform)HL7v2IO.getAll());
        PCollection failed = readResult.getFailedReads();
        PCollection messages = readResult.getMessages();
        PCollection failedMsgIds = (PCollection)failed.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(HealthcareIOError::getDataResource));
        PAssert.that((PCollection)failedMsgIds).containsInAnyOrder(badMessageIDs);
        PAssert.that((PCollection)messages).empty();
        this.pipeline.run();
    }

    @Test
    public void test_HL7v2IO_failedWrites() {
        Message msg = new Message().setData("");
        List<HL7v2Message> emptyMessages = Collections.singletonList(HL7v2Message.fromModel((Message)msg));
        PCollection messages = (PCollection)this.pipeline.apply((PTransform)Create.of(emptyMessages).withCoder((Coder)new HL7v2MessageCoder()));
        HL7v2IO.Write.Result writeResult = (HL7v2IO.Write.Result)messages.apply((PTransform)HL7v2IO.ingestMessages((String)"projects/foo/locations/us-central1/datasets/bar/hl7V2Stores/baz"));
        PCollection failedInserts = writeResult.getFailedInsertsWithErr();
        PCollection failedMsgs = (PCollection)failedInserts.apply(Count.globally());
        PAssert.thatSingleton((PCollection)failedMsgs).isEqualTo((Object)1L);
        this.pipeline.run();
    }
}

