/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIO;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIOPatientEverything;
import org.apache.beam.sdk.io.gcp.healthcare.FhirSearchParameter;
import org.apache.beam.sdk.io.gcp.healthcare.FhirSearchParameterCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOError;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FhirIOTest {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();

    @Test
    public void test_FhirIO_failedReads() {
        List<String> badMessageIDs = Arrays.asList("foo", "bar");
        FhirIO.Read.Result readResult = (FhirIO.Read.Result)((PCollection)this.pipeline.apply((PTransform)Create.of(badMessageIDs))).apply((PTransform)FhirIO.readResources());
        PCollection failed = readResult.getFailedReads();
        PCollection resources = readResult.getResources();
        PCollection failedMsgIds = (PCollection)failed.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(HealthcareIOError::getDataResource));
        PAssert.that((PCollection)failedMsgIds).containsInAnyOrder(badMessageIDs);
        PAssert.that((PCollection)resources).empty();
        this.pipeline.run();
    }

    @Test
    public void test_FhirIO_failedSearches() {
        FhirSearchParameter input = FhirSearchParameter.of((String)"resource-type-1", null);
        FhirIO.Search.Result searchResult = (FhirIO.Search.Result)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)input, (Object[])new FhirSearchParameter[0]).withCoder((Coder)FhirSearchParameterCoder.of((Coder)StringUtf8Coder.of())))).apply((PTransform)FhirIO.searchResources((String)"bad-store"));
        PCollection failed = searchResult.getFailedSearches();
        PCollection failedMsgIds = (PCollection)failed.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(HealthcareIOError::getDataResource));
        PAssert.that((PCollection)failedMsgIds).containsInAnyOrder((Object[])new String[]{input.toString()});
        PAssert.that((PCollection)searchResult.getResources()).empty();
        PAssert.that((PCollection)searchResult.getKeyedResources()).empty();
        this.pipeline.run();
    }

    @Test
    public void test_FhirIO_failedSearchesWithGenericParameters() {
        FhirSearchParameter input = FhirSearchParameter.of((String)"resource-type-1", null);
        FhirIO.Search.Result searchResult = (FhirIO.Search.Result)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)input, (Object[])new FhirSearchParameter[0]).withCoder((Coder)FhirSearchParameterCoder.of((Coder)ListCoder.of((Coder)StringUtf8Coder.of()))))).apply((PTransform)FhirIO.searchResourcesWithGenericParameters((String)"bad-store"));
        PCollection failed = searchResult.getFailedSearches();
        PCollection failedMsgIds = (PCollection)failed.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(HealthcareIOError::getDataResource));
        PAssert.that((PCollection)failedMsgIds).containsInAnyOrder((Object[])new String[]{input.toString()});
        PAssert.that((PCollection)searchResult.getResources()).empty();
        PAssert.that((PCollection)searchResult.getKeyedResources()).empty();
        this.pipeline.run();
    }

    @Test
    public void test_FhirIO_failedWrites() {
        String badBundle = "bad";
        List<String> emptyMessages = Collections.singletonList(badBundle);
        PCollection fhirBundles = (PCollection)this.pipeline.apply((PTransform)Create.of(emptyMessages));
        FhirIO.Write.AbstractResult writeResult = (FhirIO.Write.AbstractResult)fhirBundles.apply((PTransform)FhirIO.Write.executeBundles((String)"projects/foo/locations/us-central1/datasets/bar/hl7V2Stores/baz"));
        PCollection failedInserts = writeResult.getFailedBodies();
        PAssert.thatSingleton((PCollection)failedInserts).satisfies((SerializableFunction & Serializable)err -> {
            Assert.assertEquals((Object)"bad", (Object)err.getDataResource());
            return null;
        });
        PCollection numFailedInserts = (PCollection)failedInserts.apply(Count.globally());
        PAssert.thatSingleton((PCollection)numFailedInserts).isEqualTo((Object)1L);
        this.pipeline.run();
    }

    @Test
    public void test_FhirIO_failedPatientEverything() {
        FhirIOPatientEverything.PatientEverythingParameter input = FhirIOPatientEverything.PatientEverythingParameter.builder().setResourceName("bad-resource-name").build();
        FhirIOPatientEverything.Result everythingResult = (FhirIOPatientEverything.Result)((PCollection)this.pipeline.apply((PTransform)Create.of((Object)input, (Object[])new FhirIOPatientEverything.PatientEverythingParameter[0]))).apply((PTransform)FhirIO.getPatientEverything());
        PCollection failed = everythingResult.getFailedReads();
        PCollection failedEverything = (PCollection)failed.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptors.strings()).via(HealthcareIOError::getDataResource));
        PAssert.that((PCollection)failedEverything).containsInAnyOrder((Object[])new String[]{input.toString()});
        PAssert.that((PCollection)everythingResult.getPatientCompartments()).empty();
        this.pipeline.run();
    }

    @Test
    public void test_FhirIO_Export_invalidUri() {
        String invalidUri = "someInvalidUri";
        this.pipeline.apply((PTransform)FhirIO.exportResources((String)"fakeStore", (String)"someInvalidUri"));
        RuntimeException exceptionThrown = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> ((TestPipeline)this.pipeline).run());
        Assert.assertTrue((boolean)exceptionThrown.getMessage().contains("someInvalidUri"));
    }
}

