/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import org.apache.beam.runners.direct.DirectOptions;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIO;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIOTestUtil;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareStoreTestPipelineOptions;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubGrpcClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubOptions;
import org.apache.beam.sdk.io.gcp.pubsub.TestPubsubOptions;
import org.apache.beam.sdk.io.gcp.pubsub.TestPubsubSignal;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Supplier;
import org.joda.time.Duration;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FhirIOReadIT {
    @Rule
    public transient TestPubsubSignal signal = TestPubsubSignal.create();
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create();
    private final String fhirStoreName;
    private final String pubsubTopic;
    private final String pubsubSubscription;
    private final String project;
    private transient HealthcareApiClient client;
    private String healthcareDataset;
    private PubsubClient pubsub;
    private TestPubsubOptions pipelineOptions;
    public String version;

    @Parameterized.Parameters(name="{0}")
    public static Collection<String> versions() {
        return Arrays.asList("DSTU2", "STU3", "R4");
    }

    public FhirIOReadIT(String version) {
        this.version = version;
        long testTime = System.currentTimeMillis();
        this.fhirStoreName = "FHIR_store_" + version + "_write_it_" + testTime + "_" + new SecureRandom().nextInt(32);
        this.project = ((HealthcareStoreTestPipelineOptions)TestPipeline.testingPipelineOptions().as(HealthcareStoreTestPipelineOptions.class)).getStoreProjectId();
        this.pubsubTopic = "projects/" + this.project + "/topics/FhirIO-IT-" + version + "-notifications-" + testTime + "-" + new SecureRandom().nextInt(32);
        this.pubsubSubscription = this.pubsubTopic.replaceAll("topic", "subscription");
        this.pipelineOptions = (TestPubsubOptions)TestPipeline.testingPipelineOptions().as(TestPubsubOptions.class);
    }

    @Before
    public void setup() throws Exception {
        this.healthcareDataset = String.format("projects/%s/locations/us-central1/datasets/apache-beam-integration-testing", this.project);
        if (this.client == null) {
            this.client = new HttpHealthcareApiClient();
        }
        this.pubsub = PubsubGrpcClient.FACTORY.newClient(null, null, (PubsubOptions)this.pipelineOptions);
        PubsubClient.TopicPath topicPath = PubsubClient.topicPathFromPath((String)this.pubsubTopic);
        this.pubsub.createTopic(topicPath);
        PubsubClient.SubscriptionPath subscriptionPath = PubsubClient.subscriptionPathFromPath((String)this.pubsubSubscription);
        this.pubsub.createSubscription(topicPath, subscriptionPath, 60);
        this.client.createFhirStore(this.healthcareDataset, this.fhirStoreName, this.version, this.pubsubTopic);
        FhirIOTestUtil.executeFhirBundles(this.client, this.healthcareDataset + "/fhirStores/" + this.fhirStoreName, FhirIOTestUtil.BUNDLES.get(this.version));
    }

    @After
    public void deleteFhirStore() throws IOException {
        HttpHealthcareApiClient client = new HttpHealthcareApiClient();
        client.deleteFhirStore(this.healthcareDataset + "/fhirStores/" + this.fhirStoreName);
        PubsubClient.TopicPath topicPath = PubsubClient.topicPathFromPath((String)this.pubsubTopic);
        PubsubClient.SubscriptionPath subscriptionPath = PubsubClient.subscriptionPathFromPath((String)this.pubsubSubscription);
        this.pubsub.deleteSubscription(subscriptionPath);
        this.pubsub.deleteTopic(topicPath);
        this.pubsub.close();
    }

    @Test
    public void testFhirIORead() throws Exception {
        ((DirectOptions)this.pipeline.getOptions().as(DirectOptions.class)).setBlockOnRun(false);
        FhirIO.Read.Result result = (FhirIO.Read.Result)((PCollection)this.pipeline.apply((PTransform)PubsubIO.readStrings().fromSubscription(this.pubsubSubscription))).apply((PTransform)FhirIO.readResources());
        PCollection resources = result.getResources();
        resources.apply("waitForAnyMessage", this.signal.signalSuccessWhen(resources.getCoder(), (SerializableFunction & Serializable)anyResources -> true));
        Supplier start = this.signal.waitForStart(Duration.standardMinutes((long)5L));
        this.pipeline.apply(this.signal.signalStart());
        PipelineResult job = this.pipeline.run();
        start.get();
        this.signal.waitForSuccess(Duration.standardMinutes((long)5L));
        try {
            job.cancel();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

