/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.gson.JsonArray;
import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.beam.runners.direct.DirectOptions;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIO;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIOPatientEverything;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIOTestUtil;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareStoreTestPipelineOptions;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class FhirIOPatientEverythingIT {
    public String version;
    private final String project;
    private transient HealthcareApiClient client;
    private static String healthcareDataset;
    private static final String BASE_STORE_ID;
    private String fhirStoreId;
    private List<FhirIOPatientEverything.PatientEverythingParameter> input = new ArrayList<FhirIOPatientEverything.PatientEverythingParameter>();
    @Rule
    public transient TestPipeline pipeline = TestPipeline.create();

    @Parameterized.Parameters(name="{0}")
    public static Collection<String> versions() {
        return Arrays.asList("R4");
    }

    public FhirIOPatientEverythingIT(String version) {
        this.version = version;
        this.fhirStoreId = BASE_STORE_ID + version;
        this.project = ((HealthcareStoreTestPipelineOptions)TestPipeline.testingPipelineOptions().as(HealthcareStoreTestPipelineOptions.class)).getStoreProjectId();
    }

    @Before
    public void setup() throws Exception {
        healthcareDataset = String.format("projects/%s/locations/us-central1/datasets/apache-beam-integration-testing", this.project);
        if (this.client == null) {
            this.client = new HttpHealthcareApiClient();
        }
        this.client.createFhirStore(healthcareDataset, this.fhirStoreId, this.version, "");
        List<String> bundles = FhirIOTestUtil.BUNDLES.get(this.version);
        List<String> prepopulatedResourceNames = FhirIOTestUtil.executeFhirBundles(this.client, healthcareDataset + "/fhirStores/" + this.fhirStoreId, bundles);
        HashMap filters = new HashMap();
        int requests = 0;
        for (String resourceName : prepopulatedResourceNames) {
            if (!resourceName.contains("/fhir/Patient/")) continue;
            this.input.add(FhirIOPatientEverything.PatientEverythingParameter.builder().setResourceName(resourceName).setFilters(filters).build());
            if (++requests <= 50) continue;
            break;
        }
    }

    @After
    public void teardown() throws IOException {
        HttpHealthcareApiClient client = new HttpHealthcareApiClient();
        for (String version : FhirIOPatientEverythingIT.versions()) {
            client.deleteFhirStore(healthcareDataset + "/fhirStores/" + BASE_STORE_ID + version);
        }
    }

    @Test
    public void testFhirIOPatientEverything() {
        ((DirectOptions)this.pipeline.getOptions().as(DirectOptions.class)).setBlockOnRun(false);
        PCollection everythingConfigs = (PCollection)this.pipeline.apply((PTransform)Create.of(this.input));
        FhirIOPatientEverything.Result result = (FhirIOPatientEverything.Result)everythingConfigs.apply((PTransform)FhirIO.getPatientEverything());
        PAssert.that((PCollection)result.getFailedReads()).empty();
        PCollection resources = result.getPatientCompartments();
        PAssert.that((PCollection)resources).satisfies((SerializableFunction & Serializable)input -> {
            for (JsonArray resource : input) {
                Assert.assertNotEquals((long)0L, (long)resource.size());
            }
            return null;
        });
        this.pipeline.run().waitUntilFinish();
    }

    static {
        BASE_STORE_ID = "FHIR_store_patient_everything_it_" + System.currentTimeMillis() + "_" + new SecureRandom().nextInt(32);
    }
}

