/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.api.services.healthcare.v1.model.DeidentifyConfig;
import java.io.IOException;
import java.security.SecureRandom;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIO;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIOTestUtil;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareStoreTestPipelineOptions;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.io.gcp.testing.BigqueryClient;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class FhirIOLROIT {
    private static final String FHIR_VERSION = "STU3";
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create();
    private final transient HealthcareApiClient client = new HttpHealthcareApiClient();
    private final String project;
    private final String healthcareDataset;
    private final String fhirStoreId = "FHIR_store_" + System.currentTimeMillis() + "_" + new SecureRandom().nextInt(32);
    private final String fhirStoreName;
    private final String deidFhirStoreId = this.fhirStoreId + "_deid";
    private final String deidFhirStoreName;

    public FhirIOLROIT() throws IOException {
        this.project = ((HealthcareStoreTestPipelineOptions)TestPipeline.testingPipelineOptions().as(HealthcareStoreTestPipelineOptions.class)).getStoreProjectId();
        this.healthcareDataset = String.format("projects/%s/locations/us-central1/datasets/apache-beam-integration-testing", this.project);
        String fhirStorePrefix = this.healthcareDataset + "/fhirStores/";
        this.fhirStoreName = fhirStorePrefix + this.fhirStoreId;
        this.deidFhirStoreName = fhirStorePrefix + this.deidFhirStoreId;
    }

    @Before
    public void setup() throws Exception {
        this.client.createFhirStore(this.healthcareDataset, this.fhirStoreId, FHIR_VERSION, null);
        this.client.createFhirStore(this.healthcareDataset, this.deidFhirStoreId, FHIR_VERSION, null);
        FhirIOTestUtil.executeFhirBundles(this.client, this.fhirStoreName, FhirIOTestUtil.BUNDLES.get(FHIR_VERSION));
    }

    @After
    public void deleteAllFhirStores() {
        try {
            this.client.deleteFhirStore(this.fhirStoreName);
            this.client.deleteFhirStore(this.deidFhirStoreName);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @AfterClass
    public static void teardownBucket() throws IOException {
        FhirIOTestUtil.tearDownTempBucket();
    }

    @Test
    public void test_FhirIO_exportFhirResources_Gcs() {
        String exportGcsUriPrefix = "gs://temp-storage-for-healthcare-io-tests/export/" + new SecureRandom().nextInt(32);
        this.pipeline.apply((PTransform)FhirIO.exportResources((String)this.fhirStoreName, (String)exportGcsUriPrefix));
        this.pipeline.run();
    }

    @Test
    public void test_FhirIO_exportFhirResources_BigQuery() throws IOException, InterruptedException {
        String bqDatasetId = this.fhirStoreId + "_dataset";
        BigqueryClient bqClient = BigqueryClient.getClient((String)"FhirIOROIT");
        bqClient.createNewDataset(this.project, bqDatasetId, Long.valueOf(3600000L));
        String exportBqDatasetUri = String.format("bq://%s.%s", this.project, bqDatasetId);
        this.pipeline.apply((PTransform)FhirIO.exportResources((String)this.fhirStoreName, (String)exportBqDatasetUri));
        this.pipeline.run();
        bqClient.deleteDataset(this.project, bqDatasetId);
    }

    @Test
    public void test_FhirIO_deidentify() throws IOException {
        DeidentifyConfig deidConfig = new DeidentifyConfig();
        this.pipeline.apply((PTransform)FhirIO.deidentify((String)this.fhirStoreName, (String)this.deidFhirStoreName, (DeidentifyConfig)deidConfig));
        this.pipeline.run();
    }
}

