/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore.it;

import com.google.api.core.ApiFuture;
import com.google.cloud.firestore.QuerySnapshot;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.Precondition;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Value;
import com.google.firestore.v1.Write;
import com.google.protobuf.Timestamp;
import com.google.rpc.Code;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreIO;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.io.gcp.firestore.it.BaseFirestoreIT;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Test;

public final class FirestoreV1IT
extends BaseFirestoreIT {
    @Test
    public void batchWrite_partialFailureOutputsToDeadLetterQueue() throws InterruptedException, ExecutionException, TimeoutException {
        String collectionId = "a";
        String docId = this.helper.docId();
        Write validWrite = Write.newBuilder().setUpdate(Document.newBuilder().setName(FirestoreV1IT.docPath(this.helper.getBaseDocumentPath(), collectionId, docId)).putFields("foo", Value.newBuilder().setStringValue(docId).build())).build();
        long millis = System.currentTimeMillis();
        Timestamp timestamp = Timestamp.newBuilder().setSeconds(millis / 1000L).setNanos((int)(millis % 1000L * 1000000L)).build();
        String docId2 = this.helper.docId();
        this.helper.getBaseDocument().collection(collectionId).document(docId2).create((Map)ImmutableMap.of((Object)"foo", (Object)"baz")).get(10L, TimeUnit.SECONDS);
        Write conditionalUpdate = Write.newBuilder().setUpdate(Document.newBuilder().setName(FirestoreV1IT.docPath(this.helper.getBaseDocumentPath(), collectionId, docId2)).putFields("foo", Value.newBuilder().setStringValue(docId).build())).setCurrentDocument(Precondition.newBuilder().setUpdateTime(timestamp)).build();
        ArrayList writes = Lists.newArrayList((Object[])new Write[]{validWrite, conditionalUpdate});
        RpcQosOptions options = BaseFirestoreIT.rpcQosOptions.toBuilder().withBatchMaxCount(2).build();
        PCollection writeFailurePCollection = (PCollection)((PCollection)this.testPipeline.apply((PTransform)Create.of((Iterable)writes))).apply((PTransform)((FirestoreV1.BatchWriteWithDeadLetterQueue.Builder)FirestoreIO.v1().write().batchWrite().withDeadLetterQueue().withRpcQosOptions(options)).build());
        PAssert.that((PCollection)writeFailurePCollection).satisfies((SerializableFunction & Serializable)writeFailures -> {
            Iterator iterator = writeFailures.iterator();
            Assert.assertTrue((boolean)iterator.hasNext());
            FirestoreV1.WriteFailure failure = (FirestoreV1.WriteFailure)iterator.next();
            Assert.assertEquals((Object)Code.FAILED_PRECONDITION, (Object)Code.forNumber((int)failure.getStatus().getCode()));
            Assert.assertNotNull((Object)failure.getWriteResult());
            Assert.assertFalse((boolean)failure.getWriteResult().hasUpdateTime());
            Assert.assertEquals((Object)conditionalUpdate, (Object)failure.getWrite());
            Assert.assertFalse((boolean)iterator.hasNext());
            return null;
        });
        this.testPipeline.run((PipelineOptions)this.options);
        ApiFuture actualDocsQuery = this.helper.getBaseDocument().collection(collectionId).orderBy("__name__").get();
        QuerySnapshot querySnapshot = (QuerySnapshot)actualDocsQuery.get(10L, TimeUnit.SECONDS);
        List documents = querySnapshot.getDocuments();
        List actualDocumentIds = documents.stream().map(doc -> KV.of((Object)doc.getId(), (Object)doc.getString("foo"))).collect(Collectors.toList());
        ArrayList expected = Lists.newArrayList((Object[])new KV[]{KV.of((Object)docId, (Object)docId), KV.of((Object)docId2, (Object)"baz")});
        Assert.assertEquals((Object)expected, actualDocumentIds);
    }

    @Override
    protected PTransform<PCollection<String>, PCollection<ListCollectionIdsRequest>> getListCollectionIdsPTransform(String testMethodName) {
        return new ListCollectionIds(this.helper.getDatabase(), this.helper.getBaseDocumentPath());
    }

    @Override
    protected PTransform<PCollection<String>, PCollection<ListDocumentsRequest>> getListDocumentsPTransform(String testMethodName) {
        return new ListDocuments(this.helper.getDatabase(), this.helper.getBaseDocumentPath());
    }

    @Override
    protected PTransform<PCollection<List<String>>, PCollection<BatchGetDocumentsRequest>> getBatchGetDocumentsPTransform(String testMethodName, String collectionId) {
        return new BatchGetDocuments(this.helper.getDatabase(), this.helper.getBaseDocumentPath(), collectionId);
    }

    @Override
    protected PTransform<PCollection<String>, PCollection<RunQueryRequest>> getRunQueryPTransform(String testMethodName) {
        return new RunQuery(this.helper.getDatabase(), this.helper.getBaseDocumentPath());
    }

    @Override
    protected PTransform<PCollection<String>, PCollection<PartitionQueryRequest>> getPartitionQueryPTransform(String testMethodName, int partitionCount) {
        return new PartitionQuery(this.helper.getDatabase(), this.helper.getDocumentRoot(), partitionCount);
    }

    @Override
    protected PTransform<PCollection<List<String>>, PCollection<Write>> getWritePTransform(String testMethodName, String collectionId) {
        return new WritePTransform(this.helper.getDatabase(), this.helper.getBaseDocumentPath(), collectionId);
    }

    private static String docPath(String baseDocumentPath, String collectionId, String docId) {
        return String.format("%s/%s/%s", baseDocumentPath, collectionId, docId);
    }

    private static abstract class BasePTransform<InT, OutT>
    extends PTransform<PCollection<InT>, PCollection<OutT>> {
        protected final String database;
        protected final String baseDocumentPath;
        protected final String collectionId;

        private BasePTransform(String database, String baseDocumentPath, String collectionId) {
            this.database = database;
            this.baseDocumentPath = baseDocumentPath;
            this.collectionId = collectionId;
        }

        protected String docPath(String docId) {
            return FirestoreV1IT.docPath(this.baseDocumentPath, this.collectionId, docId);
        }
    }

    private static final class WritePTransform
    extends BasePTransform<List<String>, Write> {
        public WritePTransform(String database, String baseDocumentPath, String collectionId) {
            super(database, baseDocumentPath, collectionId);
        }

        public PCollection<Write> expand(PCollection<List<String>> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<List<String>, Write>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    List documentIds = (List)c.element();
                    documentIds.stream().map(docId -> Write.newBuilder().setUpdate(Document.newBuilder().setName(this.docPath((String)docId)).putFields("foo", Value.newBuilder().setStringValue(docId).build())).build()).forEach(arg_0 -> ((DoFn.ProcessContext)c).output(arg_0));
                }
            }));
        }
    }

    private static final class PartitionQuery
    extends BasePTransform<String, PartitionQueryRequest> {
        private final int partitionCount;

        public PartitionQuery(String database, String baseDocumentPath, int partitionCount) {
            super(database, baseDocumentPath, "");
            this.partitionCount = partitionCount;
        }

        public PCollection<PartitionQueryRequest> expand(PCollection<String> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<String, PartitionQueryRequest>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    c.output((Object)PartitionQueryRequest.newBuilder().setParent(baseDocumentPath).setPageSize(1).setPartitionCount((long)partitionCount).setStructuredQuery(StructuredQuery.newBuilder().addFrom(StructuredQuery.CollectionSelector.newBuilder().setCollectionId((String)c.element()).setAllDescendants(true)).addOrderBy(StructuredQuery.Order.newBuilder().setField(StructuredQuery.FieldReference.newBuilder().setFieldPath("__name__")).setDirection(StructuredQuery.Direction.ASCENDING))).build());
                }
            }));
        }
    }

    private static final class RunQuery
    extends BasePTransform<String, RunQueryRequest> {
        public RunQuery(String database, String baseDocumentPath) {
            super(database, baseDocumentPath, "");
        }

        public PCollection<RunQueryRequest> expand(PCollection<String> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<String, RunQueryRequest>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    c.output((Object)RunQueryRequest.newBuilder().setParent(baseDocumentPath).setStructuredQuery(StructuredQuery.newBuilder().addFrom(StructuredQuery.CollectionSelector.newBuilder().setCollectionId((String)c.element())).setWhere(StructuredQuery.Filter.newBuilder().setFieldFilter(StructuredQuery.FieldFilter.newBuilder().setField(StructuredQuery.FieldReference.newBuilder().setFieldPath("foo")).setOp(StructuredQuery.FieldFilter.Operator.EQUAL).setValue(Value.newBuilder().setStringValue("bar"))))).build());
                }
            }));
        }
    }

    private static final class BatchGetDocuments
    extends BasePTransform<List<String>, BatchGetDocumentsRequest> {
        public BatchGetDocuments(String database, String baseDocumentPath, String collectionId) {
            super(database, baseDocumentPath, collectionId);
        }

        public PCollection<BatchGetDocumentsRequest> expand(PCollection<List<String>> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<List<String>, BatchGetDocumentsRequest>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    BatchGetDocumentsRequest.Builder builder = BatchGetDocumentsRequest.newBuilder().setDatabase(database);
                    builder.addDocuments(this.docPath("404"));
                    ((List)c.element()).stream().map(docId -> this.docPath((String)docId)).forEach(arg_0 -> ((BatchGetDocumentsRequest.Builder)builder).addDocuments(arg_0));
                    c.output((Object)builder.build());
                }
            }));
        }
    }

    private static final class ListDocuments
    extends BasePTransform<String, ListDocumentsRequest> {
        public ListDocuments(String database, String baseDocumentPath) {
            super(database, baseDocumentPath, "");
        }

        public PCollection<ListDocumentsRequest> expand(PCollection<String> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<String, ListDocumentsRequest>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    c.output((Object)ListDocumentsRequest.newBuilder().setParent(baseDocumentPath).setCollectionId((String)c.element()).build());
                }
            }));
        }
    }

    private static final class ListCollectionIds
    extends BasePTransform<String, ListCollectionIdsRequest> {
        public ListCollectionIds(String database, String baseDocumentPath) {
            super(database, baseDocumentPath, "");
        }

        public PCollection<ListCollectionIdsRequest> expand(PCollection<String> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new DoFn<String, ListCollectionIdsRequest>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext c) {
                    c.output((Object)ListCollectionIdsRequest.newBuilder().setParent(baseDocumentPath).build());
                }
            }));
        }
    }
}

