/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore.it;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.cloud.firestore.CollectionReference;
import com.google.cloud.firestore.DocumentReference;
import com.google.cloud.firestore.Firestore;
import com.google.cloud.firestore.FirestoreOptions;
import com.google.cloud.firestore.WriteBatch;
import com.google.cloud.firestore.WriteResult;
import com.google.cloud.firestore.spi.v1.FirestoreRpc;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.ListCollectionIdsRequest;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Write;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Streams;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.MoreExecutors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FirestoreTestingHelper
implements TestRule {
    private static final Logger LOG = LoggerFactory.getLogger(FirestoreTestingHelper.class);
    static final String BASE_COLLECTION_ID;
    private static final FirestoreOptions FIRESTORE_OPTIONS;
    private final Firestore fs = (Firestore)FIRESTORE_OPTIONS.getService();
    private final FirestoreRpc rpc = (FirestoreRpc)FIRESTORE_OPTIONS.getRpc();
    private final CleanupMode cleanupMode;
    private Class<?> testClass;
    private String testName;
    private DataLayout dataLayout;
    private int docIdCounter;
    private int colIdCounter;
    private boolean testSuccess = false;

    public FirestoreTestingHelper(CleanupMode cleanupMode) {
        this.cleanupMode = cleanupMode;
    }

    public Statement apply(final @NonNull Statement base, Description description) {
        this.testClass = description.getTestClass();
        this.testName = description.getMethodName();
        TestDataLayoutHint hint = (TestDataLayoutHint)description.getAnnotation(TestDataLayoutHint.class);
        this.dataLayout = hint != null ? hint.value() : DataLayout.Shallow;
        return new Statement(){

            public void evaluate() throws Throwable {
                block10: {
                    try {
                        base.evaluate();
                        FirestoreTestingHelper.this.testSuccess = true;
                    }
                    catch (Throwable throwable) {
                        block11: {
                            if (FirestoreTestingHelper.this.cleanupMode == CleanupMode.ALWAYS || FirestoreTestingHelper.this.cleanupMode == CleanupMode.ON_SUCCESS_ONLY && FirestoreTestingHelper.this.testSuccess) {
                                try {
                                    FirestoreTestingHelper.this.cleanUp(FirestoreTestingHelper.this.getBaseDocumentPath());
                                }
                                catch (Exception e) {
                                    if (LOG.isDebugEnabled() || LOG.isTraceEnabled()) {
                                        LOG.debug("Error while running cleanup", (Throwable)e);
                                        break block11;
                                    }
                                    LOG.info("Error while running cleanup: {} (set log level higher for stacktrace)", (Object)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
                                }
                            }
                        }
                        throw throwable;
                    }
                    if (FirestoreTestingHelper.this.cleanupMode == CleanupMode.ALWAYS || FirestoreTestingHelper.this.cleanupMode == CleanupMode.ON_SUCCESS_ONLY && FirestoreTestingHelper.this.testSuccess) {
                        try {
                            FirestoreTestingHelper.this.cleanUp(FirestoreTestingHelper.this.getBaseDocumentPath());
                        }
                        catch (Exception e) {
                            if (LOG.isDebugEnabled() || LOG.isTraceEnabled()) {
                                LOG.debug("Error while running cleanup", (Throwable)e);
                                break block10;
                            }
                            LOG.info("Error while running cleanup: {} (set log level higher for stacktrace)", (Object)(e.getMessage() == null ? e.getClass().getName() : e.getMessage()));
                        }
                    }
                }
            }
        };
    }

    Firestore getFs() {
        return this.fs;
    }

    String getDatabase() {
        return String.format("projects/%s/databases/%s", FIRESTORE_OPTIONS.getProjectId(), FIRESTORE_OPTIONS.getDatabaseId());
    }

    String getDocumentRoot() {
        return this.getDatabase() + "/documents";
    }

    DocumentReference getBaseDocument() {
        return FirestoreTestingHelper.getBaseDocument(this.fs, this.testClass, this.testName);
    }

    String getBaseDocumentPath() {
        return String.format("%s/%s", this.getDocumentRoot(), this.getBaseDocument().getPath());
    }

    String docId() {
        return FirestoreTestingHelper.id("doc", this.docIdCounter++);
    }

    String colId() {
        return FirestoreTestingHelper.id("col", this.colIdCounter++);
    }

    DocumentGenerator documentGenerator(int to, String collectionId) {
        return this.documentGenerator(to, collectionId, false);
    }

    DocumentGenerator documentGenerator(int to, String collectionId, boolean addBazDoc) {
        return new DocumentGenerator(to, collectionId, addBazDoc);
    }

    Stream<String> listCollectionIds(String parent) {
        ListCollectionIdsRequest lcir = ListCollectionIdsRequest.newBuilder().setParent(parent).build();
        FirestoreClient.ListCollectionIdsPagedResponse response = (FirestoreClient.ListCollectionIdsPagedResponse)this.rpc.listCollectionIdsPagedCallable().call((Object)lcir);
        return StreamSupport.stream(response.iteratePages().spliterator(), false).flatMap(page -> StreamSupport.stream(page.getValues().spliterator(), false)).map(colId -> String.format("%s/%s", parent, colId));
    }

    Stream<String> listDocumentIds(String collectionPath) {
        int index = collectionPath.lastIndexOf(47);
        String parent = collectionPath.substring(0, index);
        String collectionId = collectionPath.substring(index + 1);
        ListDocumentsRequest ldr = ListDocumentsRequest.newBuilder().setParent(parent).setCollectionId(collectionId).setShowMissing(true).build();
        FirestoreClient.ListDocumentsPagedResponse response = (FirestoreClient.ListDocumentsPagedResponse)this.rpc.listDocumentsPagedCallable().call((Object)ldr);
        return StreamSupport.stream(response.iteratePages().spliterator(), false).flatMap(page -> ((ListDocumentsResponse)page.getResponse()).getDocumentsList().stream()).map(Document::getName).filter(s -> !s.isEmpty());
    }

    Stream<String> listDocumentsViaQuery(String collectionPath) {
        int index = collectionPath.lastIndexOf(47);
        String parent = collectionPath.substring(0, index);
        String collectionId = collectionPath.substring(index + 1);
        StructuredQuery.FieldReference nameField = StructuredQuery.FieldReference.newBuilder().setFieldPath("__name__").build();
        RunQueryRequest rqr = RunQueryRequest.newBuilder().setParent(parent).setStructuredQuery(StructuredQuery.newBuilder().addFrom(StructuredQuery.CollectionSelector.newBuilder().setCollectionId(collectionId)).addOrderBy(StructuredQuery.Order.newBuilder().setField(nameField).setDirection(StructuredQuery.Direction.ASCENDING).build()).setSelect(StructuredQuery.Projection.newBuilder().addFields(nameField).build())).build();
        return StreamSupport.stream(this.rpc.runQueryCallable().call((Object)rqr).spliterator(), false).filter(RunQueryResponse::hasDocument).map(RunQueryResponse::getDocument).map(Document::getName);
    }

    private void cleanUp(String baseDocument) {
        LOG.debug("Running cleanup...");
        Batcher batcher = new Batcher();
        this.walkDoc(batcher, baseDocument);
        batcher.flush();
        LOG.debug("Running cleanup complete");
    }

    private void walkDoc(Batcher batcher, String baseDocument) {
        batcher.checkState();
        this.listCollectionIds(baseDocument).forEach(col -> this.walkCol(batcher, (String)col));
        batcher.add(baseDocument);
    }

    private void walkCol(Batcher batcher, String baseCollection) {
        batcher.checkState();
        if (this.dataLayout == DataLayout.Shallow) {
            this.listDocumentsViaQuery(baseCollection).forEach(batcher::add);
            batcher.flush();
        }
        this.listDocumentIds(baseCollection).forEach(doc -> this.walkDoc(batcher, (String)doc));
    }

    static DocumentReference getBaseDocument(Firestore fs, Class<?> testClass, String testName) {
        return fs.collection("beam").document("IT").collection(BASE_COLLECTION_ID).document(testClass.getSimpleName()).collection("test").document(testName);
    }

    static <T> Stream<List<T>> chunkUpDocIds(List<T> things) {
        return Streams.stream((Iterable)Iterables.partition(things, (int)500));
    }

    static <T> ApiFunction<List<List<T>>, List<T>> flattenListList() {
        return input -> {
            ArrayList retVal = new ArrayList();
            for (List writeResults : input) {
                retVal.addAll(writeResults);
            }
            return retVal;
        };
    }

    static String assumeEnvVarSet(@NonNull String name) {
        LOG.debug(">>> assumeEnvVarSet(name : {})", (Object)name);
        try {
            String value = System.getenv(name);
            LOG.debug("value = {}", (Object)value);
            Assume.assumeThat((String)(name + " not set"), (Object)value, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            String string = value;
            return string;
        }
        finally {
            LOG.debug("<<< assumeEnvVarSet(name : {})", (Object)name);
        }
    }

    private static String id(String docOrCol, int counter) {
        return String.format("%s-%05d", docOrCol, counter);
    }

    static {
        Instant now = Clock.systemUTC().instant();
        DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withZone(ZoneId.from(ZoneOffset.UTC));
        BASE_COLLECTION_ID = formatter.format(now);
        FIRESTORE_OPTIONS = FirestoreOptions.getDefaultInstance();
    }

    private final class Batcher {
        private static final int MAX_BATCH_SIZE = 500;
        private final BatchWriteRequest.Builder batch;
        private boolean failed;

        public Batcher() {
            this.batch = BatchWriteRequest.newBuilder().setDatabase(FirestoreTestingHelper.this.getDatabase());
            this.failed = false;
        }

        public void add(String docName) {
            this.checkState();
            this.batch.addWrites(Write.newBuilder().setDelete(docName));
        }

        private void checkState() {
            this.requireNotFailed();
            this.maybeFlush();
        }

        private void requireNotFailed() {
            if (this.failed) {
                throw new IllegalStateException("Previous batch commit failed, unable to enqueue new operation");
            }
        }

        private void maybeFlush() {
            if (this.batch.getWritesCount() == 500) {
                this.flush();
            }
        }

        private void flush() {
            if (this.batch.getWritesCount() == 0) {
                return;
            }
            try {
                LOG.trace("Flushing {} elements...", (Object)this.batch.getWritesCount());
                FirestoreTestingHelper.this.rpc.batchWriteCallable().futureCall((Object)this.batch.build()).get(30L, TimeUnit.SECONDS);
                LOG.trace("Flushing {} elements complete", (Object)this.batch.getWritesCount());
                this.batch.clearWrites();
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                this.failed = true;
                throw new RuntimeException(e);
            }
        }
    }

    final class DocumentGenerator {
        private final List<String> documentIds;
        private final String collectionId;
        private final boolean addBazDoc;

        private DocumentGenerator(int to, String collectionId, boolean addBazDoc) {
            this.documentIds = Collections.unmodifiableList(IntStream.rangeClosed(1, to).mapToObj(i -> FirestoreTestingHelper.this.docId()).collect(Collectors.toList()));
            this.collectionId = collectionId;
            this.addBazDoc = addBazDoc;
        }

        ApiFuture<List<WriteResult>> generateDocuments() {
            CollectionReference baseCollection = FirestoreTestingHelper.this.getBaseDocument().collection(this.collectionId);
            List futures = Streams.concat((Stream[])new Stream[]{FirestoreTestingHelper.chunkUpDocIds(this.documentIds).map(chunk -> {
                WriteBatch batch = FirestoreTestingHelper.this.fs.batch();
                chunk.stream().map(arg_0 -> ((CollectionReference)baseCollection).document(arg_0)).forEach(ref -> {
                    WriteBatch cfr_ignored_0 = (WriteBatch)batch.set(ref, (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
                });
                return batch.commit();
            }), Stream.of(Optional.of(this.addBazDoc)).filter(o -> o.filter(b -> b).isPresent()).map(x -> {
                WriteBatch batch = FirestoreTestingHelper.this.fs.batch();
                batch.set(baseCollection.document(), (Map)ImmutableMap.of((Object)"foo", (Object)"baz"));
                return batch.commit();
            })}).collect(Collectors.toList());
            return ApiFutures.transform((ApiFuture)ApiFutures.allAsList(futures), FirestoreTestingHelper.flattenListList(), (Executor)MoreExecutors.directExecutor());
        }

        List<String> getDocumentIds() {
            return this.documentIds;
        }

        List<String> expectedDocumentPaths() {
            return this.documentIds.stream().map(id -> String.format("%s/%s/%s", FirestoreTestingHelper.this.getDocumentRoot(), FirestoreTestingHelper.this.getBaseDocument().collection(this.collectionId).getPath(), id)).collect(Collectors.toList());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    static @interface TestDataLayoutHint {
        public DataLayout value() default DataLayout.Shallow;
    }

    static enum DataLayout {
        Shallow,
        Deep;

    }

    static enum CleanupMode {
        ALWAYS,
        ON_SUCCESS_ONLY,
        NEVER;

    }
}

