/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.firestore.v1.Write;
import com.google.rpc.Code;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.grpc.Status;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.apache.beam.sdk.io.gcp.firestore.CounterFactory;
import org.apache.beam.sdk.io.gcp.firestore.DistributionFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreProtoHelpers;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1WriteFn;
import org.apache.beam.sdk.io.gcp.firestore.JodaClock;
import org.apache.beam.sdk.io.gcp.firestore.RpcQos;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosImpl;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public final class RpcQosTest {
    private static final ApiException RETRYABLE_ERROR = ApiExceptionFactory.createException((Throwable)new SocketTimeoutException("retryableError"), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.CANCELLED), (boolean)true);
    private static final ApiException NON_RETRYABLE_ERROR = ApiExceptionFactory.createException((Throwable)new IOException("nonRetryableError"), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.FAILED_PRECONDITION), (boolean)false);
    private static final ApiException RETRYABLE_ERROR_WITH_NON_RETRYABLE_CODE = ApiExceptionFactory.createException((Throwable)new SocketTimeoutException("retryableError"), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INVALID_ARGUMENT), (boolean)true);
    private static final RpcQos.RpcAttempt.Context RPC_ATTEMPT_CONTEXT = RpcQosTest.class::getName;
    @Mock(lenient=true)
    private Sleeper sleeper;
    @Mock(lenient=true)
    private CounterFactory counterFactory;
    @Mock(lenient=true)
    private DistributionFactory distributionFactory;
    @Mock(lenient=true)
    private Counter counterThrottlingMs;
    @Mock(lenient=true)
    private Counter counterRpcFailures;
    @Mock(lenient=true)
    private Counter counterRpcSuccesses;
    @Mock(lenient=true)
    private Counter counterRpcStreamValueReceived;
    @Mock(lenient=true)
    private BoundedWindow window;
    private final JodaClock monotonicClock = new JodaClock(){
        private long counter = 0L;

        public Instant instant() {
            return Instant.ofEpochMilli((long)this.counter++);
        }
    };
    private final Random random = new Random(1234567890L);
    private RpcQosOptions options;

    @Before
    public void setUp() {
        Mockito.when((Object)this.counterFactory.get(RPC_ATTEMPT_CONTEXT.getNamespace(), "throttlingMs")).thenReturn((Object)this.counterThrottlingMs);
        Mockito.when((Object)this.counterFactory.get(RPC_ATTEMPT_CONTEXT.getNamespace(), "rpc_failures")).thenReturn((Object)this.counterRpcFailures);
        Mockito.when((Object)this.counterFactory.get(RPC_ATTEMPT_CONTEXT.getNamespace(), "rpc_successes")).thenReturn((Object)this.counterRpcSuccesses);
        Mockito.when((Object)this.counterFactory.get(RPC_ATTEMPT_CONTEXT.getNamespace(), "rpc_streamValueReceived")).thenReturn((Object)this.counterRpcStreamValueReceived);
        Mockito.when((Object)this.distributionFactory.get((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenAnswer(invocation -> (Distribution)Mockito.mock(Distribution.class, (String)((String)invocation.getArgument(1, String.class))));
        this.options = RpcQosOptions.defaultOptions().toBuilder().withInitialBackoff(Duration.millis((long)1L)).withSamplePeriod(Duration.millis((long)100L)).withSamplePeriodBucketSize(Duration.millis((long)10L)).withOverloadRatio(2.0).withThrottleDuration(Duration.millis((long)50L)).withHintMaxNumWorkers(1).unsafeBuild();
    }

    @Test
    public void reads_processedWhenNoErrors() throws InterruptedException {
        RpcQosImpl qos = new RpcQosImpl(this.options, this.random, this.sleeper, this.counterFactory, this.distributionFactory);
        int numSuccesses = 100;
        int numStreamElements = 25;
        for (int i = 0; i < numSuccesses; ++i) {
            RpcQos.RpcReadAttempt readAttempt = qos.newReadAttempt(RPC_ATTEMPT_CONTEXT);
            Instant start = this.monotonicClock.instant();
            Assert.assertTrue((boolean)readAttempt.awaitSafeToProceed(start));
            for (int j = 0; j < numStreamElements; ++j) {
                readAttempt.recordStreamValue(this.monotonicClock.instant());
            }
            readAttempt.recordRequestStart(this.monotonicClock.instant());
            readAttempt.recordRequestSuccessful(this.monotonicClock.instant());
        }
        ((Sleeper)Mockito.verify((Object)this.sleeper, (VerificationMode)Mockito.times((int)0))).sleep(ArgumentMatchers.anyLong());
        ((Counter)Mockito.verify((Object)this.counterThrottlingMs, (VerificationMode)Mockito.times((int)0))).inc(ArgumentMatchers.anyLong());
        ((Counter)Mockito.verify((Object)this.counterRpcFailures, (VerificationMode)Mockito.times((int)0))).inc();
        ((Counter)Mockito.verify((Object)this.counterRpcSuccesses, (VerificationMode)Mockito.times((int)numSuccesses))).inc();
        ((Counter)Mockito.verify((Object)this.counterRpcStreamValueReceived, (VerificationMode)Mockito.times((int)(numSuccesses * numStreamElements)))).inc();
    }

    @Test
    public void reads_blockWhenNotSafeToProceed() throws InterruptedException {
        RpcQosImpl qos = new RpcQosImpl(this.options, this.random, this.sleeper, this.counterFactory, this.distributionFactory);
        int numFailures = 3;
        for (int i = 0; i < numFailures; ++i) {
            RpcQos.RpcReadAttempt readAttempt = qos.newReadAttempt(RPC_ATTEMPT_CONTEXT);
            Instant start = this.monotonicClock.instant();
            Assert.assertTrue((boolean)readAttempt.awaitSafeToProceed(start));
            Instant end = this.monotonicClock.instant();
            readAttempt.recordRequestStart(start);
            readAttempt.recordRequestFailed(end);
        }
        RpcQos.RpcReadAttempt readAttempt2 = qos.newReadAttempt(RPC_ATTEMPT_CONTEXT);
        Assert.assertFalse((boolean)readAttempt2.awaitSafeToProceed(this.monotonicClock.instant()));
        long sleepMillis = this.options.getInitialBackoff().getMillis();
        ((Sleeper)Mockito.verify((Object)this.sleeper, (VerificationMode)Mockito.times((int)0))).sleep(sleepMillis);
        ((Counter)Mockito.verify((Object)this.counterThrottlingMs, (VerificationMode)Mockito.times((int)0))).inc(sleepMillis);
        ((Counter)Mockito.verify((Object)this.counterRpcFailures, (VerificationMode)Mockito.times((int)numFailures))).inc();
        ((Counter)Mockito.verify((Object)this.counterRpcSuccesses, (VerificationMode)Mockito.times((int)0))).inc();
        ((Counter)Mockito.verify((Object)this.counterRpcStreamValueReceived, (VerificationMode)Mockito.times((int)0))).inc();
    }

    @Test
    public void writes_blockWhenNotSafeToProceed() throws InterruptedException {
        RpcQosImpl qos = new RpcQosImpl(this.options, this.random, this.sleeper, this.counterFactory, this.distributionFactory);
        int numFailures = 3;
        for (int i = 0; i < numFailures; ++i) {
            RpcQos.RpcWriteAttempt writeAttempt = qos.newWriteAttempt(RPC_ATTEMPT_CONTEXT);
            Instant start = this.monotonicClock.instant();
            Assert.assertTrue((boolean)writeAttempt.awaitSafeToProceed(start));
            writeAttempt.recordRequestStart(start, 1);
            Instant end = this.monotonicClock.instant();
            writeAttempt.recordWriteCounts(end, 0, 1);
            writeAttempt.recordRequestFailed(end);
        }
        RpcQos.RpcWriteAttempt writeAttempt2 = qos.newWriteAttempt(RPC_ATTEMPT_CONTEXT);
        Assert.assertFalse((boolean)writeAttempt2.awaitSafeToProceed(this.monotonicClock.instant()));
        long sleepMillis = this.options.getInitialBackoff().getMillis();
        ((Sleeper)Mockito.verify((Object)this.sleeper, (VerificationMode)Mockito.times((int)0))).sleep(sleepMillis);
        ((Counter)Mockito.verify((Object)this.counterThrottlingMs, (VerificationMode)Mockito.times((int)0))).inc(sleepMillis);
        ((Counter)Mockito.verify((Object)this.counterRpcFailures, (VerificationMode)Mockito.times((int)numFailures))).inc();
        ((Counter)Mockito.verify((Object)this.counterRpcSuccesses, (VerificationMode)Mockito.times((int)0))).inc();
        ((Counter)Mockito.verify((Object)this.counterRpcStreamValueReceived, (VerificationMode)Mockito.times((int)0))).inc();
    }

    @Test
    public void writes_shouldFlush_numWritesHigherThanBatchCount_newTimeBucket_lteq0() {
        this.doTest_writes_shouldFlush_numWritesHigherThanBatchCount_newTimeBucket(false, 0);
    }

    @Test
    public void writes_shouldFlush_numWritesHigherThanBatchCount_newTimeBucket_lt() {
        this.doTest_writes_shouldFlush_numWritesHigherThanBatchCount_newTimeBucket(false, 9);
    }

    @Test
    public void writes_shouldFlush_numWritesHigherThanBatchCount_newTimeBucket_eq() {
        this.doTest_writes_shouldFlush_numWritesHigherThanBatchCount_newTimeBucket(true, 10);
    }

    @Test
    public void writes_shouldFlush_numWritesHigherThanBatchCount_newTimeBucket_gt() {
        this.doTest_writes_shouldFlush_numWritesHigherThanBatchCount_newTimeBucket(true, 11);
    }

    @Test
    public void writes_shouldFlush_numWritesHigherThanBatchCount_existingTimeBucket_lteq0() {
        this.doTest_writes_shouldFlush_numWritesHigherThanBatchCount_existingTimeBucket(false, 0);
    }

    @Test
    public void writes_shouldFlush_numWritesHigherThanBatchCount_existingTimeBucket_lt() {
        this.doTest_writes_shouldFlush_numWritesHigherThanBatchCount_existingTimeBucket(false, 9);
    }

    @Test
    public void writes_shouldFlush_numWritesHigherThanBatchCount_existingTimeBucket_eq() {
        this.doTest_writes_shouldFlush_numWritesHigherThanBatchCount_existingTimeBucket(true, 10);
    }

    @Test
    public void writes_shouldFlush_numWritesHigherThanBatchCount_existingTimeBucket_gt() {
        this.doTest_writes_shouldFlush_numWritesHigherThanBatchCount_existingTimeBucket(true, 11);
    }

    @Test
    public void writes_shouldFlush_numBytes_lt() {
        this.doTest_writes_shouldFlush_numBytes(false, 2999L);
    }

    @Test
    public void writes_shouldFlush_numBytes_eq() {
        this.doTest_writes_shouldFlush_numBytes(true, 3000L);
    }

    @Test
    public void attemptsExhaustCorrectly() throws InterruptedException {
        RpcQosOptions rpcQosOptions = this.options.toBuilder().withMaxAttempts(3).unsafeBuild();
        RpcQosImpl qos = new RpcQosImpl(rpcQosOptions, this.random, this.sleeper, this.counterFactory, this.distributionFactory);
        RpcQos.RpcReadAttempt readAttempt = qos.newReadAttempt(RPC_ATTEMPT_CONTEXT);
        readAttempt.recordRequestStart(this.monotonicClock.instant());
        readAttempt.recordRequestFailed(this.monotonicClock.instant());
        readAttempt.checkCanRetry(this.monotonicClock.instant(), (RuntimeException)((Object)RETRYABLE_ERROR));
        readAttempt.recordRequestStart(this.monotonicClock.instant());
        readAttempt.recordRequestFailed(this.monotonicClock.instant());
        readAttempt.checkCanRetry(this.monotonicClock.instant(), (RuntimeException)((Object)RETRYABLE_ERROR));
        readAttempt.recordRequestStart(this.monotonicClock.instant());
        readAttempt.recordRequestFailed(this.monotonicClock.instant());
        try {
            readAttempt.checkCanRetry(this.monotonicClock.instant(), (RuntimeException)((Object)RETRYABLE_ERROR));
            Assert.fail((String)"expected retry to be exhausted after third attempt");
        }
        catch (ApiException e) {
            Assert.assertSame((Object)((Object)e), (Object)((Object)RETRYABLE_ERROR));
        }
        ((Counter)Mockito.verify((Object)this.counterThrottlingMs, (VerificationMode)Mockito.times((int)0))).inc(ArgumentMatchers.anyLong());
        ((Counter)Mockito.verify((Object)this.counterRpcFailures, (VerificationMode)Mockito.times((int)3))).inc();
        ((Counter)Mockito.verify((Object)this.counterRpcSuccesses, (VerificationMode)Mockito.times((int)0))).inc();
        ((Counter)Mockito.verify((Object)this.counterRpcStreamValueReceived, (VerificationMode)Mockito.times((int)0))).inc();
    }

    @Test
    public void attemptThrowsOnNonRetryableError() throws InterruptedException {
        RpcQosOptions rpcQosOptions = this.options.toBuilder().withMaxAttempts(3).unsafeBuild();
        RpcQosImpl qos = new RpcQosImpl(rpcQosOptions, this.random, this.sleeper, this.counterFactory, this.distributionFactory);
        RpcQos.RpcReadAttempt readAttempt = qos.newReadAttempt(RPC_ATTEMPT_CONTEXT);
        readAttempt.recordRequestStart(this.monotonicClock.instant());
        readAttempt.recordRequestFailed(this.monotonicClock.instant());
        try {
            readAttempt.checkCanRetry(this.monotonicClock.instant(), (RuntimeException)((Object)NON_RETRYABLE_ERROR));
            Assert.fail((String)"expected non-retryable error to throw error on first occurrence");
        }
        catch (ApiException e) {
            Assert.assertSame((Object)((Object)e), (Object)((Object)NON_RETRYABLE_ERROR));
        }
        ((Counter)Mockito.verify((Object)this.counterThrottlingMs, (VerificationMode)Mockito.times((int)0))).inc(ArgumentMatchers.anyLong());
        ((Counter)Mockito.verify((Object)this.counterRpcFailures, (VerificationMode)Mockito.times((int)1))).inc();
        ((Counter)Mockito.verify((Object)this.counterRpcSuccesses, (VerificationMode)Mockito.times((int)0))).inc();
        ((Counter)Mockito.verify((Object)this.counterRpcStreamValueReceived, (VerificationMode)Mockito.times((int)0))).inc();
    }

    @Test
    public void attemptThrowsOnNonRetryableErrorCode() throws InterruptedException {
        RpcQosOptions rpcQosOptions = this.options.toBuilder().withMaxAttempts(3).unsafeBuild();
        RpcQosImpl qos = new RpcQosImpl(rpcQosOptions, this.random, this.sleeper, this.counterFactory, this.distributionFactory);
        RpcQos.RpcReadAttempt readAttempt = qos.newReadAttempt(RPC_ATTEMPT_CONTEXT);
        readAttempt.recordRequestStart(this.monotonicClock.instant());
        readAttempt.recordRequestFailed(this.monotonicClock.instant());
        try {
            readAttempt.checkCanRetry(this.monotonicClock.instant(), (RuntimeException)((Object)RETRYABLE_ERROR_WITH_NON_RETRYABLE_CODE));
            Assert.fail((String)"expected non-retryable error to throw error on first occurrence");
        }
        catch (ApiException e) {
            Assert.assertSame((Object)((Object)e), (Object)((Object)RETRYABLE_ERROR_WITH_NON_RETRYABLE_CODE));
        }
        ((Counter)Mockito.verify((Object)this.counterThrottlingMs, (VerificationMode)Mockito.times((int)0))).inc(ArgumentMatchers.anyLong());
        ((Counter)Mockito.verify((Object)this.counterRpcFailures, (VerificationMode)Mockito.times((int)1))).inc();
        ((Counter)Mockito.verify((Object)this.counterRpcSuccesses, (VerificationMode)Mockito.times((int)0))).inc();
        ((Counter)Mockito.verify((Object)this.counterRpcStreamValueReceived, (VerificationMode)Mockito.times((int)0))).inc();
    }

    @Test
    public void attemptEnforcesActiveStateToPerformOperations_maxAttemptsExhausted() throws InterruptedException {
        RpcQosOptions rpcQosOptions = this.options.toBuilder().withMaxAttempts(1).unsafeBuild();
        RpcQosImpl qos = new RpcQosImpl(rpcQosOptions, this.random, this.sleeper, this.counterFactory, this.distributionFactory);
        RpcQos.RpcReadAttempt readAttempt = qos.newReadAttempt(RPC_ATTEMPT_CONTEXT);
        readAttempt.recordRequestStart(this.monotonicClock.instant());
        readAttempt.recordRequestFailed(this.monotonicClock.instant());
        try {
            readAttempt.checkCanRetry(this.monotonicClock.instant(), (RuntimeException)((Object)RETRYABLE_ERROR));
            Assert.fail((String)"expected error to be re-thrown due to max attempts exhaustion");
        }
        catch (ApiException apiException) {
            // empty catch block
        }
        try {
            readAttempt.recordStreamValue(this.monotonicClock.instant());
            Assert.fail((String)"expected IllegalStateException due to attempt being in terminal state");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ((Sleeper)Mockito.verify((Object)this.sleeper, (VerificationMode)Mockito.times((int)0))).sleep(ArgumentMatchers.anyLong());
        ((Counter)Mockito.verify((Object)this.counterThrottlingMs, (VerificationMode)Mockito.times((int)0))).inc(ArgumentMatchers.anyLong());
        ((Counter)Mockito.verify((Object)this.counterRpcFailures, (VerificationMode)Mockito.times((int)1))).inc();
        ((Counter)Mockito.verify((Object)this.counterRpcSuccesses, (VerificationMode)Mockito.times((int)0))).inc();
        ((Counter)Mockito.verify((Object)this.counterRpcStreamValueReceived, (VerificationMode)Mockito.times((int)0))).inc();
    }

    @Test
    public void attemptEnforcesActiveStateToPerformOperations_successful() throws InterruptedException {
        RpcQosOptions rpcQosOptions = this.options.toBuilder().withMaxAttempts(1).unsafeBuild();
        RpcQosImpl qos = new RpcQosImpl(rpcQosOptions, this.random, this.sleeper, this.counterFactory, this.distributionFactory);
        RpcQos.RpcReadAttempt readAttempt = qos.newReadAttempt(RPC_ATTEMPT_CONTEXT);
        readAttempt.recordRequestStart(this.monotonicClock.instant());
        readAttempt.recordRequestSuccessful(this.monotonicClock.instant());
        readAttempt.completeSuccess();
        try {
            readAttempt.recordStreamValue(this.monotonicClock.instant());
            Assert.fail((String)"expected IllegalStateException due to attempt being in terminal state");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ((Sleeper)Mockito.verify((Object)this.sleeper, (VerificationMode)Mockito.times((int)0))).sleep(ArgumentMatchers.anyLong());
        ((Counter)Mockito.verify((Object)this.counterThrottlingMs, (VerificationMode)Mockito.times((int)0))).inc(ArgumentMatchers.anyLong());
        ((Counter)Mockito.verify((Object)this.counterRpcFailures, (VerificationMode)Mockito.times((int)0))).inc();
        ((Counter)Mockito.verify((Object)this.counterRpcSuccesses, (VerificationMode)Mockito.times((int)1))).inc();
        ((Counter)Mockito.verify((Object)this.counterRpcStreamValueReceived, (VerificationMode)Mockito.times((int)0))).inc();
    }

    @Test
    public void offerOfElementWhichWouldCrossMaxBytesReturnFalse() {
        RpcQosOptions rpcQosOptions = this.options.toBuilder().withBatchMaxBytes(5000L).unsafeBuild();
        RpcQosImpl qos = new RpcQosImpl(rpcQosOptions, this.random, this.sleeper, this.counterFactory, this.distributionFactory);
        RpcQos.RpcWriteAttempt attempt = qos.newWriteAttempt(RPC_ATTEMPT_CONTEXT);
        RpcQos.RpcWriteAttempt.FlushBuffer accumulator = attempt.newFlushBuffer(this.monotonicClock.instant());
        Assert.assertFalse((boolean)accumulator.offer(new FixedSerializationSize<Write>(FirestoreProtoHelpers.newWrite(), 5001L)));
        Assert.assertFalse((boolean)accumulator.isFull());
        Assert.assertEquals((long)0L, (long)accumulator.getBufferedElementsBytes());
        Assert.assertEquals((long)0L, (long)accumulator.getBufferedElementsCount());
    }

    @Test
    public void flushBuffer_doesNotErrorWhenMaxIsOne() {
        RpcQosImpl.FlushBufferImpl buffer = new RpcQosImpl.FlushBufferImpl(1, 1000L);
        Assert.assertTrue((boolean)buffer.offer(new FixedSerializationSize<String>("a", 1L)));
        Assert.assertFalse((boolean)buffer.offer(new FixedSerializationSize<String>("b", 1L)));
        Assert.assertEquals((long)1L, (long)buffer.getBufferedElementsCount());
    }

    @Test
    public void flushBuffer_doesNotErrorWhenMaxIsZero() {
        RpcQosImpl.FlushBufferImpl buffer = new RpcQosImpl.FlushBufferImpl(0, 1000L);
        Assert.assertFalse((boolean)buffer.offer(new FixedSerializationSize<String>("a", 1L)));
        Assert.assertEquals((long)0L, (long)buffer.getBufferedElementsCount());
        Assert.assertFalse((boolean)buffer.isFull());
        Assert.assertFalse((boolean)buffer.isNonEmpty());
    }

    @Test
    public void rampUp_calcForWorkerCount1() {
        Instant t0 = Instant.ofEpochMilli((long)0L);
        Instant t5 = Instant.ofEpochSecond((long)300L);
        Instant t10 = Instant.ofEpochSecond((long)600L);
        Instant t15 = Instant.ofEpochSecond((long)900L);
        Instant t90 = Instant.ofEpochSecond((long)5400L);
        RpcQosImpl.WriteRampUp tracker = new RpcQosImpl.WriteRampUp(500.0, this.distributionFactory);
        Assert.assertEquals((long)500L, (long)tracker.getAvailableWriteCountBudget(t0));
        Assert.assertEquals((long)500L, (long)tracker.getAvailableWriteCountBudget(t5));
        Assert.assertEquals((long)750L, (long)tracker.getAvailableWriteCountBudget(t10));
        Assert.assertEquals((long)1125L, (long)tracker.getAvailableWriteCountBudget(t15));
        Assert.assertEquals((long)492630L, (long)tracker.getAvailableWriteCountBudget(t90));
    }

    @Test
    public void rampUp_calcForWorkerCount100() {
        Instant t0 = Instant.ofEpochMilli((long)0L);
        Instant t5 = Instant.ofEpochSecond((long)300L);
        Instant t10 = Instant.ofEpochSecond((long)600L);
        Instant t15 = Instant.ofEpochSecond((long)900L);
        Instant t90 = Instant.ofEpochSecond((long)5400L);
        RpcQosImpl.WriteRampUp tracker = new RpcQosImpl.WriteRampUp(5.0, this.distributionFactory);
        Assert.assertEquals((long)5L, (long)tracker.getAvailableWriteCountBudget(t0));
        Assert.assertEquals((long)5L, (long)tracker.getAvailableWriteCountBudget(t5));
        Assert.assertEquals((long)7L, (long)tracker.getAvailableWriteCountBudget(t10));
        Assert.assertEquals((long)11L, (long)tracker.getAvailableWriteCountBudget(t15));
        Assert.assertEquals((long)4926L, (long)tracker.getAvailableWriteCountBudget(t90));
    }

    @Test
    public void rampUp_calcForWorkerCount1000() {
        Instant t0 = Instant.ofEpochMilli((long)0L);
        Instant t5 = Instant.ofEpochSecond((long)300L);
        Instant t10 = Instant.ofEpochSecond((long)600L);
        Instant t15 = Instant.ofEpochSecond((long)900L);
        Instant t90 = Instant.ofEpochSecond((long)5400L);
        RpcQosImpl.WriteRampUp tracker = new RpcQosImpl.WriteRampUp(1.0, this.distributionFactory);
        Assert.assertEquals((long)1L, (long)tracker.getAvailableWriteCountBudget(t0));
        Assert.assertEquals((long)1L, (long)tracker.getAvailableWriteCountBudget(t5));
        Assert.assertEquals((long)1L, (long)tracker.getAvailableWriteCountBudget(t10));
        Assert.assertEquals((long)2L, (long)tracker.getAvailableWriteCountBudget(t15));
        Assert.assertEquals((long)985L, (long)tracker.getAvailableWriteCountBudget(t90));
    }

    @Test
    public void rampUp_calcFor90Minutes() {
        int increment = 5;
        List expected = this.from0To90By(increment).map(x -> (int)(500.0 * Math.pow(1.5, Math.max(0, (x - increment) / increment)))).boxed().collect(Collectors.toList());
        RpcQosImpl.WriteRampUp tracker = new RpcQosImpl.WriteRampUp(500.0, this.distributionFactory);
        List actual = this.from0To90By(increment).mapToObj(i -> Instant.ofEpochSecond((long)(60 * i))).map(arg_0 -> ((RpcQosImpl.WriteRampUp)tracker).getAvailableWriteCountBudget(arg_0)).collect(Collectors.toList());
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void initialBatchSizeRelativeToWorkerCount_10000() {
        this.doTest_initialBatchSizeRelativeToWorkerCount(10000, 1);
    }

    @Test
    public void initialBatchSizeRelativeToWorkerCount_1000() {
        this.doTest_initialBatchSizeRelativeToWorkerCount(1000, 1);
    }

    @Test
    public void initialBatchSizeRelativeToWorkerCount_100() {
        this.doTest_initialBatchSizeRelativeToWorkerCount(100, 5);
    }

    @Test
    public void initialBatchSizeRelativeToWorkerCount_10() {
        this.doTest_initialBatchSizeRelativeToWorkerCount(10, 50);
    }

    @Test
    public void initialBatchSizeRelativeToWorkerCount_1() {
        this.doTest_initialBatchSizeRelativeToWorkerCount(1, 500);
    }

    @Test
    public void isCodeRetryable() {
        this.doTest_isCodeRetryable(Code.ABORTED, true);
        this.doTest_isCodeRetryable(Code.ALREADY_EXISTS, false);
        this.doTest_isCodeRetryable(Code.CANCELLED, true);
        this.doTest_isCodeRetryable(Code.DATA_LOSS, false);
        this.doTest_isCodeRetryable(Code.DEADLINE_EXCEEDED, true);
        this.doTest_isCodeRetryable(Code.FAILED_PRECONDITION, false);
        this.doTest_isCodeRetryable(Code.INTERNAL, true);
        this.doTest_isCodeRetryable(Code.INVALID_ARGUMENT, false);
        this.doTest_isCodeRetryable(Code.NOT_FOUND, false);
        this.doTest_isCodeRetryable(Code.OK, true);
        this.doTest_isCodeRetryable(Code.OUT_OF_RANGE, false);
        this.doTest_isCodeRetryable(Code.PERMISSION_DENIED, false);
        this.doTest_isCodeRetryable(Code.RESOURCE_EXHAUSTED, true);
        this.doTest_isCodeRetryable(Code.UNAUTHENTICATED, true);
        this.doTest_isCodeRetryable(Code.UNAVAILABLE, true);
        this.doTest_isCodeRetryable(Code.UNIMPLEMENTED, false);
        this.doTest_isCodeRetryable(Code.UNKNOWN, true);
    }

    @Test
    public void statusCodeAwareBackoff_graceCodeBackoffWithin60sec() {
        RpcQosImpl.StatusCodeAwareBackoff backoff = new RpcQosImpl.StatusCodeAwareBackoff(this.random, 5, Duration.standardSeconds((long)5L), (Set)ImmutableSet.of((Object)14));
        RpcQosImpl.StatusCodeAwareBackoff.BackoffResult backoffResult1 = backoff.nextBackoff(Instant.ofEpochMilli((long)1L), 14);
        Assert.assertEquals((Object)RpcQosImpl.StatusCodeAwareBackoff.BackoffResults.NONE, (Object)backoffResult1);
        RpcQosImpl.StatusCodeAwareBackoff.BackoffResult backoffResult2 = backoff.nextBackoff(Instant.ofEpochMilli((long)2L), 14);
        Assert.assertEquals((Object)new RpcQosImpl.StatusCodeAwareBackoff.BackoffDuration(Duration.millis((long)6091L)), (Object)backoffResult2);
        RpcQosImpl.StatusCodeAwareBackoff.BackoffResult backoffResult3 = backoff.nextBackoff(Instant.ofEpochMilli((long)60100L), 14);
        Assert.assertEquals((Object)RpcQosImpl.StatusCodeAwareBackoff.BackoffResults.NONE, (Object)backoffResult3);
    }

    @Test
    public void statusCodeAwareBackoff_exhausted_attemptCount() {
        RpcQosImpl.StatusCodeAwareBackoff backoff = new RpcQosImpl.StatusCodeAwareBackoff(this.random, 1, Duration.standardSeconds((long)5L), Collections.emptySet());
        RpcQosImpl.StatusCodeAwareBackoff.BackoffResult backoffResult1 = backoff.nextBackoff(Instant.ofEpochMilli((long)1L), 14);
        Assert.assertEquals((Object)RpcQosImpl.StatusCodeAwareBackoff.BackoffResults.EXHAUSTED, (Object)backoffResult1);
    }

    @Test
    public void statusCodeAwareBackoff_exhausted_cumulativeBackoff() {
        RpcQosImpl.StatusCodeAwareBackoff backoff = new RpcQosImpl.StatusCodeAwareBackoff(this.random, 3, Duration.standardSeconds((long)60L), Collections.emptySet());
        RpcQosImpl.StatusCodeAwareBackoff.BackoffDuration backoff60Sec = new RpcQosImpl.StatusCodeAwareBackoff.BackoffDuration(Duration.standardMinutes((long)1L));
        RpcQosImpl.StatusCodeAwareBackoff.BackoffResult backoffResult1 = backoff.nextBackoff(Instant.ofEpochMilli((long)1L), 4);
        Assert.assertEquals((Object)backoff60Sec, (Object)backoffResult1);
        RpcQosImpl.StatusCodeAwareBackoff.BackoffResult backoffResult2 = backoff.nextBackoff(Instant.ofEpochMilli((long)2L), 4);
        Assert.assertEquals((Object)RpcQosImpl.StatusCodeAwareBackoff.BackoffResults.EXHAUSTED, (Object)backoffResult2);
    }

    private IntStream from0To90By(int increment) {
        return IntStream.iterate(0, i -> i + increment).limit(90 / increment + 1);
    }

    private void doTest_writes_shouldFlush_numWritesHigherThanBatchCount_newTimeBucket(boolean expectFlush, int batchCount) {
        this.doTest_shouldFlush_numWritesHigherThanBatchCount(expectFlush, batchCount, qos -> {});
    }

    private void doTest_writes_shouldFlush_numWritesHigherThanBatchCount_existingTimeBucket(boolean expectFlush, int batchCount) {
        this.doTest_shouldFlush_numWritesHigherThanBatchCount(expectFlush, batchCount, qos -> {
            RpcQos.RpcWriteAttempt attempt = qos.newWriteAttempt(RPC_ATTEMPT_CONTEXT);
            attempt.recordRequestStart(this.monotonicClock.instant(), 1);
            attempt.recordWriteCounts(this.monotonicClock.instant(), 1, 0);
        });
    }

    private void doTest_shouldFlush_numWritesHigherThanBatchCount(boolean expectFlush, int batchCount, Consumer<RpcQos> preAttempt) {
        RpcQosOptions rpcQosOptions = this.options.toBuilder().withBatchInitialCount(10).withBatchMaxCount(10).unsafeBuild();
        RpcQosImpl qos = new RpcQosImpl(rpcQosOptions, this.random, this.sleeper, this.counterFactory, this.distributionFactory);
        preAttempt.accept((RpcQos)qos);
        RpcQos.RpcWriteAttempt attempt = qos.newWriteAttempt(RPC_ATTEMPT_CONTEXT);
        RpcQos.RpcWriteAttempt.FlushBuffer accumulator = attempt.newFlushBuffer(this.monotonicClock.instant());
        for (int i = 0; i < batchCount; ++i) {
            accumulator.offer((RpcQos.RpcWriteAttempt.Element)new FirestoreV1WriteFn.WriteElement(i, FirestoreProtoHelpers.newWrite(), this.window));
        }
        if (expectFlush) {
            Assert.assertTrue((boolean)accumulator.isFull());
            Assert.assertEquals((long)10L, (long)accumulator.getBufferedElementsCount());
        } else {
            Assert.assertFalse((boolean)accumulator.isFull());
            Assert.assertEquals((long)batchCount, (long)accumulator.getBufferedElementsCount());
        }
    }

    private void doTest_writes_shouldFlush_numBytes(boolean expectFlush, long numBytes) {
        RpcQosOptions rpcQosOptions = this.options.toBuilder().withBatchMaxBytes(3000L).unsafeBuild();
        RpcQosImpl qos = new RpcQosImpl(rpcQosOptions, this.random, this.sleeper, this.counterFactory, this.distributionFactory);
        RpcQos.RpcWriteAttempt attempt = qos.newWriteAttempt(RPC_ATTEMPT_CONTEXT);
        RpcQos.RpcWriteAttempt.FlushBuffer accumulator = attempt.newFlushBuffer(this.monotonicClock.instant());
        Assert.assertTrue((boolean)accumulator.offer(new FixedSerializationSize<Write>(FirestoreProtoHelpers.newWrite(), numBytes)));
        Assert.assertEquals((Object)expectFlush, (Object)accumulator.isFull());
        Assert.assertEquals((long)numBytes, (long)accumulator.getBufferedElementsBytes());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new Write[]{FirestoreProtoHelpers.newWrite()}), StreamSupport.stream(accumulator.spliterator(), false).map(RpcQos.RpcWriteAttempt.Element::getValue).collect(Collectors.toList()));
    }

    private void doTest_initialBatchSizeRelativeToWorkerCount(int hintWorkerCount, int expectedBatchMaxCount) {
        RpcQosOptions options = RpcQosOptions.newBuilder().withHintMaxNumWorkers(hintWorkerCount).withBatchInitialCount(500).build();
        RpcQosImpl qos = new RpcQosImpl(options, this.random, this.sleeper, this.counterFactory, this.distributionFactory);
        RpcQosImpl.RpcWriteAttemptImpl attempt = qos.newWriteAttempt(RPC_ATTEMPT_CONTEXT);
        RpcQosImpl.FlushBufferImpl buffer = attempt.newFlushBuffer(Instant.EPOCH);
        Assert.assertEquals((long)expectedBatchMaxCount, (long)buffer.nextBatchMaxCount);
    }

    private void doTest_isCodeRetryable(Code code, boolean shouldBeRetryable) {
        RpcQosOptions options = RpcQosOptions.defaultOptions();
        RpcQosImpl qos = new RpcQosImpl(options, this.random, this.sleeper, this.counterFactory, this.distributionFactory);
        RpcQosImpl.RpcWriteAttemptImpl attempt = qos.newWriteAttempt(RPC_ATTEMPT_CONTEXT);
        Assert.assertEquals((Object)shouldBeRetryable, (Object)attempt.isCodeRetryable(code));
    }

    private static final class FixedSerializationSize<T>
    implements RpcQos.RpcWriteAttempt.Element<T> {
        private final long serializedSize;
        private final T write;

        public FixedSerializationSize(T write, long serializedSize) {
            this.write = write;
            this.serializedSize = serializedSize;
        }

        public T getValue() {
            return this.write;
        }

        public long getSerializedSize() {
            return this.serializedSize;
        }

        public String toString() {
            return "FixedSerializationSize{serializedSize=" + this.serializedSize + ", write=" + this.write + '}';
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FixedSerializationSize)) {
                return false;
            }
            FixedSerializationSize that = (FixedSerializationSize)o;
            return this.serializedSize == that.serializedSize && Objects.equals(this.write, that.write);
        }

        public int hashCode() {
            return Objects.hash(this.serializedSize, this.write);
        }
    }
}

