/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Value;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.beam.sdk.io.gcp.firestore.BaseFirestoreV1FnTest;
import org.apache.beam.sdk.io.gcp.firestore.BaseFirestoreV1ReadFnTest;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreStatefulComponentFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1ReadFn;
import org.apache.beam.sdk.io.gcp.firestore.JodaClock;
import org.apache.beam.sdk.io.gcp.firestore.RpcQos;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.AbstractIterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class FirestoreV1FnRunQueryTest
extends BaseFirestoreV1ReadFnTest<RunQueryRequest, RunQueryResponse> {
    @Mock
    private ServerStreamingCallable<RunQueryRequest, RunQueryResponse> callable;
    @Mock
    private ServerStream<RunQueryResponse> responseStream1;
    @Mock
    private ServerStream<RunQueryResponse> responseStream2;

    @Test
    public void endToEnd() throws Exception {
        TestData testData = TestData.fieldEqualsBar().setProjectId("testing-project").build();
        ImmutableList responses = ImmutableList.of((Object)testData.response1, (Object)testData.response2, (Object)testData.response3);
        Mockito.when((Object)this.responseStream1.iterator()).thenReturn(responses.iterator());
        Mockito.when((Object)this.callable.call((Object)testData.request)).thenReturn(this.responseStream1);
        Mockito.when((Object)this.stub.runQueryCallable()).thenReturn(this.callable);
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        RpcQosOptions options = RpcQosOptions.defaultOptions();
        Mockito.when((Object)this.ff.getRpcQos((RpcQosOptions)ArgumentMatchers.any())).thenReturn((Object)FirestoreStatefulComponentFactory.INSTANCE.getRpcQos(options));
        ArgumentCaptor responsesCaptor = ArgumentCaptor.forClass(RunQueryResponse.class);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).output((Object)((RunQueryResponse)responsesCaptor.capture()));
        Mockito.when((Object)((RunQueryRequest)this.processContext.element())).thenReturn((Object)testData.request);
        FirestoreV1ReadFn.RunQueryFn fn = new FirestoreV1ReadFn.RunQueryFn(this.clock, this.ff, options);
        this.runFunction(fn);
        List allValues = responsesCaptor.getAllValues();
        Assert.assertEquals((Object)responses, (Object)allValues);
    }

    @Override
    public void resumeFromLastReadValue() throws Exception {
        TestData testData = TestData.fieldEqualsBar().setProjectId("testing-project").setOrderFunction(f -> Collections.singletonList(StructuredQuery.Order.newBuilder().setDirection(StructuredQuery.Direction.ASCENDING).setField(f).build())).build();
        RunQueryRequest request2 = RunQueryRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", "testing-project")).setStructuredQuery(testData.request.getStructuredQuery().toBuilder().setStartAt(Cursor.newBuilder().setBefore(false).addValues(Value.newBuilder().setStringValue("bar")))).build();
        ImmutableList responses = ImmutableList.of((Object)testData.response1, (Object)testData.response2, (Object)testData.response3);
        Mockito.when((Object)this.responseStream1.iterator()).thenReturn((Object)new AbstractIterator<RunQueryResponse>((List)responses){
            private int invocationCount = 1;
            final /* synthetic */ List val$responses;
            {
                this.val$responses = list;
            }

            protected RunQueryResponse computeNext() {
                int count;
                if ((count = this.invocationCount++) == 1) {
                    return (RunQueryResponse)this.val$responses.get(0);
                }
                if (count == 2) {
                    return (RunQueryResponse)this.val$responses.get(1);
                }
                throw BaseFirestoreV1FnTest.RETRYABLE_ERROR;
            }
        });
        Mockito.when((Object)this.callable.call((Object)testData.request)).thenReturn(this.responseStream1);
        ((RpcQos.RpcReadAttempt)Mockito.doNothing().when((Object)this.attempt)).checkCanRetry((Instant)ArgumentMatchers.any(), (RuntimeException)ArgumentMatchers.eq((Object)RETRYABLE_ERROR));
        Mockito.when((Object)this.responseStream2.iterator()).thenReturn((Object)ImmutableList.of((Object)((RunQueryResponse)responses.get(2))).iterator());
        Mockito.when((Object)this.callable.call((Object)request2)).thenReturn(this.responseStream2);
        Mockito.when((Object)this.stub.runQueryCallable()).thenReturn(this.callable);
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        Mockito.when((Object)this.ff.getRpcQos((RpcQosOptions)ArgumentMatchers.any())).thenReturn((Object)this.rpcQos);
        Mockito.when((Object)this.rpcQos.newReadAttempt((RpcQos.RpcAttempt.Context)ArgumentMatchers.any())).thenReturn((Object)this.attempt);
        Mockito.when((Object)this.attempt.awaitSafeToProceed((Instant)ArgumentMatchers.any())).thenReturn((Object)true);
        ArgumentCaptor responsesCaptor = ArgumentCaptor.forClass(RunQueryResponse.class);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).output((Object)((RunQueryResponse)responsesCaptor.capture()));
        Mockito.when((Object)((RunQueryRequest)this.processContext.element())).thenReturn((Object)testData.request);
        FirestoreV1ReadFn.RunQueryFn fn = new FirestoreV1ReadFn.RunQueryFn(this.clock, this.ff, this.rpcQosOptions);
        this.runFunction(fn);
        List allValues = responsesCaptor.getAllValues();
        Assert.assertEquals((Object)responses, (Object)allValues);
        ((ServerStreamingCallable)Mockito.verify(this.callable, (VerificationMode)Mockito.times((int)1))).call((Object)testData.request);
        ((ServerStreamingCallable)Mockito.verify(this.callable, (VerificationMode)Mockito.times((int)1))).call((Object)request2);
        ((RpcQos.RpcReadAttempt)Mockito.verify((Object)this.attempt, (VerificationMode)Mockito.times((int)3))).recordStreamValue((Instant)ArgumentMatchers.any());
    }

    @Test
    public void resumeFromLastReadValue_withNoOrderBy() throws Exception {
        TestData testData = TestData.fieldEqualsBar().setProjectId("testing-project").build();
        RunQueryRequest request2 = RunQueryRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", "testing-project")).setStructuredQuery(testData.request.getStructuredQuery().toBuilder().setStartAt(Cursor.newBuilder().setBefore(false).addValues(Value.newBuilder().setReferenceValue(testData.response2.getDocument().getName()))).addOrderBy(StructuredQuery.Order.newBuilder().setField(StructuredQuery.FieldReference.newBuilder().setFieldPath("__name__")).setDirection(StructuredQuery.Direction.ASCENDING))).build();
        ImmutableList responses = ImmutableList.of((Object)testData.response1, (Object)testData.response2, (Object)testData.response3);
        Mockito.when((Object)this.responseStream1.iterator()).thenReturn((Object)new AbstractIterator<RunQueryResponse>((List)responses){
            private int invocationCount = 1;
            final /* synthetic */ List val$responses;
            {
                this.val$responses = list;
            }

            protected RunQueryResponse computeNext() {
                int count;
                if ((count = this.invocationCount++) == 1) {
                    return (RunQueryResponse)this.val$responses.get(0);
                }
                if (count == 2) {
                    return (RunQueryResponse)this.val$responses.get(1);
                }
                throw BaseFirestoreV1FnTest.RETRYABLE_ERROR;
            }
        });
        Mockito.when((Object)this.callable.call((Object)testData.request)).thenReturn(this.responseStream1);
        ((RpcQos.RpcReadAttempt)Mockito.doNothing().when((Object)this.attempt)).checkCanRetry((Instant)ArgumentMatchers.any(), (RuntimeException)ArgumentMatchers.eq((Object)RETRYABLE_ERROR));
        Mockito.when((Object)this.responseStream2.iterator()).thenReturn((Object)ImmutableList.of((Object)testData.response3).iterator());
        Mockito.when((Object)this.callable.call((Object)request2)).thenReturn(this.responseStream2);
        Mockito.when((Object)this.stub.runQueryCallable()).thenReturn(this.callable);
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        Mockito.when((Object)this.ff.getRpcQos((RpcQosOptions)ArgumentMatchers.any())).thenReturn((Object)this.rpcQos);
        Mockito.when((Object)this.rpcQos.newReadAttempt((RpcQos.RpcAttempt.Context)ArgumentMatchers.any())).thenReturn((Object)this.attempt);
        Mockito.when((Object)this.attempt.awaitSafeToProceed((Instant)ArgumentMatchers.any())).thenReturn((Object)true);
        ArgumentCaptor responsesCaptor = ArgumentCaptor.forClass(RunQueryResponse.class);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).output((Object)((RunQueryResponse)responsesCaptor.capture()));
        Mockito.when((Object)((RunQueryRequest)this.processContext.element())).thenReturn((Object)testData.request);
        FirestoreV1ReadFn.RunQueryFn fn = new FirestoreV1ReadFn.RunQueryFn(this.clock, this.ff, this.rpcQosOptions);
        this.runFunction(fn);
        List allValues = responsesCaptor.getAllValues();
        Assert.assertEquals((Object)responses, (Object)allValues);
        ((ServerStreamingCallable)Mockito.verify(this.callable, (VerificationMode)Mockito.times((int)1))).call((Object)testData.request);
        ((ServerStreamingCallable)Mockito.verify(this.callable, (VerificationMode)Mockito.times((int)1))).call((Object)request2);
        ((RpcQos.RpcReadAttempt)Mockito.verify((Object)this.attempt, (VerificationMode)Mockito.times((int)3))).recordStreamValue((Instant)ArgumentMatchers.any());
    }

    @Override
    protected BaseFirestoreV1ReadFnTest.V1RpcFnTestCtx newCtx() {
        return new BaseFirestoreV1ReadFnTest.V1RpcFnTestCtx(){

            public RunQueryRequest getRequest() {
                return RunQueryRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", "testing-project")).build();
            }

            @Override
            public void mockRpcToCallable(FirestoreStub stub) {
                Mockito.when((Object)stub.runQueryCallable()).thenReturn((Object)FirestoreV1FnRunQueryTest.this.callable);
            }

            public void whenCallableCall(RunQueryRequest in, Throwable ... throwables) {
                Mockito.when((Object)FirestoreV1FnRunQueryTest.this.callable.call((Object)in)).thenThrow(throwables);
            }

            @Override
            public void verifyNoInteractionsWithCallable() {
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{FirestoreV1FnRunQueryTest.this.callable});
            }
        };
    }

    protected FirestoreV1ReadFn.RunQueryFn getFn(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
        return new FirestoreV1ReadFn.RunQueryFn(clock, firestoreStatefulComponentFactory, rpcQosOptions);
    }

    private static final class TestData {
        private final RunQueryRequest request;
        private final RunQueryResponse response1;
        private final RunQueryResponse response2;
        private final RunQueryResponse response3;

        public TestData(String projectId, Function<StructuredQuery.FieldReference, List<StructuredQuery.Order>> orderFunction) {
            String fieldPath = "foo";
            StructuredQuery.FieldReference foo = StructuredQuery.FieldReference.newBuilder().setFieldPath(fieldPath).build();
            StructuredQuery.Builder builder = StructuredQuery.newBuilder().addFrom(StructuredQuery.CollectionSelector.newBuilder().setAllDescendants(false).setCollectionId("collection")).setWhere(StructuredQuery.Filter.newBuilder().setFieldFilter(StructuredQuery.FieldFilter.newBuilder().setField(foo).setOp(StructuredQuery.FieldFilter.Operator.EQUAL).setValue(Value.newBuilder().setStringValue("bar")).build()));
            orderFunction.apply(foo).forEach(arg_0 -> ((StructuredQuery.Builder)builder).addOrderBy(arg_0));
            this.request = RunQueryRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", projectId)).setStructuredQuery(builder).build();
            this.response1 = TestData.newResponse(fieldPath, 1);
            this.response2 = TestData.newResponse(fieldPath, 2);
            this.response3 = TestData.newResponse(fieldPath, 3);
        }

        private static RunQueryResponse newResponse(String field, int docNumber) {
            String docId = String.format("doc-%d", docNumber);
            return RunQueryResponse.newBuilder().setDocument(Document.newBuilder().setName(docId).putAllFields((Map)ImmutableMap.of((Object)field, (Object)Value.newBuilder().setStringValue("bar").build())).build()).build();
        }

        private static Builder fieldEqualsBar() {
            return new Builder();
        }

        private static final class Builder {
            private String projectId;
            private Function<StructuredQuery.FieldReference, List<StructuredQuery.Order>> orderFunction = f -> Collections.emptyList();

            public Builder setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            public Builder setOrderFunction(Function<StructuredQuery.FieldReference, List<StructuredQuery.Order>> orderFunction) {
                this.orderFunction = orderFunction;
                return this;
            }

            private TestData build() {
                return new TestData(Objects.requireNonNull(this.projectId, "projectId must be non null"), Objects.requireNonNull(this.orderFunction, "orderFunction must be non null"));
            }
        }
    }
}

