/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import com.google.firestore.v1.Cursor;
import com.google.firestore.v1.PartitionQueryRequest;
import com.google.firestore.v1.PartitionQueryResponse;
import com.google.firestore.v1.Value;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.sdk.io.gcp.firestore.BaseFirestoreV1FnTest;
import org.apache.beam.sdk.io.gcp.firestore.BaseFirestoreV1ReadFnTest;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreStatefulComponentFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1ReadFn;
import org.apache.beam.sdk.io.gcp.firestore.JodaClock;
import org.apache.beam.sdk.io.gcp.firestore.RpcQos;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.AbstractIterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;

public final class FirestoreV1FnPartitionQueryTest
extends BaseFirestoreV1ReadFnTest<PartitionQueryRequest, FirestoreV1ReadFn.PartitionQueryPair> {
    @Mock
    private UnaryCallable<PartitionQueryRequest, FirestoreClient.PartitionQueryPagedResponse> callable;
    @Mock
    private FirestoreClient.PartitionQueryPagedResponse pagedResponse1;
    @Mock
    private FirestoreClient.PartitionQueryPage page1;
    @Mock
    private FirestoreClient.PartitionQueryPagedResponse pagedResponse2;
    @Mock
    private FirestoreClient.PartitionQueryPage page2;

    @Test
    public void endToEnd() throws Exception {
        PartitionQueryRequest request1 = PartitionQueryRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", "testing-project")).build();
        PartitionQueryResponse response1 = PartitionQueryResponse.newBuilder().addPartitions(Cursor.newBuilder().addValues(Value.newBuilder().setReferenceValue("doc-100"))).addPartitions(Cursor.newBuilder().addValues(Value.newBuilder().setReferenceValue("doc-200"))).addPartitions(Cursor.newBuilder().addValues(Value.newBuilder().setReferenceValue("doc-300"))).addPartitions(Cursor.newBuilder().addValues(Value.newBuilder().setReferenceValue("doc-400"))).build();
        Mockito.when((Object)((FirestoreClient.PartitionQueryPagedResponse)this.callable.call((Object)request1))).thenReturn((Object)this.pagedResponse1);
        Mockito.when((Object)((PartitionQueryResponse)this.page1.getResponse())).thenReturn((Object)response1);
        Mockito.when((Object)this.pagedResponse1.iteratePages()).thenReturn((Object)ImmutableList.of((Object)this.page1));
        Mockito.when((Object)this.stub.partitionQueryPagedCallable()).thenReturn(this.callable);
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        RpcQosOptions options = RpcQosOptions.defaultOptions();
        Mockito.when((Object)this.ff.getRpcQos((RpcQosOptions)ArgumentMatchers.any())).thenReturn((Object)FirestoreStatefulComponentFactory.INSTANCE.getRpcQos(options));
        ArgumentCaptor responses = ArgumentCaptor.forClass(FirestoreV1ReadFn.PartitionQueryPair.class);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).output((Object)((FirestoreV1ReadFn.PartitionQueryPair)responses.capture()));
        Mockito.when((Object)((PartitionQueryRequest)this.processContext.element())).thenReturn((Object)request1);
        FirestoreV1ReadFn.PartitionQueryFn fn = new FirestoreV1ReadFn.PartitionQueryFn(this.clock, this.ff, options);
        this.runFunction(fn);
        ArrayList expected = Lists.newArrayList((Object[])new FirestoreV1ReadFn.PartitionQueryPair[]{new FirestoreV1ReadFn.PartitionQueryPair(request1, response1)});
        List allValues = responses.getAllValues();
        Assert.assertEquals((Object)expected, (Object)allValues);
    }

    @Test
    public void endToEnd_emptyCursors() throws Exception {
        PartitionQueryRequest request1 = PartitionQueryRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", "testing-project")).build();
        PartitionQueryResponse response1 = PartitionQueryResponse.newBuilder().build();
        Mockito.when((Object)((FirestoreClient.PartitionQueryPagedResponse)this.callable.call((Object)request1))).thenReturn((Object)this.pagedResponse1);
        Mockito.when((Object)((PartitionQueryResponse)this.page1.getResponse())).thenReturn((Object)response1);
        Mockito.when((Object)this.pagedResponse1.iteratePages()).thenReturn((Object)ImmutableList.of((Object)this.page1));
        Mockito.when((Object)this.stub.partitionQueryPagedCallable()).thenReturn(this.callable);
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        RpcQosOptions options = RpcQosOptions.defaultOptions();
        Mockito.when((Object)this.ff.getRpcQos((RpcQosOptions)ArgumentMatchers.any())).thenReturn((Object)FirestoreStatefulComponentFactory.INSTANCE.getRpcQos(options));
        ArgumentCaptor responses = ArgumentCaptor.forClass(FirestoreV1ReadFn.PartitionQueryPair.class);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).output((Object)((FirestoreV1ReadFn.PartitionQueryPair)responses.capture()));
        Mockito.when((Object)((PartitionQueryRequest)this.processContext.element())).thenReturn((Object)request1);
        FirestoreV1ReadFn.PartitionQueryFn fn = new FirestoreV1ReadFn.PartitionQueryFn(this.clock, this.ff, options);
        this.runFunction(fn);
        ArrayList expected = Lists.newArrayList((Object[])new FirestoreV1ReadFn.PartitionQueryPair[]{new FirestoreV1ReadFn.PartitionQueryPair(request1, response1)});
        List allValues = responses.getAllValues();
        Assert.assertEquals((Object)expected, (Object)allValues);
    }

    @Override
    public void resumeFromLastReadValue() throws Exception {
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        Mockito.when((Object)this.ff.getRpcQos((RpcQosOptions)ArgumentMatchers.any())).thenReturn((Object)this.rpcQos);
        Mockito.when((Object)this.rpcQos.newReadAttempt((RpcQos.RpcAttempt.Context)ArgumentMatchers.any())).thenReturn((Object)this.attempt);
        Mockito.when((Object)this.attempt.awaitSafeToProceed((Instant)ArgumentMatchers.any())).thenReturn((Object)true);
        PartitionQueryRequest request1 = PartitionQueryRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", "testing-project")).build();
        PartitionQueryResponse response1 = PartitionQueryResponse.newBuilder().addPartitions(Cursor.newBuilder().addValues(Value.newBuilder().setReferenceValue("doc-100"))).addPartitions(Cursor.newBuilder().addValues(Value.newBuilder().setReferenceValue("doc-200"))).addPartitions(Cursor.newBuilder().addValues(Value.newBuilder().setReferenceValue("doc-300"))).setNextPageToken("page2").build();
        Mockito.when((Object)((PartitionQueryResponse)this.page1.getResponse())).thenReturn((Object)response1);
        Mockito.when((Object)((FirestoreClient.PartitionQueryPagedResponse)this.callable.call((Object)request1))).thenReturn((Object)this.pagedResponse1);
        ((RpcQos.RpcReadAttempt)Mockito.doNothing().when((Object)this.attempt)).checkCanRetry((Instant)ArgumentMatchers.any(), (RuntimeException)ArgumentMatchers.eq((Object)((Object)RETRYABLE_ERROR)));
        Mockito.when((Object)this.pagedResponse1.iteratePages()).thenAnswer(invocation -> new Iterable<FirestoreClient.PartitionQueryPage>(){

            @Override
            public Iterator<FirestoreClient.PartitionQueryPage> iterator() {
                return new AbstractIterator<FirestoreClient.PartitionQueryPage>(){
                    private boolean first = true;

                    protected FirestoreClient.PartitionQueryPage computeNext() {
                        if (this.first) {
                            this.first = false;
                            return FirestoreV1FnPartitionQueryTest.this.page1;
                        }
                        throw BaseFirestoreV1FnTest.RETRYABLE_ERROR;
                    }
                };
            }
        });
        PartitionQueryRequest request2 = PartitionQueryRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", "testing-project")).setPageToken("page2").build();
        PartitionQueryResponse response2 = PartitionQueryResponse.newBuilder().addPartitions(Cursor.newBuilder().addValues(Value.newBuilder().setReferenceValue("doc-400"))).build();
        PartitionQueryResponse expectedResponse = response1.toBuilder().clearNextPageToken().addAllPartitions((Iterable)response2.getPartitionsList()).build();
        Mockito.when((Object)((PartitionQueryResponse)this.page2.getResponse())).thenReturn((Object)response2);
        Mockito.when((Object)this.page2.hasNextPage()).thenReturn((Object)false);
        Mockito.when((Object)((FirestoreClient.PartitionQueryPagedResponse)this.callable.call((Object)request2))).thenReturn((Object)this.pagedResponse2);
        Mockito.when((Object)this.pagedResponse2.iteratePages()).thenReturn((Object)ImmutableList.of((Object)this.page2));
        Mockito.when((Object)this.stub.partitionQueryPagedCallable()).thenReturn(this.callable);
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        ArgumentCaptor responses = ArgumentCaptor.forClass(FirestoreV1ReadFn.PartitionQueryPair.class);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).output((Object)((FirestoreV1ReadFn.PartitionQueryPair)responses.capture()));
        Mockito.when((Object)((PartitionQueryRequest)this.processContext.element())).thenReturn((Object)request1);
        FirestoreV1ReadFn.PartitionQueryFn fn = new FirestoreV1ReadFn.PartitionQueryFn(this.clock, this.ff, this.rpcQosOptions);
        this.runFunction(fn);
        ArrayList expected = Lists.newArrayList((Object[])new FirestoreV1ReadFn.PartitionQueryPair[]{new FirestoreV1ReadFn.PartitionQueryPair(request1, expectedResponse)});
        List allValues = responses.getAllValues();
        Assert.assertEquals((Object)expected, (Object)allValues);
    }

    @Override
    protected BaseFirestoreV1ReadFnTest.V1RpcFnTestCtx newCtx() {
        return new BaseFirestoreV1ReadFnTest.V1RpcFnTestCtx(){

            public PartitionQueryRequest getRequest() {
                return PartitionQueryRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", "testing-project")).build();
            }

            @Override
            public void mockRpcToCallable(FirestoreStub stub) {
                Mockito.when((Object)stub.partitionQueryPagedCallable()).thenReturn((Object)FirestoreV1FnPartitionQueryTest.this.callable);
            }

            public void whenCallableCall(PartitionQueryRequest in, Throwable ... throwables) {
                Mockito.when((Object)((FirestoreClient.PartitionQueryPagedResponse)FirestoreV1FnPartitionQueryTest.this.callable.call((Object)in))).thenThrow(throwables);
            }

            @Override
            public void verifyNoInteractionsWithCallable() {
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{FirestoreV1FnPartitionQueryTest.this.callable});
            }
        };
    }

    protected FirestoreV1ReadFn.PartitionQueryFn getFn(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
        return new FirestoreV1ReadFn.PartitionQueryFn(clock, firestoreStatefulComponentFactory, rpcQosOptions);
    }
}

