/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.firestore.v1.FirestoreClient;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.ListDocumentsRequest;
import com.google.firestore.v1.ListDocumentsResponse;
import com.google.firestore.v1.Value;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.firestore.BaseFirestoreV1FnTest;
import org.apache.beam.sdk.io.gcp.firestore.BaseFirestoreV1ReadFnTest;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreStatefulComponentFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1ReadFn;
import org.apache.beam.sdk.io.gcp.firestore.JodaClock;
import org.apache.beam.sdk.io.gcp.firestore.RpcQos;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.AbstractIterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;

public final class FirestoreV1FnListDocumentsTest
extends BaseFirestoreV1ReadFnTest<ListDocumentsRequest, ListDocumentsResponse> {
    @Mock
    private UnaryCallable<ListDocumentsRequest, FirestoreClient.ListDocumentsPagedResponse> callable;
    @Mock
    private FirestoreClient.ListDocumentsPagedResponse pagedResponse1;
    @Mock
    private FirestoreClient.ListDocumentsPage page1;
    @Mock
    private FirestoreClient.ListDocumentsPagedResponse pagedResponse2;
    @Mock
    private FirestoreClient.ListDocumentsPage page2;

    @Test
    public void endToEnd() throws Exception {
        ListDocumentsRequest request1 = ListDocumentsRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", "testing-project")).build();
        ListDocumentsResponse response1 = ListDocumentsResponse.newBuilder().addDocuments(Document.newBuilder().setName("doc_1-1").putAllFields((Map)ImmutableMap.of((Object)"foo", (Object)Value.newBuilder().setStringValue("bar").build())).build()).addDocuments(Document.newBuilder().setName("doc_1-2").putAllFields((Map)ImmutableMap.of((Object)"foo", (Object)Value.newBuilder().setStringValue("bar").build())).build()).addDocuments(Document.newBuilder().setName("doc_1-3").putAllFields((Map)ImmutableMap.of((Object)"foo", (Object)Value.newBuilder().setStringValue("bar").build())).build()).setNextPageToken("page2").build();
        Mockito.when((Object)this.page1.getNextPageToken()).thenReturn((Object)response1.getNextPageToken());
        Mockito.when((Object)((ListDocumentsResponse)this.page1.getResponse())).thenReturn((Object)response1);
        Mockito.when((Object)this.page1.hasNextPage()).thenReturn((Object)true);
        ListDocumentsResponse response2 = ListDocumentsResponse.newBuilder().addDocuments(Document.newBuilder().setName("doc_2-1").putAllFields((Map)ImmutableMap.of((Object)"foo", (Object)Value.newBuilder().setStringValue("bar").build())).build()).build();
        Mockito.when((Object)((ListDocumentsResponse)this.page2.getResponse())).thenReturn((Object)response2);
        Mockito.when((Object)this.page2.hasNextPage()).thenReturn((Object)false);
        Mockito.when((Object)this.pagedResponse1.iteratePages()).thenReturn((Object)ImmutableList.of((Object)this.page1, (Object)this.page2));
        Mockito.when((Object)((FirestoreClient.ListDocumentsPagedResponse)this.callable.call((Object)request1))).thenReturn((Object)this.pagedResponse1);
        Mockito.when((Object)this.stub.listDocumentsPagedCallable()).thenReturn(this.callable);
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        RpcQosOptions options = RpcQosOptions.defaultOptions();
        Mockito.when((Object)this.ff.getRpcQos((RpcQosOptions)ArgumentMatchers.any())).thenReturn((Object)FirestoreStatefulComponentFactory.INSTANCE.getRpcQos(options));
        ArgumentCaptor responses = ArgumentCaptor.forClass(ListDocumentsResponse.class);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).output((Object)((ListDocumentsResponse)responses.capture()));
        Mockito.when((Object)((ListDocumentsRequest)this.processContext.element())).thenReturn((Object)request1);
        FirestoreV1ReadFn.ListDocumentsFn fn = new FirestoreV1ReadFn.ListDocumentsFn(this.clock, this.ff, options);
        this.runFunction(fn);
        ArrayList expected = Lists.newArrayList((Object[])new ListDocumentsResponse[]{response1, response2});
        List allValues = responses.getAllValues();
        Assert.assertEquals((Object)expected, (Object)allValues);
    }

    @Override
    public void resumeFromLastReadValue() throws Exception {
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        Mockito.when((Object)this.ff.getRpcQos((RpcQosOptions)ArgumentMatchers.any())).thenReturn((Object)this.rpcQos);
        Mockito.when((Object)this.rpcQos.newReadAttempt((RpcQos.RpcAttempt.Context)ArgumentMatchers.any())).thenReturn((Object)this.attempt);
        Mockito.when((Object)this.attempt.awaitSafeToProceed((Instant)ArgumentMatchers.any())).thenReturn((Object)true);
        ListDocumentsRequest request1 = ListDocumentsRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", "testing-project")).build();
        ListDocumentsResponse response1 = ListDocumentsResponse.newBuilder().addDocuments(Document.newBuilder().setName("doc_1-1").putAllFields((Map)ImmutableMap.of((Object)"foo", (Object)Value.newBuilder().setStringValue("bar").build())).build()).addDocuments(Document.newBuilder().setName("doc_1-2").putAllFields((Map)ImmutableMap.of((Object)"foo", (Object)Value.newBuilder().setStringValue("bar").build())).build()).addDocuments(Document.newBuilder().setName("doc_1-3").putAllFields((Map)ImmutableMap.of((Object)"foo", (Object)Value.newBuilder().setStringValue("bar").build())).build()).setNextPageToken("page2").build();
        Mockito.when((Object)this.page1.getNextPageToken()).thenReturn((Object)response1.getNextPageToken());
        Mockito.when((Object)((ListDocumentsResponse)this.page1.getResponse())).thenReturn((Object)response1);
        Mockito.when((Object)this.page1.hasNextPage()).thenReturn((Object)true);
        Mockito.when((Object)((FirestoreClient.ListDocumentsPagedResponse)this.callable.call((Object)request1))).thenReturn((Object)this.pagedResponse1);
        ((RpcQos.RpcReadAttempt)Mockito.doNothing().when((Object)this.attempt)).checkCanRetry((Instant)ArgumentMatchers.any(), (RuntimeException)ArgumentMatchers.eq((Object)((Object)RETRYABLE_ERROR)));
        Mockito.when((Object)this.pagedResponse1.iteratePages()).thenAnswer(invocation -> new Iterable<FirestoreClient.ListDocumentsPage>(){

            @Override
            public Iterator<FirestoreClient.ListDocumentsPage> iterator() {
                return new AbstractIterator<FirestoreClient.ListDocumentsPage>(){
                    private boolean first = true;

                    protected FirestoreClient.ListDocumentsPage computeNext() {
                        if (this.first) {
                            this.first = false;
                            return FirestoreV1FnListDocumentsTest.this.page1;
                        }
                        throw BaseFirestoreV1FnTest.RETRYABLE_ERROR;
                    }
                };
            }
        });
        ListDocumentsRequest request2 = ListDocumentsRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", "testing-project")).setPageToken("page2").build();
        ListDocumentsResponse response2 = ListDocumentsResponse.newBuilder().addDocuments(Document.newBuilder().setName("doc_2-1").putAllFields((Map)ImmutableMap.of((Object)"foo", (Object)Value.newBuilder().setStringValue("bar").build())).build()).build();
        Mockito.when((Object)((ListDocumentsResponse)this.page2.getResponse())).thenReturn((Object)response2);
        Mockito.when((Object)this.page2.hasNextPage()).thenReturn((Object)false);
        Mockito.when((Object)((FirestoreClient.ListDocumentsPagedResponse)this.callable.call((Object)request2))).thenReturn((Object)this.pagedResponse2);
        Mockito.when((Object)this.pagedResponse2.iteratePages()).thenReturn((Object)ImmutableList.of((Object)this.page2));
        Mockito.when((Object)this.stub.listDocumentsPagedCallable()).thenReturn(this.callable);
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        ArgumentCaptor responses = ArgumentCaptor.forClass(ListDocumentsResponse.class);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).output((Object)((ListDocumentsResponse)responses.capture()));
        Mockito.when((Object)((ListDocumentsRequest)this.processContext.element())).thenReturn((Object)request1);
        FirestoreV1ReadFn.ListDocumentsFn fn = new FirestoreV1ReadFn.ListDocumentsFn(this.clock, this.ff, this.rpcQosOptions);
        this.runFunction(fn);
        ArrayList expected = Lists.newArrayList((Object[])new ListDocumentsResponse[]{response1, response2});
        List allValues = responses.getAllValues();
        Assert.assertEquals((Object)expected, (Object)allValues);
    }

    @Override
    protected BaseFirestoreV1ReadFnTest.V1RpcFnTestCtx newCtx() {
        return new BaseFirestoreV1ReadFnTest.V1RpcFnTestCtx(){

            public ListDocumentsRequest getRequest() {
                return ListDocumentsRequest.newBuilder().setParent(String.format("projects/%s/databases/(default)/document", "testing-project")).build();
            }

            @Override
            public void mockRpcToCallable(FirestoreStub stub) {
                Mockito.when((Object)stub.listDocumentsPagedCallable()).thenReturn((Object)FirestoreV1FnListDocumentsTest.this.callable);
            }

            public void whenCallableCall(ListDocumentsRequest in, Throwable ... throwables) {
                Mockito.when((Object)((FirestoreClient.ListDocumentsPagedResponse)FirestoreV1FnListDocumentsTest.this.callable.call((Object)in))).thenThrow(throwables);
            }

            @Override
            public void verifyNoInteractionsWithCallable() {
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{FirestoreV1FnListDocumentsTest.this.callable});
            }
        };
    }

    protected FirestoreV1ReadFn.ListDocumentsFn getFn(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
        return new FirestoreV1ReadFn.ListDocumentsFn(clock, firestoreStatefulComponentFactory, rpcQosOptions);
    }
}

