/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.api.gax.rpc.UnaryCallable;
import com.google.firestore.v1.ArrayValue;
import com.google.firestore.v1.BatchWriteRequest;
import com.google.firestore.v1.BatchWriteResponse;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentTransform;
import com.google.firestore.v1.Precondition;
import com.google.firestore.v1.Value;
import com.google.firestore.v1.Write;
import com.google.firestore.v1.WriteResult;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import com.google.rpc.Code;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.firestore.BaseFirestoreV1WriteFnTest;
import org.apache.beam.sdk.io.gcp.firestore.CounterFactory;
import org.apache.beam.sdk.io.gcp.firestore.DistributionFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreProtoHelpers;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreStatefulComponentFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1WriteFn;
import org.apache.beam.sdk.io.gcp.firestore.JodaClock;
import org.apache.beam.sdk.io.gcp.firestore.RpcQos;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class FirestoreV1FnBatchWriteWithDeadLetterQueueTest
extends BaseFirestoreV1WriteFnTest<FirestoreV1.WriteFailure, FirestoreV1WriteFn.BatchWriteFnWithDeadLetterQueue> {
    @Override
    @Test
    public void enqueueingWritesValidateBytesSize() throws Exception {
        int maxBytes = 50;
        RpcQosOptions options = this.rpcQosOptions.toBuilder().withBatchMaxBytes((long)maxBytes).build();
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        Mockito.when((Object)this.ff.getRpcQos((RpcQosOptions)ArgumentMatchers.any())).thenReturn((Object)FirestoreStatefulComponentFactory.INSTANCE.getRpcQos(options));
        byte[] bytes = new byte[maxBytes + 1];
        SecureRandom.getInstanceStrong().nextBytes(bytes);
        byte[] base64Bytes = Base64.getEncoder().encode(bytes);
        String base64String = Base64.getEncoder().encodeToString(bytes);
        Value largeValue = Value.newBuilder().setStringValueBytes(ByteString.copyFrom((byte[])base64Bytes)).build();
        Write write1 = Write.newBuilder().setTransform(DocumentTransform.newBuilder().setDocument(String.format("doc-%03d", 2)).addFieldTransforms(DocumentTransform.FieldTransform.newBuilder().setAppendMissingElements(ArrayValue.newBuilder().addValues(largeValue)))).build();
        Write write2 = Write.newBuilder().setDelete(String.format("doc-%03d_%s", 3, base64String)).build();
        Write write3 = Write.newBuilder().setUpdate(Document.newBuilder().setName(String.format("doc-%03d", 4)).putAllFields((Map)ImmutableMap.of((Object)"foo", (Object)largeValue))).build();
        FirestoreV1WriteFn.BatchWriteFnWithDeadLetterQueue fn = this.getFn(this.clock, this.ff, options, this.metricsFixture.counterFactory, this.metricsFixture.distributionFactory);
        fn.populateDisplayData(this.displayDataBuilder);
        fn.setup();
        fn.startBundle(this.startBundleContext);
        ArgumentCaptor write1FailureCapture = ArgumentCaptor.forClass(FirestoreV1.WriteFailure.class);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).outputWithTimestamp((Object)((FirestoreV1.WriteFailure)write1FailureCapture.capture()), (Instant)ArgumentMatchers.any());
        Mockito.when((Object)((Write)this.processContext.element())).thenReturn((Object)write1);
        fn.processElement(this.processContext, this.window);
        FirestoreV1.WriteFailure failure = (FirestoreV1.WriteFailure)write1FailureCapture.getValue();
        Assert.assertNotNull((Object)failure);
        String message = failure.getStatus().getMessage();
        Assert.assertTrue((boolean)message.contains("TRANSFORM"));
        Assert.assertTrue((boolean)message.contains("larger than configured max allowed bytes per batch"));
        ArgumentCaptor write2FailureCapture = ArgumentCaptor.forClass(FirestoreV1.WriteFailure.class);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).outputWithTimestamp((Object)((FirestoreV1.WriteFailure)write2FailureCapture.capture()), (Instant)ArgumentMatchers.any());
        Mockito.when((Object)((Write)this.processContext.element())).thenReturn((Object)write2);
        fn.processElement(this.processContext, this.window);
        FirestoreV1.WriteFailure failure2 = (FirestoreV1.WriteFailure)write2FailureCapture.getValue();
        Assert.assertNotNull((Object)failure2);
        String message2 = failure2.getStatus().getMessage();
        Assert.assertTrue((boolean)message2.contains("DELETE"));
        Assert.assertTrue((boolean)message2.contains("larger than configured max allowed bytes per batch"));
        ArgumentCaptor write3FailureCapture = ArgumentCaptor.forClass(FirestoreV1.WriteFailure.class);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).outputWithTimestamp((Object)((FirestoreV1.WriteFailure)write3FailureCapture.capture()), (Instant)ArgumentMatchers.any());
        Mockito.when((Object)((Write)this.processContext.element())).thenReturn((Object)write3);
        fn.processElement(this.processContext, this.window);
        FirestoreV1.WriteFailure failure3 = (FirestoreV1.WriteFailure)write3FailureCapture.getValue();
        Assert.assertNotNull((Object)failure3);
        String message3 = failure3.getStatus().getMessage();
        Assert.assertTrue((boolean)message3.contains("UPDATE"));
        Assert.assertTrue((boolean)message3.contains("larger than configured max allowed bytes per batch"));
        Assert.assertEquals((long)0L, (long)fn.writes.size());
    }

    @Test
    public void nonRetryableWriteIsOutput() throws Exception {
        Write write0 = FirestoreProtoHelpers.newWrite(0L);
        Write write1 = FirestoreProtoHelpers.newWrite(1L).toBuilder().setCurrentDocument(Precondition.newBuilder().setExists(false).build()).build();
        BatchWriteRequest expectedRequest1 = BatchWriteRequest.newBuilder().setDatabase("projects/testing-project/databases/(default)").addWrites(write0).addWrites(write1).build();
        BatchWriteResponse response1 = BatchWriteResponse.newBuilder().addStatus(STATUS_OK).addWriteResults(WriteResult.newBuilder().setUpdateTime(Timestamp.newBuilder().setSeconds(1L).build()).build()).addStatus(FirestoreV1FnBatchWriteWithDeadLetterQueueTest.statusForCode(Code.ALREADY_EXISTS)).addWriteResults(WriteResult.newBuilder().build()).build();
        RpcQosOptions options = this.rpcQosOptions.toBuilder().withMaxAttempts(1).withBatchMaxCount(2).build();
        Mockito.when((Object)((Write)this.processContext.element())).thenReturn((Object)write0, (Object[])new Write[]{write1}).thenThrow(new Throwable[]{new IllegalStateException("too many calls")});
        Mockito.when((Object)this.rpcQos.newWriteAttempt((RpcQos.RpcAttempt.Context)ArgumentMatchers.any())).thenReturn((Object)this.attempt);
        Mockito.when((Object)this.attempt.awaitSafeToProceed((Instant)ArgumentMatchers.any())).thenReturn((Object)true);
        Mockito.when((Object)this.attempt.newFlushBuffer((Instant)ArgumentMatchers.any())).thenReturn(this.newFlushBuffer(options)).thenReturn(this.newFlushBuffer(options)).thenThrow(new Throwable[]{new IllegalStateException("too many attempt#newFlushBuffer calls")});
        Mockito.when((Object)this.attempt.isCodeRetryable(Code.ALREADY_EXISTS)).thenReturn((Object)false);
        ArgumentCaptor requestCaptor1 = ArgumentCaptor.forClass(BatchWriteRequest.class);
        Mockito.when((Object)((BatchWriteResponse)this.callable.call((Object)((BatchWriteRequest)requestCaptor1.capture())))).thenReturn((Object)response1);
        FirestoreV1WriteFn.BatchWriteFnWithDeadLetterQueue fn = this.getFn(this.clock, this.ff, options, CounterFactory.DEFAULT, DistributionFactory.DEFAULT);
        fn.setup();
        fn.startBundle(this.startBundleContext);
        fn.processElement(this.processContext, this.window);
        ArgumentCaptor writeFailureCapture = ArgumentCaptor.forClass(FirestoreV1.WriteFailure.class);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).outputWithTimestamp((Object)((FirestoreV1.WriteFailure)writeFailureCapture.capture()), (Instant)ArgumentMatchers.any());
        fn.processElement(this.processContext, this.window);
        FirestoreV1.WriteFailure failure = (FirestoreV1.WriteFailure)writeFailureCapture.getValue();
        Assert.assertEquals((long)Code.ALREADY_EXISTS.getNumber(), (long)failure.getStatus().getCode());
        Assert.assertEquals((Object)write1, (Object)failure.getWrite());
        Assert.assertEquals((Object)WriteResult.getDefaultInstance(), (Object)failure.getWriteResult());
        Assert.assertEquals((Object)expectedRequest1, (Object)requestCaptor1.getValue());
        ArrayList actualWrites = new ArrayList(fn.writes);
        Assert.assertTrue((boolean)actualWrites.isEmpty());
        fn.finishBundle(this.finishBundleContext);
        ((RpcQos.RpcWriteAttempt)Mockito.verify((Object)this.attempt, (VerificationMode)Mockito.times((int)1))).recordRequestStart((Instant)ArgumentMatchers.any(), ArgumentMatchers.eq((int)2));
        ((RpcQos.RpcWriteAttempt)Mockito.verify((Object)this.attempt, (VerificationMode)Mockito.times((int)1))).recordWriteCounts((Instant)ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((int)1));
        ((RpcQos.RpcWriteAttempt)Mockito.verify((Object)this.attempt, (VerificationMode)Mockito.never())).completeSuccess();
        ((UnaryCallable)Mockito.verify((Object)this.callable, (VerificationMode)Mockito.times((int)1))).call((Object)((BatchWriteRequest)ArgumentMatchers.any()));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.callable});
    }

    @Override
    protected FirestoreV1WriteFn.BatchWriteFnWithDeadLetterQueue getFn(JodaClock clock, FirestoreStatefulComponentFactory ff, RpcQosOptions rpcQosOptions, CounterFactory counterFactory, DistributionFactory distributionFactory) {
        return new FirestoreV1WriteFn.BatchWriteFnWithDeadLetterQueue(clock, ff, rpcQosOptions, counterFactory);
    }
}

