/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import com.google.firestore.v1.BatchGetDocumentsRequest;
import com.google.firestore.v1.BatchGetDocumentsResponse;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.Value;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.firestore.BaseFirestoreV1FnTest;
import org.apache.beam.sdk.io.gcp.firestore.BaseFirestoreV1ReadFnTest;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreStatefulComponentFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1ReadFn;
import org.apache.beam.sdk.io.gcp.firestore.JodaClock;
import org.apache.beam.sdk.io.gcp.firestore.RpcQos;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.AbstractIterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class FirestoreV1FnBatchGetDocumentsTest
extends BaseFirestoreV1ReadFnTest<BatchGetDocumentsRequest, BatchGetDocumentsResponse> {
    @Mock
    private ServerStreamingCallable<BatchGetDocumentsRequest, BatchGetDocumentsResponse> callable;
    @Mock
    private ServerStream<BatchGetDocumentsResponse> responseStream1;
    @Mock
    private ServerStream<BatchGetDocumentsResponse> responseStream2;
    @Mock
    private ServerStream<BatchGetDocumentsResponse> responseStream3;

    @Test
    public void endToEnd() throws Exception {
        BatchGetDocumentsRequest request = BatchGetDocumentsRequest.newBuilder().setDatabase(String.format("projects/%s/databases/(default)", "testing-project")).addDocuments("doc_1-1").addDocuments("doc_1-2").addDocuments("doc_1-3").build();
        BatchGetDocumentsResponse response1 = FirestoreV1FnBatchGetDocumentsTest.newFound(1);
        BatchGetDocumentsResponse response2 = FirestoreV1FnBatchGetDocumentsTest.newFound(2);
        BatchGetDocumentsResponse response3 = FirestoreV1FnBatchGetDocumentsTest.newFound(3);
        ImmutableList responses = ImmutableList.of((Object)response1, (Object)response2, (Object)response3);
        Mockito.when((Object)this.responseStream1.iterator()).thenReturn(responses.iterator());
        Mockito.when((Object)this.callable.call((Object)request)).thenReturn(this.responseStream1);
        Mockito.when((Object)this.stub.batchGetDocumentsCallable()).thenReturn(this.callable);
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        Mockito.when((Object)this.ff.getRpcQos((RpcQosOptions)ArgumentMatchers.any())).thenReturn((Object)FirestoreStatefulComponentFactory.INSTANCE.getRpcQos(this.rpcQosOptions));
        ArgumentCaptor responsesCaptor = ArgumentCaptor.forClass(BatchGetDocumentsResponse.class);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).output((Object)((BatchGetDocumentsResponse)responsesCaptor.capture()));
        Mockito.when((Object)((BatchGetDocumentsRequest)this.processContext.element())).thenReturn((Object)request);
        this.runFunction(this.getFn(this.clock, this.ff, this.rpcQosOptions));
        List allValues = responsesCaptor.getAllValues();
        Assert.assertEquals((Object)responses, (Object)allValues);
    }

    @Override
    public void resumeFromLastReadValue() throws Exception {
        final BatchGetDocumentsResponse response1 = FirestoreV1FnBatchGetDocumentsTest.newMissing(1);
        final BatchGetDocumentsResponse response2 = FirestoreV1FnBatchGetDocumentsTest.newFound(2);
        final BatchGetDocumentsResponse response3 = FirestoreV1FnBatchGetDocumentsTest.newMissing(3);
        BatchGetDocumentsResponse response4 = FirestoreV1FnBatchGetDocumentsTest.newFound(4);
        BatchGetDocumentsRequest request1 = BatchGetDocumentsRequest.newBuilder().setDatabase(String.format("projects/%s/databases/(default)", "testing-project")).addDocuments(response1.getMissing()).addDocuments(response2.getFound().getName()).addDocuments(response3.getMissing()).addDocuments(response4.getFound().getName()).build();
        BatchGetDocumentsRequest request2 = BatchGetDocumentsRequest.newBuilder().setDatabase(String.format("projects/%s/databases/(default)", "testing-project")).addDocuments(response3.getMissing()).addDocuments(response4.getFound().getName()).build();
        BatchGetDocumentsRequest request3 = BatchGetDocumentsRequest.newBuilder().setDatabase(String.format("projects/%s/databases/(default)", "testing-project")).addDocuments(response4.getFound().getName()).build();
        Mockito.when((Object)this.responseStream1.iterator()).thenReturn((Object)new AbstractIterator<BatchGetDocumentsResponse>(){
            private int counter = 10;

            protected BatchGetDocumentsResponse computeNext() {
                int count;
                if ((count = this.counter++) == 10) {
                    return response1;
                }
                if (count == 11) {
                    return response2;
                }
                throw BaseFirestoreV1FnTest.RETRYABLE_ERROR;
            }
        });
        Mockito.when((Object)this.responseStream2.iterator()).thenReturn((Object)new AbstractIterator<BatchGetDocumentsResponse>(){
            private int counter = 20;

            protected BatchGetDocumentsResponse computeNext() {
                int count;
                if ((count = this.counter++) == 20) {
                    return response3;
                }
                throw BaseFirestoreV1FnTest.RETRYABLE_ERROR;
            }
        });
        Mockito.when((Object)this.responseStream3.iterator()).thenReturn((Object)ImmutableList.of((Object)response4).iterator());
        ((RpcQos.RpcReadAttempt)Mockito.doNothing().when((Object)this.attempt)).checkCanRetry((Instant)ArgumentMatchers.any(), (RuntimeException)ArgumentMatchers.eq((Object)RETRYABLE_ERROR));
        Mockito.when((Object)this.callable.call((Object)request1)).thenReturn(this.responseStream1);
        Mockito.when((Object)this.callable.call((Object)request2)).thenReturn(this.responseStream2);
        Mockito.when((Object)this.callable.call((Object)request3)).thenReturn(this.responseStream3);
        Mockito.when((Object)this.stub.batchGetDocumentsCallable()).thenReturn(this.callable);
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        Mockito.when((Object)this.ff.getRpcQos((RpcQosOptions)ArgumentMatchers.any())).thenReturn((Object)this.rpcQos);
        Mockito.when((Object)this.rpcQos.newReadAttempt((RpcQos.RpcAttempt.Context)ArgumentMatchers.any())).thenReturn((Object)this.attempt);
        Mockito.when((Object)this.attempt.awaitSafeToProceed((Instant)ArgumentMatchers.any())).thenReturn((Object)true);
        ArgumentCaptor responsesCaptor = ArgumentCaptor.forClass(BatchGetDocumentsResponse.class);
        ((DoFn.ProcessContext)Mockito.doNothing().when((Object)this.processContext)).output((Object)((BatchGetDocumentsResponse)responsesCaptor.capture()));
        Mockito.when((Object)((BatchGetDocumentsRequest)this.processContext.element())).thenReturn((Object)request1);
        FirestoreV1ReadFn.BatchGetDocumentsFn fn = new FirestoreV1ReadFn.BatchGetDocumentsFn(this.clock, this.ff, this.rpcQosOptions);
        this.runFunction(fn);
        ImmutableList expectedResponses = ImmutableList.of((Object)response1, (Object)response2, (Object)response3, (Object)response4);
        List actualResponses = responsesCaptor.getAllValues();
        Assert.assertEquals((Object)expectedResponses, (Object)actualResponses);
        ((ServerStreamingCallable)Mockito.verify(this.callable, (VerificationMode)Mockito.times((int)1))).call((Object)request1);
        ((ServerStreamingCallable)Mockito.verify(this.callable, (VerificationMode)Mockito.times((int)1))).call((Object)request2);
        ((RpcQos.RpcReadAttempt)Mockito.verify((Object)this.attempt, (VerificationMode)Mockito.times((int)4))).recordStreamValue((Instant)ArgumentMatchers.any());
    }

    @Override
    protected BaseFirestoreV1ReadFnTest.V1RpcFnTestCtx newCtx() {
        return new BaseFirestoreV1ReadFnTest.V1RpcFnTestCtx(){

            public BatchGetDocumentsRequest getRequest() {
                return BatchGetDocumentsRequest.newBuilder().setDatabase(String.format("projects/%s/databases/(default)", "testing-project")).addDocuments("doc_1-1").build();
            }

            @Override
            public void mockRpcToCallable(FirestoreStub stub) {
                Mockito.when((Object)stub.batchGetDocumentsCallable()).thenReturn((Object)FirestoreV1FnBatchGetDocumentsTest.this.callable);
            }

            public void whenCallableCall(BatchGetDocumentsRequest in, Throwable ... throwables) {
                Mockito.when((Object)FirestoreV1FnBatchGetDocumentsTest.this.callable.call((Object)in)).thenThrow(throwables);
            }

            @Override
            public void verifyNoInteractionsWithCallable() {
                Mockito.verifyNoMoreInteractions((Object[])new Object[]{FirestoreV1FnBatchGetDocumentsTest.this.callable});
            }
        };
    }

    protected FirestoreV1ReadFn.BatchGetDocumentsFn getFn(JodaClock clock, FirestoreStatefulComponentFactory firestoreStatefulComponentFactory, RpcQosOptions rpcQosOptions) {
        return new FirestoreV1ReadFn.BatchGetDocumentsFn(clock, firestoreStatefulComponentFactory, rpcQosOptions);
    }

    private static BatchGetDocumentsResponse newFound(int docNumber) {
        String docName = FirestoreV1FnBatchGetDocumentsTest.docName(docNumber);
        return BatchGetDocumentsResponse.newBuilder().setFound(Document.newBuilder().setName(docName).putAllFields((Map)ImmutableMap.of((Object)"foo", (Object)Value.newBuilder().setStringValue("bar").build())).build()).build();
    }

    private static BatchGetDocumentsResponse newMissing(int docNumber) {
        String docName = FirestoreV1FnBatchGetDocumentsTest.docName(docNumber);
        return BatchGetDocumentsResponse.newBuilder().setMissing(docName).build();
    }

    private static String docName(int docNumber) {
        return String.format("doc-%d", docNumber);
    }
}

