/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import org.apache.beam.sdk.io.gcp.firestore.BaseFirestoreV1FnTest;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreStatefulComponentFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1ReadFn;
import org.apache.beam.sdk.io.gcp.firestore.JodaClock;
import org.apache.beam.sdk.io.gcp.firestore.RpcQos;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

abstract class BaseFirestoreV1ReadFnTest<InT, OutT>
extends BaseFirestoreV1FnTest<InT, OutT, FirestoreV1ReadFn.BaseFirestoreV1ReadFn<InT, OutT>> {
    @Mock
    protected RpcQos.RpcReadAttempt attempt;

    BaseFirestoreV1ReadFnTest() {
    }

    @Override
    @Test
    public final void attemptsExhaustedForRetryableError() throws Exception {
        FirestoreV1ReadFn.BaseFirestoreV1ReadFn<InT, OutT> fn = this.getFn(this.clock, this.ff, this.rpcQosOptions);
        V1RpcFnTestCtx ctx = this.newCtx();
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        Mockito.when((Object)this.ff.getRpcQos((RpcQosOptions)ArgumentMatchers.any())).thenReturn((Object)this.rpcQos);
        Mockito.when((Object)this.rpcQos.newReadAttempt(fn.getRpcAttemptContext())).thenReturn((Object)this.attempt);
        ctx.mockRpcToCallable(this.stub);
        Mockito.when((Object)this.attempt.awaitSafeToProceed((Instant)ArgumentMatchers.any())).thenReturn((Object)true, (Object[])new Boolean[]{true, true});
        ctx.whenCallableCall(ArgumentMatchers.any(), RETRYABLE_ERROR, RETRYABLE_ERROR, RETRYABLE_ERROR);
        ((RpcQos.RpcReadAttempt)Mockito.doNothing().when((Object)this.attempt)).recordRequestFailed((Instant)ArgumentMatchers.any());
        ((RpcQos.RpcReadAttempt)Mockito.doNothing().doNothing().doThrow(new Throwable[]{RETRYABLE_ERROR}).when((Object)this.attempt)).checkCanRetry((Instant)ArgumentMatchers.any(), (RuntimeException)ArgumentMatchers.eq((Object)((Object)RETRYABLE_ERROR)));
        Mockito.when((Object)this.processContext.element()).thenReturn(ctx.getRequest());
        try {
            this.runFunction(fn);
            Assert.fail((String)"Expected ApiException to be throw after exhausted attempts");
        }
        catch (ApiException e) {
            Assert.assertSame((Object)((Object)RETRYABLE_ERROR), (Object)((Object)e));
        }
        ((RpcQos.RpcReadAttempt)Mockito.verify((Object)this.attempt, (VerificationMode)Mockito.times((int)3))).awaitSafeToProceed((Instant)ArgumentMatchers.any());
        ((RpcQos.RpcReadAttempt)Mockito.verify((Object)this.attempt, (VerificationMode)Mockito.times((int)3))).recordRequestFailed((Instant)ArgumentMatchers.any());
        ((RpcQos.RpcReadAttempt)Mockito.verify((Object)this.attempt, (VerificationMode)Mockito.times((int)0))).recordStreamValue((Instant)ArgumentMatchers.any());
        ((RpcQos.RpcReadAttempt)Mockito.verify((Object)this.attempt, (VerificationMode)Mockito.times((int)0))).recordRequestSuccessful((Instant)ArgumentMatchers.any());
    }

    @Override
    @Test
    public final void noRequestIsSentIfNotSafeToProceed() throws Exception {
        FirestoreV1ReadFn.BaseFirestoreV1ReadFn<InT, OutT> fn = this.getFn(this.clock, this.ff, this.rpcQosOptions);
        V1RpcFnTestCtx ctx = this.newCtx();
        Mockito.when((Object)this.ff.getFirestoreStub((PipelineOptions)ArgumentMatchers.any())).thenReturn((Object)this.stub);
        Mockito.when((Object)this.ff.getRpcQos((RpcQosOptions)ArgumentMatchers.any())).thenReturn((Object)this.rpcQos);
        Mockito.when((Object)this.rpcQos.newReadAttempt(fn.getRpcAttemptContext())).thenReturn((Object)this.attempt);
        InterruptedException interruptedException = new InterruptedException();
        Mockito.when((Object)this.attempt.awaitSafeToProceed((Instant)ArgumentMatchers.any())).thenReturn((Object)false).thenThrow(new Throwable[]{interruptedException});
        Mockito.when((Object)this.processContext.element()).thenReturn(ctx.getRequest());
        try {
            this.runFunction(fn);
            Assert.fail((String)"Expected ApiException to be throw after exhausted attempts");
        }
        catch (InterruptedException e) {
            Assert.assertSame((Object)interruptedException, (Object)e);
        }
        ((FirestoreStub)Mockito.verify((Object)this.stub, (VerificationMode)Mockito.times((int)1))).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stub});
        ctx.verifyNoInteractionsWithCallable();
        ((RpcQos.RpcReadAttempt)Mockito.verify((Object)this.attempt, (VerificationMode)Mockito.times((int)0))).recordRequestFailed((Instant)ArgumentMatchers.any());
        ((RpcQos.RpcReadAttempt)Mockito.verify((Object)this.attempt, (VerificationMode)Mockito.times((int)0))).recordStreamValue((Instant)ArgumentMatchers.any());
        ((RpcQos.RpcReadAttempt)Mockito.verify((Object)this.attempt, (VerificationMode)Mockito.times((int)0))).recordRequestSuccessful((Instant)ArgumentMatchers.any());
    }

    @Test
    public abstract void resumeFromLastReadValue() throws Exception;

    protected abstract V1RpcFnTestCtx newCtx();

    @Override
    protected final FirestoreV1ReadFn.BaseFirestoreV1ReadFn<InT, OutT> getFn() {
        return this.getFn(JodaClock.DEFAULT, FirestoreStatefulComponentFactory.INSTANCE, this.rpcQosOptions);
    }

    protected abstract FirestoreV1ReadFn.BaseFirestoreV1ReadFn<InT, OutT> getFn(JodaClock var1, FirestoreStatefulComponentFactory var2, RpcQosOptions var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processElementsAndFinishBundle(FirestoreV1ReadFn.BaseFirestoreV1ReadFn<InT, OutT> fn, int processElementCount) throws Exception {
        try {
            for (int i = 0; i < processElementCount; ++i) {
                fn.processElement(this.processContext);
            }
        }
        finally {
            fn.finishBundle();
        }
    }

    protected abstract class V1RpcFnTestCtx {
        protected V1RpcFnTestCtx() {
        }

        public abstract InT getRequest();

        public abstract void mockRpcToCallable(FirestoreStub var1);

        public abstract void whenCallableCall(InT var1, Throwable ... var2);

        public abstract void verifyNoInteractionsWithCallable();
    }
}

