/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.firestore.v1.stub.FirestoreStub;
import io.grpc.Status;
import java.net.SocketTimeoutException;
import org.apache.beam.sdk.io.gcp.firestore.BaseFirestoreFnTest;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreDoFn;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreStatefulComponentFactory;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreV1RpcAttemptContexts;
import org.apache.beam.sdk.io.gcp.firestore.JodaClock;
import org.apache.beam.sdk.io.gcp.firestore.RpcQos;
import org.apache.beam.sdk.io.gcp.firestore.RpcQosOptions;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mock;

abstract class BaseFirestoreV1FnTest<InT, OutT, FnT extends FirestoreDoFn<InT, OutT>>
extends BaseFirestoreFnTest<InT, OutT, FnT> {
    protected static final ApiException RETRYABLE_ERROR = ApiExceptionFactory.createException((Throwable)new SocketTimeoutException("retryableError"), (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.CANCELLED), (boolean)true);
    protected final RpcQosOptions rpcQosOptions = RpcQosOptions.newBuilder().build();
    protected final JodaClock clock = new MonotonicJodaClock();
    @Mock
    protected FirestoreStatefulComponentFactory ff;
    @Mock
    protected FirestoreStub stub;
    @Mock
    protected RpcQos rpcQos;

    BaseFirestoreV1FnTest() {
    }

    @Test
    public abstract void attemptsExhaustedForRetryableError() throws Exception;

    @Test
    public abstract void noRequestIsSentIfNotSafeToProceed() throws Exception;

    @Test
    public final void contextNamespaceMatchesPublicAPIDefinedValue() {
        Object fn = this.getFn();
        RpcQos.RpcAttempt.Context rpcAttemptContext = ((FirestoreV1RpcAttemptContexts.HasRpcAttemptContext)fn).getRpcAttemptContext();
        if (rpcAttemptContext instanceof FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext) {
            FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext v1FnRpcAttemptContext = (FirestoreV1RpcAttemptContexts.V1FnRpcAttemptContext)rpcAttemptContext;
            switch (v1FnRpcAttemptContext) {
                case BatchGetDocuments: {
                    Assert.assertEquals((Object)"org.apache.beam.sdk.io.gcp.firestore.FirestoreV1.BatchGetDocuments", (Object)v1FnRpcAttemptContext.getNamespace());
                    break;
                }
                case BatchWrite: {
                    Assert.assertEquals((Object)"org.apache.beam.sdk.io.gcp.firestore.FirestoreV1.BatchWrite", (Object)v1FnRpcAttemptContext.getNamespace());
                    break;
                }
                case ListCollectionIds: {
                    Assert.assertEquals((Object)"org.apache.beam.sdk.io.gcp.firestore.FirestoreV1.ListCollectionIds", (Object)v1FnRpcAttemptContext.getNamespace());
                    break;
                }
                case ListDocuments: {
                    Assert.assertEquals((Object)"org.apache.beam.sdk.io.gcp.firestore.FirestoreV1.ListDocuments", (Object)v1FnRpcAttemptContext.getNamespace());
                    break;
                }
                case PartitionQuery: {
                    Assert.assertEquals((Object)"org.apache.beam.sdk.io.gcp.firestore.FirestoreV1.PartitionQuery", (Object)v1FnRpcAttemptContext.getNamespace());
                    break;
                }
                case RunQuery: {
                    Assert.assertEquals((Object)"org.apache.beam.sdk.io.gcp.firestore.FirestoreV1.RunQuery", (Object)v1FnRpcAttemptContext.getNamespace());
                    break;
                }
                default: {
                    Assert.fail((String)"Unverified V1FnRpcAttemptContext value");
                }
            }
        }
    }

    private static class MonotonicJodaClock
    implements JodaClock {
        private long counter = 0L;

        private MonotonicJodaClock() {
        }

        public Instant instant() {
            return Instant.ofEpochMilli((long)this.counter++);
        }
    }
}

