/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.firestore;

import com.google.auth.Credentials;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreDoFn;
import org.apache.beam.sdk.io.gcp.firestore.FirestoreOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.SerializableUtils;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
abstract class BaseFirestoreFnTest<InT, OutT, FnT extends FirestoreDoFn<InT, OutT>> {
    protected final String projectId = "testing-project";
    @Mock
    protected DoFn.StartBundleContext startBundleContext;
    @Mock
    protected DoFn.ProcessContext processContext;
    @Mock(lenient=true)
    protected DisplayData.Builder displayDataBuilder;
    @Mock(lenient=true)
    protected PipelineOptions pipelineOptions;
    @Mock(lenient=true)
    protected GcpOptions gcpOptions;
    @Mock(lenient=true)
    protected FirestoreOptions firestoreOptions;
    @Mock
    protected Credentials credentials;

    BaseFirestoreFnTest() {
    }

    @Before
    public void stubDisplayDataBuilderChains() {
        Mockito.when((Object)this.displayDataBuilder.include((String)ArgumentMatchers.any(), (HasDisplayData)ArgumentMatchers.any())).thenReturn((Object)this.displayDataBuilder);
        Mockito.when((Object)this.displayDataBuilder.add((DisplayData.ItemSpec)ArgumentMatchers.any())).thenReturn((Object)this.displayDataBuilder);
        Mockito.when((Object)this.displayDataBuilder.addIfNotNull((DisplayData.ItemSpec)ArgumentMatchers.any())).thenReturn((Object)this.displayDataBuilder);
        Mockito.when((Object)this.displayDataBuilder.addIfNotDefault((DisplayData.ItemSpec)ArgumentMatchers.any(), ArgumentMatchers.any())).thenReturn((Object)this.displayDataBuilder);
    }

    @Before
    public void stubPipelineOptions() {
        Mockito.when((Object)this.startBundleContext.getPipelineOptions()).thenReturn((Object)this.pipelineOptions);
        Mockito.when((Object)((FirestoreOptions)this.pipelineOptions.as(FirestoreOptions.class))).thenReturn((Object)this.firestoreOptions);
        Mockito.when((Object)this.firestoreOptions.getEmulatorHost()).thenReturn(null);
        Mockito.when((Object)((GcpOptions)this.pipelineOptions.as(GcpOptions.class))).thenReturn((Object)this.gcpOptions);
        Mockito.when((Object)this.gcpOptions.getProject()).thenReturn((Object)"testing-project");
        Mockito.when((Object)this.gcpOptions.getGcpCredential()).thenReturn((Object)this.credentials);
    }

    @Test
    public final void ensureSerializable() {
        SerializableUtils.ensureSerializable(this.getFn());
    }

    protected abstract FnT getFn();

    protected final void runFunction(FnT fn) throws Exception {
        this.runFunction(fn, 1);
    }

    protected final void runFunction(FnT fn, int processElementCount) throws Exception {
        fn.populateDisplayData(this.displayDataBuilder);
        fn.setup();
        fn.startBundle(this.startBundleContext);
        this.processElementsAndFinishBundle(fn, processElementCount);
    }

    protected abstract void processElementsAndFinishBundle(FnT var1, int var2) throws Exception;
}

