/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import java.util.Map;
import org.apache.beam.sdk.io.gcp.datastore.RampupThrottlingFn;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnTester;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.joda.time.DateTimeUtils;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class RampupThrottlingFnTest {
    @Mock
    private Counter mockCounter;
    private final Sleeper mockSleeper = millis -> {
        ((Counter)Mockito.verify((Object)this.mockCounter)).inc(millis);
        throw new RampupDelayException();
    };
    private DoFnTester<Void, Void> rampupThrottlingFnTester;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.openMocks((Object)this);
        DateTimeUtils.setCurrentMillisFixed((long)0L);
        TestPipeline pipeline = TestPipeline.create();
        PCollectionView startTimeView = (PCollectionView)((PCollection)pipeline.apply((PTransform)Create.of((Object)Instant.now(), (Object[])new Instant[0]))).apply((PTransform)View.asSingleton());
        RampupThrottlingFn<Void> rampupThrottlingFn = new RampupThrottlingFn<Void>(1, startTimeView){

            @DoFn.Setup
            public void setup() {
                super.setup();
                this.sleeper = RampupThrottlingFnTest.this.mockSleeper;
            }
        };
        this.rampupThrottlingFnTester = DoFnTester.of((DoFn)rampupThrottlingFn);
        this.rampupThrottlingFnTester.setSideInput(startTimeView, (BoundedWindow)GlobalWindow.INSTANCE, (Object)Instant.now());
        this.rampupThrottlingFnTester.setCloningBehavior(DoFnTester.CloningBehavior.DO_NOT_CLONE);
        this.rampupThrottlingFnTester.startBundle();
        rampupThrottlingFn.throttlingMsecs = this.mockCounter;
    }

    @After
    public void tearDown() {
        DateTimeUtils.setCurrentMillisSystem();
    }

    @Test
    public void testRampupThrottler() throws Exception {
        ImmutableMap rampupSchedule = ImmutableMap.builder().put((Object)Duration.ZERO, (Object)500).put((Object)Duration.millis((long)1L), (Object)0).put((Object)Duration.standardSeconds((long)1L), (Object)500).put((Object)Duration.standardSeconds((long)1L).plus((ReadableDuration)Duration.millis((long)1L)), (Object)0).put((Object)Duration.standardMinutes((long)5L), (Object)500).put((Object)Duration.standardMinutes((long)10L), (Object)750).put((Object)Duration.standardMinutes((long)15L), (Object)1125).put((Object)Duration.standardMinutes((long)30L), (Object)3796).put((Object)Duration.standardMinutes((long)60L), (Object)43248).build();
        for (Map.Entry entry : rampupSchedule.entrySet()) {
            DateTimeUtils.setCurrentMillisFixed((long)((Duration)entry.getKey()).getMillis());
            for (int i = 0; i < (Integer)entry.getValue(); ++i) {
                this.rampupThrottlingFnTester.processElement(null);
            }
            Assert.assertThrows(RampupDelayException.class, () -> this.rampupThrottlingFnTester.processElement(null));
        }
    }

    static class RampupDelayException
    extends InterruptedException {
        RampupDelayException() {
        }
    }
}

