/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.datastore.v1.CommitRequest;
import com.google.datastore.v1.CommitResponse;
import com.google.datastore.v1.Entity;
import com.google.datastore.v1.EntityResult;
import com.google.datastore.v1.Filter;
import com.google.datastore.v1.GqlQuery;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.Mutation;
import com.google.datastore.v1.PartitionId;
import com.google.datastore.v1.PropertyFilter;
import com.google.datastore.v1.PropertyOrder;
import com.google.datastore.v1.Query;
import com.google.datastore.v1.QueryResultBatch;
import com.google.datastore.v1.RunQueryRequest;
import com.google.datastore.v1.RunQueryResponse;
import com.google.datastore.v1.Value;
import com.google.datastore.v1.client.Datastore;
import com.google.datastore.v1.client.DatastoreException;
import com.google.datastore.v1.client.DatastoreHelper;
import com.google.datastore.v1.client.QuerySplitter;
import com.google.protobuf.Int32Value;
import com.google.rpc.Code;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.datastore.DatastoreIO;
import org.apache.beam.sdk.io.gcp.datastore.DatastoreV1;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnTester;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataEvaluator;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class DatastoreV1Test {
    private static final String PROJECT_ID = "testProject";
    private static final String NAMESPACE = "testNamespace";
    private static final String KIND = "testKind";
    private static final Query QUERY;
    private static final String LOCALHOST = "localhost:9955";
    private static final String GQL_QUERY = "SELECT * from testKind";
    private static final DatastoreV1.Read.V1Options V_1_OPTIONS;
    @Mock
    private Datastore mockDatastore;
    @Mock
    QuerySplitter mockQuerySplitter;
    @Mock
    DatastoreV1.V1DatastoreFactory mockDatastoreFactory;
    @Rule
    public final ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockDatastoreFactory.getDatastore((PipelineOptions)Matchers.any(PipelineOptions.class), (String)Matchers.any(String.class), (String)Matchers.any())).thenReturn((Object)this.mockDatastore);
        Mockito.when((Object)this.mockDatastoreFactory.getQuerySplitter()).thenReturn((Object)this.mockQuerySplitter);
        MetricsContainerImpl container = new MetricsContainerImpl(null);
        MetricsEnvironment.setProcessWideContainer((MetricsContainer)container);
    }

    @Test
    public void testBuildRead() throws Exception {
        DatastoreV1.Read read = DatastoreIO.v1().read().withProjectId(PROJECT_ID).withQuery(QUERY).withNamespace(NAMESPACE);
        Assert.assertEquals((Object)QUERY, (Object)read.getQuery());
        Assert.assertEquals((Object)PROJECT_ID, (Object)read.getProjectId().get());
        Assert.assertEquals((Object)NAMESPACE, (Object)read.getNamespace().get());
    }

    @Test
    public void testBuildReadWithGqlQuery() throws Exception {
        DatastoreV1.Read read = DatastoreIO.v1().read().withProjectId(PROJECT_ID).withLiteralGqlQuery(GQL_QUERY).withNamespace(NAMESPACE);
        Assert.assertEquals((Object)GQL_QUERY, (Object)read.getLiteralGqlQuery().get());
        Assert.assertEquals((Object)PROJECT_ID, (Object)read.getProjectId().get());
        Assert.assertEquals((Object)NAMESPACE, (Object)read.getNamespace().get());
    }

    @Test
    public void testBuildReadAlt() throws Exception {
        DatastoreV1.Read read = DatastoreIO.v1().read().withQuery(QUERY).withNamespace(NAMESPACE).withProjectId(PROJECT_ID).withLocalhost(LOCALHOST);
        Assert.assertEquals((Object)QUERY, (Object)read.getQuery());
        Assert.assertEquals((Object)PROJECT_ID, (Object)read.getProjectId().get());
        Assert.assertEquals((Object)NAMESPACE, (Object)read.getNamespace().get());
        Assert.assertEquals((Object)LOCALHOST, (Object)read.getLocalhost());
    }

    @Test
    public void testReadValidationFailsQueryAndGqlQuery() throws Exception {
        DatastoreV1.Read read = DatastoreIO.v1().read().withProjectId(PROJECT_ID).withLiteralGqlQuery(GQL_QUERY).withQuery(QUERY);
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("withQuery() and withLiteralGqlQuery() are exclusive");
        read.expand(null);
    }

    @Test
    public void testReadValidationFailsQueryLimitZero() throws Exception {
        Query invalidLimit = Query.newBuilder().setLimit(Int32Value.newBuilder().setValue(0)).build();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid query limit 0: must be positive");
        DatastoreIO.v1().read().withQuery(invalidLimit);
    }

    @Test
    public void testReadValidationFailsQueryLimitNegative() throws Exception {
        Query invalidLimit = Query.newBuilder().setLimit(Int32Value.newBuilder().setValue(-5)).build();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Invalid query limit -5: must be positive");
        DatastoreIO.v1().read().withQuery(invalidLimit);
    }

    @Test
    public void testReadDisplayData() {
        DatastoreV1.Read read = DatastoreIO.v1().read().withProjectId(PROJECT_ID).withQuery(QUERY).withNamespace(NAMESPACE);
        DisplayData displayData = DisplayData.from((HasDisplayData)read);
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"projectId", (String)PROJECT_ID));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"query", (String)QUERY.toString()));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"namespace", (String)NAMESPACE));
    }

    @Test
    public void testReadDisplayDataWithGqlQuery() {
        DatastoreV1.Read read = DatastoreIO.v1().read().withProjectId(PROJECT_ID).withLiteralGqlQuery(GQL_QUERY).withNamespace(NAMESPACE);
        DisplayData displayData = DisplayData.from((HasDisplayData)read);
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"projectId", (String)PROJECT_ID));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"gqlQuery", (String)GQL_QUERY));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"namespace", (String)NAMESPACE));
    }

    @Test
    public void testSourcePrimitiveDisplayData() {
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        int numSplits = 98;
        DatastoreV1.Read read = DatastoreIO.v1().read().withProjectId(PROJECT_ID).withQuery(Query.newBuilder().build()).withNumQuerySplits(numSplits);
        String assertMessage = "DatastoreIO read should include the '%s' in its primitive display data";
        Set displayData = evaluator.displayDataForPrimitiveSourceTransforms((PTransform)read);
        MatcherAssert.assertThat((String)String.format(assertMessage, "project id"), (Object)displayData, (Matcher)org.hamcrest.Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"projectId", (String)PROJECT_ID)));
        MatcherAssert.assertThat((String)String.format(assertMessage, "number of query splits"), (Object)displayData, (Matcher)org.hamcrest.Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"numQuerySplits", (long)numSplits)));
    }

    @Test
    public void testWriteDisplayData() {
        DatastoreV1.Write write = DatastoreIO.v1().write().withProjectId(PROJECT_ID);
        DisplayData displayData = DisplayData.from((HasDisplayData)write);
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"projectId", (String)PROJECT_ID));
    }

    @Test
    public void testDeleteEntityDisplayData() {
        DatastoreV1.DeleteEntity deleteEntity = DatastoreIO.v1().deleteEntity().withProjectId(PROJECT_ID);
        DisplayData displayData = DisplayData.from((HasDisplayData)deleteEntity);
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"projectId", (String)PROJECT_ID));
    }

    @Test
    public void testDeleteKeyDisplayData() {
        DatastoreV1.DeleteKey deleteKey = DatastoreIO.v1().deleteKey().withProjectId(PROJECT_ID);
        DisplayData displayData = DisplayData.from((HasDisplayData)deleteKey);
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"projectId", (String)PROJECT_ID));
    }

    @Test
    public void testWritePrimitiveDisplayData() {
        int hintNumWorkers = 10;
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        DatastoreV1.Write write = DatastoreIO.v1().write().withProjectId("myProject").withHintNumWorkers(hintNumWorkers);
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)write);
        MatcherAssert.assertThat((String)"DatastoreIO write should include the project in its primitive display data", (Object)displayData, (Matcher)org.hamcrest.Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"projectId")));
        MatcherAssert.assertThat((String)"DatastoreIO write should include the upsertFn in its primitive display data", (Object)displayData, (Matcher)org.hamcrest.Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"upsertFn")));
        MatcherAssert.assertThat((String)"DatastoreIO write should include ramp-up throttling worker count hint if enabled", (Object)displayData, (Matcher)org.hamcrest.Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"hintNumWorkers", (long)hintNumWorkers)));
    }

    @Test
    public void testWritePrimitiveDisplayDataDisabledThrottler() {
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        DatastoreV1.Write write = DatastoreIO.v1().write().withProjectId("myProject").withRampupThrottlingDisabled();
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)write);
        MatcherAssert.assertThat((String)"DatastoreIO write should include the project in its primitive display data", (Object)displayData, (Matcher)org.hamcrest.Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"projectId")));
        MatcherAssert.assertThat((String)"DatastoreIO write should include the upsertFn in its primitive display data", (Object)displayData, (Matcher)org.hamcrest.Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"upsertFn")));
        MatcherAssert.assertThat((String)"DatastoreIO write should include ramp-up throttling worker count hint if enabled", (Object)displayData, (Matcher)org.hamcrest.Matchers.not((Matcher)org.hamcrest.Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"hintNumWorkers"))));
    }

    @Test
    public void testDeleteEntityPrimitiveDisplayData() {
        int hintNumWorkers = 10;
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        DatastoreV1.DeleteEntity write = DatastoreIO.v1().deleteEntity().withProjectId("myProject").withHintNumWorkers(hintNumWorkers);
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)write);
        MatcherAssert.assertThat((String)"DatastoreIO write should include the project in its primitive display data", (Object)displayData, (Matcher)org.hamcrest.Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"projectId")));
        MatcherAssert.assertThat((String)"DatastoreIO write should include the deleteEntityFn in its primitive display data", (Object)displayData, (Matcher)org.hamcrest.Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"deleteEntityFn")));
        MatcherAssert.assertThat((String)"DatastoreIO write should include ramp-up throttling worker count hint if enabled", (Object)displayData, (Matcher)org.hamcrest.Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"hintNumWorkers", (long)hintNumWorkers)));
    }

    @Test
    public void testDeleteKeyPrimitiveDisplayData() {
        int hintNumWorkers = 10;
        DisplayDataEvaluator evaluator = DisplayDataEvaluator.create();
        DatastoreV1.DeleteKey write = DatastoreIO.v1().deleteKey().withProjectId("myProject").withHintNumWorkers(hintNumWorkers);
        Set displayData = evaluator.displayDataForPrimitiveTransforms((PTransform)write);
        MatcherAssert.assertThat((String)"DatastoreIO write should include the project in its primitive display data", (Object)displayData, (Matcher)org.hamcrest.Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"projectId")));
        MatcherAssert.assertThat((String)"DatastoreIO write should include the deleteKeyFn in its primitive display data", (Object)displayData, (Matcher)org.hamcrest.Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"deleteKeyFn")));
        MatcherAssert.assertThat((String)"DatastoreIO write should include ramp-up throttling worker count hint if enabled", (Object)displayData, (Matcher)org.hamcrest.Matchers.hasItem((Matcher)DisplayDataMatchers.hasDisplayItem((String)"hintNumWorkers", (long)hintNumWorkers)));
    }

    @Test
    public void testBuildWrite() throws Exception {
        DatastoreV1.Write write = DatastoreIO.v1().write().withProjectId(PROJECT_ID);
        Assert.assertEquals((Object)PROJECT_ID, (Object)write.getProjectId());
    }

    @Test
    public void testHasNameOrId() {
        Key key = DatastoreHelper.makeKey((Object[])new Object[]{"bird", "finch"}).build();
        Assert.assertTrue((boolean)DatastoreV1.isValidKey((Key)key));
        key = DatastoreHelper.makeKey((Object[])new Object[]{"bird", 123}).build();
        Assert.assertTrue((boolean)DatastoreV1.isValidKey((Key)key));
        key = DatastoreHelper.makeKey((Object[])new Object[]{"bird"}).build();
        Assert.assertFalse((boolean)DatastoreV1.isValidKey((Key)key));
        key = DatastoreHelper.makeKey((Object[])new Object[]{"bird", "owl"}).build();
        key = DatastoreHelper.makeKey((Object[])new Object[]{key, "bird", "horned"}).build();
        Assert.assertTrue((boolean)DatastoreV1.isValidKey((Key)key));
        key = DatastoreHelper.makeKey((Object[])new Object[]{"bird", "owl"}).build();
        key = DatastoreHelper.makeKey((Object[])new Object[]{key, "bird", 123}).build();
        Assert.assertTrue((boolean)DatastoreV1.isValidKey((Key)key));
        key = DatastoreHelper.makeKey((Object[])new Object[]{"bird", "owl"}).build();
        key = DatastoreHelper.makeKey((Object[])new Object[]{key, "bird"}).build();
        Assert.assertFalse((boolean)DatastoreV1.isValidKey((Key)key));
        key = DatastoreHelper.makeKey((Object[])new Object[0]).build();
        Assert.assertFalse((boolean)DatastoreV1.isValidKey((Key)key));
    }

    @Test
    public void testAddEntitiesWithIncompleteKeys() throws Exception {
        Key key = DatastoreHelper.makeKey((Object[])new Object[]{"bird"}).build();
        Entity entity = Entity.newBuilder().setKey(key).build();
        DatastoreV1.UpsertFn upsertFn = new DatastoreV1.UpsertFn();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Entities to be written to the Cloud Datastore must have complete keys");
        upsertFn.apply(entity);
    }

    @Test
    public void testAddEntities() throws Exception {
        Key key = DatastoreHelper.makeKey((Object[])new Object[]{"bird", "finch"}).build();
        Entity entity = Entity.newBuilder().setKey(key).build();
        DatastoreV1.UpsertFn upsertFn = new DatastoreV1.UpsertFn();
        Mutation expectedMutation = DatastoreHelper.makeUpsert((Entity)entity).build();
        Assert.assertEquals((Object)expectedMutation, (Object)upsertFn.apply(entity));
    }

    @Test
    public void testDeleteEntitiesWithIncompleteKeys() throws Exception {
        Key key = DatastoreHelper.makeKey((Object[])new Object[]{"bird"}).build();
        Entity entity = Entity.newBuilder().setKey(key).build();
        DatastoreV1.DeleteEntityFn deleteEntityFn = new DatastoreV1.DeleteEntityFn();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Entities to be deleted from the Cloud Datastore must have complete keys");
        deleteEntityFn.apply(entity);
    }

    @Test
    public void testDeleteEntities() throws Exception {
        Key key = DatastoreHelper.makeKey((Object[])new Object[]{"bird", "finch"}).build();
        Entity entity = Entity.newBuilder().setKey(key).build();
        DatastoreV1.DeleteEntityFn deleteEntityFn = new DatastoreV1.DeleteEntityFn();
        Mutation expectedMutation = DatastoreHelper.makeDelete((Key)entity.getKey()).build();
        Assert.assertEquals((Object)expectedMutation, (Object)deleteEntityFn.apply(entity));
    }

    @Test
    public void testDeleteIncompleteKeys() throws Exception {
        Key key = DatastoreHelper.makeKey((Object[])new Object[]{"bird"}).build();
        DatastoreV1.DeleteKeyFn deleteKeyFn = new DatastoreV1.DeleteKeyFn();
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Keys to be deleted from the Cloud Datastore must be complete");
        deleteKeyFn.apply(key);
    }

    @Test
    public void testDeleteKeys() {
        Key key = DatastoreHelper.makeKey((Object[])new Object[]{"bird", "finch"}).build();
        DatastoreV1.DeleteKeyFn deleteKeyFn = new DatastoreV1.DeleteKeyFn();
        Mutation expectedMutation = DatastoreHelper.makeDelete((Key)key).build();
        Assert.assertEquals((Object)expectedMutation, (Object)deleteKeyFn.apply(key));
    }

    @Test
    public void testDatastoreWriteFnDisplayData() {
        DatastoreV1.DatastoreWriterFn datastoreWriter = new DatastoreV1.DatastoreWriterFn(PROJECT_ID, null);
        DisplayData displayData = DisplayData.from((HasDisplayData)datastoreWriter);
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((String)"projectId", (String)PROJECT_ID));
    }

    @Test
    public void testDatatoreWriterFnWithOneBatch() throws Exception {
        this.datastoreWriterFnTest(100);
        this.verifyMetricWasSet("BatchDatastoreWrite", "ok", "", 2L);
    }

    @Test
    public void testDatatoreWriterFnWithMultipleBatches() throws Exception {
        this.datastoreWriterFnTest(250);
        this.verifyMetricWasSet("BatchDatastoreWrite", "ok", "", 5L);
    }

    @Test
    public void testDatatoreWriterFnWithBatchesExactMultiple() throws Exception {
        this.datastoreWriterFnTest(100);
        this.verifyMetricWasSet("BatchDatastoreWrite", "ok", "", 2L);
    }

    private void datastoreWriterFnTest(int numMutations) throws Exception {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>(numMutations);
        for (int i = 0; i < numMutations; ++i) {
            mutations.add(DatastoreHelper.makeUpsert((Entity)Entity.newBuilder().setKey(DatastoreHelper.makeKey((Object[])new Object[]{"key" + i, i + 1})).build()).build());
        }
        DatastoreV1.DatastoreWriterFn datastoreWriter = new DatastoreV1.DatastoreWriterFn((ValueProvider)ValueProvider.StaticValueProvider.of((Object)PROJECT_ID), null, this.mockDatastoreFactory, (DatastoreV1.WriteBatcher)new FakeWriteBatcher());
        DoFnTester doFnTester = DoFnTester.of((DoFn)datastoreWriter);
        doFnTester.setCloningBehavior(DoFnTester.CloningBehavior.DO_NOT_CLONE);
        doFnTester.processBundle(mutations);
        int start = 0;
        while (start < numMutations) {
            int end = Math.min(numMutations, start + 50);
            CommitRequest.Builder commitRequest = CommitRequest.newBuilder();
            commitRequest.setMode(CommitRequest.Mode.NON_TRANSACTIONAL);
            commitRequest.addAllMutations(mutations.subList(start, end));
            ((Datastore)Mockito.verify((Object)this.mockDatastore, (VerificationMode)Mockito.times((int)1))).commit(commitRequest.build());
            start = end;
        }
    }

    @Test
    public void testDatatoreWriterFnWithLargeEntities() throws Exception {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        int entitySize = 0;
        for (int i = 0; i < 12; ++i) {
            Entity entity = Entity.newBuilder().setKey(DatastoreHelper.makeKey((Object[])new Object[]{"key" + i, i + 1})).putProperties("long", DatastoreHelper.makeValue((String)new String(new char[900000])).setExcludeFromIndexes(true).build()).build();
            entitySize = entity.getSerializedSize();
            mutations.add(DatastoreHelper.makeUpsert((Entity)entity).build());
        }
        DatastoreV1.DatastoreWriterFn datastoreWriter = new DatastoreV1.DatastoreWriterFn((ValueProvider)ValueProvider.StaticValueProvider.of((Object)PROJECT_ID), null, this.mockDatastoreFactory, (DatastoreV1.WriteBatcher)new FakeWriteBatcher());
        DoFnTester doFnTester = DoFnTester.of((DoFn)datastoreWriter);
        doFnTester.setCloningBehavior(DoFnTester.CloningBehavior.DO_NOT_CLONE);
        doFnTester.processBundle(mutations);
        int entitiesPerRpc = 9000000 / entitySize;
        int start = 0;
        while (start < mutations.size()) {
            int end = Math.min(mutations.size(), start + entitiesPerRpc);
            CommitRequest.Builder commitRequest = CommitRequest.newBuilder();
            commitRequest.setMode(CommitRequest.Mode.NON_TRANSACTIONAL);
            commitRequest.addAllMutations(mutations.subList(start, end));
            ((Datastore)Mockito.verify((Object)this.mockDatastore)).commit(commitRequest.build());
            start = end;
        }
    }

    @Test
    public void testDatatoreWriterFnRetriesErrors() throws Exception {
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        int numRpcs = 2;
        for (int i = 0; i < 50 * numRpcs; ++i) {
            mutations.add(DatastoreHelper.makeUpsert((Entity)Entity.newBuilder().setKey(DatastoreHelper.makeKey((Object[])new Object[]{"key" + i, i + 1})).build()).build());
        }
        CommitResponse successfulCommit = CommitResponse.getDefaultInstance();
        Mockito.when((Object)this.mockDatastore.commit((CommitRequest)Matchers.any(CommitRequest.class))).thenReturn((Object)successfulCommit).thenThrow(new Throwable[]{new DatastoreException("commit", Code.DEADLINE_EXCEEDED, "", null)}).thenReturn((Object)successfulCommit);
        DatastoreV1.DatastoreWriterFn datastoreWriter = new DatastoreV1.DatastoreWriterFn((ValueProvider)ValueProvider.StaticValueProvider.of((Object)PROJECT_ID), null, this.mockDatastoreFactory, (DatastoreV1.WriteBatcher)new FakeWriteBatcher());
        DoFnTester doFnTester = DoFnTester.of((DoFn)datastoreWriter);
        doFnTester.setCloningBehavior(DoFnTester.CloningBehavior.DO_NOT_CLONE);
        doFnTester.processBundle(mutations);
        this.verifyMetricWasSet("BatchDatastoreWrite", "ok", "", 2L);
        this.verifyMetricWasSet("BatchDatastoreWrite", "unknown", "", 1L);
    }

    @Test
    public void testEstimatedSizeBytes() throws Exception {
        long entityBytes = 100L;
        long timestamp = 1234L;
        RunQueryRequest latestTimestampRequest = DatastoreV1.Read.makeRequest((Query)DatastoreV1Test.makeLatestTimestampQuery(NAMESPACE), (String)NAMESPACE);
        RunQueryResponse latestTimestampResponse = DatastoreV1Test.makeLatestTimestampResponse(timestamp);
        RunQueryRequest statRequest = DatastoreV1.Read.makeRequest((Query)DatastoreV1Test.makeStatKindQuery(NAMESPACE, timestamp), (String)NAMESPACE);
        RunQueryResponse statResponse = DatastoreV1Test.makeStatKindResponse(entityBytes);
        Mockito.when((Object)this.mockDatastore.runQuery(latestTimestampRequest)).thenReturn((Object)latestTimestampResponse);
        Mockito.when((Object)this.mockDatastore.runQuery(statRequest)).thenReturn((Object)statResponse);
        Assert.assertEquals((long)entityBytes, (long)DatastoreV1.Read.getEstimatedSizeBytes((Datastore)this.mockDatastore, (Query)QUERY, (String)NAMESPACE));
        ((Datastore)Mockito.verify((Object)this.mockDatastore, (VerificationMode)Mockito.times((int)1))).runQuery(latestTimestampRequest);
        ((Datastore)Mockito.verify((Object)this.mockDatastore, (VerificationMode)Mockito.times((int)1))).runQuery(statRequest);
    }

    @Test
    public void testSplitQueryFnWithNumSplits() throws Exception {
        int numSplits = 100;
        Mockito.when((Object)this.mockQuerySplitter.getSplits((Query)Matchers.eq((Object)QUERY), (PartitionId)Matchers.any(PartitionId.class), Matchers.eq((int)numSplits), (Datastore)Matchers.any(Datastore.class))).thenReturn(this.splitQuery(QUERY, numSplits));
        DatastoreV1.Read.SplitQueryFn splitQueryFn = new DatastoreV1.Read.SplitQueryFn(V_1_OPTIONS, numSplits, this.mockDatastoreFactory);
        DoFnTester doFnTester = DoFnTester.of((DoFn)splitQueryFn);
        doFnTester.setCloningBehavior(DoFnTester.CloningBehavior.DO_NOT_CLONE);
        List queries = doFnTester.processBundle((Object[])new Query[]{QUERY});
        Assert.assertEquals((long)queries.size(), (long)numSplits);
        for (Query subQuery : queries) {
            Assert.assertNotEquals((Object)subQuery, (Object)QUERY);
        }
        ((QuerySplitter)Mockito.verify((Object)this.mockQuerySplitter, (VerificationMode)Mockito.times((int)1))).getSplits((Query)Matchers.eq((Object)QUERY), (PartitionId)Matchers.any(PartitionId.class), Matchers.eq((int)numSplits), (Datastore)Matchers.any(Datastore.class));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.mockDatastore});
    }

    @Test
    public void testSplitQueryFnWithoutNumSplits() throws Exception {
        int numSplits = 0;
        int expectedNumSplits = 20;
        long entityBytes = (long)expectedNumSplits * 0x4000000L;
        long timestamp = 1234L;
        RunQueryRequest latestTimestampRequest = DatastoreV1.Read.makeRequest((Query)DatastoreV1Test.makeLatestTimestampQuery(NAMESPACE), (String)NAMESPACE);
        RunQueryResponse latestTimestampResponse = DatastoreV1Test.makeLatestTimestampResponse(timestamp);
        RunQueryRequest statRequest = DatastoreV1.Read.makeRequest((Query)DatastoreV1Test.makeStatKindQuery(NAMESPACE, timestamp), (String)NAMESPACE);
        RunQueryResponse statResponse = DatastoreV1Test.makeStatKindResponse(entityBytes);
        Mockito.when((Object)this.mockDatastore.runQuery(latestTimestampRequest)).thenReturn((Object)latestTimestampResponse);
        Mockito.when((Object)this.mockDatastore.runQuery(statRequest)).thenReturn((Object)statResponse);
        Mockito.when((Object)this.mockQuerySplitter.getSplits((Query)Matchers.eq((Object)QUERY), (PartitionId)Matchers.any(PartitionId.class), Matchers.eq((int)expectedNumSplits), (Datastore)Matchers.any(Datastore.class))).thenReturn(this.splitQuery(QUERY, expectedNumSplits));
        DatastoreV1.Read.SplitQueryFn splitQueryFn = new DatastoreV1.Read.SplitQueryFn(V_1_OPTIONS, numSplits, this.mockDatastoreFactory);
        DoFnTester doFnTester = DoFnTester.of((DoFn)splitQueryFn);
        doFnTester.setCloningBehavior(DoFnTester.CloningBehavior.DO_NOT_CLONE);
        List queries = doFnTester.processBundle((Object[])new Query[]{QUERY});
        Assert.assertEquals((long)expectedNumSplits, (long)queries.size());
        ((QuerySplitter)Mockito.verify((Object)this.mockQuerySplitter, (VerificationMode)Mockito.times((int)1))).getSplits((Query)Matchers.eq((Object)QUERY), (PartitionId)Matchers.any(PartitionId.class), Matchers.eq((int)expectedNumSplits), (Datastore)Matchers.any(Datastore.class));
        ((Datastore)Mockito.verify((Object)this.mockDatastore, (VerificationMode)Mockito.times((int)1))).runQuery(latestTimestampRequest);
        ((Datastore)Mockito.verify((Object)this.mockDatastore, (VerificationMode)Mockito.times((int)1))).runQuery(statRequest);
    }

    @Test
    public void testSplitQueryFnWithQueryLimit() throws Exception {
        Query queryWithLimit = QUERY.toBuilder().setLimit(Int32Value.newBuilder().setValue(1)).build();
        DatastoreV1.Read.SplitQueryFn splitQueryFn = new DatastoreV1.Read.SplitQueryFn(V_1_OPTIONS, 10, this.mockDatastoreFactory);
        DoFnTester doFnTester = DoFnTester.of((DoFn)splitQueryFn);
        doFnTester.setCloningBehavior(DoFnTester.CloningBehavior.DO_NOT_CLONE);
        List queries = doFnTester.processBundle((Object[])new Query[]{queryWithLimit});
        Assert.assertEquals((long)1L, (long)queries.size());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockDatastore});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockQuerySplitter});
    }

    @Test
    public void testReadFnWithOneBatch() throws Exception {
        this.readFnTest(5);
        this.verifyMetricWasSet("BatchDatastoreRead", "ok", NAMESPACE, 1L);
    }

    @Test
    public void testReadFnWithMultipleBatches() throws Exception {
        this.readFnTest(505);
        this.verifyMetricWasSet("BatchDatastoreRead", "ok", NAMESPACE, 2L);
    }

    @Test
    public void testReadFnWithBatchesExactMultiple() throws Exception {
        this.readFnTest(2500);
        this.verifyMetricWasSet("BatchDatastoreRead", "ok", NAMESPACE, 5L);
    }

    @Test
    public void testReadFnRetriesErrors() throws Exception {
        Query query = Query.newBuilder().setLimit(Int32Value.newBuilder().setValue(1)).build();
        Mockito.when((Object)this.mockDatastore.runQuery((RunQueryRequest)Matchers.any(RunQueryRequest.class))).thenThrow(new Throwable[]{new DatastoreException("RunQuery", Code.DEADLINE_EXCEEDED, "", null)}).thenAnswer(invocationOnMock -> {
            Query q = ((RunQueryRequest)invocationOnMock.getArguments()[0]).getQuery();
            return DatastoreV1Test.mockResponseForQuery(q);
        });
        DatastoreV1.Read.ReadFn readFn = new DatastoreV1.Read.ReadFn(V_1_OPTIONS, this.mockDatastoreFactory);
        DoFnTester doFnTester = DoFnTester.of((DoFn)readFn);
        doFnTester.setCloningBehavior(DoFnTester.CloningBehavior.DO_NOT_CLONE);
        doFnTester.processBundle((Object[])new Query[]{query});
        this.verifyMetricWasSet("BatchDatastoreRead", "ok", NAMESPACE, 1L);
        this.verifyMetricWasSet("BatchDatastoreRead", "unknown", NAMESPACE, 1L);
    }

    @Test
    public void testTranslateGqlQueryWithLimit() throws Exception {
        String gql = "SELECT * from DummyKind LIMIT 10";
        String gqlWithZeroLimit = gql + " LIMIT 0";
        GqlQuery gqlQuery = GqlQuery.newBuilder().setQueryString(gql).setAllowLiterals(true).build();
        GqlQuery gqlQueryWithZeroLimit = GqlQuery.newBuilder().setQueryString(gqlWithZeroLimit).setAllowLiterals(true).build();
        RunQueryRequest gqlRequest = DatastoreV1.Read.makeRequest((GqlQuery)gqlQuery, (String)V_1_OPTIONS.getNamespace());
        RunQueryRequest gqlRequestWithZeroLimit = DatastoreV1.Read.makeRequest((GqlQuery)gqlQueryWithZeroLimit, (String)V_1_OPTIONS.getNamespace());
        Mockito.when((Object)this.mockDatastore.runQuery(gqlRequestWithZeroLimit)).thenThrow(new Throwable[]{new DatastoreException("runQuery", Code.INVALID_ARGUMENT, "invalid query", (Throwable)new RuntimeException())});
        Mockito.when((Object)this.mockDatastore.runQuery(gqlRequest)).thenReturn((Object)RunQueryResponse.newBuilder().setQuery(QUERY).build());
        Assert.assertEquals((Object)DatastoreV1.Read.translateGqlQueryWithLimitCheck((String)gql, (Datastore)this.mockDatastore, (String)V_1_OPTIONS.getNamespace()), (Object)QUERY);
        ((Datastore)Mockito.verify((Object)this.mockDatastore, (VerificationMode)Mockito.times((int)1))).runQuery(gqlRequest);
        ((Datastore)Mockito.verify((Object)this.mockDatastore, (VerificationMode)Mockito.times((int)1))).runQuery(gqlRequestWithZeroLimit);
    }

    @Test
    public void testTranslateGqlQueryWithNoLimit() throws Exception {
        String gql = "SELECT * from DummyKind";
        String gqlWithZeroLimit = gql + " LIMIT 0";
        GqlQuery gqlQueryWithZeroLimit = GqlQuery.newBuilder().setQueryString(gqlWithZeroLimit).setAllowLiterals(true).build();
        RunQueryRequest gqlRequestWithZeroLimit = DatastoreV1.Read.makeRequest((GqlQuery)gqlQueryWithZeroLimit, (String)V_1_OPTIONS.getNamespace());
        Mockito.when((Object)this.mockDatastore.runQuery(gqlRequestWithZeroLimit)).thenReturn((Object)RunQueryResponse.newBuilder().setQuery(QUERY).build());
        Assert.assertEquals((Object)DatastoreV1.Read.translateGqlQueryWithLimitCheck((String)gql, (Datastore)this.mockDatastore, (String)V_1_OPTIONS.getNamespace()), (Object)QUERY);
        ((Datastore)Mockito.verify((Object)this.mockDatastore, (VerificationMode)Mockito.times((int)1))).runQuery(gqlRequestWithZeroLimit);
    }

    @Test
    public void testTranslateGqlQueryWithException() throws Exception {
        String gql = "SELECT * from DummyKind";
        String gqlWithZeroLimit = gql + " LIMIT 0";
        GqlQuery gqlQueryWithZeroLimit = GqlQuery.newBuilder().setQueryString(gqlWithZeroLimit).setAllowLiterals(true).build();
        RunQueryRequest gqlRequestWithZeroLimit = DatastoreV1.Read.makeRequest((GqlQuery)gqlQueryWithZeroLimit, (String)V_1_OPTIONS.getNamespace());
        Mockito.when((Object)this.mockDatastore.runQuery(gqlRequestWithZeroLimit)).thenThrow(new Throwable[]{new RuntimeException("TestException")});
        this.thrown.expect(RuntimeException.class);
        this.thrown.expectMessage("TestException");
        DatastoreV1.Read.translateGqlQueryWithLimitCheck((String)gql, (Datastore)this.mockDatastore, (String)V_1_OPTIONS.getNamespace());
    }

    @Test
    public void testRuntimeOptionsNotCalledInApplyQuery() {
        RuntimeTestOptions options = (RuntimeTestOptions)PipelineOptionsFactory.as(RuntimeTestOptions.class);
        Pipeline pipeline = TestPipeline.create((PipelineOptions)options);
        ((PCollection)pipeline.apply((PTransform)DatastoreIO.v1().read().withProjectId(options.getDatastoreProject()).withQuery(QUERY).withNamespace(options.getNamespace()))).apply((PTransform)DatastoreIO.v1().write().withProjectId(options.getDatastoreProject()));
    }

    @Test
    public void testRuntimeOptionsNotCalledInApplyGqlQuery() {
        RuntimeTestOptions options = (RuntimeTestOptions)PipelineOptionsFactory.as(RuntimeTestOptions.class);
        Pipeline pipeline = TestPipeline.create((PipelineOptions)options);
        ((PCollection)pipeline.apply((PTransform)DatastoreIO.v1().read().withProjectId(options.getDatastoreProject()).withLiteralGqlQuery(options.getGqlQuery()))).apply((PTransform)DatastoreIO.v1().write().withProjectId(options.getDatastoreProject()));
    }

    @Test
    public void testWriteBatcherWithoutData() {
        DatastoreV1.WriteBatcherImpl writeBatcher = new DatastoreV1.WriteBatcherImpl();
        writeBatcher.start();
        Assert.assertEquals((long)50L, (long)writeBatcher.nextBatchSize(0L));
    }

    @Test
    public void testWriteBatcherFastQueries() {
        DatastoreV1.WriteBatcherImpl writeBatcher = new DatastoreV1.WriteBatcherImpl();
        writeBatcher.start();
        writeBatcher.addRequestLatency(0L, 1000L, 200);
        writeBatcher.addRequestLatency(0L, 1000L, 200);
        Assert.assertEquals((long)500L, (long)writeBatcher.nextBatchSize(0L));
    }

    @Test
    public void testWriteBatcherSlowQueries() {
        DatastoreV1.WriteBatcherImpl writeBatcher = new DatastoreV1.WriteBatcherImpl();
        writeBatcher.start();
        writeBatcher.addRequestLatency(0L, 10000L, 200);
        writeBatcher.addRequestLatency(0L, 10000L, 200);
        Assert.assertEquals((long)120L, (long)writeBatcher.nextBatchSize(0L));
    }

    @Test
    public void testWriteBatcherSizeNotBelowMinimum() {
        DatastoreV1.WriteBatcherImpl writeBatcher = new DatastoreV1.WriteBatcherImpl();
        writeBatcher.start();
        writeBatcher.addRequestLatency(0L, 75000L, 50);
        writeBatcher.addRequestLatency(0L, 75000L, 50);
        Assert.assertEquals((long)5L, (long)writeBatcher.nextBatchSize(0L));
    }

    @Test
    public void testWriteBatcherSlidingWindow() {
        DatastoreV1.WriteBatcherImpl writeBatcher = new DatastoreV1.WriteBatcherImpl();
        writeBatcher.start();
        writeBatcher.addRequestLatency(0L, 30000L, 50);
        writeBatcher.addRequestLatency(50000L, 8000L, 200);
        writeBatcher.addRequestLatency(100000L, 8000L, 200);
        Assert.assertEquals((long)150L, (long)writeBatcher.nextBatchSize(150000L));
    }

    private static RunQueryResponse mockResponseForQuery(Query q) {
        Assert.assertTrue((boolean)q.hasLimit());
        int limit = q.getLimit().getValue();
        MatcherAssert.assertThat((Object)limit, (Matcher)org.hamcrest.Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
        MatcherAssert.assertThat((Object)limit, (Matcher)org.hamcrest.Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(500)));
        ArrayList<EntityResult> entities = new ArrayList<EntityResult>(limit);
        for (int i = 0; i < limit; ++i) {
            entities.add(EntityResult.newBuilder().setEntity(Entity.newBuilder().setKey(DatastoreHelper.makeKey((Object[])new Object[]{"key" + i, i + 1}))).build());
        }
        RunQueryResponse.Builder ret = RunQueryResponse.newBuilder();
        ret.getBatchBuilder().addAllEntityResults(entities).setEntityResultType(EntityResult.ResultType.FULL).setMoreResults(limit == 500 ? QueryResultBatch.MoreResultsType.NOT_FINISHED : QueryResultBatch.MoreResultsType.NO_MORE_RESULTS);
        return ret.build();
    }

    private void readFnTest(int numEntities) throws Exception {
        Query query = Query.newBuilder().setLimit(Int32Value.newBuilder().setValue(numEntities)).build();
        Mockito.when((Object)this.mockDatastore.runQuery((RunQueryRequest)Matchers.any(RunQueryRequest.class))).thenAnswer(invocationOnMock -> {
            Query q = ((RunQueryRequest)invocationOnMock.getArguments()[0]).getQuery();
            return DatastoreV1Test.mockResponseForQuery(q);
        });
        DatastoreV1.Read.ReadFn readFn = new DatastoreV1.Read.ReadFn(V_1_OPTIONS, this.mockDatastoreFactory);
        DoFnTester doFnTester = DoFnTester.of((DoFn)readFn);
        doFnTester.setCloningBehavior(DoFnTester.CloningBehavior.DO_NOT_CLONE);
        List entities = doFnTester.processBundle((Object[])new Query[]{query});
        int expectedNumCallsToRunQuery = (int)Math.ceil((double)numEntities / 500.0);
        ((Datastore)Mockito.verify((Object)this.mockDatastore, (VerificationMode)Mockito.times((int)expectedNumCallsToRunQuery))).runQuery((RunQueryRequest)Matchers.any(RunQueryRequest.class));
        Assert.assertEquals((long)numEntities, (long)entities.size());
    }

    private static RunQueryResponse makeStatKindResponse(long entitySizeInBytes) {
        RunQueryResponse.Builder statKindResponse = RunQueryResponse.newBuilder();
        Entity.Builder entity = Entity.newBuilder();
        entity.setKey(DatastoreHelper.makeKey((Object[])new Object[]{"dummyKind", "dummyId"}));
        entity.putProperties("entity_bytes", DatastoreHelper.makeValue((long)entitySizeInBytes).build());
        EntityResult.Builder entityResult = EntityResult.newBuilder();
        entityResult.setEntity(entity);
        QueryResultBatch.Builder batch = QueryResultBatch.newBuilder();
        batch.addEntityResults(entityResult);
        statKindResponse.setBatch(batch);
        return statKindResponse.build();
    }

    private static RunQueryResponse makeLatestTimestampResponse(long timestamp) {
        RunQueryResponse.Builder timestampResponse = RunQueryResponse.newBuilder();
        Entity.Builder entity = Entity.newBuilder();
        entity.setKey(DatastoreHelper.makeKey((Object[])new Object[]{"dummyKind", "dummyId"}));
        entity.putProperties("timestamp", DatastoreHelper.makeValue((Date)new Date(timestamp * 1000L)).build());
        EntityResult.Builder entityResult = EntityResult.newBuilder();
        entityResult.setEntity(entity);
        QueryResultBatch.Builder batch = QueryResultBatch.newBuilder();
        batch.addEntityResults(entityResult);
        timestampResponse.setBatch(batch);
        return timestampResponse.build();
    }

    private static Query makeStatKindQuery(String namespace, long timestamp) {
        Query.Builder statQuery = Query.newBuilder();
        if (namespace == null) {
            statQuery.addKindBuilder().setName("__Stat_Kind__");
        } else {
            statQuery.addKindBuilder().setName("__Stat_Ns_Kind__");
        }
        statQuery.setFilter(DatastoreHelper.makeAndFilter((Filter[])new Filter[]{DatastoreHelper.makeFilter((String)"kind_name", (PropertyFilter.Operator)PropertyFilter.Operator.EQUAL, (Value)DatastoreHelper.makeValue((String)KIND).build()).build(), DatastoreHelper.makeFilter((String)"timestamp", (PropertyFilter.Operator)PropertyFilter.Operator.EQUAL, (Value)DatastoreHelper.makeValue((long)(timestamp * 1000000L)).build()).build()}));
        return statQuery.build();
    }

    private static Query makeLatestTimestampQuery(String namespace) {
        Query.Builder timestampQuery = Query.newBuilder();
        if (namespace == null) {
            timestampQuery.addKindBuilder().setName("__Stat_Total__");
        } else {
            timestampQuery.addKindBuilder().setName("__Stat_Ns_Total__");
        }
        timestampQuery.addOrder(DatastoreHelper.makeOrder((String)"timestamp", (PropertyOrder.Direction)PropertyOrder.Direction.DESCENDING));
        timestampQuery.setLimit(Int32Value.newBuilder().setValue(1));
        return timestampQuery.build();
    }

    private List<Query> splitQuery(Query query, int numSplits) {
        ArrayList<Query> queries = new ArrayList<Query>();
        int offsetOfOriginal = query.getOffset();
        for (int i = 0; i < numSplits; ++i) {
            Query.Builder q = Query.newBuilder();
            q.addKindBuilder().setName(KIND);
            q.setOffset(++offsetOfOriginal);
            queries.add(q.build());
        }
        return queries;
    }

    private void verifyMetricWasSet(String method, String status, String namespace, long count) {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("PTRANSFORM", "");
        labels.put("SERVICE", "Datastore");
        labels.put("METHOD", method);
        labels.put("RESOURCE", "//bigtable.googleapis.com/projects/testProject/namespaces/" + namespace);
        labels.put("DATASTORE_PROJECT", PROJECT_ID);
        labels.put("DATASTORE_NAMESPACE", namespace);
        labels.put("STATUS", status);
        MonitoringInfoMetricName name = MonitoringInfoMetricName.named((String)MonitoringInfoConstants.Urns.API_REQUEST_COUNT, labels);
        MetricsContainerImpl container = (MetricsContainerImpl)MetricsEnvironment.getProcessWideContainer();
        Assert.assertEquals((long)count, (long)container.getCounter((MetricName)name).getCumulative());
    }

    static {
        Query.Builder q = Query.newBuilder();
        q.addKindBuilder().setName(KIND);
        QUERY = q.build();
        V_1_OPTIONS = DatastoreV1.Read.V1Options.from((String)PROJECT_ID, (String)NAMESPACE, null);
    }

    static class FakeWriteBatcher
    implements DatastoreV1.WriteBatcher {
        FakeWriteBatcher() {
        }

        public void start() {
        }

        public void addRequestLatency(long timeSinceEpochMillis, long latencyMillis, int numMutations) {
        }

        public int nextBatchSize(long timeSinceEpochMillis) {
            return 50;
        }
    }

    public static interface RuntimeTestOptions
    extends PipelineOptions {
        public ValueProvider<String> getDatastoreProject();

        public void setDatastoreProject(ValueProvider<String> var1);

        public ValueProvider<String> getGqlQuery();

        public void setGqlQuery(ValueProvider<String> var1);

        public ValueProvider<String> getNamespace();

        public void setNamespace(ValueProvider<String> var1);
    }
}

