/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.Cell;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.io.gcp.bigtable.CellValueParser;
import org.apache.beam.sdk.schemas.Schema;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.junit.Assert;
import org.junit.Test;

public class CellValueParserTest {
    private static final CellValueParser PARSER = new CellValueParser();

    @Test
    public void shouldParseBooleanTypeFalse() {
        byte[] value = new byte[]{0};
        Assert.assertEquals((Object)false, (Object)PARSER.getCellValue(this.cell(value), Schema.FieldType.BOOLEAN));
    }

    @Test
    public void shouldParseBooleanTypeTrueNotOne() {
        byte[] value = new byte[]{1};
        Assert.assertEquals((Object)true, (Object)PARSER.getCellValue(this.cell(value), Schema.FieldType.BOOLEAN));
    }

    @Test
    public void shouldParseBooleanTypeTrueOne() {
        byte[] value = new byte[]{4};
        Assert.assertEquals((Object)true, (Object)PARSER.getCellValue(this.cell(value), Schema.FieldType.BOOLEAN));
    }

    @Test
    public void shouldFailParseBooleanTypeTooLong() {
        byte[] value = new byte[10];
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> PARSER.getCellValue(this.cell(value), Schema.FieldType.BOOLEAN));
        this.checkMessage(exception.getMessage(), "Boolean has to be 1-byte long bytearray");
    }

    @Test
    public void shouldParseByteType() {
        byte[] value = new byte[]{2};
        Assert.assertEquals((Object)2, (Object)PARSER.getCellValue(this.cell(value), Schema.FieldType.BYTE));
    }

    @Test
    public void shouldFailTooLongByteValue() {
        byte[] value = new byte[3];
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> PARSER.getCellValue(this.cell(value), Schema.FieldType.BYTE));
        this.checkMessage(exception.getMessage(), "Byte has to be 1-byte long bytearray");
    }

    @Test
    public void shouldParseInt16Type() {
        byte[] value = new byte[]{2, 0};
        Assert.assertEquals((Object)512, (Object)PARSER.getCellValue(this.cell(value), Schema.FieldType.INT16));
    }

    @Test
    public void shouldFailParseInt16TypeTooLong() {
        byte[] value = new byte[6];
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> PARSER.getCellValue(this.cell(value), Schema.FieldType.INT16));
        this.checkMessage(exception.getMessage(), "Int16 has to be 2-bytes long bytearray");
    }

    @Test
    public void shouldParseInt32Type() {
        byte[] value = new byte[]{0, 2, 0, 0};
        Assert.assertEquals((Object)131072, (Object)PARSER.getCellValue(this.cell(value), Schema.FieldType.INT32));
    }

    @Test
    public void shouldFailParseInt32TypeTooLong() {
        byte[] value = new byte[6];
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> PARSER.getCellValue(this.cell(value), Schema.FieldType.INT32));
        this.checkMessage(exception.getMessage(), "Int32 has to be 4-bytes long bytearray");
    }

    @Test
    public void shouldParseInt64Type() {
        byte[] value = new byte[]{0, 0, 0, 0, 0, 2, 0, 0};
        Assert.assertEquals((Object)131072L, (Object)PARSER.getCellValue(this.cell(value), Schema.FieldType.INT64));
    }

    @Test
    public void shouldFailParseInt64TypeTooLong() {
        byte[] value = new byte[10];
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> PARSER.getCellValue(this.cell(value), Schema.FieldType.INT64));
        this.checkMessage(exception.getMessage(), "Int64 has to be 8-bytes long bytearray");
    }

    @Test
    public void shouldParseFloatType() {
        byte[] value = new byte[]{64, 0, 0, 0};
        Assert.assertEquals((double)2.0, (double)((Float)PARSER.getCellValue(this.cell(value), Schema.FieldType.FLOAT)).floatValue(), (double)0.001);
    }

    @Test
    public void shouldFailParseFloatTypeTooLong() {
        byte[] value = new byte[10];
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> PARSER.getCellValue(this.cell(value), Schema.FieldType.FLOAT));
        this.checkMessage(exception.getMessage(), "Float has to be 4-bytes long bytearray");
    }

    @Test
    public void shouldParseDoubleType() {
        byte[] value = new byte[]{64, 21, 51, 51, 51, 51, 51, 51};
        Assert.assertEquals((double)5.3, (double)((Double)PARSER.getCellValue(this.cell(value), Schema.FieldType.DOUBLE)), (double)0.001);
    }

    @Test
    public void shouldFailParseDoubleTypeTooLong() {
        byte[] value = new byte[10];
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> PARSER.getCellValue(this.cell(value), Schema.FieldType.DOUBLE));
        this.checkMessage(exception.getMessage(), "Double has to be 8-bytes long bytearray");
    }

    @Test
    public void shouldParseStringType() {
        byte[] value = "stringValue".getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((Object)"stringValue", (Object)PARSER.getCellValue(this.cell(value), Schema.FieldType.STRING));
    }

    @Test
    public void shouldParseDateType() {
        byte[] value = "2019-04-06".getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((Object)DateTime.parse((String)"2019-04-06"), (Object)PARSER.getCellValue(this.cell(value), Schema.FieldType.DATETIME));
    }

    @Test
    public void shouldParseDatetimeType() {
        byte[] value = "2010-06-30T01:20".getBytes(StandardCharsets.UTF_8);
        Assert.assertEquals((Object)new DateTime(2010, 6, 30, 1, 20), (Object)PARSER.getCellValue(this.cell(value), Schema.FieldType.DATETIME));
    }

    @Test
    public void shouldParseBytesType() {
        byte[] value = new byte[]{1, 2, 3, 4, 5};
        Assert.assertEquals((Object)ByteString.copyFrom((byte[])value), (Object)ByteString.copyFrom((byte[])((byte[])PARSER.getCellValue(this.cell(value), Schema.FieldType.BYTES))));
    }

    @Test
    public void shouldFailOnUnsupportedType() {
        byte[] value = new byte[]{};
        IllegalArgumentException exception = (IllegalArgumentException)Assert.assertThrows(IllegalArgumentException.class, () -> PARSER.getCellValue(this.cell(value), Schema.FieldType.of((Schema.TypeName)Schema.TypeName.MAP)));
        this.checkMessage(exception.getMessage(), "Unsupported cell value type 'MAP'.");
    }

    @Test
    public void shouldEncodeBooleanTrue() {
        ByteString expected = this.byteString(new byte[]{1});
        ByteString actual = PARSER.valueToByteString((Object)true, Schema.FieldType.BOOLEAN);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldEncodeBooleanFalse() {
        ByteString expected = this.byteString(new byte[]{0});
        ByteString actual = PARSER.valueToByteString((Object)false, Schema.FieldType.BOOLEAN);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldEncodeLong() {
        ByteString expected = this.byteString(new byte[]{0, 0, 0, 0, 0, 0, 0, 22});
        ByteString actual = PARSER.valueToByteString((Object)22L, Schema.FieldType.INT64);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldEncodeInt() {
        ByteString expected = this.byteString(new byte[]{0, 0, 0, 15});
        ByteString actual = PARSER.valueToByteString((Object)15, Schema.FieldType.INT32);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldEncodeShort() {
        ByteString expected = this.byteString(new byte[]{0, 5});
        ByteString actual = PARSER.valueToByteString((Object)5, Schema.FieldType.INT16);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldEncodeByte() {
        ByteString expected = this.byteString(new byte[]{5});
        ByteString actual = PARSER.valueToByteString((Object)5, Schema.FieldType.BYTE);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldEncodeDouble() {
        ByteString expected = this.byteString(new byte[]{64, 21, 51, 51, 51, 51, 51, 51});
        ByteString actual = PARSER.valueToByteString((Object)5.3, Schema.FieldType.DOUBLE);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldEncodeFloat() {
        ByteString expected = this.byteString(new byte[]{64, 0, 0, 0});
        ByteString actual = PARSER.valueToByteString((Object)Float.valueOf(2.0f), Schema.FieldType.FLOAT);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldEncodeUtf8String() {
        ByteString expected = this.byteString(new byte[]{98, 101, 97, 109});
        ByteString actual = PARSER.valueToByteString((Object)"beam", Schema.FieldType.STRING);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldEncodeByteArray() {
        ByteString expected = this.byteString(new byte[]{0, 2, 1});
        ByteString actual = PARSER.valueToByteString((Object)new byte[]{0, 2, 1}, Schema.FieldType.BYTES);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void shouldEncodeDateTime() {
        ByteString expected = this.byteString("2020-12-06T00:00:00.000Z".getBytes(StandardCharsets.UTF_8));
        ByteString actual = PARSER.valueToByteString((Object)new DateTime(2020, 12, 6, 0, 0, 0, DateTimeZone.UTC), Schema.FieldType.DATETIME);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    private ByteString byteString(byte[] bytes) {
        return ByteString.copyFrom((byte[])bytes);
    }

    private Cell cell(byte[] value) {
        return Cell.newBuilder().setValue(ByteString.copyFrom((byte[])value)).build();
    }

    private void checkMessage(@Nullable String message, String substring) {
        if (message != null) {
            MatcherAssert.assertThat((Object)message, (Matcher)Matchers.containsString((String)substring));
        } else {
            Assert.fail();
        }
    }
}

