/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.Row;
import com.google.bigtable.v2.RowFilter;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.cloud.bigtable.grpc.BigtableInstanceName;
import com.google.cloud.bigtable.grpc.BigtableSession;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.cloud.bigtable.grpc.async.BulkMutation;
import com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.cloud.bigtable.grpc.scanner.FlatRowConverter;
import com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.cloud.bigtable.grpc.scanner.ScanHandler;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.runners.core.metrics.GcpResourceIdentifiers;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.runners.core.metrics.ServiceCallMetric;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableServiceImpl;
import org.apache.beam.sdk.io.range.ByteKey;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class BigtableServiceImplTest {
    private static final String PROJECT_ID = "project";
    private static final String INSTANCE_ID = "instance";
    private static final String TABLE_ID = "table";
    private static final int SEGMENT_SIZE = 10;
    private static final long DEFAULT_ROW_SIZE = 0x1900000L;
    private static final long DEFAULT_BYTE_SEGMENT_SIZE = 1048576000L;
    private static final String DEFAULT_PREFIX = "b";
    private static final BigtableTableName TABLE_NAME = new BigtableInstanceName("project", "instance").toTableName("table");
    @Mock
    private BigtableSession mockSession;
    @Mock
    private BulkMutation mockBulkMutation;
    @Mock
    private BigtableDataClient mockBigtableDataClient;
    @Mock
    private BigtableIO.BigtableSource mockBigtableSource;
    @Mock
    private ScanHandler scanHandler;
    @Mock
    private ServiceCallMetric mockCallMetric;
    @Captor
    private ArgumentCaptor<ReadRowsRequest> requestCaptor;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        BigtableOptions options = new BigtableOptions.Builder().setProjectId(PROJECT_ID).setInstanceId(INSTANCE_ID).build();
        Mockito.when((Object)this.mockSession.getOptions()).thenReturn((Object)options);
        Mockito.when((Object)this.mockSession.createBulkMutation((BigtableTableName)Matchers.eq((Object)TABLE_NAME))).thenReturn((Object)this.mockBulkMutation);
        Mockito.when((Object)this.mockSession.getDataClient()).thenReturn((Object)this.mockBigtableDataClient);
        MetricsContainerImpl container = new MetricsContainerImpl(null);
        MetricsEnvironment.setProcessWideContainer((MetricsContainer)container);
    }

    @Test
    public void testRead() throws IOException {
        ByteKey start = ByteKey.copyFrom((byte[])"a".getBytes(StandardCharsets.UTF_8));
        ByteKey end = ByteKey.copyFrom((byte[])DEFAULT_PREFIX.getBytes(StandardCharsets.UTF_8));
        Mockito.when((Object)this.mockBigtableSource.getRanges()).thenReturn(Arrays.asList(ByteKeyRange.of((ByteKey)start, (ByteKey)end)));
        Mockito.when((Object)this.mockBigtableSource.getTableId()).thenReturn((Object)ValueProvider.StaticValueProvider.of((Object)TABLE_ID));
        ResultScanner mockResultScanner = (ResultScanner)Mockito.mock(ResultScanner.class);
        Row expectedRow = Row.newBuilder().setKey(ByteString.copyFromUtf8((String)"a")).build();
        Mockito.when((Object)((Row)mockResultScanner.next())).thenReturn((Object)expectedRow).thenReturn(null);
        Mockito.when((Object)this.mockBigtableDataClient.readRows((ReadRowsRequest)Matchers.any(ReadRowsRequest.class))).thenReturn((Object)mockResultScanner);
        BigtableServiceImpl.BigtableReaderImpl underTest = new BigtableServiceImpl.BigtableReaderImpl(this.mockSession, this.mockBigtableSource);
        underTest.start();
        Assert.assertEquals((Object)expectedRow, (Object)underTest.getCurrentRow());
        Assert.assertFalse((boolean)underTest.advance());
        underTest.close();
        ((ResultScanner)Mockito.verify((Object)mockResultScanner, (VerificationMode)Mockito.times((int)1))).close();
        this.verifyMetricWasSet("google.bigtable.v2.ReadRows", "ok", 1L);
    }

    @Test
    public void testReadSingleRangeBelowSegmentLimit() throws Exception {
        RowSet.Builder ranges = RowSet.newBuilder();
        ranges.addRowRanges(BigtableServiceImplTest.generateRowRange(BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 0), BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 1)));
        FlatRow expectedRow = FlatRow.newBuilder().withRowKey(ByteString.copyFromUtf8((String)"a")).build();
        Mockito.when((Object)this.mockBigtableDataClient.readFlatRows((ReadRowsRequest)Matchers.any(ReadRowsRequest.class), (StreamObserver)Matchers.any())).thenAnswer(this.mockReadRowsAnswer(Arrays.asList(expectedRow)));
        BigtableServiceImpl.BigtableSegmentReaderImpl underTest = new BigtableServiceImpl.BigtableSegmentReaderImpl(this.mockSession, TABLE_ID, ranges.build(), 10, 1048576000L, RowFilter.getDefaultInstance(), this.mockCallMetric);
        underTest.start();
        Assert.assertEquals((Object)FlatRowConverter.convert((FlatRow)expectedRow), (Object)underTest.getCurrentRow());
        Assert.assertFalse((boolean)underTest.advance());
        underTest.close();
        ((ServiceCallMetric)Mockito.verify((Object)this.mockCallMetric, (VerificationMode)Mockito.times((int)2))).call("ok");
    }

    @Test
    public void testReadSingleRangeAboveSegmentLimit() throws IOException {
        RowSet.Builder ranges = RowSet.newBuilder();
        ranges.addRowRanges(BigtableServiceImplTest.generateRowRange(BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 0), BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 20)));
        OngoingStubbing stub = Mockito.when((Object)this.mockBigtableDataClient.readFlatRows((ReadRowsRequest)Matchers.any(ReadRowsRequest.class), (StreamObserver)Matchers.any()));
        ImmutableList expectedResults = ImmutableList.of(BigtableServiceImplTest.generateSegmentResult(DEFAULT_PREFIX, 0, 10), BigtableServiceImplTest.generateSegmentResult(DEFAULT_PREFIX, 10, 10), (Object)ImmutableList.of());
        this.expectRowResults(stub, (List<List<FlatRow>>)expectedResults);
        BigtableServiceImpl.BigtableSegmentReaderImpl underTest = new BigtableServiceImpl.BigtableSegmentReaderImpl(this.mockSession, TABLE_ID, ranges.build(), 10, 1048576000L, RowFilter.getDefaultInstance(), this.mockCallMetric);
        ArrayList<Row> actualResults = new ArrayList<Row>();
        Assert.assertTrue((boolean)underTest.start());
        do {
            actualResults.add(underTest.getCurrentRow());
        } while (underTest.advance());
        Assert.assertEquals(expectedResults.stream().flatMap(Collection::stream).map(i -> FlatRowConverter.convert((FlatRow)i)).collect(Collectors.toList()), actualResults);
        underTest.close();
        ((ServiceCallMetric)Mockito.verify((Object)this.mockCallMetric, (VerificationMode)Mockito.times((int)3))).call("ok");
    }

    @Test
    public void testReadMultipleRanges() throws IOException {
        RowSet.Builder ranges = RowSet.newBuilder();
        ranges.addRowRanges(BigtableServiceImplTest.generateRowRange(BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 0), BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 10)));
        ranges.addRowRanges(BigtableServiceImplTest.generateRowRange(BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 10), BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 20)));
        OngoingStubbing stub = Mockito.when((Object)this.mockBigtableDataClient.readFlatRows((ReadRowsRequest)Matchers.any(ReadRowsRequest.class), (StreamObserver)Matchers.any()));
        ImmutableList expectedResults = ImmutableList.of(BigtableServiceImplTest.generateSegmentResult(DEFAULT_PREFIX, 0, 10), BigtableServiceImplTest.generateSegmentResult(DEFAULT_PREFIX, 10, 10), (Object)ImmutableList.of());
        this.expectRowResults(stub, (List<List<FlatRow>>)expectedResults);
        BigtableServiceImpl.BigtableSegmentReaderImpl underTest = new BigtableServiceImpl.BigtableSegmentReaderImpl(this.mockSession, TABLE_ID, ranges.build(), 10, 1048576000L, RowFilter.getDefaultInstance(), this.mockCallMetric);
        ArrayList<Row> actualResults = new ArrayList<Row>();
        Assert.assertTrue((boolean)underTest.start());
        do {
            actualResults.add(underTest.getCurrentRow());
        } while (underTest.advance());
        Assert.assertEquals(expectedResults.stream().flatMap(Collection::stream).map(i -> FlatRowConverter.convert((FlatRow)i)).collect(Collectors.toList()), actualResults);
        underTest.close();
        ((ServiceCallMetric)Mockito.verify((Object)this.mockCallMetric, (VerificationMode)Mockito.times((int)3))).call("ok");
    }

    @Test
    public void testReadMultipleRangesOverlappingKeys() throws IOException {
        RowSet.Builder ranges = RowSet.newBuilder();
        ranges.addRowRanges(BigtableServiceImplTest.generateRowRange(BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 0), BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 10)));
        ranges.addRowRanges(BigtableServiceImplTest.generateRowRange(BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 5), BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 20)));
        ranges.addRowRanges(BigtableServiceImplTest.generateRowRange(BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 7), BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 20)));
        OngoingStubbing stub = Mockito.when((Object)this.mockBigtableDataClient.readFlatRows((ReadRowsRequest)Matchers.any(ReadRowsRequest.class), (StreamObserver)Matchers.any()));
        ImmutableList expectedResults = ImmutableList.of(BigtableServiceImplTest.generateSegmentResult(DEFAULT_PREFIX, 0, 10), BigtableServiceImplTest.generateSegmentResult(DEFAULT_PREFIX, 10, 10), (Object)ImmutableList.of());
        this.expectRowResults(stub, (List<List<FlatRow>>)expectedResults);
        BigtableServiceImpl.BigtableSegmentReaderImpl underTest = new BigtableServiceImpl.BigtableSegmentReaderImpl(this.mockSession, TABLE_ID, ranges.build(), 10, 1048576000L, RowFilter.getDefaultInstance(), this.mockCallMetric);
        ArrayList<Row> actualResults = new ArrayList<Row>();
        Assert.assertTrue((boolean)underTest.start());
        do {
            actualResults.add(underTest.getCurrentRow());
        } while (underTest.advance());
        Assert.assertEquals(expectedResults.stream().flatMap(Collection::stream).map(i -> FlatRowConverter.convert((FlatRow)i)).collect(Collectors.toList()), actualResults);
        underTest.close();
        ((ServiceCallMetric)Mockito.verify((Object)this.mockCallMetric, (VerificationMode)Mockito.times((int)3))).call("ok");
    }

    @Test
    public void testReadFullTableScan() throws IOException {
        OngoingStubbing stub = Mockito.when((Object)this.mockBigtableDataClient.readFlatRows((ReadRowsRequest)Matchers.any(ReadRowsRequest.class), (StreamObserver)Matchers.any()));
        ImmutableList expectedResults = ImmutableList.of(BigtableServiceImplTest.generateSegmentResult(DEFAULT_PREFIX, 0, 10), BigtableServiceImplTest.generateSegmentResult(DEFAULT_PREFIX, 10, 10), BigtableServiceImplTest.generateSegmentResult(DEFAULT_PREFIX, 20, 10), (Object)ImmutableList.of());
        this.expectRowResults(stub, (List<List<FlatRow>>)expectedResults);
        BigtableServiceImpl.BigtableSegmentReaderImpl underTest = new BigtableServiceImpl.BigtableSegmentReaderImpl(this.mockSession, TABLE_ID, RowSet.getDefaultInstance(), 10, 1048576000L, RowFilter.getDefaultInstance(), this.mockCallMetric);
        ArrayList<Row> actualResults = new ArrayList<Row>();
        Assert.assertTrue((boolean)underTest.start());
        do {
            actualResults.add(underTest.getCurrentRow());
        } while (underTest.advance());
        Assert.assertEquals(expectedResults.stream().flatMap(Collection::stream).map(i -> FlatRowConverter.convert((FlatRow)i)).collect(Collectors.toList()), actualResults);
        underTest.close();
        ((ServiceCallMetric)Mockito.verify((Object)this.mockCallMetric, (VerificationMode)Mockito.times((int)4))).call("ok");
    }

    @Test
    public void testReadFillBuffer() throws IOException {
        RowSet.Builder ranges = RowSet.newBuilder();
        ranges.addRowRanges(BigtableServiceImplTest.generateRowRange(BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 0), BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 5)));
        ranges.addRowRanges(BigtableServiceImplTest.generateRowRange(BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 5), BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 10)));
        ranges.addRowRanges(BigtableServiceImplTest.generateRowRange(BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 10), BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 20)));
        OngoingStubbing stub = Mockito.when((Object)this.mockBigtableDataClient.readFlatRows((ReadRowsRequest)Matchers.any(ReadRowsRequest.class), (StreamObserver)Matchers.any()));
        ImmutableList expectedResults = ImmutableList.of(BigtableServiceImplTest.generateSegmentResult(DEFAULT_PREFIX, 0, 10), BigtableServiceImplTest.generateSegmentResult(DEFAULT_PREFIX, 10, 10), (Object)ImmutableList.of());
        this.expectRowResults(stub, (List<List<FlatRow>>)expectedResults);
        BigtableServiceImpl.BigtableSegmentReaderImpl underTest = new BigtableServiceImpl.BigtableSegmentReaderImpl(this.mockSession, TABLE_ID, ranges.build(), 10, 1048576000L, RowFilter.getDefaultInstance(), this.mockCallMetric);
        ArrayList<Row> actualResults = new ArrayList<Row>();
        Assert.assertTrue((boolean)underTest.start());
        ((BigtableDataClient)Mockito.verify((Object)this.mockBigtableDataClient, (VerificationMode)Mockito.times((int)1))).readFlatRows((ReadRowsRequest)this.requestCaptor.capture(), (StreamObserver)Matchers.any(StreamObserver.class));
        Assert.assertEquals((long)3L, (long)((ReadRowsRequest)this.requestCaptor.getValue()).getRows().getRowRangesCount());
        do {
            actualResults.add(underTest.getCurrentRow());
        } while (underTest.advance());
        ((BigtableDataClient)Mockito.verify((Object)this.mockBigtableDataClient, (VerificationMode)Mockito.times((int)3))).readFlatRows((ReadRowsRequest)this.requestCaptor.capture(), (StreamObserver)Matchers.any(StreamObserver.class));
        Assert.assertEquals((long)1L, (long)((ReadRowsRequest)this.requestCaptor.getValue()).getRows().getRowRangesCount());
        Assert.assertEquals(expectedResults.stream().flatMap(Collection::stream).map(i -> FlatRowConverter.convert((FlatRow)i)).collect(Collectors.toList()), actualResults);
        underTest.close();
        ((ServiceCallMetric)Mockito.verify((Object)this.mockCallMetric, (VerificationMode)Mockito.times((int)3))).call("ok");
    }

    @Test
    public void testReadByteLimitBuffer() throws IOException {
        long segmentByteLimit = 0x7D00000L;
        int numOfRowsInsideBuffer = (int)(segmentByteLimit / 0x1900000L) + 1;
        RowRange mockRowRange = BigtableServiceImplTest.generateRowRange(BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 0), BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 10));
        OngoingStubbing stub = Mockito.when((Object)this.mockBigtableDataClient.readFlatRows((ReadRowsRequest)Matchers.any(ReadRowsRequest.class), (StreamObserver)Matchers.any()));
        ImmutableList expectedResults = ImmutableList.of(BigtableServiceImplTest.generateLargeSegmentResult(DEFAULT_PREFIX, 0, numOfRowsInsideBuffer), BigtableServiceImplTest.generateSegmentResult(DEFAULT_PREFIX, numOfRowsInsideBuffer, 10 - numOfRowsInsideBuffer), (Object)ImmutableList.of());
        this.expectRowResults(stub, (List<List<FlatRow>>)expectedResults);
        BigtableServiceImpl.BigtableSegmentReaderImpl underTest = new BigtableServiceImpl.BigtableSegmentReaderImpl(this.mockSession, TABLE_ID, RowSet.newBuilder().addRowRanges(mockRowRange).build(), 10, segmentByteLimit, RowFilter.getDefaultInstance(), this.mockCallMetric);
        ArrayList<Row> actualResults = new ArrayList<Row>();
        Assert.assertTrue((boolean)underTest.start());
        do {
            actualResults.add(underTest.getCurrentRow());
        } while (underTest.advance());
        Assert.assertEquals(expectedResults.stream().flatMap(Collection::stream).map(i -> FlatRowConverter.convert((FlatRow)i)).collect(Collectors.toList()), actualResults);
        underTest.close();
        ((ServiceCallMetric)Mockito.verify((Object)this.mockCallMetric, (VerificationMode)Mockito.times((int)3))).call("ok");
    }

    @Test
    public void testReadSegmentExceptionHandling() throws IOException {
        RowSet.Builder ranges = RowSet.newBuilder();
        ranges.addRowRanges(BigtableServiceImplTest.generateRowRange(BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 0), BigtableServiceImplTest.generateByteString(DEFAULT_PREFIX, 1)));
        Mockito.when((Object)this.mockBigtableDataClient.readFlatRows((ReadRowsRequest)Matchers.any(ReadRowsRequest.class), (StreamObserver)Matchers.any())).thenAnswer((Answer)new Answer<ScanHandler>(){

            public ScanHandler answer(InvocationOnMock invocationOnMock) throws Throwable {
                final StreamObserver flatRowObserver = (StreamObserver)invocationOnMock.getArgument(1);
                new Thread(){

                    @Override
                    public void run() {
                        flatRowObserver.onError((Throwable)Status.INVALID_ARGUMENT.asRuntimeException());
                    }
                }.start();
                return BigtableServiceImplTest.this.scanHandler;
            }
        });
        BigtableServiceImpl.BigtableSegmentReaderImpl underTest = new BigtableServiceImpl.BigtableSegmentReaderImpl(this.mockSession, TABLE_ID, ranges.build(), 10, 1048576000L, RowFilter.getDefaultInstance(), this.mockCallMetric);
        IOException returnedError = null;
        try {
            underTest.start();
        }
        catch (IOException e) {
            returnedError = e;
        }
        Assert.assertTrue((boolean)(returnedError.getCause() instanceof StatusRuntimeException));
        ((ServiceCallMetric)Mockito.verify((Object)this.mockCallMetric, (VerificationMode)Mockito.times((int)1))).call(Status.INVALID_ARGUMENT.getCode().toString());
    }

    @Test
    public void testWrite() throws IOException, InterruptedException {
        Mockito.when((Object)this.mockBigtableSource.getTableId()).thenReturn((Object)ValueProvider.StaticValueProvider.of((Object)TABLE_ID));
        BigtableServiceImpl.BigtableWriterImpl underTest = new BigtableServiceImpl.BigtableWriterImpl(this.mockSession, TABLE_NAME);
        Mutation mutation = Mutation.newBuilder().setSetCell(Mutation.SetCell.newBuilder().setFamilyName("Family").build()).build();
        ByteString key = ByteString.copyFromUtf8((String)"key");
        SettableFuture fakeResponse = SettableFuture.create();
        Mockito.when((Object)this.mockBulkMutation.add((MutateRowsRequest.Entry)Matchers.any(MutateRowsRequest.Entry.class))).thenReturn((Object)fakeResponse);
        underTest.writeRecord(KV.of((Object)key, (Object)ImmutableList.of((Object)mutation)));
        MutateRowsRequest.Entry expected = MutateRowsRequest.Entry.newBuilder().setRowKey(key).addMutations(mutation).build();
        ((BulkMutation)Mockito.verify((Object)this.mockBulkMutation, (VerificationMode)Mockito.times((int)1))).add(expected);
        underTest.close();
        ((BulkMutation)Mockito.verify((Object)this.mockBulkMutation, (VerificationMode)Mockito.times((int)1))).flush();
    }

    private void verifyMetricWasSet(String method, String status, long count) {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("PTRANSFORM", "");
        labels.put("SERVICE", "BigTable");
        labels.put("METHOD", method);
        labels.put("RESOURCE", GcpResourceIdentifiers.bigtableResource((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID));
        labels.put("BIGTABLE_PROJECT_ID", PROJECT_ID);
        labels.put("INSTANCE_ID", INSTANCE_ID);
        labels.put("TABLE_ID", GcpResourceIdentifiers.bigtableTableID((String)PROJECT_ID, (String)INSTANCE_ID, (String)TABLE_ID));
        labels.put("STATUS", status);
        MonitoringInfoMetricName name = MonitoringInfoMetricName.named((String)MonitoringInfoConstants.Urns.API_REQUEST_COUNT, labels);
        MetricsContainerImpl container = (MetricsContainerImpl)MetricsEnvironment.getProcessWideContainer();
        Assert.assertEquals((long)count, (long)container.getCounter((MetricName)name).getCumulative());
    }

    private Answer<ScanHandler> mockReadRowsAnswer(final List<FlatRow> rows) {
        return new Answer<ScanHandler>(){

            public ScanHandler answer(InvocationOnMock invocationOnMock) throws Throwable {
                final StreamObserver flatRowObserver = (StreamObserver)invocationOnMock.getArgument(1);
                new Thread(){

                    @Override
                    public void run() {
                        for (int i = 0; i < rows.size(); ++i) {
                            flatRowObserver.onNext((Object)((FlatRow)rows.get(i)));
                        }
                        flatRowObserver.onCompleted();
                    }
                }.start();
                return BigtableServiceImplTest.this.scanHandler;
            }
        };
    }

    private static RowRange generateRowRange(ByteString start, ByteString end) {
        return RowRange.newBuilder().setStartKeyClosed(start).setEndKeyOpen(end).build();
    }

    private static List<FlatRow> generateSegmentResult(String prefix, int startIndex, int count) {
        return BigtableServiceImplTest.generateSegmentResult(prefix, startIndex, count, false);
    }

    private static List<FlatRow> generateLargeSegmentResult(String prefix, int startIndex, int count) {
        return BigtableServiceImplTest.generateSegmentResult(prefix, startIndex, count, true);
    }

    private static List<FlatRow> generateSegmentResult(String prefix, int startIndex, int count, boolean largeRow) {
        byte[] largeMemory = new byte[0x1900000];
        return IntStream.range(startIndex, startIndex + count).mapToObj(i -> {
            FlatRow.Builder builder = FlatRow.newBuilder();
            if (!largeRow) {
                builder.withRowKey(BigtableServiceImplTest.generateByteString(prefix, i));
            } else {
                builder.withRowKey(BigtableServiceImplTest.generateByteString(prefix, i)).addCell("Family", ByteString.copyFromUtf8((String)"LargeMemoryRow"), System.currentTimeMillis(), ByteString.copyFrom((byte[])largeMemory));
            }
            return builder.build();
        }).collect(Collectors.toList());
    }

    private <T> OngoingStubbing<T> expectRowResults(OngoingStubbing<T> stub, List<List<FlatRow>> results) {
        for (List<FlatRow> result : results) {
            stub = stub.thenAnswer(this.mockReadRowsAnswer(result));
        }
        return stub;
    }

    private static ByteString generateByteString(String prefix, int index) {
        return ByteString.copyFromUtf8((String)(prefix + String.format("%05d", index)));
    }
}

