/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.cloud.bigtable.config.BigtableOptions;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableTestOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigtableReadIT {
    @Test
    public void testE2EBigtableRead() throws Exception {
        PipelineOptionsFactory.register(BigtableTestOptions.class);
        BigtableTestOptions options = (BigtableTestOptions)TestPipeline.testingPipelineOptions().as(BigtableTestOptions.class);
        String project = options.getBigtableProject();
        if (project.equals("")) {
            project = ((GcpOptions)options.as(GcpOptions.class)).getProject();
        }
        BigtableOptions.Builder bigtableOptionsBuilder = new BigtableOptions.Builder().setProjectId(project).setInstanceId(options.getInstanceId());
        String tableId = "BigtableReadTest";
        long numRows = 1000L;
        Pipeline p = Pipeline.create((PipelineOptions)options);
        PCollection count = (PCollection)((PCollection)p.apply((PTransform)BigtableIO.read().withBigtableOptions(bigtableOptionsBuilder).withTableId("BigtableReadTest"))).apply(Count.globally());
        PAssert.thatSingleton((PCollection)count).isEqualTo((Object)1000L);
        p.run();
    }
}

