/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.BulkOptions;
import java.io.Serializable;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableConfig;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableService;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.DisplayDataMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class BigtableConfigTest {
    static final ValueProvider<String> NOT_ACCESSIBLE_VALUE = new ValueProvider<String>(){

        public String get() {
            throw new IllegalStateException("Value is not accessible");
        }

        public boolean isAccessible() {
            return false;
        }
    };
    static final ValueProvider<String> PROJECT_ID = ValueProvider.StaticValueProvider.of((Object)"project_id");
    static final ValueProvider<String> INSTANCE_ID = ValueProvider.StaticValueProvider.of((Object)"instance_id");
    static final ValueProvider<String> TABLE_ID = ValueProvider.StaticValueProvider.of((Object)"table");
    static final SerializableFunction<BigtableOptions.Builder, BigtableOptions.Builder> CONFIGURATOR = (SerializableFunction & Serializable)input -> input;
    static final BigtableService SERVICE = (BigtableService)Mockito.mock(BigtableService.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private BigtableConfig config;

    @Before
    public void setup() throws Exception {
        this.config = BigtableConfig.builder().setValidate(false).build();
    }

    @Test
    public void testWithProjectId() {
        Assert.assertEquals((Object)PROJECT_ID.get(), (Object)this.config.withProjectId(PROJECT_ID).getProjectId().get());
        this.thrown.expect(IllegalArgumentException.class);
        this.config.withProjectId(null);
    }

    @Test
    public void testWithInstanceId() {
        Assert.assertEquals((Object)INSTANCE_ID.get(), (Object)this.config.withInstanceId(INSTANCE_ID).getInstanceId().get());
        this.thrown.expect(IllegalArgumentException.class);
        this.config.withInstanceId(null);
    }

    @Test
    public void testWithTableId() {
        Assert.assertEquals((Object)TABLE_ID.get(), (Object)this.config.withTableId(TABLE_ID).getTableId().get());
        this.thrown.expect(IllegalArgumentException.class);
        this.config.withTableId(null);
    }

    @Test
    public void testWithBigtableOptionsConfigurator() {
        Assert.assertEquals(CONFIGURATOR, (Object)this.config.withBigtableOptionsConfigurator(CONFIGURATOR).getBigtableOptionsConfigurator());
        this.thrown.expect(IllegalArgumentException.class);
        this.config.withBigtableOptionsConfigurator(null);
    }

    @Test
    public void testWithValidate() {
        Assert.assertTrue((boolean)this.config.withValidate(true).getValidate());
    }

    @Test
    public void testWithBigtableService() {
        Assert.assertEquals((Object)SERVICE, (Object)this.config.withBigtableService(SERVICE).getBigtableService());
        this.thrown.expect(IllegalArgumentException.class);
        this.config.withBigtableService(null);
    }

    @Test
    public void testValidate() {
        this.config.withProjectId(PROJECT_ID).withInstanceId(INSTANCE_ID).withTableId(TABLE_ID).validate();
    }

    @Test
    public void testValidateFailsWithoutProjectId() {
        this.config.withInstanceId(INSTANCE_ID).withTableId(TABLE_ID);
        this.thrown.expect(IllegalArgumentException.class);
        this.config.validate();
    }

    @Test
    public void testValidateFailsWithoutInstanceId() {
        this.config.withProjectId(PROJECT_ID).withTableId(TABLE_ID);
        this.thrown.expect(IllegalArgumentException.class);
        this.config.validate();
    }

    @Test
    public void testValidateFailsWithoutTableId() {
        this.config.withProjectId(PROJECT_ID).withInstanceId(INSTANCE_ID);
        this.thrown.expect(IllegalArgumentException.class);
        this.config.validate();
    }

    @Test
    public void testPopulateDisplayData() {
        DisplayData displayData = DisplayData.from(arg_0 -> ((BigtableConfig)this.config.withProjectId(PROJECT_ID).withInstanceId(INSTANCE_ID).withTableId(TABLE_ID)).populateDisplayData(arg_0));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((Matcher)Matchers.allOf((Matcher)DisplayDataMatchers.hasKey((String)"projectId"), (Matcher)DisplayDataMatchers.hasLabel((String)"Bigtable Project Id"), (Matcher)DisplayDataMatchers.hasValue((Object)PROJECT_ID.get()))));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((Matcher)Matchers.allOf((Matcher)DisplayDataMatchers.hasKey((String)"instanceId"), (Matcher)DisplayDataMatchers.hasLabel((String)"Bigtable Instance Id"), (Matcher)DisplayDataMatchers.hasValue((Object)INSTANCE_ID.get()))));
        MatcherAssert.assertThat((Object)displayData, (Matcher)DisplayDataMatchers.hasDisplayItem((Matcher)Matchers.allOf((Matcher)DisplayDataMatchers.hasKey((String)"tableId"), (Matcher)DisplayDataMatchers.hasLabel((String)"Bigtable Table Id"), (Matcher)DisplayDataMatchers.hasValue((Object)TABLE_ID.get()))));
    }

    @Test
    public void testGetBigtableServiceWithDefaultService() {
        Assert.assertEquals((Object)SERVICE, (Object)this.config.withBigtableService(SERVICE).getBigtableService());
    }

    @Test
    public void testGetBigtableServiceWithConfigurator() {
        SerializableFunction & Serializable configurator = (SerializableFunction & Serializable)input -> input.setInstanceId((String)INSTANCE_ID.get() + (String)INSTANCE_ID.get()).setProjectId((String)PROJECT_ID.get() + (String)PROJECT_ID.get()).setBulkOptions(new BulkOptions.Builder().setUseBulkApi(true).build());
        BigtableService service = this.config.withProjectId(PROJECT_ID).withInstanceId(INSTANCE_ID).withBigtableOptionsConfigurator((SerializableFunction)configurator).getBigtableService(PipelineOptionsFactory.as(GcpOptions.class));
        Assert.assertEquals((Object)PROJECT_ID.get(), (Object)service.getBigtableOptions().getProjectId());
        Assert.assertEquals((Object)INSTANCE_ID.get(), (Object)service.getBigtableOptions().getInstanceId());
        Assert.assertTrue((boolean)service.getBigtableOptions().getBulkOptions().useBulkApi());
    }

    @Test
    public void testIsDataAccessible() {
        Assert.assertTrue((boolean)this.config.withTableId(TABLE_ID).withProjectId(PROJECT_ID).withInstanceId(INSTANCE_ID).isDataAccessible());
        Assert.assertTrue((boolean)this.config.withTableId(TABLE_ID).withProjectId(PROJECT_ID).withBigtableOptions(new BigtableOptions.Builder().setInstanceId("instance_id").build()).isDataAccessible());
        Assert.assertTrue((boolean)this.config.withTableId(TABLE_ID).withInstanceId(INSTANCE_ID).withBigtableOptions(new BigtableOptions.Builder().setProjectId("project_id").build()).isDataAccessible());
        Assert.assertTrue((boolean)this.config.withTableId(TABLE_ID).withBigtableOptions(new BigtableOptions.Builder().setProjectId("project_id").setInstanceId("instance_id").build()).isDataAccessible());
        Assert.assertFalse((boolean)this.config.withTableId(NOT_ACCESSIBLE_VALUE).withProjectId(PROJECT_ID).withInstanceId(INSTANCE_ID).isDataAccessible());
        Assert.assertFalse((boolean)this.config.withTableId(TABLE_ID).withProjectId(NOT_ACCESSIBLE_VALUE).withInstanceId(INSTANCE_ID).isDataAccessible());
        Assert.assertFalse((boolean)this.config.withTableId(TABLE_ID).withProjectId(PROJECT_ID).withInstanceId(NOT_ACCESSIBLE_VALUE).isDataAccessible());
    }
}

