/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1.BigDecimalByteStringEncoder;
import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Functions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.BaseEncoding;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TableRowToStorageApiProtoTest {
    private static final TableSchema BASE_TABLE_SCHEMA = new TableSchema().setFields((List)ImmutableList.builder().add((Object)new TableFieldSchema().setType("STRING").setName("stringValue")).add((Object)new TableFieldSchema().setType("STRING").setName("f")).add((Object)new TableFieldSchema().setType("BYTES").setName("bytesValue")).add((Object)new TableFieldSchema().setType("INT64").setName("int64Value")).add((Object)new TableFieldSchema().setType("INTEGER").setName("intValue")).add((Object)new TableFieldSchema().setType("FLOAT64").setName("float64Value")).add((Object)new TableFieldSchema().setType("FLOAT").setName("floatValue")).add((Object)new TableFieldSchema().setType("BOOL").setName("boolValue")).add((Object)new TableFieldSchema().setType("BOOLEAN").setName("booleanValue")).add((Object)new TableFieldSchema().setType("TIMESTAMP").setName("timestampValue")).add((Object)new TableFieldSchema().setType("TIME").setName("timeValue")).add((Object)new TableFieldSchema().setType("DATETIME").setName("datetimeValue")).add((Object)new TableFieldSchema().setType("DATE").setName("dateValue")).add((Object)new TableFieldSchema().setType("NUMERIC").setName("numericValue")).add((Object)new TableFieldSchema().setType("BIGNUMERIC").setName("bigNumericValue")).add((Object)new TableFieldSchema().setType("BYTES").setMode("REPEATED").setName("arrayValue")).add((Object)new TableFieldSchema().setType("TIMESTAMP").setName("timestampISOValue")).add((Object)new TableFieldSchema().setType("TIMESTAMP").setName("timestampValueLong")).add((Object)new TableFieldSchema().setType("TIMESTAMP").setName("timestampValueSpace")).add((Object)new TableFieldSchema().setType("DATETIME").setName("datetimeValueSpace")).build());
    private static final TableSchema BASE_TABLE_SCHEMA_NO_F = new TableSchema().setFields((List)ImmutableList.builder().add((Object)new TableFieldSchema().setType("STRING").setName("stringValue")).add((Object)new TableFieldSchema().setType("BYTES").setName("bytesValue")).add((Object)new TableFieldSchema().setType("INT64").setName("int64Value")).add((Object)new TableFieldSchema().setType("INTEGER").setName("intValue")).add((Object)new TableFieldSchema().setType("FLOAT64").setName("float64Value")).add((Object)new TableFieldSchema().setType("FLOAT").setName("floatValue")).add((Object)new TableFieldSchema().setType("BOOL").setName("boolValue")).add((Object)new TableFieldSchema().setType("BOOLEAN").setName("booleanValue")).add((Object)new TableFieldSchema().setType("TIMESTAMP").setName("timestampValue")).add((Object)new TableFieldSchema().setType("TIME").setName("timeValue")).add((Object)new TableFieldSchema().setType("DATETIME").setName("datetimeValue")).add((Object)new TableFieldSchema().setType("DATE").setName("dateValue")).add((Object)new TableFieldSchema().setType("NUMERIC").setName("numericValue")).add((Object)new TableFieldSchema().setType("BIGNUMERIC").setName("bigNumericValue")).add((Object)new TableFieldSchema().setType("BYTES").setMode("REPEATED").setName("arrayValue")).add((Object)new TableFieldSchema().setType("TIMESTAMP").setName("timestampISOValue")).add((Object)new TableFieldSchema().setType("TIMESTAMP").setName("timestampValueLong")).add((Object)new TableFieldSchema().setType("TIMESTAMP").setName("timestampValueSpace")).add((Object)new TableFieldSchema().setType("DATETIME").setName("datetimeValueSpace")).build());
    private static final DescriptorProtos.DescriptorProto BASE_TABLE_SCHEMA_PROTO = DescriptorProtos.DescriptorProto.newBuilder().addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("stringvalue").setNumber(1).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("f").setNumber(2).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("bytesvalue").setNumber(3).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("int64value").setNumber(4).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("intvalue").setNumber(5).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("float64value").setNumber(6).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("floatvalue").setNumber(7).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("boolvalue").setNumber(8).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("booleanvalue").setNumber(9).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("timestampvalue").setNumber(10).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("timevalue").setNumber(11).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("datetimevalue").setNumber(12).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("datevalue").setNumber(13).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("numericvalue").setNumber(14).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("bignumericvalue").setNumber(15).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("arrayvalue").setNumber(16).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("timestampisovalue").setNumber(17).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("timestampvaluelong").setNumber(18).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("timestampvaluespace").setNumber(19).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("datetimevaluespace").setNumber(20).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).build();
    private static final DescriptorProtos.DescriptorProto BASE_TABLE_SCHEMA_NO_F_PROTO = DescriptorProtos.DescriptorProto.newBuilder().addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("stringvalue").setNumber(1).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("bytesvalue").setNumber(2).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("int64value").setNumber(3).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("intvalue").setNumber(4).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("float64value").setNumber(5).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("floatvalue").setNumber(6).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("boolvalue").setNumber(7).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("booleanvalue").setNumber(8).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("timestampvalue").setNumber(9).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("timevalue").setNumber(10).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("datetimevalue").setNumber(11).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("datevalue").setNumber(2).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("numericvalue").setNumber(13).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("bignumericvalue").setNumber(14).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("arrayvalue").setNumber(15).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("timestampisovalue").setNumber(17).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("timestampvaluelong").setNumber(20).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("timestampvaluespace").setNumber(21).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).addField(DescriptorProtos.FieldDescriptorProto.newBuilder().setName("datetimevaluespace").setNumber(21).setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL).build()).build();
    private static final TableSchema NESTED_TABLE_SCHEMA = new TableSchema().setFields((List)ImmutableList.builder().add((Object)new TableFieldSchema().setType("STRUCT").setName("nestedValue1").setFields(BASE_TABLE_SCHEMA.getFields())).add((Object)new TableFieldSchema().setType("RECORD").setName("nestedValue2").setFields(BASE_TABLE_SCHEMA.getFields())).add((Object)new TableFieldSchema().setType("STRUCT").setName("nestedValueNoF1").setFields(BASE_TABLE_SCHEMA_NO_F.getFields())).add((Object)new TableFieldSchema().setType("RECORD").setName("nestedValueNoF2").setFields(BASE_TABLE_SCHEMA_NO_F.getFields())).build());
    private static final List<Object> REPEATED_BYTES = ImmutableList.of((Object)BaseEncoding.base64().encode("hello".getBytes(StandardCharsets.UTF_8)), (Object)"goodbye".getBytes(StandardCharsets.UTF_8), (Object)ByteString.copyFrom((byte[])"solong".getBytes(StandardCharsets.UTF_8)));
    private static final List<Object> EXPECTED_PROTO_REPEATED_BYTES = ImmutableList.of((Object)ByteString.copyFrom((byte[])"hello".getBytes(StandardCharsets.UTF_8)), (Object)ByteString.copyFrom((byte[])"goodbye".getBytes(StandardCharsets.UTF_8)), (Object)ByteString.copyFrom((byte[])"solong".getBytes(StandardCharsets.UTF_8)));
    private static final TableRow BASE_TABLE_ROW = new TableRow().setF((List)Lists.newArrayList((Object[])new TableCell[]{new TableCell().setV((Object)"string"), new TableCell().setV((Object)"fff"), new TableCell().setV((Object)BaseEncoding.base64().encode("string".getBytes(StandardCharsets.UTF_8))), new TableCell().setV((Object)"42"), new TableCell().setV((Object)"43"), new TableCell().setV((Object)"2.8168"), new TableCell().setV((Object)"2"), new TableCell().setV((Object)"true"), new TableCell().setV((Object)"true"), new TableCell().setV((Object)"1970-01-01T00:00:00.000043Z"), new TableCell().setV((Object)"00:52:07.123456"), new TableCell().setV((Object)"2019-08-16T00:52:07.123456"), new TableCell().setV((Object)"2019-08-16"), new TableCell().setV((Object)"23.4"), new TableCell().setV((Object)"2312345.4"), new TableCell().setV(REPEATED_BYTES), new TableCell().setV((Object)"1970-01-01T00:00:00.000+01:00"), new TableCell().setV((Object)"1234567"), new TableCell().setV((Object)"1970-01-01 00:00:00.000343"), new TableCell().setV((Object)"2019-08-16 00:52:07.123456")}));
    private static final TableRow BASE_TABLE_ROW_NO_F = new TableRow().set("stringValue", (Object)"string").set("bytesValue", (Object)BaseEncoding.base64().encode("string".getBytes(StandardCharsets.UTF_8))).set("int64Value", (Object)"42").set("intValue", (Object)"43").set("float64Value", (Object)"2.8168").set("floatValue", (Object)"2").set("boolValue", (Object)"true").set("booleanValue", (Object)"true").set("timestampValue", (Object)"1970-01-01T00:00:00.000043Z").set("timeValue", (Object)"00:52:07.123456").set("datetimeValue", (Object)"2019-08-16T00:52:07.123456").set("dateValue", (Object)"2019-08-16").set("numericValue", (Object)"23.4").set("bigNumericValue", (Object)"2312345.4").set("arrayValue", REPEATED_BYTES).set("timestampISOValue", (Object)"1970-01-01T00:00:00.000+01:00").set("timestampValueLong", (Object)"1234567").set("timestampValueSpace", (Object)"1970-01-01 00:00:00.000343").set("datetimeValueSpace", (Object)"2019-08-16 00:52:07.123456");
    private static final Map<String, Object> BASE_ROW_EXPECTED_PROTO_VALUES = ImmutableMap.builder().put((Object)"stringvalue", (Object)"string").put((Object)"f", (Object)"fff").put((Object)"bytesvalue", (Object)ByteString.copyFrom((byte[])"string".getBytes(StandardCharsets.UTF_8))).put((Object)"int64value", (Object)42L).put((Object)"intvalue", (Object)43L).put((Object)"float64value", (Object)2.8168).put((Object)"floatvalue", (Object)2.0).put((Object)"boolvalue", (Object)true).put((Object)"booleanvalue", (Object)true).put((Object)"timestampvalue", (Object)43L).put((Object)"timevalue", (Object)3497124416L).put((Object)"datetimevalue", (Object)142111881387172416L).put((Object)"datevalue", (Object)((int)LocalDate.of(2019, 8, 16).toEpochDay())).put((Object)"numericvalue", (Object)BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("23.4"))).put((Object)"bignumericvalue", (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)new BigDecimal("2312345.4"))).put((Object)"arrayvalue", EXPECTED_PROTO_REPEATED_BYTES).put((Object)"timestampisovalue", (Object)-3600000000L).put((Object)"timestampvaluelong", (Object)1234567000L).put((Object)"timestampvaluespace", (Object)343L).put((Object)"datetimevaluespace", (Object)142111881387172416L).build();
    private static final Map<String, Object> BASE_ROW_NO_F_EXPECTED_PROTO_VALUES = ImmutableMap.builder().put((Object)"stringvalue", (Object)"string").put((Object)"bytesvalue", (Object)ByteString.copyFrom((byte[])"string".getBytes(StandardCharsets.UTF_8))).put((Object)"int64value", (Object)42L).put((Object)"intvalue", (Object)43L).put((Object)"float64value", (Object)2.8168).put((Object)"floatvalue", (Object)2.0).put((Object)"boolvalue", (Object)true).put((Object)"booleanvalue", (Object)true).put((Object)"timestampvalue", (Object)43L).put((Object)"timevalue", (Object)3497124416L).put((Object)"datetimevalue", (Object)142111881387172416L).put((Object)"datevalue", (Object)((int)LocalDate.parse("2019-08-16").toEpochDay())).put((Object)"numericvalue", (Object)BigDecimalByteStringEncoder.encodeToNumericByteString((BigDecimal)new BigDecimal("23.4"))).put((Object)"bignumericvalue", (Object)BigDecimalByteStringEncoder.encodeToBigNumericByteString((BigDecimal)new BigDecimal("2312345.4"))).put((Object)"arrayvalue", EXPECTED_PROTO_REPEATED_BYTES).put((Object)"timestampisovalue", (Object)-3600000000L).put((Object)"timestampvaluelong", (Object)1234567000L).put((Object)"timestampvaluespace", (Object)343L).put((Object)"datetimevaluespace", (Object)142111881387172416L).build();
    private static final TableSchema REPEATED_MESSAGE_SCHEMA = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setType("STRUCT").setName("repeated1").setFields(BASE_TABLE_SCHEMA.getFields()).setMode("REPEATED"), (Object)new TableFieldSchema().setType("RECORD").setName("repeated2").setFields(BASE_TABLE_SCHEMA.getFields()).setMode("REPEATED"), (Object)new TableFieldSchema().setType("STRUCT").setName("repeatednof1").setFields(BASE_TABLE_SCHEMA_NO_F.getFields()).setMode("REPEATED"), (Object)new TableFieldSchema().setType("RECORD").setName("repeatednof2").setFields(BASE_TABLE_SCHEMA_NO_F.getFields()).setMode("REPEATED")));

    @Test
    public void testDescriptorFromTableSchema() {
        DescriptorProtos.DescriptorProto descriptor = TableRowToStorageApiProto.descriptorSchemaFromTableSchema((TableSchema)BASE_TABLE_SCHEMA);
        Map<String, DescriptorProtos.FieldDescriptorProto.Type> types = descriptor.getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getType));
        Map<String, DescriptorProtos.FieldDescriptorProto.Type> expectedTypes = BASE_TABLE_SCHEMA_PROTO.getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getType));
        Assert.assertEquals(expectedTypes, types);
    }

    @Test
    public void testNestedFromTableSchema() {
        DescriptorProtos.DescriptorProto descriptor = TableRowToStorageApiProto.descriptorSchemaFromTableSchema((TableSchema)NESTED_TABLE_SCHEMA);
        Map<String, DescriptorProtos.FieldDescriptorProto.Type> expectedBaseTypes = BASE_TABLE_SCHEMA_PROTO.getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getType));
        Map<String, DescriptorProtos.FieldDescriptorProto.Type> expectedBaseTypesNoF = BASE_TABLE_SCHEMA_NO_F_PROTO.getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getType));
        Map<String, DescriptorProtos.FieldDescriptorProto.Type> types = descriptor.getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getType));
        Map<String, String> typeNames = descriptor.getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getTypeName));
        Assert.assertEquals((long)4L, (long)types.size());
        Map nestedTypes = descriptor.getNestedTypeList().stream().collect(Collectors.toMap(DescriptorProtos.DescriptorProto::getName, Functions.identity()));
        Assert.assertEquals((long)4L, (long)nestedTypes.size());
        Assert.assertEquals((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE, (Object)types.get("nestedvalue1"));
        String nestedTypeName1 = typeNames.get("nestedvalue1");
        Map<String, DescriptorProtos.FieldDescriptorProto.Type> nestedTypes1 = ((DescriptorProtos.DescriptorProto)nestedTypes.get(nestedTypeName1)).getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getType));
        Assert.assertEquals(expectedBaseTypes, nestedTypes1);
        Assert.assertEquals((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE, (Object)types.get("nestedvalue2"));
        String nestedTypeName2 = typeNames.get("nestedvalue2");
        Map<String, DescriptorProtos.FieldDescriptorProto.Type> nestedTypes2 = ((DescriptorProtos.DescriptorProto)nestedTypes.get(nestedTypeName2)).getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getType));
        Assert.assertEquals(expectedBaseTypes, nestedTypes2);
        Assert.assertEquals((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE, (Object)types.get("nestedvaluenof1"));
        String nestedTypeNameNoF1 = typeNames.get("nestedvaluenof1");
        Map<String, DescriptorProtos.FieldDescriptorProto.Type> nestedTypesNoF1 = ((DescriptorProtos.DescriptorProto)nestedTypes.get(nestedTypeNameNoF1)).getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getType));
        Assert.assertEquals(expectedBaseTypesNoF, nestedTypesNoF1);
        Assert.assertEquals((Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE, (Object)types.get("nestedvaluenof2"));
        String nestedTypeNameNoF2 = typeNames.get("nestedvaluenof2");
        Map<String, DescriptorProtos.FieldDescriptorProto.Type> nestedTypesNoF2 = ((DescriptorProtos.DescriptorProto)nestedTypes.get(nestedTypeNameNoF2)).getFieldList().stream().collect(Collectors.toMap(DescriptorProtos.FieldDescriptorProto::getName, DescriptorProtos.FieldDescriptorProto::getType));
        Assert.assertEquals(expectedBaseTypesNoF, nestedTypesNoF2);
    }

    private void assertBaseRecord(DynamicMessage msg, boolean withF) {
        Map<String, Object> recordFields = msg.getAllFields().entrySet().stream().collect(Collectors.toMap(entry -> ((Descriptors.FieldDescriptor)entry.getKey()).getName(), entry -> entry.getValue()));
        Assert.assertEquals(withF ? BASE_ROW_EXPECTED_PROTO_VALUES : BASE_ROW_NO_F_EXPECTED_PROTO_VALUES, recordFields);
    }

    @Test
    public void testMessageFromTableRow() throws Exception {
        TableRow tableRow = new TableRow().set("nestedValue1", (Object)BASE_TABLE_ROW).set("nestedValue2", (Object)BASE_TABLE_ROW).set("nestedValueNoF1", (Object)BASE_TABLE_ROW_NO_F).set("nestedValueNoF2", (Object)BASE_TABLE_ROW_NO_F);
        Descriptors.Descriptor descriptor = TableRowToStorageApiProto.getDescriptorFromTableSchema((TableSchema)NESTED_TABLE_SCHEMA);
        TableRowToStorageApiProto.SchemaInformation schemaInformation = TableRowToStorageApiProto.SchemaInformation.fromTableSchema((TableSchema)NESTED_TABLE_SCHEMA);
        DynamicMessage msg = TableRowToStorageApiProto.messageFromTableRow((TableRowToStorageApiProto.SchemaInformation)schemaInformation, (Descriptors.Descriptor)descriptor, (TableRow)tableRow, (boolean)false);
        Assert.assertEquals((long)4L, (long)msg.getAllFields().size());
        Map fieldDescriptors = descriptor.getFields().stream().collect(Collectors.toMap(Descriptors.FieldDescriptor::getName, Functions.identity()));
        this.assertBaseRecord((DynamicMessage)msg.getField((Descriptors.FieldDescriptor)fieldDescriptors.get("nestedvalue1")), true);
        this.assertBaseRecord((DynamicMessage)msg.getField((Descriptors.FieldDescriptor)fieldDescriptors.get("nestedvalue2")), true);
        this.assertBaseRecord((DynamicMessage)msg.getField((Descriptors.FieldDescriptor)fieldDescriptors.get("nestedvaluenof1")), false);
        this.assertBaseRecord((DynamicMessage)msg.getField((Descriptors.FieldDescriptor)fieldDescriptors.get("nestedvaluenof2")), false);
    }

    @Test
    public void testMessageWithFFromTableRow() throws Exception {
        Descriptors.Descriptor descriptor = TableRowToStorageApiProto.getDescriptorFromTableSchema((TableSchema)BASE_TABLE_SCHEMA);
        TableRowToStorageApiProto.SchemaInformation schemaInformation = TableRowToStorageApiProto.SchemaInformation.fromTableSchema((TableSchema)BASE_TABLE_SCHEMA);
        DynamicMessage msg = TableRowToStorageApiProto.messageFromTableRow((TableRowToStorageApiProto.SchemaInformation)schemaInformation, (Descriptors.Descriptor)descriptor, (TableRow)BASE_TABLE_ROW, (boolean)false);
        this.assertBaseRecord(msg, true);
    }

    @Test
    public void testRepeatedDescriptorFromTableSchema() throws Exception {
        TableRow repeatedRow = new TableRow().set("repeated1", (Object)ImmutableList.of((Object)BASE_TABLE_ROW, (Object)BASE_TABLE_ROW)).set("repeated2", (Object)ImmutableList.of((Object)BASE_TABLE_ROW, (Object)BASE_TABLE_ROW)).set("repeatednof1", (Object)ImmutableList.of((Object)BASE_TABLE_ROW_NO_F, (Object)BASE_TABLE_ROW_NO_F)).set("repeatednof2", (Object)ImmutableList.of((Object)BASE_TABLE_ROW_NO_F, (Object)BASE_TABLE_ROW_NO_F));
        Descriptors.Descriptor descriptor = TableRowToStorageApiProto.getDescriptorFromTableSchema((TableSchema)REPEATED_MESSAGE_SCHEMA);
        TableRowToStorageApiProto.SchemaInformation schemaInformation = TableRowToStorageApiProto.SchemaInformation.fromTableSchema((TableSchema)REPEATED_MESSAGE_SCHEMA);
        DynamicMessage msg = TableRowToStorageApiProto.messageFromTableRow((TableRowToStorageApiProto.SchemaInformation)schemaInformation, (Descriptors.Descriptor)descriptor, (TableRow)repeatedRow, (boolean)false);
        Assert.assertEquals((long)4L, (long)msg.getAllFields().size());
        Map fieldDescriptors = descriptor.getFields().stream().collect(Collectors.toMap(Descriptors.FieldDescriptor::getName, Functions.identity()));
        List repeated1 = (List)msg.getField((Descriptors.FieldDescriptor)fieldDescriptors.get("repeated1"));
        Assert.assertEquals((long)2L, (long)repeated1.size());
        this.assertBaseRecord((DynamicMessage)repeated1.get(0), true);
        this.assertBaseRecord((DynamicMessage)repeated1.get(1), true);
        List repeated2 = (List)msg.getField((Descriptors.FieldDescriptor)fieldDescriptors.get("repeated2"));
        Assert.assertEquals((long)2L, (long)repeated2.size());
        this.assertBaseRecord((DynamicMessage)repeated2.get(0), true);
        this.assertBaseRecord((DynamicMessage)repeated2.get(1), true);
        List repeatednof1 = (List)msg.getField((Descriptors.FieldDescriptor)fieldDescriptors.get("repeatednof1"));
        Assert.assertEquals((long)2L, (long)repeatednof1.size());
        this.assertBaseRecord((DynamicMessage)repeatednof1.get(0), false);
        this.assertBaseRecord((DynamicMessage)repeatednof1.get(1), false);
        List repeatednof2 = (List)msg.getField((Descriptors.FieldDescriptor)fieldDescriptors.get("repeatednof2"));
        Assert.assertEquals((long)2L, (long)repeatednof2.size());
        this.assertBaseRecord((DynamicMessage)repeatednof2.get(0), false);
        this.assertBaseRecord((DynamicMessage)repeatednof2.get(1), false);
    }

    @Test
    public void testNullRepeatedDescriptorFromTableSchema() throws Exception {
        TableRow repeatedRow = new TableRow().set("repeated1", null).set("repeated2", null).set("repeatednof1", null).set("repeatednof2", null);
        Descriptors.Descriptor descriptor = TableRowToStorageApiProto.getDescriptorFromTableSchema((TableSchema)REPEATED_MESSAGE_SCHEMA);
        TableRowToStorageApiProto.SchemaInformation schemaInformation = TableRowToStorageApiProto.SchemaInformation.fromTableSchema((TableSchema)REPEATED_MESSAGE_SCHEMA);
        DynamicMessage msg = TableRowToStorageApiProto.messageFromTableRow((TableRowToStorageApiProto.SchemaInformation)schemaInformation, (Descriptors.Descriptor)descriptor, (TableRow)repeatedRow, (boolean)false);
        Map fieldDescriptors = descriptor.getFields().stream().collect(Collectors.toMap(Descriptors.FieldDescriptor::getName, Functions.identity()));
        List repeated1 = (List)msg.getField((Descriptors.FieldDescriptor)fieldDescriptors.get("repeated1"));
        Assert.assertTrue((boolean)repeated1.isEmpty());
        List repeated2 = (List)msg.getField((Descriptors.FieldDescriptor)fieldDescriptors.get("repeated2"));
        Assert.assertTrue((boolean)repeated2.isEmpty());
        List repeatednof1 = (List)msg.getField((Descriptors.FieldDescriptor)fieldDescriptors.get("repeatednof1"));
        Assert.assertTrue((boolean)repeatednof1.isEmpty());
        List repeatednof2 = (List)msg.getField((Descriptors.FieldDescriptor)fieldDescriptors.get("repeatednof2"));
        Assert.assertTrue((boolean)repeatednof2.isEmpty());
    }
}

