/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.testing.BigqueryClient;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.BaseEncoding;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class TableRowToStorageApiProtoIT {
    private static final Logger LOG = LoggerFactory.getLogger(TableRowToStorageApiProtoIT.class);
    private static final BigqueryClient BQ_CLIENT = new BigqueryClient("TableRowToStorageApiProtoIT");
    private static final String PROJECT = ((GcpOptions)TestPipeline.testingPipelineOptions().as(GcpOptions.class)).getProject();
    private static final String BIG_QUERY_DATASET_ID = "table_row_to_storage_api_proto_" + System.nanoTime();
    private static final TableSchema BASE_TABLE_SCHEMA = new TableSchema().setFields((List)ImmutableList.builder().add((Object)new TableFieldSchema().setType("STRING").setName("stringValue")).add((Object)new TableFieldSchema().setType("BYTES").setName("bytesValue")).add((Object)new TableFieldSchema().setType("INT64").setName("int64Value")).add((Object)new TableFieldSchema().setType("INTEGER").setName("intValue")).add((Object)new TableFieldSchema().setType("FLOAT64").setName("float64Value")).add((Object)new TableFieldSchema().setType("FLOAT").setName("floatValue")).add((Object)new TableFieldSchema().setType("BOOL").setName("boolValue")).add((Object)new TableFieldSchema().setType("BOOLEAN").setName("booleanValue")).add((Object)new TableFieldSchema().setType("TIMESTAMP").setName("timestampValue")).add((Object)new TableFieldSchema().setType("TIME").setName("timeValue")).add((Object)new TableFieldSchema().setType("DATETIME").setName("datetimeValue")).add((Object)new TableFieldSchema().setType("DATE").setName("dateValue")).add((Object)new TableFieldSchema().setType("NUMERIC").setName("numericValue")).add((Object)new TableFieldSchema().setType("BIGNUMERIC").setName("bigNumericValue")).add((Object)new TableFieldSchema().setType("BYTES").setMode("REPEATED").setName("arrayValue")).build());
    private static final List<Object> REPEATED_BYTES = ImmutableList.of((Object)BaseEncoding.base64().encode("hello".getBytes(StandardCharsets.UTF_8)), (Object)"goodbye".getBytes(StandardCharsets.UTF_8), (Object)"solong".getBytes(StandardCharsets.UTF_8));
    private static final TableRow BASE_TABLE_ROW = new TableRow().set("stringValue", (Object)"string").set("bytesValue", (Object)BaseEncoding.base64().encode("string".getBytes(StandardCharsets.UTF_8))).set("int64Value", (Object)"42").set("intValue", (Object)"43").set("float64Value", (Object)"2.8168").set("floatValue", (Object)"2.817").set("boolValue", (Object)"true").set("booleanValue", (Object)"true").set("timestampValue", (Object)"1970-01-01T00:00:00.000043Z").set("timeValue", (Object)"00:52:07.123456").set("datetimeValue", (Object)"2019-08-16T00:52:07.123456").set("dateValue", (Object)"2019-08-16").set("numericValue", (Object)"23.4").set("bigNumericValue", (Object)"23334.4").set("arrayValue", REPEATED_BYTES);
    private static final TableRow BASE_TABLE_ROW_JODA_TIME = new TableRow().set("stringValue", (Object)"string").set("bytesValue", (Object)"string".getBytes(StandardCharsets.UTF_8)).set("int64Value", (Object)42).set("intValue", (Object)43).set("float64Value", (Object)Float.valueOf(2.8168f)).set("floatValue", (Object)Float.valueOf(2.817f)).set("boolValue", (Object)true).set("booleanValue", (Object)true).set("timestampValue", (Object)org.joda.time.Instant.parse((String)"1970-01-01T00:00:00.0043Z")).set("timeValue", (Object)LocalTime.parse((String)"00:52:07.123456")).set("datetimeValue", (Object)LocalDateTime.parse((String)"2019-08-16T00:52:07.123456")).set("dateValue", (Object)org.joda.time.LocalDate.parse((String)"2019-08-16")).set("numericValue", (Object)new BigDecimal("23.4")).set("bigNumericValue", (Object)"23334.4").set("arrayValue", REPEATED_BYTES);
    private static final TableRow BASE_TABLE_ROW_JAVA_TIME = new TableRow().set("stringValue", (Object)"string").set("bytesValue", (Object)"string".getBytes(StandardCharsets.UTF_8)).set("int64Value", (Object)42).set("intValue", (Object)43).set("float64Value", (Object)Float.valueOf(2.8168f)).set("floatValue", (Object)Float.valueOf(2.817f)).set("boolValue", (Object)true).set("booleanValue", (Object)true).set("timestampValue", (Object)Instant.parse("1970-01-01T00:00:00.000043Z")).set("timeValue", (Object)java.time.LocalTime.parse("00:52:07.123456")).set("datetimeValue", (Object)java.time.LocalDateTime.parse("2019-08-16T00:52:07.123456")).set("dateValue", (Object)LocalDate.parse("2019-08-16")).set("numericValue", (Object)new BigDecimal("23.4")).set("bigNumericValue", (Object)"23334.4").set("arrayValue", REPEATED_BYTES);
    private static final TableRow BASE_TABLE_ROW_NUM_TIME = new TableRow().set("stringValue", (Object)"string").set("bytesValue", (Object)"string".getBytes(StandardCharsets.UTF_8)).set("int64Value", (Object)42).set("intValue", (Object)43).set("float64Value", (Object)Float.valueOf(2.8168f)).set("floatValue", (Object)Float.valueOf(2.817f)).set("boolValue", (Object)true).set("booleanValue", (Object)true).set("timestampValue", (Object)43).set("timeValue", (Object)3497124416L).set("datetimeValue", (Object)142111881387172416L).set("dateValue", (Object)18124).set("numericValue", (Object)new BigDecimal("23.4")).set("bigNumericValue", (Object)"23334.4").set("arrayValue", REPEATED_BYTES);
    private static final TableRow BASE_TABLE_ROW_FLOATS = new TableRow().set("stringValue", (Object)"string").set("bytesValue", (Object)"string".getBytes(StandardCharsets.UTF_8)).set("int64Value", (Object)42).set("intValue", (Object)43).set("float64Value", (Object)Float.valueOf(2.8168f)).set("floatValue", (Object)Float.valueOf(2.817f)).set("boolValue", (Object)true).set("booleanValue", (Object)true).set("timestampValue", (Object)43).set("timeValue", (Object)3497124416L).set("datetimeValue", (Object)1.4211188138717242E17).set("dateValue", (Object)18124).set("numericValue", (Object)23.4).set("bigNumericValue", (Object)"23334.4").set("arrayValue", REPEATED_BYTES);
    private static final TableRow BASE_TABLE_ROW_NULL = new TableRow().set("bytesValue", null).set("int64Value", null).set("intValue", null).set("float64Value", null).set("floatValue", null).set("boolValue", null).set("booleanValue", null).set("timestampValue", null).set("timeValue", null).set("datetimeValue", null).set("dateValue", null).set("numericValue", null).set("arrayValue", null);
    private static final List<Object> REPEATED_BYTES_EXPECTED = ImmutableList.of((Object)BaseEncoding.base64().encode("hello".getBytes(StandardCharsets.UTF_8)), (Object)BaseEncoding.base64().encode("goodbye".getBytes(StandardCharsets.UTF_8)), (Object)BaseEncoding.base64().encode("solong".getBytes(StandardCharsets.UTF_8)));
    private static final TableRow BASE_TABLE_ROW_EXPECTED = new TableRow().set("stringValue", (Object)"string").set("bytesValue", (Object)BaseEncoding.base64().encode("string".getBytes(StandardCharsets.UTF_8))).set("int64Value", (Object)"42").set("intValue", (Object)"43").set("float64Value", (Object)2.8168).set("floatValue", (Object)2.817).set("boolValue", (Object)true).set("booleanValue", (Object)true).set("timestampValue", (Object)"4.3E-5").set("timeValue", (Object)"00:52:07.123456").set("datetimeValue", (Object)"2019-08-16T00:52:07.123456").set("dateValue", (Object)"2019-08-16").set("numericValue", (Object)"23.4").set("bigNumericValue", (Object)"23334.4").set("arrayValue", REPEATED_BYTES_EXPECTED);
    private static final TableRow BASE_TABLE_ROW_JODA_EXPECTED = new TableRow().set("stringValue", (Object)"string").set("bytesValue", (Object)BaseEncoding.base64().encode("string".getBytes(StandardCharsets.UTF_8))).set("int64Value", (Object)"42").set("intValue", (Object)"43").set("float64Value", (Object)2.8168).set("floatValue", (Object)2.817).set("boolValue", (Object)true).set("booleanValue", (Object)true).set("timestampValue", (Object)"0.004").set("timeValue", (Object)"00:52:07.123000").set("datetimeValue", (Object)"2019-08-16T00:52:07.123000").set("dateValue", (Object)"2019-08-16").set("numericValue", (Object)"23.4").set("bigNumericValue", (Object)"23334.4").set("arrayValue", REPEATED_BYTES_EXPECTED);
    private static final TableRow BASE_TABLE_ROW_NUM_EXPECTED = new TableRow().set("stringValue", (Object)"string").set("bytesValue", (Object)BaseEncoding.base64().encode("string".getBytes(StandardCharsets.UTF_8))).set("int64Value", (Object)"42").set("intValue", (Object)"43").set("float64Value", (Object)2.8168).set("floatValue", (Object)2.817).set("boolValue", (Object)true).set("booleanValue", (Object)true).set("timestampValue", (Object)"4.3E-5").set("timeValue", (Object)"00:52:07.123456").set("datetimeValue", (Object)"2019-08-16T00:52:07.123456").set("dateValue", (Object)"2019-08-16").set("numericValue", (Object)"23.4").set("bigNumericValue", (Object)"23334.4").set("arrayValue", REPEATED_BYTES_EXPECTED);
    private static final TableRow BASE_TABLE_ROW_FLOATS_EXPECTED = new TableRow().set("stringValue", (Object)"string").set("bytesValue", (Object)BaseEncoding.base64().encode("string".getBytes(StandardCharsets.UTF_8))).set("int64Value", (Object)"42").set("intValue", (Object)"43").set("float64Value", (Object)2.8168).set("floatValue", (Object)2.817).set("boolValue", (Object)true).set("booleanValue", (Object)true).set("timestampValue", (Object)"4.3E-5").set("timeValue", (Object)"00:52:07.123456").set("datetimeValue", (Object)"2019-08-16T00:52:07.123456").set("dateValue", (Object)"2019-08-16").set("numericValue", (Object)"23.4").set("bigNumericValue", (Object)"23334.4").set("arrayValue", REPEATED_BYTES_EXPECTED);
    private static final TableRow BASE_TABLE_ROW_NULL_EXPECTED = new TableRow().set("arrayValue", (Object)ImmutableList.of());
    private static final TableSchema NESTED_TABLE_SCHEMA = new TableSchema().setFields((List)ImmutableList.builder().add((Object)new TableFieldSchema().setType("STRUCT").setName("nestedValue1").setMode("REQUIRED").setFields(BASE_TABLE_SCHEMA.getFields())).add((Object)new TableFieldSchema().setType("RECORD").setName("nestedValue2").setMode("REPEATED").setFields(BASE_TABLE_SCHEMA.getFields())).add((Object)new TableFieldSchema().setType("RECORD").setName("nestedValue3").setMode("NULLABLE").setFields(BASE_TABLE_SCHEMA.getFields())).build());

    @BeforeClass
    public static void setUpTestEnvironment() throws IOException, InterruptedException {
        BQ_CLIENT.createNewDataset(PROJECT, BIG_QUERY_DATASET_ID);
    }

    @AfterClass
    public static void cleanup() {
        LOG.info("Start to clean up tables and datasets.");
        BQ_CLIENT.deleteDataset(PROJECT, BIG_QUERY_DATASET_ID);
    }

    @Test
    public void testBaseTableRow() throws IOException, InterruptedException {
        String tableSpec = TableRowToStorageApiProtoIT.createTable(BASE_TABLE_SCHEMA);
        TableRowToStorageApiProtoIT.runPipeline(tableSpec, Collections.singleton(BASE_TABLE_ROW));
        List actualTableRows = BQ_CLIENT.queryUnflattened(String.format("SELECT * FROM [%s]", tableSpec), PROJECT, true);
        Assert.assertEquals((long)1L, (long)actualTableRows.size());
        Assert.assertEquals((Object)BASE_TABLE_ROW_EXPECTED, actualTableRows.get(0));
    }

    @Test
    public void testNestedRichTypesAndNull() throws IOException, InterruptedException {
        String tableSpec = TableRowToStorageApiProtoIT.createTable(NESTED_TABLE_SCHEMA);
        TableRow tableRow = new TableRow().set("nestedValue1", (Object)BASE_TABLE_ROW).set("nestedValue2", Arrays.asList(BASE_TABLE_ROW_JAVA_TIME, BASE_TABLE_ROW_JODA_TIME, BASE_TABLE_ROW_NUM_TIME, BASE_TABLE_ROW_FLOATS, BASE_TABLE_ROW_NULL)).set("nestedValue3", null);
        TableRowToStorageApiProtoIT.runPipeline(tableSpec, Collections.singleton(tableRow));
        List actualTableRows = BQ_CLIENT.queryUnflattened(String.format("SELECT * FROM [%s]", tableSpec), PROJECT, true);
        Assert.assertEquals((long)1L, (long)actualTableRows.size());
        Assert.assertEquals((Object)BASE_TABLE_ROW_EXPECTED, (Object)((TableRow)actualTableRows.get(0)).get((Object)"nestedValue1"));
        Assert.assertEquals((Object)ImmutableList.of((Object)BASE_TABLE_ROW_EXPECTED, (Object)BASE_TABLE_ROW_JODA_EXPECTED, (Object)BASE_TABLE_ROW_NUM_EXPECTED, (Object)BASE_TABLE_ROW_FLOATS_EXPECTED, (Object)BASE_TABLE_ROW_NULL_EXPECTED), (Object)((TableRow)actualTableRows.get(0)).get((Object)"nestedValue2"));
        Assert.assertNull((Object)((TableRow)actualTableRows.get(0)).get((Object)"nestedValue3"));
    }

    private static String createTable(TableSchema tableSchema) throws IOException, InterruptedException {
        String table = "table" + System.nanoTime();
        BQ_CLIENT.deleteTable(PROJECT, BIG_QUERY_DATASET_ID, table);
        BQ_CLIENT.createNewTable(PROJECT, BIG_QUERY_DATASET_ID, new Table().setSchema(tableSchema).setTableReference(new TableReference().setTableId(table).setDatasetId(BIG_QUERY_DATASET_ID).setProjectId(PROJECT)));
        return PROJECT + ":" + BIG_QUERY_DATASET_ID + "." + table;
    }

    private static void runPipeline(String tableSpec, Iterable<TableRow> tableRows) {
        Pipeline p = Pipeline.create();
        ((PCollection)p.apply("Create test cases", (PTransform)Create.of(tableRows))).apply("Write using Storage Write API", (PTransform)BigQueryIO.write().to(tableSpec).withFormatFunction(SerializableFunctions.identity()).withMethod(BigQueryIO.Write.Method.STORAGE_WRITE_API).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_NEVER));
        p.run().waitUntilFinish();
    }
}

