/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySchemaTransformWriteConfiguration;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySchemaTransformWriteProvider;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.testing.FakeBigQueryServices;
import org.apache.beam.sdk.io.gcp.testing.FakeDatasetService;
import org.apache.beam.sdk.io.gcp.testing.FakeJobService;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.InvalidConfigurationException;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BigQuerySchemaTransformWriteProviderTest {
    private static final String PROJECT = "fakeproject";
    private static final String DATASET = "fakedataset";
    private static final String TABLE_ID = "faketable";
    private static final TableReference TABLE_REFERENCE = new TableReference().setProjectId("fakeproject").setDatasetId("fakedataset").setTableId("faketable");
    private static final Schema SCHEMA = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"name", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"number", (Schema.FieldType)Schema.FieldType.INT64)});
    private static final TableSchema TABLE_SCHEMA = BigQueryUtils.toTableSchema((Schema)SCHEMA);
    private static final List<Row> ROWS = Arrays.asList(Row.withSchema((Schema)SCHEMA).withFieldValue("name", (Object)"a").withFieldValue("number", (Object)1L).build(), Row.withSchema((Schema)SCHEMA).withFieldValue("name", (Object)"b").withFieldValue("number", (Object)2L).build(), Row.withSchema((Schema)SCHEMA).withFieldValue("name", (Object)"c").withFieldValue("number", (Object)3L).build());
    private static final BigQueryOptions OPTIONS = (BigQueryOptions)TestPipeline.testingPipelineOptions().as(BigQueryOptions.class);
    private final FakeDatasetService fakeDatasetService = new FakeDatasetService();
    private final FakeJobService fakeJobService = new FakeJobService();
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final FakeBigQueryServices fakeBigQueryServices = new FakeBigQueryServices().withJobService((BigQueryServices.JobService)this.fakeJobService).withDatasetService(this.fakeDatasetService);
    @Rule
    public transient TestPipeline p = TestPipeline.fromOptions((PipelineOptions)OPTIONS);

    @Before
    public void setUp() throws IOException, InterruptedException {
        FakeDatasetService.setUp();
        this.fakeDatasetService.createDataset(PROJECT, DATASET, "", "", null);
        this.temporaryFolder.create();
        OPTIONS.setProject(PROJECT);
        OPTIONS.setTempLocation(this.temporaryFolder.getRoot().getAbsolutePath());
    }

    @After
    public void tearDown() {
        this.temporaryFolder.delete();
    }

    @Test
    public void testLoad() throws IOException, InterruptedException {
        BigQuerySchemaTransformWriteProvider provider = new BigQuerySchemaTransformWriteProvider();
        BigQuerySchemaTransformWriteConfiguration configuration = BigQuerySchemaTransformWriteConfiguration.builder().setTableSpec(BigQueryHelpers.toTableSpec((TableReference)TABLE_REFERENCE)).setWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE.name()).setCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED.name()).build();
        Row configurationRow = configuration.toBeamRow();
        SchemaTransform schemaTransform = provider.from(configurationRow);
        BigQuerySchemaTransformWriteProvider.PCollectionRowTupleTransform pCollectionRowTupleTransform = (BigQuerySchemaTransformWriteProvider.PCollectionRowTupleTransform)schemaTransform.buildTransform();
        pCollectionRowTupleTransform.setTestBigQueryServices((BigQueryServices)this.fakeBigQueryServices);
        String tag = (String)provider.inputCollectionNames().get(0);
        PCollectionRowTuple input = PCollectionRowTuple.of((String)tag, (PCollection)((PCollection)this.p.apply((PTransform)Create.of(ROWS).withRowSchema(SCHEMA))));
        input.apply((PTransform)pCollectionRowTupleTransform);
        this.p.run();
        Assert.assertNotNull((Object)this.fakeDatasetService.getTable(TABLE_REFERENCE));
        Assert.assertEquals((long)ROWS.size(), (long)this.fakeDatasetService.getAllRows(PROJECT, DATASET, TABLE_ID).size());
    }

    @Test
    public void testValidatePipelineOptions() {
        List<Pair> cases = Arrays.asList(Pair.of((Object)BigQuerySchemaTransformWriteConfiguration.builder().setTableSpec("project.doesnot.exist").setCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_NEVER.name()).setWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND.name()), InvalidConfigurationException.class), Pair.of((Object)BigQuerySchemaTransformWriteConfiguration.builder().setTableSpec(String.format("%s.%s.%s", PROJECT, DATASET, "doesnotexist")).setCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_NEVER.name()).setWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_EMPTY.name()), InvalidConfigurationException.class), Pair.of((Object)BigQuerySchemaTransformWriteConfiguration.builder().setTableSpec("project.doesnot.exist").setCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED.name()).setWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND.name()), null));
        for (Pair caze : cases) {
            BigQuerySchemaTransformWriteProvider.PCollectionRowTupleTransform transform = this.transformFrom(((BigQuerySchemaTransformWriteConfiguration.Builder)caze.getLeft()).build());
            if (caze.getRight() != null) {
                Assert.assertThrows((Class)((Class)caze.getRight()), () -> transform.validate(this.p.getOptions()));
                continue;
            }
            transform.validate(this.p.getOptions());
        }
    }

    @Test
    public void testToWrite() {
        List<Pair> cases = Arrays.asList(Pair.of((Object)BigQuerySchemaTransformWriteConfiguration.builder().setTableSpec(BigQueryHelpers.toTableSpec((TableReference)TABLE_REFERENCE)).setCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_NEVER.name()).setWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_EMPTY.name()), (Object)BigQueryIO.writeTableRows().to(TABLE_REFERENCE).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_NEVER).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_EMPTY).withSchema(TABLE_SCHEMA)), Pair.of((Object)BigQuerySchemaTransformWriteConfiguration.builder().setTableSpec(BigQueryHelpers.toTableSpec((TableReference)TABLE_REFERENCE)).setCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED.name()).setWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE.name()), (Object)BigQueryIO.writeTableRows().to(TABLE_REFERENCE).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE).withSchema(TABLE_SCHEMA)));
        for (Pair caze : cases) {
            BigQuerySchemaTransformWriteProvider.PCollectionRowTupleTransform transform = this.transformFrom(((BigQuerySchemaTransformWriteConfiguration.Builder)caze.getLeft()).build());
            Map gotDisplayData = DisplayData.from((HasDisplayData)transform.toWrite(SCHEMA)).asMap();
            Map wantDisplayData = DisplayData.from((HasDisplayData)((HasDisplayData)caze.getRight())).asMap();
            HashSet keys = new HashSet();
            keys.addAll(gotDisplayData.keySet());
            keys.addAll(wantDisplayData.keySet());
            for (DisplayData.Identifier key : keys) {
                DisplayData.Item got = null;
                DisplayData.Item want = null;
                if (gotDisplayData.containsKey(key)) {
                    got = (DisplayData.Item)gotDisplayData.get(key);
                }
                if (wantDisplayData.containsKey(key)) {
                    want = (DisplayData.Item)wantDisplayData.get(key);
                }
                Assert.assertEquals(want, (Object)got);
            }
        }
    }

    @Test
    public void validatePCollectionRowTupleInput() {
        PCollectionRowTuple empty = PCollectionRowTuple.empty((Pipeline)this.p);
        PCollectionRowTuple valid = PCollectionRowTuple.of((String)"INPUT", (PCollection)((PCollection)this.p.apply("CreateRowsWithValidSchema", (PTransform)Create.of(ROWS))).setRowSchema(SCHEMA));
        PCollectionRowTuple invalid = PCollectionRowTuple.of((String)"INPUT", (PCollection)((PCollection)this.p.apply("CreateRowsWithInvalidSchema", (PTransform)Create.of((Object)Row.nullRow((Schema)Schema.builder().addNullableField("name", Schema.FieldType.STRING).build()), (Object[])new Row[0]))));
        BigQuerySchemaTransformWriteProvider.PCollectionRowTupleTransform transform = this.transformFrom(BigQuerySchemaTransformWriteConfiguration.builder().setTableSpec(BigQueryHelpers.toTableSpec((TableReference)TABLE_REFERENCE)).setCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED.name()).setWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND.name()).build());
        Assert.assertThrows(IllegalArgumentException.class, () -> transform.validate(empty));
        Assert.assertThrows(IllegalStateException.class, () -> transform.validate(invalid));
        transform.validate(valid);
        this.p.run();
    }

    private BigQuerySchemaTransformWriteProvider.PCollectionRowTupleTransform transformFrom(BigQuerySchemaTransformWriteConfiguration configuration) {
        BigQuerySchemaTransformWriteProvider provider = new BigQuerySchemaTransformWriteProvider();
        BigQuerySchemaTransformWriteProvider.PCollectionRowTupleTransform transform = (BigQuerySchemaTransformWriteProvider.PCollectionRowTupleTransform)provider.from(configuration.toBeamRow()).buildTransform();
        transform.setTestBigQueryServices((BigQueryServices)this.fakeBigQueryServices);
        return transform;
    }
}

