/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySchemaTransformReadConfiguration;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySchemaTransformReadProvider;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.testing.FakeBigQueryServices;
import org.apache.beam.sdk.io.gcp.testing.FakeDatasetService;
import org.apache.beam.sdk.io.gcp.testing.FakeJobService;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.commons.lang3.tuple.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQuerySchemaTransformReadProviderTest {
    private static final String PROJECT = "fakeproject";
    private static final String DATASET = "fakedataset";
    private static final String TABLE_ID = "faketable";
    private static final String QUERY = "select * from `fakeproject.fakedataset.faketable`";
    private static final String LOCATION = "kingdom-of-figaro";
    private static final TableReference TABLE_REFERENCE = new TableReference().setProjectId("fakeproject").setDatasetId("fakedataset").setTableId("faketable");
    private static final String TABLE_SPEC = BigQueryHelpers.toTableSpec((TableReference)TABLE_REFERENCE);
    private static final Schema SCHEMA = Schema.of((Schema.Field[])new Schema.Field[]{Schema.Field.of((String)"name", (Schema.FieldType)Schema.FieldType.STRING), Schema.Field.of((String)"number", (Schema.FieldType)Schema.FieldType.INT64)});
    private static final List<TableRow> RECORDS = Arrays.asList(new TableRow().set("name", (Object)"a").set("number", (Object)1L), new TableRow().set("name", (Object)"b").set("number", (Object)2L), new TableRow().set("name", (Object)"c").set("number", (Object)3L));
    private static final List<Row> ROWS = Arrays.asList(Row.withSchema((Schema)SCHEMA).withFieldValue("name", (Object)"a").withFieldValue("number", (Object)1L).build(), Row.withSchema((Schema)SCHEMA).withFieldValue("name", (Object)"b").withFieldValue("number", (Object)2L).build(), Row.withSchema((Schema)SCHEMA).withFieldValue("name", (Object)"c").withFieldValue("number", (Object)3L).build());
    private static final TableSchema TABLE_SCHEMA = BigQueryUtils.toTableSchema((Schema)SCHEMA);
    private static final BigQueryOptions OPTIONS = (BigQueryOptions)TestPipeline.testingPipelineOptions().as(BigQueryOptions.class);
    private final FakeDatasetService fakeDatasetService = new FakeDatasetService();
    private final FakeJobService fakeJobService = new FakeJobService();
    private final Table fakeTable = new Table();
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private final FakeBigQueryServices fakeBigQueryServices = new FakeBigQueryServices().withJobService((BigQueryServices.JobService)this.fakeJobService).withDatasetService(this.fakeDatasetService);
    @Rule
    public transient TestPipeline p = TestPipeline.fromOptions((PipelineOptions)OPTIONS).enableAbandonedNodeEnforcement(false);

    @Before
    public void setUp() throws IOException, InterruptedException, ExecutionException {
        FakeDatasetService.setUp();
        FakeJobService.setUp();
        BigQueryIO.clearStaticCaches();
        this.fakeTable.setSchema(TABLE_SCHEMA);
        this.fakeTable.setTableReference(TABLE_REFERENCE);
        this.fakeDatasetService.createDataset(PROJECT, DATASET, LOCATION, "", null);
        this.fakeDatasetService.createTable(this.fakeTable);
        this.fakeDatasetService.insertAll(this.fakeTable.getTableReference(), RECORDS, null);
        this.temporaryFolder.create();
        OPTIONS.setProject(PROJECT);
        OPTIONS.setTempLocation(this.temporaryFolder.getRoot().getAbsolutePath());
    }

    @After
    public void tearDown() {
        this.temporaryFolder.delete();
    }

    @Test
    public void testQuery() {
        List<Pair> cases = Arrays.asList(Pair.of((Object)BigQuerySchemaTransformReadConfiguration.builder().setQuery(QUERY), (Object)BigQueryIO.readTableRowsWithSchema().fromQuery(QUERY)), Pair.of((Object)BigQuerySchemaTransformReadConfiguration.builder().setQuery(QUERY).setQueryLocation(LOCATION), (Object)BigQueryIO.readTableRowsWithSchema().fromQuery(QUERY).withQueryLocation(LOCATION)), Pair.of((Object)BigQuerySchemaTransformReadConfiguration.builder().setQuery(QUERY).setUseStandardSql(Boolean.valueOf(true)), (Object)BigQueryIO.readTableRowsWithSchema().fromQuery(QUERY).usingStandardSql()), Pair.of((Object)BigQuerySchemaTransformReadConfiguration.builder().setQuery(QUERY).setUseStandardSql(Boolean.valueOf(false)), (Object)BigQueryIO.readTableRowsWithSchema().fromQuery(QUERY)));
        for (Pair caze : cases) {
            Map want = DisplayData.from((HasDisplayData)((HasDisplayData)caze.getRight())).asMap();
            BigQuerySchemaTransformReadProvider provider = new BigQuerySchemaTransformReadProvider();
            BigQuerySchemaTransformReadConfiguration configuration = ((BigQuerySchemaTransformReadConfiguration.Builder)caze.getLeft()).build();
            Row configurationRow = configuration.toBeamRow();
            SchemaTransform schemaTransform = provider.from(configurationRow);
            BigQuerySchemaTransformReadProvider.PCollectionRowTupleTransform pCollectionRowTupleTransform = (BigQuerySchemaTransformReadProvider.PCollectionRowTupleTransform)schemaTransform.buildTransform();
            Map got = DisplayData.from((HasDisplayData)pCollectionRowTupleTransform.toTypedRead()).asMap();
            this.assertEquals(want, got);
        }
    }

    @Test
    public void testExtract() {
        BigQuerySchemaTransformReadProvider provider = new BigQuerySchemaTransformReadProvider();
        BigQuerySchemaTransformReadConfiguration configuration = BigQuerySchemaTransformReadConfiguration.builder().setTableSpec(TABLE_SPEC).build();
        Row configurationRow = configuration.toBeamRow();
        SchemaTransform schemaTransform = provider.from(configurationRow);
        BigQuerySchemaTransformReadProvider.PCollectionRowTupleTransform pCollectionRowTupleTransform = (BigQuerySchemaTransformReadProvider.PCollectionRowTupleTransform)schemaTransform.buildTransform();
        pCollectionRowTupleTransform.setTestBigQueryServices((BigQueryServices)this.fakeBigQueryServices);
        PCollectionRowTuple input = PCollectionRowTuple.empty((Pipeline)this.p);
        String tag = (String)provider.outputCollectionNames().get(0);
        PCollectionRowTuple output = (PCollectionRowTuple)input.apply((PTransform)pCollectionRowTupleTransform);
        Assert.assertTrue((boolean)output.has(tag));
        PCollection got = output.get(tag);
        PAssert.that((PCollection)got).containsInAnyOrder(ROWS);
        this.p.run();
    }

    @Test
    public void testInvalidConfiguration() {
        BigQuerySchemaTransformReadProvider provider = new BigQuerySchemaTransformReadProvider();
        for (Pair caze : Arrays.asList(Pair.of((Object)BigQuerySchemaTransformReadConfiguration.builder(), IllegalArgumentException.class), Pair.of((Object)BigQuerySchemaTransformReadConfiguration.builder().setQuery(QUERY).setTableSpec(TABLE_SPEC), IllegalStateException.class), Pair.of((Object)BigQuerySchemaTransformReadConfiguration.builder().setQueryLocation(LOCATION), IllegalArgumentException.class), Pair.of((Object)BigQuerySchemaTransformReadConfiguration.builder().setUseStandardSql(Boolean.valueOf(true)), IllegalArgumentException.class))) {
            Row configurationRow = ((BigQuerySchemaTransformReadConfiguration.Builder)caze.getLeft()).build().toBeamRow();
            SchemaTransform schemaTransform = provider.from(configurationRow);
            BigQuerySchemaTransformReadProvider.PCollectionRowTupleTransform pCollectionRowTupleTransform = (BigQuerySchemaTransformReadProvider.PCollectionRowTupleTransform)schemaTransform.buildTransform();
            pCollectionRowTupleTransform.setTestBigQueryServices((BigQueryServices)this.fakeBigQueryServices);
            PCollectionRowTuple empty = PCollectionRowTuple.empty((Pipeline)this.p);
            Assert.assertThrows((Class)((Class)caze.getRight()), () -> {
                PCollectionRowTuple cfr_ignored_0 = (PCollectionRowTuple)empty.apply((PTransform)pCollectionRowTupleTransform);
            });
        }
    }

    @Test
    public void testInvalidInput() {
        BigQuerySchemaTransformReadProvider provider = new BigQuerySchemaTransformReadProvider();
        BigQuerySchemaTransformReadConfiguration configuration = BigQuerySchemaTransformReadConfiguration.builder().setTableSpec(TABLE_SPEC).build();
        Row configurationRow = configuration.toBeamRow();
        SchemaTransform schemaTransform = provider.from(configurationRow);
        BigQuerySchemaTransformReadProvider.PCollectionRowTupleTransform pCollectionRowTupleTransform = (BigQuerySchemaTransformReadProvider.PCollectionRowTupleTransform)schemaTransform.buildTransform();
        pCollectionRowTupleTransform.setTestBigQueryServices((BigQueryServices)this.fakeBigQueryServices);
        PCollectionRowTuple input = PCollectionRowTuple.of((String)"badinput", (PCollection)((PCollection)this.p.apply((PTransform)Create.of(ROWS))));
        Assert.assertThrows(IllegalArgumentException.class, () -> {
            PCollectionRowTuple cfr_ignored_0 = (PCollectionRowTuple)input.apply((PTransform)pCollectionRowTupleTransform);
        });
    }

    private void assertEquals(Map<DisplayData.Identifier, DisplayData.Item> want, Map<DisplayData.Identifier, DisplayData.Item> got) {
        HashSet<DisplayData.Identifier> keys = new HashSet<DisplayData.Identifier>();
        keys.addAll(want.keySet());
        keys.addAll(got.keySet());
        for (DisplayData.Identifier key : keys) {
            DisplayData.Item wantItem = null;
            DisplayData.Item gotItem = null;
            if (want.containsKey(key)) {
                wantItem = want.get(key);
            }
            if (got.containsKey(key)) {
                gotItem = got.get(key);
            }
            Assert.assertEquals((Object)wantItem, gotItem);
        }
    }
}

