/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.QueryResponse;
import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.testing.BigqueryClient;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryIOStorageWriteIT {
    private String project;
    private static final String DATASET_ID = "big_query_storage";
    private static final String TABLE_PREFIX = "storage_write_";
    private BigQueryOptions bqOptions;
    private static final BigqueryClient BQ_CLIENT = new BigqueryClient("BigQueryStorageIOWriteIT");

    private void setUpTestEnvironment(WriteMode writeMode) {
        PipelineOptionsFactory.register(BigQueryOptions.class);
        this.bqOptions = (BigQueryOptions)TestPipeline.testingPipelineOptions().as(BigQueryOptions.class);
        this.bqOptions.setProject(((GcpOptions)TestPipeline.testingPipelineOptions().as(GcpOptions.class)).getProject());
        this.bqOptions.setUseStorageWriteApi(Boolean.valueOf(true));
        if (writeMode == WriteMode.AT_LEAST_ONCE) {
            this.bqOptions.setUseStorageWriteApiAtLeastOnce(Boolean.valueOf(true));
        }
        this.bqOptions.setNumStorageWriteApiStreams(Integer.valueOf(2));
        this.bqOptions.setStorageWriteApiTriggeringFrequencySec(Integer.valueOf(1));
        this.project = ((GcpOptions)TestPipeline.testingPipelineOptions().as(GcpOptions.class)).getProject();
    }

    private void runBigQueryIOStorageWritePipeline(int rowCount, WriteMode writeMode) {
        String tableName = TABLE_PREFIX + System.currentTimeMillis();
        TableSchema schema = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("number").setType("INTEGER"), (Object)new TableFieldSchema().setName("str").setType("STRING")));
        Pipeline p = Pipeline.create((PipelineOptions)this.bqOptions);
        ((PCollection)((PCollection)p.apply("Input", (PTransform)GenerateSequence.from((long)0L).to((long)rowCount))).apply("GenerateMessage", (PTransform)ParDo.of((DoFn)new FillRowFn()))).apply("WriteToBQ", (PTransform)BigQueryIO.writeTableRows().to(String.format("%s:%s.%s", this.project, DATASET_ID, tableName)).withSchema(schema).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND));
        p.run().waitUntilFinish();
        String testQuery = String.format("SELECT count(*) FROM [%s.%s];", DATASET_ID, tableName);
        try {
            QueryResponse response = BQ_CLIENT.queryWithRetries(testQuery, this.project);
            if (writeMode == WriteMode.EXACT_ONCE) {
                Assert.assertEquals((long)Integer.parseInt((String)((TableCell)((TableRow)response.getRows().get(0)).getF().get(0)).getV()), (long)rowCount);
            } else {
                Assert.assertTrue((Integer.parseInt((String)((TableCell)((TableRow)response.getRows().get(0)).getF().get(0)).getV()) >= rowCount ? 1 : 0) != 0);
            }
        }
        catch (IOException e) {
            Assert.assertTrue((String)("Unexpected exception: " + e.toString()), (boolean)false);
        }
        catch (InterruptedException e) {
            Assert.assertTrue((String)("Unexpected exception: " + e.toString()), (boolean)false);
        }
    }

    @Test
    public void testBigQueryStorageWrite30MProto() throws Exception {
        this.setUpTestEnvironment(WriteMode.EXACT_ONCE);
        this.runBigQueryIOStorageWritePipeline(3000000, WriteMode.EXACT_ONCE);
    }

    @Test
    public void testBigQueryStorageWrite30MProtoALO() throws Exception {
        this.setUpTestEnvironment(WriteMode.AT_LEAST_ONCE);
        this.runBigQueryIOStorageWritePipeline(3000000, WriteMode.AT_LEAST_ONCE);
    }

    static class FillRowFn
    extends DoFn<Long, TableRow> {
        FillRowFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            c.output((Object)new TableRow().set("number", c.element()).set("str", (Object)"aaaaaaaaaa"));
        }
    }

    private static enum WriteMode {
        EXACT_ONCE,
        AT_LEAST_ONCE;

    }
}

