/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.cloud.bigquery.storage.v1.DataFormat;
import java.io.Serializable;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.Count;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class BigQueryIOStorageReadIT {
    private static final Map<String, Long> EXPECTED_NUM_RECORDS = ImmutableMap.of((Object)"empty", (Object)0L, (Object)"1M", (Object)10592L, (Object)"1G", (Object)11110839L, (Object)"1T", (Object)11110839000L, (Object)"multi_field", (Object)11110839L);
    private static final String DATASET_ID = "big_query_storage";
    private static final String TABLE_PREFIX = "storage_read_";
    private BigQueryIOStorageReadOptions options;

    private void setUpTestEnvironment(String tableSize, DataFormat format) {
        PipelineOptionsFactory.register(BigQueryIOStorageReadOptions.class);
        this.options = (BigQueryIOStorageReadOptions)TestPipeline.testingPipelineOptions().as(BigQueryIOStorageReadOptions.class);
        this.options.setNumRecords(EXPECTED_NUM_RECORDS.get(tableSize));
        this.options.setDataFormat(format);
        String project = ((GcpOptions)TestPipeline.testingPipelineOptions().as(GcpOptions.class)).getProject();
        this.options.setInputTable(project + ":" + DATASET_ID + "." + TABLE_PREFIX + tableSize);
    }

    private void runBigQueryIOStorageReadPipeline() {
        Pipeline p = Pipeline.create((PipelineOptions)this.options);
        PCollection count = (PCollection)((PCollection)p.apply("Read", (PTransform)BigQueryIO.read((SerializableFunction)BigQueryIO.TableRowParser.INSTANCE).from(this.options.getInputTable()).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).withFormat(this.options.getDataFormat()))).apply("Count", Count.globally());
        PAssert.thatSingleton((PCollection)count).isEqualTo((Object)this.options.getNumRecords());
        p.run().waitUntilFinish();
    }

    @Test
    public void testBigQueryStorageRead1GAvro() throws Exception {
        this.setUpTestEnvironment("1G", DataFormat.AVRO);
        this.runBigQueryIOStorageReadPipeline();
    }

    @Test
    public void testBigQueryStorageRead1GArrow() throws Exception {
        this.setUpTestEnvironment("1G", DataFormat.ARROW);
        this.runBigQueryIOStorageReadPipeline();
    }

    @Test
    public void testBigQueryStorageReadProjectionPushdown() throws Exception {
        this.setUpTestEnvironment("multi_field", DataFormat.AVRO);
        Schema multiFieldSchema = Schema.builder().addNullableField("string_field", Schema.FieldType.STRING).addNullableField("int_field", Schema.FieldType.INT64).build();
        Pipeline p = Pipeline.create((PipelineOptions)this.options);
        PCollection count = (PCollection)((PCollection)((PCollection)p.apply("Read", (PTransform)BigQueryIO.read((SerializableFunction & Serializable)record -> BigQueryUtils.toBeamRow((GenericRecord)record.getRecord(), (Schema)multiFieldSchema, (BigQueryUtils.ConversionOptions)BigQueryUtils.ConversionOptions.builder().build())).from(this.options.getInputTable()).withMethod(BigQueryIO.TypedRead.Method.DIRECT_READ).withFormat(this.options.getDataFormat()).withCoder((Coder)SchemaCoder.of((Schema)multiFieldSchema)))).apply((PTransform)ParDo.of((DoFn)new GetIntField()))).apply("Count", Count.globally());
        PAssert.thatSingleton((PCollection)count).isEqualTo((Object)this.options.getNumRecords());
        p.run().waitUntilFinish();
    }

    private static class GetIntField
    extends DoFn<Row, Long> {
        @DoFn.FieldAccess(value="row")
        private final FieldAccessDescriptor fieldAccessDescriptor = FieldAccessDescriptor.withFieldNames((String[])new String[]{"int_field"});

        private GetIntField() {
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.FieldAccess(value="row") Row row, DoFn.OutputReceiver<Long> outputReceiver) throws Exception {
            outputReceiver.output((Object)((Long)row.getValue("int_field")));
        }
    }

    public static interface BigQueryIOStorageReadOptions
    extends TestPipelineOptions,
    ExperimentalOptions {
        @Description(value="The table to be read")
        @Validation.Required
        public String getInputTable();

        public void setInputTable(String var1);

        @Description(value="The expected number of records")
        @Validation.Required
        public long getNumRecords();

        public void setNumRecords(long var1);

        @Description(value="The data format to use")
        @Validation.Required
        public DataFormat getDataFormat();

        public void setDataFormat(DataFormat var1);
    }
}

