/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class BigQueryIOJsonIT {
    private static final Logger LOG = LoggerFactory.getLogger(BigQueryIOJsonIT.class);
    private static PipelineOptions testOptions = TestPipeline.testingPipelineOptions();
    @Rule
    public final transient TestPipeline p = TestPipeline.fromOptions((PipelineOptions)testOptions);
    @Rule
    public final transient TestPipeline pWrite = TestPipeline.create();
    private BigQueryIOJsonOptions options;
    private static final String project = "apache-beam-testing";
    private static final String DATASET_ID = "bq_jsontype_test_nodelete";
    private static final String JSON_TABLE_NAME = "json_data";
    private static final String JSON_TABLE_DESTINATION;
    private static final TableSchema JSON_TYPE_TABLE_SCHEMA;
    private static final List<TableRow> JSON_QUERY_TEST_DATA;
    public static final String STORAGE_WRITE_TEST_TABLE;
    public static final String STREAMING_TEST_TABLE;
    private static final Map<String, Map<String, Object>> JSON_TEST_DATA;

    public void runTestWrite(BigQueryIOJsonOptions options) {
        List<String> countries = Arrays.asList("usa", "aus", "special");
        ArrayList<TableRow> rowsToWrite = new ArrayList<TableRow>();
        for (Map.Entry<String, Map<String, Object>> element : JSON_TEST_DATA.entrySet()) {
            if (!countries.contains(element.getKey())) continue;
            TableRow row = new TableRow().set("country_code", (Object)element.getKey()).set("country", element.getValue().get("country")).set("stats", element.getValue().get("stats")).set("cities", element.getValue().get("cities")).set("landmarks", element.getValue().get("landmarks"));
            rowsToWrite.add(row);
        }
        ((PCollection)this.pWrite.apply("Create Elements", (PTransform)Create.of(rowsToWrite))).apply("Write To BigQuery", (PTransform)BigQueryIO.writeTableRows().to(options.getOutput()).withSchema(JSON_TYPE_TABLE_SCHEMA).withCreateDisposition(BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED).withMethod(options.getWriteMethod()));
        this.pWrite.run().waitUntilFinish();
        this.readAndValidateRows(options);
    }

    public static Map<String, String> getTestData(String column) {
        Map<String, String> testData = JSON_TEST_DATA.get(column).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (String)e.getValue()));
        return testData;
    }

    public void readAndValidateRows(BigQueryIOJsonOptions options) {
        BigQueryIO.TypedRead bigqueryIO = BigQueryIO.readTableRows().withMethod(options.getReadMethod());
        bigqueryIO = !options.getInputQuery().isEmpty() ? bigqueryIO.fromQuery(options.getInputQuery()).usingStandardSql() : bigqueryIO.from(options.getInputTable());
        PCollection jsonRows = (PCollection)this.p.apply("Read rows", (PTransform)bigqueryIO);
        if (!options.getInputQuery().isEmpty()) {
            PAssert.that((PCollection)jsonRows).containsInAnyOrder(JSON_QUERY_TEST_DATA);
            this.p.run().waitUntilFinish();
            return;
        }
        PCollection countries = (PCollection)jsonRows.apply("Convert countries to KV JSON Strings", (PTransform)ParDo.of((DoFn)new CountryToKVJsonString()));
        PAssert.that((PCollection)countries).satisfies((SerializableFunction)new CompareJsonStrings(BigQueryIOJsonIT.getTestData("countries")));
        PCollection stats = (PCollection)jsonRows.apply("Convert stats to KV JSON Strings", (PTransform)ParDo.of((DoFn)new StatsToKVJsonString()));
        PAssert.that((PCollection)stats).satisfies((SerializableFunction)new CompareJsonStrings(BigQueryIOJsonIT.getTestData("stats")));
        PCollection cities = (PCollection)jsonRows.apply("Convert cities to KV JSON Strings", (PTransform)ParDo.of((DoFn)new CitiesToKVJsonString()));
        PAssert.that((PCollection)cities).satisfies((SerializableFunction)new CompareJsonStrings(BigQueryIOJsonIT.getTestData("cities")));
        PCollection landmarks = (PCollection)jsonRows.apply("Convert landmarks to KV JSON Strings", (PTransform)ParDo.of((DoFn)new LandmarksToKVJsonString()));
        PAssert.that((PCollection)landmarks).satisfies((SerializableFunction)new CompareJsonStrings(BigQueryIOJsonIT.getTestData("landmarks")));
        this.p.run().waitUntilFinish();
    }

    @Test
    public void testDirectRead() throws Exception {
        LOG.info("Testing DIRECT_READ read method with JSON data");
        this.options = (BigQueryIOJsonOptions)TestPipeline.testingPipelineOptions().as(BigQueryIOJsonOptions.class);
        this.options.setReadMethod(BigQueryIO.TypedRead.Method.DIRECT_READ);
        this.options.setInputTable(JSON_TABLE_DESTINATION);
        this.readAndValidateRows(this.options);
    }

    @Test
    public void testExportRead() throws Exception {
        LOG.info("Testing EXPORT read method with JSON data");
        this.options = (BigQueryIOJsonOptions)TestPipeline.testingPipelineOptions().as(BigQueryIOJsonOptions.class);
        this.options.setReadMethod(BigQueryIO.TypedRead.Method.EXPORT);
        this.options.setInputTable(JSON_TABLE_DESTINATION);
        this.readAndValidateRows(this.options);
    }

    @Test
    public void testQueryRead() throws Exception {
        LOG.info("Testing querying JSON data with DIRECT_READ read method");
        this.options = (BigQueryIOJsonOptions)TestPipeline.testingPipelineOptions().as(BigQueryIOJsonOptions.class);
        this.options.setReadMethod(BigQueryIO.TypedRead.Method.DIRECT_READ);
        this.options.setInputQuery(String.format("SELECT country_code, country.past_leaders[2] AS past_leader, stats.gdp_per_capita[\"gdp_per_capita\"] AS gdp, cities[OFFSET(1)].city.name AS city_name, landmarks[OFFSET(1)][\"name\"] AS landmark_name FROM `%s.%s.%s`", project, DATASET_ID, JSON_TABLE_NAME));
        this.readAndValidateRows(this.options);
    }

    @Test
    public void testStorageWrite() throws Exception {
        LOG.info("Testing writing JSON data with Storage API");
        this.options = (BigQueryIOJsonOptions)TestPipeline.testingPipelineOptions().as(BigQueryIOJsonOptions.class);
        this.options.setWriteMethod(BigQueryIO.Write.Method.STORAGE_WRITE_API);
        String storageDestination = String.format("%s:%s.%s", project, DATASET_ID, STORAGE_WRITE_TEST_TABLE);
        this.options.setOutput(storageDestination);
        this.options.setInputTable(storageDestination);
        this.runTestWrite(this.options);
    }

    @Test
    public void testLegacyStreamingWrite() throws Exception {
        this.options = (BigQueryIOJsonOptions)TestPipeline.testingPipelineOptions().as(BigQueryIOJsonOptions.class);
        this.options.setWriteMethod(BigQueryIO.Write.Method.STREAMING_INSERTS);
        String streamingDestination = String.format("%s:%s.%s", project, DATASET_ID, STREAMING_TEST_TABLE);
        this.options.setOutput(streamingDestination);
        this.options.setInputTable(streamingDestination);
        this.runTestWrite(this.options);
    }

    @BeforeClass
    public static void setupTestEnvironment() throws Exception {
        PipelineOptionsFactory.register(BigQueryIOJsonOptions.class);
    }

    private static Map<String, Map<String, Object>> generateCountryData() {
        JSONObject usa = new JSONObject();
        JSONObject nyc = new JSONObject();
        nyc.put("name", (Object)"New York City");
        nyc.put("state", (Object)"NY");
        nyc.put("population", 8622357);
        JSONObject la = new JSONObject();
        la.put("name", (Object)"Los Angeles");
        la.put("state", (Object)"CA");
        la.put("population", 4085014);
        JSONObject chicago = new JSONObject();
        chicago.put("name", (Object)"Chicago");
        chicago.put("state", (Object)"IL");
        chicago.put("population", 2670406);
        JSONObject usaCities = new JSONObject();
        usaCities.put("nyc", (Object)nyc);
        usaCities.put("la", (Object)la);
        usaCities.put("chicago", (Object)chicago);
        JSONArray usaLeaders = new JSONArray();
        usaLeaders.put((Object)"Donald Trump");
        usaLeaders.put((Object)"Barack Obama");
        usaLeaders.put((Object)"George W. Bush");
        usaLeaders.put((Object)"Bill Clinton");
        usa.put("name", (Object)"United States of America");
        usa.put("population", 329484123);
        usa.put("cities", (Object)usaCities);
        usa.put("past_leaders", (Object)usaLeaders);
        usa.put("in_northern_hemisphere", true);
        JSONObject aus = new JSONObject();
        JSONObject sydney = new JSONObject();
        sydney.put("name", (Object)"Sydney");
        sydney.put("state", (Object)"New South Wales");
        sydney.put("population", 5367206);
        JSONObject melbourne = new JSONObject();
        melbourne.put("name", (Object)"Melbourne");
        melbourne.put("state", (Object)"Victoria");
        melbourne.put("population", 5159211);
        JSONObject brisbane = new JSONObject();
        brisbane.put("name", (Object)"Brisbane");
        brisbane.put("state", (Object)"Queensland");
        brisbane.put("population", 2560720);
        JSONObject ausCities = new JSONObject();
        ausCities.put("sydney", (Object)sydney);
        ausCities.put("melbourne", (Object)melbourne);
        ausCities.put("brisbane", (Object)brisbane);
        JSONArray ausLeaders = new JSONArray();
        ausLeaders.put((Object)"Malcolm Turnbull");
        ausLeaders.put((Object)"Tony Abbot");
        ausLeaders.put((Object)"Kevin Rudd");
        aus.put("name", (Object)"Australia");
        aus.put("population", 25687041);
        aus.put("cities", (Object)ausCities);
        aus.put("past_leaders", (Object)ausLeaders);
        aus.put("in_northern_hemisphere", false);
        JSONObject special = new JSONObject();
        JSONObject specialCities = new JSONObject();
        JSONObject basingse = new JSONObject();
        basingse.put("name", (Object)"Ba Sing Se");
        basingse.put("state", (Object)"The Earth Kingdom");
        basingse.put("population", 200000);
        JSONObject bikinibottom = new JSONObject();
        bikinibottom.put("name", (Object)"Bikini Bottom");
        bikinibottom.put("state", (Object)"The Pacific Ocean");
        bikinibottom.put("population", 50000);
        specialCities.put("basingse", (Object)basingse);
        specialCities.put("bikinibottom", (Object)bikinibottom);
        JSONArray specialArr = new JSONArray();
        specialArr.put((Object)"1");
        specialArr.put((Object)"2");
        specialArr.put((Object)"!@#$%^&*()_+");
        special.put("name", (Object)"newline\n, form\f, tab\t, \"quotes\", \\backslash\\, backspace\b, \u0000_hex_\u0f0f");
        special.put("population", -123456789);
        special.put("cities", (Object)specialCities);
        special.put("past_leaders", (Object)specialArr);
        special.put("in_northern_hemisphere", true);
        JSONObject statueOfLiberty = new JSONObject();
        statueOfLiberty.put("name", (Object)"Statue of Liberty");
        statueOfLiberty.put("cool rating", JSONObject.NULL);
        JSONObject goldenGateBridge = new JSONObject();
        goldenGateBridge.put("name", (Object)"Golden Gate Bridge");
        goldenGateBridge.put("cool rating", (Object)"very cool");
        JSONObject grandCanyon = new JSONObject();
        grandCanyon.put("name", (Object)"Grand Canyon");
        grandCanyon.put("cool rating", (Object)"very very cool");
        JSONObject operaHouse = new JSONObject();
        operaHouse.put("name", (Object)"Sydney Opera House");
        operaHouse.put("cool rating", (Object)"amazing");
        JSONObject greatBarrierReef = new JSONObject();
        greatBarrierReef.put("name", (Object)"Great Barrier Reef");
        greatBarrierReef.put("cool rating", JSONObject.NULL);
        JSONObject hogwarts = new JSONObject();
        hogwarts.put("name", (Object)"Hogwarts School of WitchCraft and Wizardry");
        hogwarts.put("cool rating", (Object)"magical");
        JSONObject willyWonka = new JSONObject();
        willyWonka.put("name", (Object)"Willy Wonka's Factory");
        willyWonka.put("cool rating", JSONObject.NULL);
        JSONObject rivendell = new JSONObject();
        rivendell.put("name", (Object)"Rivendell");
        rivendell.put("cool rating", (Object)"precious");
        JSONObject usGdp = new JSONObject();
        usGdp.put("gdp_per_capita", 58559.675);
        usGdp.put("currency", (Object)"constant 2015 US$");
        JSONObject usCo2 = new JSONObject();
        usCo2.put("co2 emissions", 15.241);
        usCo2.put("measurement", (Object)"metric tons per capita");
        usCo2.put("year", 2018);
        JSONObject ausGdp = new JSONObject();
        ausGdp.put("gdp_per_capita", 58043.581);
        ausGdp.put("currency", (Object)"constant 2015 US$");
        JSONObject ausCo2 = new JSONObject();
        ausCo2.put("co2 emissions", 15.476);
        ausCo2.put("measurement", (Object)"metric tons per capita");
        ausCo2.put("year", 2018);
        JSONObject specialGdp = new JSONObject();
        specialGdp.put("gdp_per_capita", 421.7);
        specialGdp.put("currency", (Object)"constant 200 BC gold");
        JSONObject specialCo2 = new JSONObject();
        specialCo2.put("co2 emissions", -10.79);
        specialCo2.put("measurement", (Object)"metric tons per capita");
        specialCo2.put("year", 2018);
        HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>();
        data.put("countries", (Map<String, Object>)ImmutableMap.of((Object)"usa", (Object)usa.toString(), (Object)"aus", (Object)aus.toString(), (Object)"special", (Object)special.toString()));
        data.put("cities", new HashMap(ImmutableMap.builder().put((Object)"usa_nyc", (Object)nyc.toString()).put((Object)"usa_la", (Object)la.toString()).put((Object)"usa_chicago", (Object)chicago.toString()).put((Object)"aus_sydney", (Object)sydney.toString()).put((Object)"aus_melbourne", (Object)melbourne.toString()).put((Object)"aus_brisbane", (Object)brisbane.toString()).put((Object)"special_basingse", (Object)basingse.toString()).put((Object)"special_bikinibottom", (Object)bikinibottom.toString()).build()));
        data.put("landmarks", new HashMap(ImmutableMap.builder().put((Object)"usa_0", (Object)statueOfLiberty.toString()).put((Object)"usa_1", (Object)goldenGateBridge.toString()).put((Object)"usa_2", (Object)grandCanyon.toString()).put((Object)"aus_0", (Object)operaHouse.toString()).put((Object)"aus_1", (Object)greatBarrierReef.toString()).put((Object)"special_0", (Object)hogwarts.toString()).put((Object)"special_1", (Object)willyWonka.toString()).put((Object)"special_2", (Object)rivendell.toString()).build()));
        data.put("stats", new HashMap(ImmutableMap.builder().put((Object)"usa_gdp_per_capita", (Object)usGdp.toString()).put((Object)"usa_co2_emissions", (Object)usCo2.toString()).put((Object)"aus_gdp_per_capita", (Object)ausGdp.toString()).put((Object)"aus_co2_emissions", (Object)ausCo2.toString()).put((Object)"special_gdp_per_capita", (Object)specialGdp.toString()).put((Object)"special_co2_emissions", (Object)specialCo2.toString()).build()));
        data.put("usa", (Map<String, Object>)ImmutableMap.of((Object)"country", (Object)usa.toString(), (Object)"cities", Arrays.asList(ImmutableMap.of((Object)"city_name", (Object)"nyc", (Object)"city", (Object)nyc.toString()), ImmutableMap.of((Object)"city_name", (Object)"la", (Object)"city", (Object)la.toString()), ImmutableMap.of((Object)"city_name", (Object)"chicago", (Object)"city", (Object)chicago.toString())), (Object)"landmarks", Arrays.asList(statueOfLiberty.toString(), goldenGateBridge.toString(), grandCanyon.toString()), (Object)"stats", (Object)ImmutableMap.of((Object)"gdp_per_capita", (Object)usGdp.toString(), (Object)"co2_emissions", (Object)usCo2.toString())));
        data.put("aus", (Map<String, Object>)ImmutableMap.of((Object)"country", (Object)aus.toString(), (Object)"cities", Arrays.asList(ImmutableMap.of((Object)"city_name", (Object)"sydney", (Object)"city", (Object)sydney.toString()), ImmutableMap.of((Object)"city_name", (Object)"melbourne", (Object)"city", (Object)melbourne.toString()), ImmutableMap.of((Object)"city_name", (Object)"brisbane", (Object)"city", (Object)brisbane.toString())), (Object)"landmarks", Arrays.asList(operaHouse.toString(), greatBarrierReef.toString()), (Object)"stats", (Object)ImmutableMap.of((Object)"gdp_per_capita", (Object)ausGdp.toString(), (Object)"co2_emissions", (Object)ausCo2.toString())));
        data.put("special", (Map<String, Object>)ImmutableMap.of((Object)"country", (Object)special.toString(), (Object)"cities", Arrays.asList(ImmutableMap.of((Object)"city_name", (Object)"basingse", (Object)"city", (Object)basingse.toString()), ImmutableMap.of((Object)"city_name", (Object)"bikinibottom", (Object)"city", (Object)bikinibottom.toString())), (Object)"landmarks", Arrays.asList(hogwarts.toString(), willyWonka.toString(), rivendell.toString()), (Object)"stats", (Object)ImmutableMap.of((Object)"gdp_per_capita", (Object)specialGdp.toString(), (Object)"co2_emissions", (Object)specialCo2.toString())));
        return data;
    }

    static {
        TestPipelineOptions opt = (TestPipelineOptions)TestPipeline.testingPipelineOptions().as(TestPipelineOptions.class);
        testOptions.setTempLocation(opt.getTempRoot() + "/java-tmp");
        JSON_TABLE_DESTINATION = String.format("%s:%s.%s", project, DATASET_ID, JSON_TABLE_NAME);
        JSON_TYPE_TABLE_SCHEMA = new TableSchema().setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("country_code").setType("STRING"), (Object)new TableFieldSchema().setName("country").setType("JSON"), (Object)new TableFieldSchema().setName("stats").setType("STRUCT").setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("gdp_per_capita").setType("JSON"), (Object)new TableFieldSchema().setName("co2_emissions").setType("JSON"))), (Object)new TableFieldSchema().setName("cities").setType("STRUCT").setMode("REPEATED").setFields((List)ImmutableList.of((Object)new TableFieldSchema().setName("city_name").setType("STRING"), (Object)new TableFieldSchema().setName("city").setType("JSON"))), (Object)new TableFieldSchema().setName("landmarks").setType("JSON").setMode("REPEATED")));
        JSON_QUERY_TEST_DATA = Arrays.asList(new TableRow().set("country_code", (Object)"usa").set("past_leader", (Object)"\"George W. Bush\"").set("gdp", (Object)"58559.675").set("city_name", (Object)"\"Los Angeles\"").set("landmark_name", (Object)"\"Golden Gate Bridge\""), new TableRow().set("country_code", (Object)"aus").set("past_leader", (Object)"\"Kevin Rudd\"").set("gdp", (Object)"58043.581").set("city_name", (Object)"\"Melbourne\"").set("landmark_name", (Object)"\"Great Barrier Reef\""), new TableRow().set("country_code", (Object)"special").set("past_leader", (Object)"\"!@#$%^&*()_+\"").set("gdp", (Object)"421.7").set("city_name", (Object)"\"Bikini Bottom\"").set("landmark_name", (Object)"\"Willy Wonka's Factory\""));
        STORAGE_WRITE_TEST_TABLE = "storagewrite_test" + System.currentTimeMillis() + "_" + new SecureRandom().nextInt(32);
        STREAMING_TEST_TABLE = "streaming_test" + System.currentTimeMillis() + "_" + new SecureRandom().nextInt(32);
        JSON_TEST_DATA = BigQueryIOJsonIT.generateCountryData();
    }

    public static interface BigQueryIOJsonOptions
    extends TestPipelineOptions {
        @Description(value="Table to read from, specified as <project_id>:<dataset_id>.<table_id>")
        @Validation.Required
        public String getInputTable();

        public void setInputTable(String var1);

        @Description(value="Query used to read from BigQuery")
        @Default.String(value="")
        public String getInputQuery();

        public void setInputQuery(String var1);

        @Description(value="Read method used to read from BigQuery")
        @Default.Enum(value="EXPORT")
        public BigQueryIO.TypedRead.Method getReadMethod();

        public void setReadMethod(BigQueryIO.TypedRead.Method var1);

        @Description(value="BigQuery table to write to, specified as <project_id>:<dataset_id>.<table_id>. The dataset must already exist.")
        @Validation.Required
        public String getOutput();

        public void setOutput(String var1);

        @Description(value="Write method used to write to BigQuery")
        @Default.Enum(value="STORAGE_WRITE_API")
        public BigQueryIO.Write.Method getWriteMethod();

        public void setWriteMethod(BigQueryIO.Write.Method var1);
    }

    static class CompareJsonStrings
    implements SerializableFunction<Iterable<KV<String, String>>, Void> {
        Map<String, String> expected;

        public CompareJsonStrings(Map<String, String> expected) {
            this.expected = expected;
        }

        public Void apply(Iterable<KV<String, String>> input) throws RuntimeException {
            int counter = 0;
            for (KV<String, String> actual : input) {
                String key = (String)actual.getKey();
                if (!this.expected.containsKey(key)) {
                    throw new NoSuchElementException(String.format("Unexpected key '%s' found in input but does not exist in expected results.", key));
                }
                String jsonStringActual = (String)actual.getValue();
                JsonElement jsonActual = JsonParser.parseString((String)jsonStringActual);
                String jsonStringExpected = this.expected.get(key);
                JsonElement jsonExpected = JsonParser.parseString((String)jsonStringExpected);
                Assert.assertEquals((Object)jsonExpected, (Object)jsonActual);
                ++counter;
            }
            if (counter != this.expected.size()) {
                throw new RuntimeException(String.format("Expected %d elements but got %d elements.", this.expected.size(), counter));
            }
            return null;
        }
    }

    static class LandmarksToKVJsonString
    extends DoFn<TableRow, KV<String, String>> {
        LandmarksToKVJsonString() {
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element TableRow row, DoFn.OutputReceiver<KV<String, String>> out) {
            String countryCode = row.get((Object)"country_code").toString();
            ArrayList landmarks = (ArrayList)row.get((Object)"landmarks");
            for (int i = 0; i < landmarks.size(); ++i) {
                String key = countryCode + "_" + i;
                String value = (String)landmarks.get(i);
                out.output((Object)KV.of((Object)key, (Object)value));
            }
        }
    }

    static class StatsToKVJsonString
    extends DoFn<TableRow, KV<String, String>> {
        StatsToKVJsonString() {
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element TableRow row, DoFn.OutputReceiver<KV<String, String>> out) {
            String countryCode = row.get((Object)"country_code").toString();
            Map map = (Map)row.get((Object)"stats");
            for (Map.Entry entry : map.entrySet()) {
                String key = countryCode + "_" + (String)entry.getKey();
                String value = (String)entry.getValue();
                out.output((Object)KV.of((Object)key, (Object)value));
            }
        }
    }

    static class CitiesToKVJsonString
    extends DoFn<TableRow, KV<String, String>> {
        CitiesToKVJsonString() {
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element TableRow row, DoFn.OutputReceiver<KV<String, String>> out) {
            String countryCode = row.get((Object)"country_code").toString();
            ArrayList cities = (ArrayList)row.get((Object)"cities");
            for (Map city : cities) {
                String key = countryCode + "_" + (String)city.get("city_name");
                String value = (String)city.get("city");
                out.output((Object)KV.of((Object)key, (Object)value));
            }
        }
    }

    static class CountryToKVJsonString
    extends DoFn<TableRow, KV<String, String>> {
        CountryToKVJsonString() {
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element TableRow row, DoFn.OutputReceiver<KV<String, String>> out) {
            String countryCode = row.get((Object)"country_code").toString();
            String country = row.get((Object)"country").toString();
            out.output((Object)KV.of((Object)countryCode, (Object)country));
        }
    }
}

