/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.ReadChangeStreamPartitionRangeTracker;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class ReadChangeStreamPartitionRangeTrackerTest {
    @Test
    public void testTryClaim() {
        PartitionMetadata partition = (PartitionMetadata)Mockito.mock(PartitionMetadata.class);
        OffsetRange range = new OffsetRange(100L, 200L);
        ReadChangeStreamPartitionRangeTracker tracker = new ReadChangeStreamPartitionRangeTracker(partition, range);
        Assert.assertEquals((Object)range, (Object)tracker.currentRestriction());
        Assert.assertTrue((boolean)tracker.tryClaim(Long.valueOf(100L)));
        Assert.assertTrue((boolean)tracker.tryClaim(Long.valueOf(100L)));
        Assert.assertTrue((boolean)tracker.tryClaim(Long.valueOf(150L)));
        Assert.assertTrue((boolean)tracker.tryClaim(Long.valueOf(199L)));
        Assert.assertFalse((boolean)tracker.tryClaim(Long.valueOf(200L)));
    }

    @Test
    public void testTrySplitReturnsNullForInitialPartition() {
        PartitionMetadata partition = (PartitionMetadata)Mockito.mock(PartitionMetadata.class);
        OffsetRange range = new OffsetRange(100L, 200L);
        ReadChangeStreamPartitionRangeTracker tracker = new ReadChangeStreamPartitionRangeTracker(partition, range);
        Mockito.when((Object)partition.getPartitionToken()).thenReturn((Object)"Parent0");
        Assert.assertNull((Object)tracker.trySplit(0.0));
    }
}

