/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Value;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PartitionMetadataTest {
    private static final String PARTITION_TOKEN = "partitionToken123";
    private static final String PARENT_TOKEN = "parentToken123";
    private static final Timestamp START_TIMESTAMP = Timestamp.ofTimeSecondsAndNanos((long)1L, (int)1);
    private static final Timestamp END_TIMESTAMP = Timestamp.ofTimeSecondsAndNanos((long)2L, (int)2);
    private static final Timestamp WATERMARK = Timestamp.ofTimeSecondsAndNanos((long)3L, (int)3);
    private static final Timestamp CREATED_AT = Timestamp.ofTimeSecondsAndNanos((long)4L, (int)4);
    private static final Timestamp SCHEDULED_AT = Timestamp.ofTimeSecondsAndNanos((long)5L, (int)5);
    private static final Timestamp RUNNING_AT = Timestamp.ofTimeSecondsAndNanos((long)6L, (int)6);
    private static final Timestamp FINISHED_AT = Timestamp.ofTimeSecondsAndNanos((long)7L, (int)7);

    @Test
    public void testBuilderDefaultsToInclusiveStartAndExclusiveEnd() {
        PartitionMetadata expectedPartitionMetadata = new PartitionMetadata(PARTITION_TOKEN, Sets.newHashSet((Object[])new String[]{PARENT_TOKEN}), START_TIMESTAMP, END_TIMESTAMP, 10L, PartitionMetadata.State.RUNNING, WATERMARK, CREATED_AT, SCHEDULED_AT, RUNNING_AT, FINISHED_AT);
        PartitionMetadata actualPartitionMetadata = PartitionMetadata.newBuilder().setPartitionToken(PARTITION_TOKEN).setParentTokens(Sets.newHashSet((Object[])new String[]{PARENT_TOKEN})).setStartTimestamp(START_TIMESTAMP).setEndTimestamp(END_TIMESTAMP).setHeartbeatMillis(10L).setState(PartitionMetadata.State.RUNNING).setWatermark(WATERMARK).setCreatedAt(CREATED_AT).setScheduledAt(SCHEDULED_AT).setRunningAt(RUNNING_AT).setFinishedAt(FINISHED_AT).build();
        Assert.assertEquals((Object)expectedPartitionMetadata, (Object)actualPartitionMetadata);
    }

    @Test
    public void testBuilderDefaultsToCommitTimestampWhenCreatedAtIsNotGiven() {
        PartitionMetadata expectedPartitionMetadata = new PartitionMetadata(PARTITION_TOKEN, Sets.newHashSet((Object[])new String[]{PARENT_TOKEN}), START_TIMESTAMP, END_TIMESTAMP, 10L, PartitionMetadata.State.RUNNING, WATERMARK, Value.COMMIT_TIMESTAMP, SCHEDULED_AT, RUNNING_AT, FINISHED_AT);
        PartitionMetadata actualPartitionMetadata = PartitionMetadata.newBuilder().setPartitionToken(PARTITION_TOKEN).setParentTokens(Sets.newHashSet((Object[])new String[]{PARENT_TOKEN})).setStartTimestamp(START_TIMESTAMP).setEndTimestamp(END_TIMESTAMP).setHeartbeatMillis(10L).setState(PartitionMetadata.State.RUNNING).setWatermark(WATERMARK).setScheduledAt(SCHEDULED_AT).setRunningAt(RUNNING_AT).setFinishedAt(FINISHED_AT).build();
        Assert.assertEquals((Object)expectedPartitionMetadata, (Object)actualPartitionMetadata);
    }

    @Test
    public void testBuilderThrowsExceptionWhenPartitionTokenMissing() {
        Assert.assertThrows((String)"partitionToken", IllegalStateException.class, () -> PartitionMetadata.newBuilder().setParentTokens(Sets.newHashSet((Object[])new String[]{PARENT_TOKEN})).setStartTimestamp(START_TIMESTAMP).setEndTimestamp(END_TIMESTAMP).setHeartbeatMillis(10L).setState(PartitionMetadata.State.CREATED).setWatermark(WATERMARK).setCreatedAt(CREATED_AT).build());
    }

    @Test
    public void testBuilderThrowsExceptionWhenParentTokenMissing() {
        Assert.assertThrows((String)"parentToken", IllegalStateException.class, () -> PartitionMetadata.newBuilder().setPartitionToken(PARTITION_TOKEN).setStartTimestamp(START_TIMESTAMP).setEndTimestamp(END_TIMESTAMP).setHeartbeatMillis(10L).setState(PartitionMetadata.State.CREATED).setWatermark(WATERMARK).setCreatedAt(CREATED_AT).build());
    }

    @Test
    public void testBuilderThrowsExceptionWhenStartTimestampMissing() {
        Assert.assertThrows((String)"startTimestamp", IllegalStateException.class, () -> PartitionMetadata.newBuilder().setPartitionToken(PARTITION_TOKEN).setParentTokens(Sets.newHashSet((Object[])new String[]{PARENT_TOKEN})).setEndTimestamp(END_TIMESTAMP).setHeartbeatMillis(10L).setState(PartitionMetadata.State.CREATED).setWatermark(WATERMARK).setCreatedAt(CREATED_AT).build());
    }

    @Test
    public void testBuilderThrowsExceptionWhenHeartbeatMillisMissing() {
        Assert.assertThrows((String)"heartbeatMillis", IllegalStateException.class, () -> PartitionMetadata.newBuilder().setPartitionToken(PARTITION_TOKEN).setParentTokens(Sets.newHashSet((Object[])new String[]{PARENT_TOKEN})).setStartTimestamp(START_TIMESTAMP).setEndTimestamp(END_TIMESTAMP).setState(PartitionMetadata.State.CREATED).setWatermark(WATERMARK).setCreatedAt(CREATED_AT).build());
    }

    @Test
    public void testBuilderThrowsExceptionWhenStateMissing() {
        Assert.assertThrows((String)"state", IllegalStateException.class, () -> PartitionMetadata.newBuilder().setPartitionToken(PARTITION_TOKEN).setParentTokens(Sets.newHashSet((Object[])new String[]{PARENT_TOKEN})).setStartTimestamp(START_TIMESTAMP).setEndTimestamp(END_TIMESTAMP).setHeartbeatMillis(10L).setCreatedAt(CREATED_AT).setWatermark(WATERMARK).build());
    }

    @Test
    public void testBuilderThrowsExceptionWhenWatermarkMissing() {
        Assert.assertThrows((String)"state", IllegalStateException.class, () -> PartitionMetadata.newBuilder().setPartitionToken(PARTITION_TOKEN).setParentTokens(Sets.newHashSet((Object[])new String[]{PARENT_TOKEN})).setStartTimestamp(START_TIMESTAMP).setEndTimestamp(END_TIMESTAMP).setHeartbeatMillis(10L).setState(PartitionMetadata.State.CREATED).setCreatedAt(CREATED_AT).build());
    }
}

