/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import com.google.cloud.Timestamp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumReader;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChangeStreamRecordMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ColumnType;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.DataChangeRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.Mod;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ModType;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.TypeCode;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ValueCaptureType;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Test;

public class ModelEncodingTest {
    @Test
    public void testModCanBeEncoded() throws IOException {
        Mod mod = new Mod("{\"column1\": \"value1\"}", "{\"column2\": \"oldValue2\"}", "{\"column2\": \"newValue2\"}");
        Assert.assertEquals((Object)mod, (Object)this.encodeAndDecode(mod));
    }

    @Test
    public void testModTypeCanBeEncoded() throws IOException {
        Assert.assertEquals((Object)ModType.INSERT, (Object)this.encodeAndDecode(ModType.INSERT));
    }

    @Test
    public void testTypeCodeCanBeEncoded() throws IOException {
        TypeCode typeCode = new TypeCode("typeCode");
        Assert.assertEquals((Object)typeCode, (Object)this.encodeAndDecode(typeCode));
    }

    @Test
    public void testValueCaptureTypeCanBeEncoded() throws IOException {
        Assert.assertEquals((Object)ValueCaptureType.OLD_AND_NEW_VALUES, (Object)this.encodeAndDecode(ValueCaptureType.OLD_AND_NEW_VALUES));
    }

    @Test
    public void testColumnTypeCanBeEncoded() throws IOException {
        ColumnType columnType = new ColumnType("column", new TypeCode("typeCode"), true, 1L);
        Assert.assertEquals((Object)columnType, (Object)this.encodeAndDecode(columnType));
    }

    @Test
    public void testDataChangeRecordCanBeEncoded() throws IOException {
        DataChangeRecord dataChangeRecord = new DataChangeRecord("1", Timestamp.now(), "2", true, "3", "TableName", Arrays.asList(new ColumnType("keyColumn", new TypeCode("typeKey"), true, 1L), new ColumnType("column1", new TypeCode("typeCode1"), false, 2L), new ColumnType("column2", new TypeCode("typeCode2"), false, 3L)), Collections.singletonList(new Mod("{\"keyColumn\": \"keyValue\"}", "{\"column1\": \"value1\", \"column2\": \"oldValue2\"}", "{\"column1\": \"value1\", \"column2\": \"newValue2\"}")), ModType.UPDATE, ValueCaptureType.OLD_AND_NEW_VALUES, 1L, 1L, ChangeStreamRecordMetadata.newBuilder().withRecordTimestamp(Timestamp.ofTimeMicroseconds((long)100L)).withPartitionToken("1").withPartitionStartTimestamp(Timestamp.ofTimeMicroseconds((long)1L)).withPartitionEndTimestamp(Timestamp.ofTimeMicroseconds((long)10000L)).withPartitionCreatedAt(Timestamp.ofTimeMicroseconds((long)100L)).withPartitionScheduledAt(Timestamp.ofTimeMicroseconds((long)101L)).withPartitionRunningAt(Timestamp.ofTimeMicroseconds((long)102L)).withQueryStartedAt(Timestamp.ofTimeMicroseconds((long)103L)).withRecordStreamStartedAt(Timestamp.ofTimeMicroseconds((long)104L)).withRecordStreamEndedAt(Timestamp.ofTimeMicroseconds((long)105L)).withRecordReadAt(Timestamp.ofTimeMicroseconds((long)106L)).withTotalStreamTimeMillis(1000L).withNumberOfRecordsRead(1L).build());
        Assert.assertEquals((Object)dataChangeRecord, (Object)this.encodeAndDecode(dataChangeRecord));
    }

    @Test
    public void testDataChangeRecordWithNullOldAndNewValuesAndNullMetadataCanBeEncoded() throws IOException {
        DataChangeRecord dataChangeRecord = new DataChangeRecord("1", Timestamp.now(), "2", true, "3", "TableName", Arrays.asList(new ColumnType("keyColumn", new TypeCode("typeKey"), true, 1L), new ColumnType("column1", new TypeCode("typeCode1"), false, 2L), new ColumnType("column2", new TypeCode("typeCode2"), false, 3L)), Collections.singletonList(new Mod("{\"keyColumn\": \"keyValue\"}", null, null)), ModType.UPDATE, ValueCaptureType.OLD_AND_NEW_VALUES, 1L, 1L, null);
        Assert.assertEquals((Object)dataChangeRecord, (Object)this.encodeAndDecode(dataChangeRecord));
    }

    @Test
    public void testPartitionMetadataCanBeEncoded() throws IOException {
        PartitionMetadata partitionMetadata = new PartitionMetadata("partitionToken", Sets.newHashSet((Object[])new String[]{"parentToken"}), Timestamp.now(), Timestamp.now(), 10L, PartitionMetadata.State.RUNNING, Timestamp.now(), Timestamp.now(), Timestamp.now(), Timestamp.now(), Timestamp.now());
        Assert.assertEquals((Object)partitionMetadata, (Object)this.encodeAndDecode(partitionMetadata));
    }

    private <T> Object encodeAndDecode(T object) throws IOException {
        Schema schema = ReflectData.get().getSchema(object.getClass());
        ReflectDatumWriter datumWriter = new ReflectDatumWriter(schema);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)outputStream, null);
        datumWriter.write(object, (Encoder)encoder);
        encoder.flush();
        ReflectDatumReader datumReader = new ReflectDatumReader(schema);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder((InputStream)inputStream, null);
        return datumReader.read(null, (Decoder)decoder);
    }
}

