/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Struct;
import java.util.Collections;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.PartitionMetadataMapper;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PartitionMetadataMapperTest {
    private PartitionMetadataMapper mapper;

    @Before
    public void setUp() {
        this.mapper = new PartitionMetadataMapper();
    }

    @Test
    public void testMapPartitionMetadataFromResultSet() {
        Struct row = ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("PartitionToken").to("token")).set("ParentTokens").toStringArray(Collections.singletonList("parentToken"))).set("StartTimestamp").to(Timestamp.ofTimeMicroseconds((long)10L))).set("EndTimestamp").to(Timestamp.ofTimeMicroseconds((long)20L))).set("HeartbeatMillis").to(5000L)).set("State").to(PartitionMetadata.State.RUNNING.name())).set("Watermark").to(Timestamp.ofTimeMicroseconds((long)30L))).set("CreatedAt").to(Timestamp.ofTimeMicroseconds((long)40L))).set("ScheduledAt").to(Timestamp.ofTimeMicroseconds((long)50L))).set("RunningAt").to(Timestamp.ofTimeMicroseconds((long)60L))).set("FinishedAt").to(Timestamp.ofTimeMicroseconds((long)70L))).build();
        PartitionMetadata partition = this.mapper.from(row);
        Assert.assertEquals((Object)new PartitionMetadata("token", Sets.newHashSet((Object[])new String[]{"parentToken"}), Timestamp.ofTimeMicroseconds((long)10L), Timestamp.ofTimeMicroseconds((long)20L), 5000L, PartitionMetadata.State.RUNNING, Timestamp.ofTimeMicroseconds((long)30L), Timestamp.ofTimeMicroseconds((long)40L), Timestamp.ofTimeMicroseconds((long)50L), Timestamp.ofTimeMicroseconds((long)60L), Timestamp.ofTimeMicroseconds((long)70L)), (Object)partition);
    }

    @Test
    public void testMapPartitionMetadataFromResultSetWithNulls() {
        Struct row = ((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("PartitionToken").to("token")).set("ParentTokens").toStringArray(Collections.singletonList("parentToken"))).set("StartTimestamp").to(Timestamp.ofTimeMicroseconds((long)10L))).set("EndTimestamp").to((Timestamp)null)).set("HeartbeatMillis").to(5000L)).set("State").to(PartitionMetadata.State.CREATED.name())).set("Watermark").to(Timestamp.ofTimeMicroseconds((long)30L))).set("CreatedAt").to(Timestamp.ofTimeMicroseconds((long)40L))).set("ScheduledAt").to((Timestamp)null)).set("RunningAt").to((Timestamp)null)).set("FinishedAt").to((Timestamp)null)).build();
        PartitionMetadata partition = this.mapper.from(row);
        Assert.assertEquals((Object)new PartitionMetadata("token", Sets.newHashSet((Object[])new String[]{"parentToken"}), Timestamp.ofTimeMicroseconds((long)10L), null, 5000L, PartitionMetadata.State.CREATED, Timestamp.ofTimeMicroseconds((long)30L), Timestamp.ofTimeMicroseconds((long)40L), null, null, null), (Object)partition);
    }
}

