/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.it;

import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.common.IOITHelper;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.it.ChangeStreamTestPipelineOptions;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegrationTestEnv
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationTestEnv.class);
    private static final int TIMEOUT_MINUTES = 10;
    private static final int MAX_TABLE_NAME_LENGTH = 128;
    private static final int MAX_CHANGE_STREAM_NAME_LENGTH = 30;
    private static final int MAX_DATABASE_NAME_LENGTH = 30;
    private static final String TABLE_NAME_PREFIX = "Singers";
    private static final String CHANGE_STREAM_NAME_PREFIX = "SingersStream";
    private List<String> changeStreams;
    private List<String> tables;
    private String projectId;
    private String instanceId;
    private String databaseId;
    private Spanner spanner;
    private DatabaseAdminClient databaseAdminClient;
    private DatabaseClient databaseClient;

    protected void before() throws Throwable {
        ChangeStreamTestPipelineOptions options = (ChangeStreamTestPipelineOptions)IOITHelper.readIOTestPipelineOptions(ChangeStreamTestPipelineOptions.class);
        this.projectId = Optional.ofNullable(options.getProjectId()).orElseGet(() -> ((GcpOptions)options.as(GcpOptions.class)).getProject());
        this.instanceId = options.getInstanceId();
        this.databaseId = this.generateDatabaseName(options.getDatabaseId());
        this.spanner = (Spanner)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(this.projectId)).build().getService();
        this.databaseAdminClient = this.spanner.getDatabaseAdminClient();
        this.recreateDatabase(this.databaseAdminClient, this.instanceId, this.databaseId);
        this.databaseClient = this.spanner.getDatabaseClient(DatabaseId.of((String)this.projectId, (String)this.instanceId, (String)this.databaseId));
        this.changeStreams = new ArrayList<String>();
        this.tables = new ArrayList<String>();
    }

    protected void after() {
        for (String changeStream : this.changeStreams) {
            try {
                this.databaseAdminClient.updateDatabaseDdl(this.instanceId, this.databaseId, Collections.singletonList("DROP CHANGE STREAM " + changeStream), null).get(10L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                LOG.error("Failed to drop change stream " + changeStream + ". Skipping...", (Throwable)e);
            }
        }
        for (String table : this.tables) {
            try {
                this.databaseAdminClient.updateDatabaseDdl(this.instanceId, this.databaseId, Collections.singletonList("DROP TABLE " + table), null).get(10L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                LOG.error("Failed to drop table " + table + ". Skipping...", (Throwable)e);
            }
        }
        try {
            this.databaseAdminClient.dropDatabase(this.instanceId, this.databaseId);
        }
        catch (Exception e) {
            LOG.error("Failed to drop database " + this.databaseId + ". Skipping...", (Throwable)e);
        }
        this.spanner.close();
    }

    String createSingersTable() throws InterruptedException, ExecutionException, TimeoutException {
        String tableName = this.generateTableName();
        LOG.info("Creating table " + tableName);
        this.databaseAdminClient.updateDatabaseDdl(this.instanceId, this.databaseId, Collections.singletonList("CREATE TABLE " + tableName + " (   SingerId   INT64 NOT NULL,   FirstName  STRING(1024),   LastName   STRING(1024),   SingerInfo BYTES(MAX) ) PRIMARY KEY (SingerId)"), null).get(10L, TimeUnit.MINUTES);
        this.tables.add(tableName);
        return tableName;
    }

    String createChangeStreamFor(String tableName) throws InterruptedException, ExecutionException, TimeoutException {
        String changeStreamName = this.generateChangeStreamName();
        LOG.info("Creating change stream " + changeStreamName + " for " + tableName);
        this.databaseAdminClient.updateDatabaseDdl(this.instanceId, this.databaseId, Collections.singletonList("CREATE CHANGE STREAM " + changeStreamName + " FOR " + tableName), null).get(10L, TimeUnit.MINUTES);
        this.changeStreams.add(changeStreamName);
        return changeStreamName;
    }

    String getProjectId() {
        return this.projectId;
    }

    String getInstanceId() {
        return this.instanceId;
    }

    String getDatabaseId() {
        return this.databaseId;
    }

    DatabaseClient getDatabaseClient() {
        return this.databaseClient;
    }

    private void recreateDatabase(DatabaseAdminClient databaseAdminClient, String instanceId, String databaseId) throws ExecutionException, InterruptedException, TimeoutException {
        databaseAdminClient.dropDatabase(instanceId, databaseId);
        LOG.info("Creating database " + databaseId);
        databaseAdminClient.createDatabase(instanceId, databaseId, Collections.emptyList()).get(10L, TimeUnit.MINUTES);
    }

    private String generateTableName() {
        return "Singers_" + RandomStringUtils.randomAlphanumeric((int)(127 - TABLE_NAME_PREFIX.length()));
    }

    private String generateChangeStreamName() {
        return "SingersStream_" + RandomStringUtils.randomAlphanumeric((int)(29 - CHANGE_STREAM_NAME_PREFIX.length()));
    }

    private String generateDatabaseName(String prefix) {
        return prefix + "_" + RandomStringUtils.randomAlphanumeric((int)(29 - prefix.length())).toLowerCase(Locale.ROOT);
    }
}

