/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.action;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Struct;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Function;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.ChildPartitionsRecordAction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.PartitionMetadataDao;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChildPartition;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.ChildPartitionsRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.util.TestTransactionAnswer;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.joda.time.Instant;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class ChildPartitionsRecordActionTest {
    private PartitionMetadataDao dao;
    private PartitionMetadataDao.InTransactionContext transaction;
    private ChangeStreamMetrics metrics;
    private ChildPartitionsRecordAction action;
    private RestrictionTracker<OffsetRange, Long> tracker;
    private ManualWatermarkEstimator<Instant> watermarkEstimator;

    @Before
    public void setUp() {
        this.dao = (PartitionMetadataDao)Mockito.mock(PartitionMetadataDao.class);
        this.transaction = (PartitionMetadataDao.InTransactionContext)Mockito.mock(PartitionMetadataDao.InTransactionContext.class);
        this.metrics = (ChangeStreamMetrics)Mockito.mock(ChangeStreamMetrics.class);
        this.action = new ChildPartitionsRecordAction(this.dao, this.metrics);
        this.tracker = (RestrictionTracker)Mockito.mock(RestrictionTracker.class);
        this.watermarkEstimator = (ManualWatermarkEstimator)Mockito.mock(ManualWatermarkEstimator.class);
        Mockito.when((Object)this.dao.runInTransaction((Function)ArgumentMatchers.any())).thenAnswer((Answer)new TestTransactionAnswer(this.transaction));
    }

    @Test
    public void testRestrictionClaimedAndIsSplitCase() {
        String partitionToken = "partitionToken";
        long heartbeat = 30L;
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)10L);
        Timestamp endTimestamp = Timestamp.ofTimeMicroseconds((long)20L);
        PartitionMetadata partition = (PartitionMetadata)Mockito.mock(PartitionMetadata.class);
        ChildPartitionsRecord record = new ChildPartitionsRecord(startTimestamp, "recordSequence", Arrays.asList(new ChildPartition("childPartition1", "partitionToken"), new ChildPartition("childPartition2", "partitionToken")), null);
        Mockito.when((Object)partition.getEndTimestamp()).thenReturn((Object)endTimestamp);
        Mockito.when((Object)partition.getHeartbeatMillis()).thenReturn((Object)30L);
        Mockito.when((Object)partition.getPartitionToken()).thenReturn((Object)"partitionToken");
        Mockito.when((Object)this.tracker.tryClaim((Object)10L)).thenReturn((Object)true);
        Mockito.when((Object)this.transaction.getPartition("childPartition1")).thenReturn(null);
        Mockito.when((Object)this.transaction.getPartition("childPartition2")).thenReturn(null);
        Optional maybeContinuation = this.action.run(partition, record, this.tracker, this.watermarkEstimator);
        Assert.assertEquals(Optional.empty(), (Object)maybeContinuation);
        ((ManualWatermarkEstimator)Mockito.verify(this.watermarkEstimator)).setWatermark(new Instant(startTimestamp.toSqlTimestamp().getTime()));
        ((PartitionMetadataDao.InTransactionContext)Mockito.verify((Object)this.transaction)).insert(PartitionMetadata.newBuilder().setPartitionToken("childPartition1").setParentTokens(Sets.newHashSet((Object[])new String[]{"partitionToken"})).setStartTimestamp(startTimestamp).setEndTimestamp(endTimestamp).setHeartbeatMillis(30L).setState(PartitionMetadata.State.CREATED).setWatermark(startTimestamp).build());
        ((PartitionMetadataDao.InTransactionContext)Mockito.verify((Object)this.transaction)).insert(PartitionMetadata.newBuilder().setPartitionToken("childPartition2").setParentTokens(Sets.newHashSet((Object[])new String[]{"partitionToken"})).setStartTimestamp(startTimestamp).setEndTimestamp(endTimestamp).setHeartbeatMillis(30L).setState(PartitionMetadata.State.CREATED).setWatermark(startTimestamp).build());
    }

    @Test
    public void testRestrictionClaimedAnsIsSplitCaseAndChildExists() {
        String partitionToken = "partitionToken";
        long heartbeat = 30L;
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)10L);
        Timestamp endTimestamp = Timestamp.ofTimeMicroseconds((long)20L);
        PartitionMetadata partition = (PartitionMetadata)Mockito.mock(PartitionMetadata.class);
        ChildPartitionsRecord record = new ChildPartitionsRecord(startTimestamp, "recordSequence", Arrays.asList(new ChildPartition("childPartition1", "partitionToken"), new ChildPartition("childPartition2", "partitionToken")), null);
        Mockito.when((Object)partition.getEndTimestamp()).thenReturn((Object)endTimestamp);
        Mockito.when((Object)partition.getHeartbeatMillis()).thenReturn((Object)30L);
        Mockito.when((Object)partition.getPartitionToken()).thenReturn((Object)"partitionToken");
        Mockito.when((Object)this.tracker.tryClaim((Object)10L)).thenReturn((Object)true);
        Mockito.when((Object)this.transaction.getPartition("childPartition1")).thenReturn((Object)((Struct)Mockito.mock(Struct.class)));
        Mockito.when((Object)this.transaction.getPartition("childPartition2")).thenReturn((Object)((Struct)Mockito.mock(Struct.class)));
        Optional maybeContinuation = this.action.run(partition, record, this.tracker, this.watermarkEstimator);
        Assert.assertEquals(Optional.empty(), (Object)maybeContinuation);
        ((ManualWatermarkEstimator)Mockito.verify(this.watermarkEstimator)).setWatermark(new Instant(startTimestamp.toSqlTimestamp().getTime()));
    }

    @Test
    public void testRestrictionClaimedAndIsMergeCaseAndChildNotExists() {
        String partitionToken = "partitionToken";
        String anotherPartitionToken = "anotherPartitionToken";
        String childPartitionToken = "childPartition1";
        HashSet parentTokens = Sets.newHashSet((Object[])new String[]{"partitionToken", "anotherPartitionToken"});
        long heartbeat = 30L;
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)10L);
        Timestamp endTimestamp = Timestamp.ofTimeMicroseconds((long)20L);
        PartitionMetadata partition = (PartitionMetadata)Mockito.mock(PartitionMetadata.class);
        ChildPartitionsRecord record = new ChildPartitionsRecord(startTimestamp, "recordSequence", Collections.singletonList(new ChildPartition("childPartition1", parentTokens)), null);
        Mockito.when((Object)partition.getEndTimestamp()).thenReturn((Object)endTimestamp);
        Mockito.when((Object)partition.getHeartbeatMillis()).thenReturn((Object)30L);
        Mockito.when((Object)partition.getPartitionToken()).thenReturn((Object)"partitionToken");
        Mockito.when((Object)this.tracker.tryClaim((Object)10L)).thenReturn((Object)true);
        Mockito.when((Object)this.transaction.getPartition("childPartition1")).thenReturn(null);
        Optional maybeContinuation = this.action.run(partition, record, this.tracker, this.watermarkEstimator);
        Assert.assertEquals(Optional.empty(), (Object)maybeContinuation);
        ((ManualWatermarkEstimator)Mockito.verify(this.watermarkEstimator)).setWatermark(new Instant(startTimestamp.toSqlTimestamp().getTime()));
        ((PartitionMetadataDao.InTransactionContext)Mockito.verify((Object)this.transaction)).insert(PartitionMetadata.newBuilder().setPartitionToken("childPartition1").setParentTokens(parentTokens).setStartTimestamp(startTimestamp).setEndTimestamp(endTimestamp).setHeartbeatMillis(30L).setState(PartitionMetadata.State.CREATED).setWatermark(startTimestamp).build());
    }

    @Test
    public void testRestrictionClaimedAndIsMergeCaseAndChildExists() {
        String partitionToken = "partitionToken";
        String anotherPartitionToken = "anotherPartitionToken";
        String childPartitionToken = "childPartition1";
        HashSet parentTokens = Sets.newHashSet((Object[])new String[]{"partitionToken", "anotherPartitionToken"});
        long heartbeat = 30L;
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)10L);
        Timestamp endTimestamp = Timestamp.ofTimeMicroseconds((long)20L);
        PartitionMetadata partition = (PartitionMetadata)Mockito.mock(PartitionMetadata.class);
        ChildPartitionsRecord record = new ChildPartitionsRecord(startTimestamp, "recordSequence", Collections.singletonList(new ChildPartition("childPartition1", parentTokens)), null);
        Mockito.when((Object)partition.getEndTimestamp()).thenReturn((Object)endTimestamp);
        Mockito.when((Object)partition.getHeartbeatMillis()).thenReturn((Object)30L);
        Mockito.when((Object)partition.getPartitionToken()).thenReturn((Object)"partitionToken");
        Mockito.when((Object)this.tracker.tryClaim((Object)10L)).thenReturn((Object)true);
        Mockito.when((Object)this.transaction.getPartition("childPartition1")).thenReturn((Object)((Struct)Mockito.mock(Struct.class)));
        Optional maybeContinuation = this.action.run(partition, record, this.tracker, this.watermarkEstimator);
        Assert.assertEquals(Optional.empty(), (Object)maybeContinuation);
        ((ManualWatermarkEstimator)Mockito.verify(this.watermarkEstimator)).setWatermark(new Instant(startTimestamp.toSqlTimestamp().getTime()));
        ((PartitionMetadataDao.InTransactionContext)Mockito.verify((Object)this.transaction, (VerificationMode)Mockito.never())).insert((PartitionMetadata)ArgumentMatchers.any());
    }

    @Test
    public void testRestrictionNotClaimed() {
        String partitionToken = "partitionToken";
        Timestamp startTimestamp = Timestamp.ofTimeMicroseconds((long)10L);
        PartitionMetadata partition = (PartitionMetadata)Mockito.mock(PartitionMetadata.class);
        ChildPartitionsRecord record = new ChildPartitionsRecord(startTimestamp, "recordSequence", Arrays.asList(new ChildPartition("childPartition1", "partitionToken"), new ChildPartition("childPartition2", "partitionToken")), null);
        Mockito.when((Object)partition.getPartitionToken()).thenReturn((Object)"partitionToken");
        Mockito.when((Object)this.tracker.tryClaim((Object)10L)).thenReturn((Object)false);
        Optional maybeContinuation = this.action.run(partition, record, this.tracker, this.watermarkEstimator);
        Assert.assertEquals(Optional.of(DoFn.ProcessContinuation.stop()), (Object)maybeContinuation);
        ((ManualWatermarkEstimator)Mockito.verify(this.watermarkEstimator, (VerificationMode)Mockito.never())).setWatermark((Instant)ArgumentMatchers.any());
        ((PartitionMetadataDao)Mockito.verify((Object)this.dao, (VerificationMode)Mockito.never())).insert((PartitionMetadata)ArgumentMatchers.any());
    }
}

