/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams;

import com.google.cloud.Timestamp;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.TimestampConverter;
import org.junit.Assert;
import org.junit.Test;

public class TimestampConverterTest {
    @Test
    public void testConvertTimestampToMicros() {
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)2000360L);
        Assert.assertEquals((long)2000360L, (long)TimestampConverter.timestampToMicros((Timestamp)timestamp));
    }

    @Test
    public void testConvertTimestampZeroToMicros() {
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)0L);
        Assert.assertEquals((long)0L, (long)TimestampConverter.timestampToMicros((Timestamp)timestamp));
    }

    @Test
    public void testConvertTimestampMinToMicros() {
        Timestamp timestamp = Timestamp.MIN_VALUE;
        Assert.assertEquals((long)-62135596800000000L, (long)TimestampConverter.timestampToMicros((Timestamp)timestamp));
    }

    @Test
    public void testConvertTimestampMaxToMicros() {
        Timestamp timestamp = Timestamp.MAX_VALUE;
        Assert.assertEquals((long)253402300799999999L, (long)TimestampConverter.timestampToMicros((Timestamp)timestamp));
    }

    @Test
    public void testConvertMillisToTimestamp() {
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)1234000L);
        Assert.assertEquals((Object)timestamp, (Object)TimestampConverter.timestampFromMillis((long)1234L));
    }

    @Test
    public void testTruncateNanos() {
        Timestamp timestamp = Timestamp.ofTimeSecondsAndNanos((long)10L, (int)123456789);
        Timestamp expectedTimestamp = Timestamp.ofTimeSecondsAndNanos((long)10L, (int)123456000);
        Assert.assertEquals((Object)expectedTimestamp, (Object)TimestampConverter.truncateNanos((Timestamp)timestamp));
    }
}

