/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.io.gcp.spanner.StructUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Test;

public class StructUtilsTest {
    private static final Schema EMPTY_SCHEMA = Schema.builder().build();
    private static final Schema INT64_SCHEMA = Schema.builder().addInt64Field("int64").build();

    @Test
    public void testStructToBeamRow() {
        Schema schema = this.getSchemaTemplate().addDateTimeField("f_date").build();
        Row row = this.getRowTemplate(schema).withFieldValue("f_date", (Object)DateTime.parse((String)"2077-10-24")).build();
        Struct struct = ((Struct.Builder)this.getStructTemplate().set("f_date").to(Date.fromYearMonthDay((int)2077, (int)10, (int)24))).build();
        Assert.assertEquals((Object)row, (Object)StructUtils.structToBeamRow((Struct)struct, (Schema)schema));
    }

    @Test
    public void testStructToBeamRowFailsColumnsDontMatch() {
        Schema schema = Schema.builder().addInt64Field("f_int64").build();
        Struct struct = ((Struct.Builder)Struct.newBuilder().set("f_different_field").to(5L)).build();
        Exception exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> StructUtils.structToBeamRow((Struct)struct, (Schema)schema));
        this.checkMessage("Field not found: f_int64", exception.getMessage());
    }

    @Test
    public void testStructToBeamRowFailsTypesDontMatch() {
        Schema schema = Schema.builder().addInt64Field("f_int64").build();
        Struct struct = ((Struct.Builder)Struct.newBuilder().set("f_int64").to("string_value")).build();
        Exception exception = (Exception)Assert.assertThrows(ClassCastException.class, () -> StructUtils.structToBeamRow((Struct)struct, (Schema)schema));
        this.checkMessage("java.lang.String cannot be cast to java.lang.Long", exception.getMessage());
    }

    @Test
    public void testBeamRowToStruct() {
        Schema schema = this.getSchemaTemplate().addIterableField("f_iterable", Schema.FieldType.INT64).addDecimalField("f_decimal").build();
        Row row = this.getRowTemplate(schema).withFieldValue("f_iterable", (Object)ImmutableList.of((Object)20L)).withFieldValue("f_decimal", (Object)BigDecimal.ONE).build();
        Struct struct = ((Struct.Builder)((Struct.Builder)this.getStructTemplate().set("f_iterable").toInt64Array((Iterable)ImmutableList.of((Object)20L))).set("f_decimal").to(BigDecimal.ONE)).build();
        Assert.assertEquals((Object)struct, (Object)StructUtils.beamRowToStruct((Row)row));
    }

    @Test
    public void testBeamRowToStructNulls() {
        Schema schema = this.getSchemaTemplate().build();
        Row row = this.getRowBuilder(schema).build();
        Struct struct = this.getStructTemplateNulls().build();
        Assert.assertEquals((Object)struct, (Object)StructUtils.beamRowToStruct((Row)row));
    }

    @Test
    public void testBeamRowToStructNullDecimalNullShouldFail() {
        Schema schema = this.getSchemaTemplate().addNullableField("f_decimal", Schema.FieldType.DECIMAL).build();
        Row row = this.getRowBuilder(schema).addValue(null).build();
        NullPointerException npe = (NullPointerException)Assert.assertThrows(NullPointerException.class, () -> StructUtils.beamRowToStruct((Row)row));
        String message = npe.getMessage();
        this.checkMessage("Null", message);
    }

    @Test
    public void testBeamRowToStructFailsTypeNotSupported() {
        Schema schema = this.getSchemaTemplate().addMapField("f_map", Schema.FieldType.STRING, Schema.FieldType.STRING).build();
        Row row = this.getRowTemplate(schema).withFieldValue("f_map", (Object)ImmutableMap.of((Object)"a", (Object)"b")).build();
        Exception exception = (Exception)Assert.assertThrows(IllegalArgumentException.class, () -> StructUtils.beamRowToStruct((Row)row));
        this.checkMessage("Unsupported beam type 'MAP' while translating row to struct.", exception.getMessage());
    }

    @Test
    public void testBeamTypeToSpannerTypeTranslation() {
        Assert.assertEquals((Object)Type.int64(), (Object)StructUtils.beamTypeToSpannerType((Schema.FieldType)Schema.FieldType.INT64));
        Assert.assertEquals((Object)Type.int64(), (Object)StructUtils.beamTypeToSpannerType((Schema.FieldType)Schema.FieldType.INT32));
        Assert.assertEquals((Object)Type.int64(), (Object)StructUtils.beamTypeToSpannerType((Schema.FieldType)Schema.FieldType.INT16));
        Assert.assertEquals((Object)Type.int64(), (Object)StructUtils.beamTypeToSpannerType((Schema.FieldType)Schema.FieldType.BYTE));
        Assert.assertEquals((Object)Type.bytes(), (Object)StructUtils.beamTypeToSpannerType((Schema.FieldType)Schema.FieldType.BYTES));
        Assert.assertEquals((Object)Type.string(), (Object)StructUtils.beamTypeToSpannerType((Schema.FieldType)Schema.FieldType.STRING));
        Assert.assertEquals((Object)Type.float64(), (Object)StructUtils.beamTypeToSpannerType((Schema.FieldType)Schema.FieldType.FLOAT));
        Assert.assertEquals((Object)Type.float64(), (Object)StructUtils.beamTypeToSpannerType((Schema.FieldType)Schema.FieldType.DOUBLE));
        Assert.assertEquals((Object)Type.bool(), (Object)StructUtils.beamTypeToSpannerType((Schema.FieldType)Schema.FieldType.BOOLEAN));
        Assert.assertEquals((Object)Type.numeric(), (Object)StructUtils.beamTypeToSpannerType((Schema.FieldType)Schema.FieldType.DECIMAL));
        Assert.assertEquals((Object)Type.struct((Iterable)ImmutableList.of((Object)Type.StructField.of((String)"int64", (Type)Type.int64()))), (Object)StructUtils.beamTypeToSpannerType((Schema.FieldType)Schema.FieldType.row((Schema)INT64_SCHEMA)));
        Assert.assertEquals((Object)Type.array((Type)Type.int64()), (Object)StructUtils.beamTypeToSpannerType((Schema.FieldType)Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT64)));
    }

    private Schema.Builder getSchemaTemplate() {
        return Schema.builder().addNullableField("f_int64", Schema.FieldType.INT64).addNullableField("f_float64", Schema.FieldType.DOUBLE).addNullableField("f_string", Schema.FieldType.STRING).addNullableField("f_bytes", Schema.FieldType.BYTES).addNullableField("f_timestamp", Schema.FieldType.DATETIME).addNullableField("f_bool", Schema.FieldType.BOOLEAN).addNullableField("f_struct", Schema.FieldType.row((Schema)EMPTY_SCHEMA)).addNullableField("f_struct_int64", Schema.FieldType.row((Schema)INT64_SCHEMA)).addNullableField("f_array", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.INT64)).addNullableField("f_struct_array", Schema.FieldType.array((Schema.FieldType)Schema.FieldType.row((Schema)INT64_SCHEMA)));
    }

    private Row.FieldValueBuilder getRowTemplate(Schema schema) {
        return Row.withSchema((Schema)schema).withFieldValue("f_int64", (Object)1L).withFieldValue("f_float64", (Object)5.5).withFieldValue("f_string", (Object)"ducky_doo").withFieldValue("f_bytes", (Object)ByteArray.copyFrom((byte[])"random_bytes".getBytes(StandardCharsets.UTF_8)).toByteArray()).withFieldValue("f_timestamp", (Object)DateTime.parse((String)"2077-01-10")).withFieldValue("f_bool", (Object)true).withFieldValue("f_struct", (Object)Row.withSchema((Schema)EMPTY_SCHEMA).build()).withFieldValue("f_struct_int64", (Object)Row.withSchema((Schema)INT64_SCHEMA).withFieldValue("int64", (Object)10L).build()).withFieldValue("f_array", (Object)ImmutableList.of((Object)55L, (Object)43L)).withFieldValue("f_struct_array", (Object)ImmutableList.of((Object)Row.withSchema((Schema)INT64_SCHEMA).withFieldValue("int64", (Object)1L).build(), (Object)Row.withSchema((Schema)INT64_SCHEMA).withFieldValue("int64", (Object)2L).build()));
    }

    private Row.Builder getRowBuilder(Schema schema) {
        return Row.withSchema((Schema)schema).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null).addValue(null);
    }

    private Struct.Builder getStructTemplate() {
        return (Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f_int64").to(1L)).set("f_float64").to(5.5)).set("f_string").to("ducky_doo")).set("f_bytes").to(ByteArray.copyFrom((byte[])"random_bytes".getBytes(StandardCharsets.UTF_8)))).set("f_timestamp").to(Timestamp.ofTimeMicroseconds((long)(DateTime.parse((String)"2077-01-10").toInstant().getMillis() * 1000L)))).set("f_bool").to(true)).set("f_struct").to(Struct.newBuilder().build())).set("f_struct_int64").to(((Struct.Builder)Struct.newBuilder().set("int64").to(10L)).build())).set("f_array").toInt64Array((Iterable)ImmutableList.of((Object)55L, (Object)43L))).set("f_struct_array").toStructArray(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"int64", (Type)Type.int64())}), (Iterable)ImmutableList.of((Object)((Struct.Builder)Struct.newBuilder().set("int64").to(1L)).build(), (Object)((Struct.Builder)Struct.newBuilder().set("int64").to(2L)).build()));
    }

    private Struct.Builder getStructTemplateNulls() {
        return (Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("f_int64").to((Long)null)).set("f_float64").to((Double)null)).set("f_string").to((String)null)).set("f_bytes").to((ByteArray)null)).set("f_timestamp").to((Timestamp)null)).set("f_bool").to((Boolean)null)).set("f_struct").to(Type.struct((Type.StructField[])new Type.StructField[0]), null)).set("f_struct_int64").to(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"int64", (Type)Type.int64())}), null)).set("f_array").toInt64Array((Iterable)null)).set("f_struct_array").toStructArray(Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"int64", (Type)Type.int64())}), null);
    }

    private void checkMessage(String substring, @Nullable String message) {
        if (message != null) {
            MatcherAssert.assertThat((Object)message, (Matcher)Matchers.containsString((String)substring));
        } else {
            Assert.fail();
        }
    }
}

