/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import java.io.Serializable;
import java.util.Collections;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.GenerateSequence;
import org.apache.beam.sdk.io.gcp.spanner.RandomUtils;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.SpannerWriteResult;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.testing.TestPipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Wait;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicate;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Throwables;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class SpannerWriteIT {
    private static final int MAX_DB_NAME_LENGTH = 30;
    @Rule
    public final transient TestPipeline p = TestPipeline.create();
    @Rule
    public transient ExpectedException thrown = ExpectedException.none();
    private Spanner spanner;
    private DatabaseAdminClient databaseAdminClient;
    private SpannerTestPipelineOptions options;
    private String databaseName;
    private String project;

    @Before
    public void setUp() throws Exception {
        PipelineOptionsFactory.register(SpannerTestPipelineOptions.class);
        this.options = (SpannerTestPipelineOptions)TestPipeline.testingPipelineOptions().as(SpannerTestPipelineOptions.class);
        this.project = this.options.getInstanceProjectId();
        if (this.project == null) {
            this.project = ((GcpOptions)this.options.as(GcpOptions.class)).getProject();
        }
        this.spanner = (Spanner)((SpannerOptions.Builder)SpannerOptions.newBuilder().setProjectId(this.project)).build().getService();
        this.databaseName = this.generateDatabaseName();
        this.databaseAdminClient = this.spanner.getDatabaseAdminClient();
        this.databaseAdminClient.dropDatabase(this.options.getInstanceId(), this.databaseName);
        OperationFuture op = this.databaseAdminClient.createDatabase(this.options.getInstanceId(), this.databaseName, Collections.singleton("CREATE TABLE " + this.options.getTable() + " (  Key           INT64,  Value         STRING(MAX) NOT NULL,) PRIMARY KEY (Key)"));
        op.get();
    }

    private String generateDatabaseName() {
        String random = RandomUtils.randomAlphaNumeric(29 - this.options.getDatabaseIdPrefix().length());
        return this.options.getDatabaseIdPrefix() + "-" + random;
    }

    @Test
    public void testWrite() throws Exception {
        int numRecords = 100;
        ((PCollection)((PCollection)this.p.apply((PTransform)GenerateSequence.from((long)0L).to((long)numRecords))).apply((PTransform)ParDo.of((DoFn)new GenerateMutations(this.options.getTable())))).apply((PTransform)SpannerIO.write().withProjectId(this.project).withInstanceId(this.options.getInstanceId()).withDatabaseId(this.databaseName));
        PipelineResult result = this.p.run();
        result.waitUntilFinish();
        MatcherAssert.assertThat((Object)result.getState(), (Matcher)Matchers.is((Object)PipelineResult.State.DONE));
        MatcherAssert.assertThat((Object)this.countNumberOfRecords(), (Matcher)Matchers.equalTo((Object)numRecords));
    }

    @Test
    public void testSequentialWrite() throws Exception {
        int numRecords = 100;
        SpannerWriteResult stepOne = (SpannerWriteResult)((PCollection)((PCollection)this.p.apply("first step", (PTransform)GenerateSequence.from((long)0L).to((long)numRecords))).apply((PTransform)ParDo.of((DoFn)new GenerateMutations(this.options.getTable())))).apply((PTransform)SpannerIO.write().withProjectId(this.project).withInstanceId(this.options.getInstanceId()).withDatabaseId(this.databaseName));
        ((PCollection)((PCollection)((PCollection)this.p.apply("second step", (PTransform)GenerateSequence.from((long)numRecords).to((long)(2 * numRecords)))).apply("Gen mutations", (PTransform)ParDo.of((DoFn)new GenerateMutations(this.options.getTable())))).apply((PTransform)Wait.on((PCollection[])new PCollection[]{stepOne.getOutput()}))).apply("write to table2", (PTransform)SpannerIO.write().withProjectId(this.project).withInstanceId(this.options.getInstanceId()).withDatabaseId(this.databaseName));
        PipelineResult result = this.p.run();
        result.waitUntilFinish();
        MatcherAssert.assertThat((Object)result.getState(), (Matcher)Matchers.is((Object)PipelineResult.State.DONE));
        MatcherAssert.assertThat((Object)this.countNumberOfRecords(), (Matcher)Matchers.equalTo((Object)(2L * (long)numRecords)));
    }

    @Test
    public void testReportFailures() throws Exception {
        int numRecords = 100;
        ((PCollection)((PCollection)this.p.apply((PTransform)GenerateSequence.from((long)0L).to((long)(2 * numRecords)))).apply((PTransform)ParDo.of((DoFn)new GenerateMutations(this.options.getTable(), new DivBy2())))).apply((PTransform)SpannerIO.write().withProjectId(this.project).withInstanceId(this.options.getInstanceId()).withDatabaseId(this.databaseName).withFailureMode(SpannerIO.FailureMode.REPORT_FAILURES));
        PipelineResult result = this.p.run();
        result.waitUntilFinish();
        MatcherAssert.assertThat((Object)result.getState(), (Matcher)Matchers.is((Object)PipelineResult.State.DONE));
        MatcherAssert.assertThat((Object)this.countNumberOfRecords(), (Matcher)Matchers.equalTo((Object)numRecords));
    }

    @Test
    public void testFailFast() throws Exception {
        this.thrown.expect((Matcher)new StackTraceContainsString("SpannerException"));
        this.thrown.expect((Matcher)new StackTraceContainsString("Value must not be NULL in table users"));
        int numRecords = 100;
        ((PCollection)((PCollection)this.p.apply((PTransform)GenerateSequence.from((long)0L).to((long)(2 * numRecords)))).apply((PTransform)ParDo.of((DoFn)new GenerateMutations(this.options.getTable(), new DivBy2())))).apply((PTransform)SpannerIO.write().withProjectId(this.project).withInstanceId(this.options.getInstanceId()).withDatabaseId(this.databaseName));
        PipelineResult result = this.p.run();
        result.waitUntilFinish();
    }

    @After
    public void tearDown() throws Exception {
        this.databaseAdminClient.dropDatabase(this.options.getInstanceId(), this.databaseName);
        this.spanner.close();
    }

    private long countNumberOfRecords() {
        ResultSet resultSet = this.spanner.getDatabaseClient(DatabaseId.of((String)this.project, (String)this.options.getInstanceId(), (String)this.databaseName)).singleUse().executeQuery(Statement.of((String)("SELECT COUNT(*) FROM " + this.options.getTable())), new Options.QueryOption[0]);
        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)Matchers.is((Object)true));
        long result = resultSet.getLong(0);
        MatcherAssert.assertThat((Object)resultSet.next(), (Matcher)Matchers.is((Object)false));
        return result;
    }

    static class StackTraceContainsString
    extends TypeSafeMatcher<Exception> {
        private String str;

        public StackTraceContainsString(String str) {
            this.str = str;
        }

        public void describeTo(Description description) {
            description.appendText("stack trace contains string '" + this.str + "'");
        }

        protected boolean matchesSafely(Exception e) {
            String stacktrace = Throwables.getStackTraceAsString((Throwable)e);
            return stacktrace.contains(this.str);
        }
    }

    private static class DivBy2
    implements Predicate<Long>,
    Serializable {
        private DivBy2() {
        }

        public boolean apply(@Nullable Long input) {
            return input % 2L == 0L;
        }
    }

    private static class GenerateMutations
    extends DoFn<Long, Mutation> {
        private final String table;
        private final int valueSize = 100;
        private final Predicate<Long> injectError;

        public GenerateMutations(String table, Predicate<Long> injectError) {
            this.table = table;
            this.injectError = injectError;
        }

        public GenerateMutations(String table) {
            this(table, (Predicate<Long>)Predicates.alwaysFalse());
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            Mutation.WriteBuilder builder = Mutation.newInsertOrUpdateBuilder((String)this.table);
            Long key = (Long)c.element();
            builder.set("Key").to(key);
            String value = this.injectError.apply((Object)key) ? null : RandomUtils.randomAlphaNumeric(100);
            builder.set("Value").to(value);
            Mutation mutation = builder.build();
            c.output((Object)mutation);
        }
    }

    public static interface SpannerTestPipelineOptions
    extends TestPipelineOptions {
        @org.apache.beam.sdk.options.Description(value="Project that hosts Spanner instance")
        public @Nullable String getInstanceProjectId();

        public void setInstanceProjectId(String var1);

        @org.apache.beam.sdk.options.Description(value="Instance ID to write to in Spanner")
        @Default.String(value="beam-test")
        public String getInstanceId();

        public void setInstanceId(String var1);

        @org.apache.beam.sdk.options.Description(value="Database ID prefix to write to in Spanner")
        @Default.String(value="beam-testdb")
        public String getDatabaseIdPrefix();

        public void setDatabaseIdPrefix(String var1);

        @org.apache.beam.sdk.options.Description(value="Table name")
        @Default.String(value="users")
        public String getTable();

        public void setTable(String var1);
    }
}

