/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ServiceFactory;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.BatchTransactionId;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.FakeBatchTransactionId;
import com.google.cloud.spanner.FakePartitionFactory;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Partition;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.ResultSets;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.beam.runners.core.metrics.GcpResourceIdentifiers;
import org.apache.beam.runners.core.metrics.MetricsContainerImpl;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.spanner.FakeServiceFactory;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.testing.PAssert;
import org.apache.beam.sdk.testing.TestPipeline;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=JUnit4.class)
public class SpannerIOReadTest
implements Serializable {
    @Rule
    public final transient TestPipeline pipeline = TestPipeline.create().enableAbandonedNodeEnforcement(false);
    @Rule
    public final transient ExpectedException thrown = ExpectedException.none();
    private FakeServiceFactory serviceFactory;
    private BatchReadOnlyTransaction mockBatchTx;
    private static final Type FAKE_TYPE = Type.struct((Type.StructField[])new Type.StructField[]{Type.StructField.of((String)"id", (Type)Type.int64()), Type.StructField.of((String)"name", (Type)Type.string())});
    private static final List<Struct> FAKE_ROWS = Arrays.asList(((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)1L))).set("name").to("Alice")).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)2L))).set("name").to("Bob")).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)3L))).set("name").to("Carl")).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)4L))).set("name").to("Dan")).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)5L))).set("name").to("Evan")).build(), ((Struct.Builder)((Struct.Builder)Struct.newBuilder().set("id").to(Value.int64((long)6L))).set("name").to("Floyd")).build());

    @Before
    public void setUp() throws Exception {
        this.serviceFactory = new FakeServiceFactory();
        this.mockBatchTx = (BatchReadOnlyTransaction)Mockito.mock(BatchReadOnlyTransaction.class);
        MetricsContainerImpl container = new MetricsContainerImpl(null);
        MetricsEnvironment.setProcessWideContainer((MetricsContainer)container);
    }

    @Test
    public void runQuery() throws Exception {
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)12345L);
        TimestampBound timestampBound = TimestampBound.ofReadTimestamp((Timestamp)timestamp);
        SpannerConfig spannerConfig = this.getSpannerConfig();
        PCollection one = (PCollection)this.pipeline.apply("read q", (PTransform)SpannerIO.read().withSpannerConfig(spannerConfig).withQuery("SELECT * FROM users").withTimestampBound(timestampBound));
        FakeBatchTransactionId id = new FakeBatchTransactionId("runQueryTest");
        Mockito.when((Object)this.mockBatchTx.getBatchTransactionId()).thenReturn((Object)id);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction(timestampBound)).thenReturn((Object)this.mockBatchTx);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction((BatchTransactionId)Matchers.any(BatchTransactionId.class))).thenReturn((Object)this.mockBatchTx);
        Partition fakePartition = FakePartitionFactory.createFakeQueryPartition(ByteString.copyFromUtf8((String)"one"));
        Mockito.when((Object)this.mockBatchTx.partitionQuery((PartitionOptions)Matchers.any(PartitionOptions.class), (Statement)Matchers.eq((Object)Statement.of((String)"SELECT * FROM users")), new Options.QueryOption[]{(Options.QueryOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(fakePartition, fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(0, 2)), (Object[])new ResultSet[]{ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(2, 6))});
        PAssert.that((PCollection)one).containsInAnyOrder(FAKE_ROWS);
        this.pipeline.run();
    }

    @Test
    public void runQueryWithPriority() throws Exception {
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)12345L);
        TimestampBound timestampBound = TimestampBound.ofReadTimestamp((Timestamp)timestamp);
        SpannerConfig spannerConfig = this.getSpannerConfig();
        SpannerIO.Read read = SpannerIO.read().withSpannerConfig(spannerConfig).withQuery("SELECT * FROM users").withTimestampBound(timestampBound).withHighPriority();
        PCollection one = (PCollection)this.pipeline.apply("read q", (PTransform)read);
        FakeBatchTransactionId id = new FakeBatchTransactionId("runQueryTest");
        Mockito.when((Object)this.mockBatchTx.getBatchTransactionId()).thenReturn((Object)id);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction(timestampBound)).thenReturn((Object)this.mockBatchTx);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction((BatchTransactionId)Matchers.any(BatchTransactionId.class))).thenReturn((Object)this.mockBatchTx);
        Partition fakePartition = FakePartitionFactory.createFakeQueryPartition(ByteString.copyFromUtf8((String)"one"));
        Mockito.when((Object)this.mockBatchTx.partitionQuery((PartitionOptions)Matchers.any(PartitionOptions.class), (Statement)Matchers.eq((Object)Statement.of((String)"SELECT * FROM users")), new Options.QueryOption[]{(Options.QueryOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(fakePartition, fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(0, 2)), (Object[])new ResultSet[]{ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(2, 6))});
        PAssert.that((PCollection)one).containsInAnyOrder(FAKE_ROWS);
        Assert.assertEquals((Object)Options.RpcPriority.HIGH, (Object)read.getSpannerConfig().getRpcPriority().get());
        this.pipeline.run();
    }

    private SpannerConfig getSpannerConfig() {
        return SpannerConfig.create().withProjectId("test").withInstanceId("123").withDatabaseId("aaa").withServiceFactory((ServiceFactory)this.serviceFactory);
    }

    @Test
    public void runReadTestWithProjectId() throws Exception {
        this.runReadTest(this.getSpannerConfig());
    }

    @Test
    public void runReadTestWithDefaultProject() throws Exception {
        this.runReadTest(SpannerConfig.create().withInstanceId("123").withDatabaseId("aaa").withServiceFactory((ServiceFactory)this.serviceFactory));
    }

    private void runReadTest(SpannerConfig spannerConfig) throws Exception {
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)12345L);
        TimestampBound timestampBound = TimestampBound.ofReadTimestamp((Timestamp)timestamp);
        PCollection one = (PCollection)this.pipeline.apply("read q", (PTransform)SpannerIO.read().withSpannerConfig(spannerConfig).withTable("users").withColumns(new String[]{"id", "name"}).withTimestampBound(timestampBound));
        FakeBatchTransactionId id = new FakeBatchTransactionId("runReadTest");
        Mockito.when((Object)this.mockBatchTx.getBatchTransactionId()).thenReturn((Object)id);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction(timestampBound)).thenReturn((Object)this.mockBatchTx);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction((BatchTransactionId)Matchers.any(BatchTransactionId.class))).thenReturn((Object)this.mockBatchTx);
        Partition fakePartition = FakePartitionFactory.createFakeReadPartition(ByteString.copyFromUtf8((String)"one"));
        Mockito.when((Object)this.mockBatchTx.partitionRead((PartitionOptions)Matchers.any(PartitionOptions.class), (String)Matchers.eq((Object)"users"), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[]{(Options.ReadOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(fakePartition, fakePartition, fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(0, 2)), (Object[])new ResultSet[]{ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(2, 4)), ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(4, 6))});
        PAssert.that((PCollection)one).containsInAnyOrder(FAKE_ROWS);
        this.pipeline.run();
    }

    @Test
    public void runReadWithPriority() throws Exception {
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)12345L);
        TimestampBound timestampBound = TimestampBound.ofReadTimestamp((Timestamp)timestamp);
        SpannerConfig spannerConfig = this.getSpannerConfig();
        SpannerIO.Read read = SpannerIO.read().withSpannerConfig(spannerConfig).withTable("users").withColumns(new String[]{"id", "name"}).withTimestampBound(timestampBound).withLowPriority();
        PCollection one = (PCollection)this.pipeline.apply("read q", (PTransform)read);
        FakeBatchTransactionId id = new FakeBatchTransactionId("runReadTest");
        Mockito.when((Object)this.mockBatchTx.getBatchTransactionId()).thenReturn((Object)id);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction(timestampBound)).thenReturn((Object)this.mockBatchTx);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction((BatchTransactionId)Matchers.any(BatchTransactionId.class))).thenReturn((Object)this.mockBatchTx);
        Partition fakePartition = FakePartitionFactory.createFakeReadPartition(ByteString.copyFromUtf8((String)"one"));
        Mockito.when((Object)this.mockBatchTx.partitionRead((PartitionOptions)Matchers.any(PartitionOptions.class), (String)Matchers.eq((Object)"users"), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[]{(Options.ReadOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(fakePartition, fakePartition, fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(0, 2)), (Object[])new ResultSet[]{ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(2, 4)), ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(4, 6))});
        PAssert.that((PCollection)one).containsInAnyOrder(FAKE_ROWS);
        Assert.assertEquals((Object)Options.RpcPriority.LOW, (Object)read.getSpannerConfig().getRpcPriority().get());
        this.pipeline.run();
    }

    @Test
    public void testQueryMetricsFail() throws Exception {
        block2: {
            Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)12345L);
            TimestampBound timestampBound = TimestampBound.ofReadTimestamp((Timestamp)timestamp);
            SpannerConfig spannerConfig = this.getSpannerConfig();
            this.pipeline.apply("read q", (PTransform)SpannerIO.read().withSpannerConfig(spannerConfig).withQuery("SELECT * FROM users").withQueryName("queryName").withTimestampBound(timestampBound));
            FakeBatchTransactionId id = new FakeBatchTransactionId("runQueryTest");
            Mockito.when((Object)this.mockBatchTx.getBatchTransactionId()).thenReturn((Object)id);
            Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction(timestampBound)).thenReturn((Object)this.mockBatchTx);
            Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction((BatchTransactionId)Matchers.any(BatchTransactionId.class))).thenReturn((Object)this.mockBatchTx);
            Partition fakePartition = FakePartitionFactory.createFakeQueryPartition(ByteString.copyFromUtf8((String)"one"));
            Mockito.when((Object)this.mockBatchTx.partitionQuery((PartitionOptions)Matchers.any(PartitionOptions.class), (Statement)Matchers.eq((Object)Statement.of((String)"SELECT * FROM users")), new Options.QueryOption[]{(Options.QueryOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(fakePartition));
            Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.DEADLINE_EXCEEDED, (String)"Simulated Timeout 1")});
            try {
                this.pipeline.run();
            }
            catch (Pipeline.PipelineExecutionException e) {
                if (e.getCause() instanceof SpannerException && ((SpannerException)e.getCause()).getErrorCode().getGrpcStatusCode() == Status.Code.DEADLINE_EXCEEDED) break block2;
                throw e;
            }
        }
        this.verifyMetricWasSet("test", "aaa", "123", "deadline_exceeded", null, 1L);
        this.verifyMetricWasSet("test", "aaa", "123", "ok", null, 0L);
    }

    @Test
    public void testQueryMetricsSucceed() throws Exception {
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)12345L);
        TimestampBound timestampBound = TimestampBound.ofReadTimestamp((Timestamp)timestamp);
        SpannerConfig spannerConfig = this.getSpannerConfig();
        this.pipeline.apply("read q", (PTransform)SpannerIO.read().withSpannerConfig(spannerConfig).withQuery("SELECT * FROM users").withQueryName("queryName").withTimestampBound(timestampBound));
        FakeBatchTransactionId id = new FakeBatchTransactionId("runQueryTest");
        Mockito.when((Object)this.mockBatchTx.getBatchTransactionId()).thenReturn((Object)id);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction(timestampBound)).thenReturn((Object)this.mockBatchTx);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction((BatchTransactionId)Matchers.any(BatchTransactionId.class))).thenReturn((Object)this.mockBatchTx);
        Partition fakePartition = FakePartitionFactory.createFakeQueryPartition(ByteString.copyFromUtf8((String)"one"));
        Mockito.when((Object)this.mockBatchTx.partitionQuery((PartitionOptions)Matchers.any(PartitionOptions.class), (Statement)Matchers.eq((Object)Statement.of((String)"SELECT * FROM users")), new Options.QueryOption[]{(Options.QueryOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(fakePartition, fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(0, 2)), (Object[])new ResultSet[]{ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(2, 4)), ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(4, 6))}).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(0, 2)), (Object[])new ResultSet[]{ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(2, 4)), ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(4, 6))});
        this.pipeline.run();
        this.verifyMetricWasSet("test", "aaa", "123", "deadline_exceeded", null, 0L);
        this.verifyMetricWasSet("test", "aaa", "123", "ok", null, 2L);
    }

    @Test
    public void testReadMetricsFail() throws Exception {
        block2: {
            Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)12345L);
            TimestampBound timestampBound = TimestampBound.ofReadTimestamp((Timestamp)timestamp);
            SpannerConfig spannerConfig = this.getSpannerConfig();
            this.pipeline.apply("read q", (PTransform)SpannerIO.read().withSpannerConfig(spannerConfig).withTable("users").withColumns(new String[]{"id", "name"}).withTimestampBound(timestampBound));
            FakeBatchTransactionId id = new FakeBatchTransactionId("runReadTest");
            Mockito.when((Object)this.mockBatchTx.getBatchTransactionId()).thenReturn((Object)id);
            Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction(timestampBound)).thenReturn((Object)this.mockBatchTx);
            Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction((BatchTransactionId)Matchers.any(BatchTransactionId.class))).thenReturn((Object)this.mockBatchTx);
            Partition fakePartition = FakePartitionFactory.createFakeReadPartition(ByteString.copyFromUtf8((String)"one"));
            Mockito.when((Object)this.mockBatchTx.partitionRead((PartitionOptions)Matchers.any(PartitionOptions.class), (String)Matchers.eq((Object)"users"), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[]{(Options.ReadOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(fakePartition));
            Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenThrow(new Throwable[]{SpannerExceptionFactory.newSpannerException((ErrorCode)ErrorCode.DEADLINE_EXCEEDED, (String)"Simulated Timeout 1")});
            try {
                this.pipeline.run();
            }
            catch (Pipeline.PipelineExecutionException e) {
                if (e.getCause() instanceof SpannerException && ((SpannerException)e.getCause()).getErrorCode().getGrpcStatusCode() == Status.Code.DEADLINE_EXCEEDED) break block2;
                throw e;
            }
        }
        this.verifyMetricWasSet("test", "aaa", "123", "deadline_exceeded", null, 1L);
        this.verifyMetricWasSet("test", "aaa", "123", "ok", null, 0L);
    }

    @Test
    public void testReadMetricsSucceed() throws Exception {
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)12345L);
        TimestampBound timestampBound = TimestampBound.ofReadTimestamp((Timestamp)timestamp);
        SpannerConfig spannerConfig = this.getSpannerConfig();
        this.pipeline.apply("read q", (PTransform)SpannerIO.read().withSpannerConfig(spannerConfig).withTable("users").withColumns(new String[]{"id", "name"}).withTimestampBound(timestampBound));
        FakeBatchTransactionId id = new FakeBatchTransactionId("runReadTest");
        Mockito.when((Object)this.mockBatchTx.getBatchTransactionId()).thenReturn((Object)id);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction(timestampBound)).thenReturn((Object)this.mockBatchTx);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction((BatchTransactionId)Matchers.any(BatchTransactionId.class))).thenReturn((Object)this.mockBatchTx);
        Partition fakePartition = FakePartitionFactory.createFakeReadPartition(ByteString.copyFromUtf8((String)"one"));
        Mockito.when((Object)this.mockBatchTx.partitionRead((PartitionOptions)Matchers.any(PartitionOptions.class), (String)Matchers.eq((Object)"users"), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[]{(Options.ReadOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(fakePartition, fakePartition, fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(0, 2)), (Object[])new ResultSet[]{ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(2, 4)), ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(4, 6))});
        this.pipeline.run();
        this.verifyMetricWasSet("test", "aaa", "123", "ok", null, 3L);
    }

    private void verifyMetricWasSet(String projectId, String databaseId, String tableId, String status, @Nullable String queryName, long count) {
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put("PTRANSFORM", "");
        labels.put("SERVICE", "Spanner");
        labels.put("METHOD", "Read");
        labels.put("RESOURCE", GcpResourceIdentifiers.spannerTable((String)projectId, (String)databaseId, (String)tableId));
        labels.put("SPANNER_PROJECT_ID", projectId);
        labels.put("SPANNER_DATABASE_ID", databaseId);
        labels.put("SPANNER_INSTANCE_ID", tableId);
        if (queryName != null) {
            labels.put("SPANNER_QUERY_NAME", queryName);
        }
        labels.put("STATUS", status);
        MonitoringInfoMetricName name = MonitoringInfoMetricName.named((String)MonitoringInfoConstants.Urns.API_REQUEST_COUNT, labels);
        MetricsContainerImpl container = (MetricsContainerImpl)MetricsEnvironment.getProcessWideContainer();
        Assert.assertEquals((long)count, (long)container.getCounter((MetricName)name).getCumulative());
    }

    @Test
    public void runReadUsingIndex() throws Exception {
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)12345L);
        TimestampBound timestampBound = TimestampBound.ofReadTimestamp((Timestamp)timestamp);
        SpannerConfig spannerConfig = this.getSpannerConfig();
        PCollection one = (PCollection)this.pipeline.apply("read q", (PTransform)SpannerIO.read().withTimestamp(Timestamp.now()).withSpannerConfig(spannerConfig).withTable("users").withColumns(new String[]{"id", "name"}).withIndex("theindex").withTimestampBound(timestampBound));
        FakeBatchTransactionId id = new FakeBatchTransactionId("runReadUsingIndexTest");
        Mockito.when((Object)this.mockBatchTx.getBatchTransactionId()).thenReturn((Object)id);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction(timestampBound)).thenReturn((Object)this.mockBatchTx);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction((BatchTransactionId)Matchers.any(BatchTransactionId.class))).thenReturn((Object)this.mockBatchTx);
        Partition fakePartition = FakePartitionFactory.createFakeReadPartition(ByteString.copyFromUtf8((String)"one"));
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction((BatchTransactionId)id)).thenReturn((Object)this.mockBatchTx);
        Mockito.when((Object)this.mockBatchTx.partitionReadUsingIndex((PartitionOptions)Matchers.any(PartitionOptions.class), (String)Matchers.eq((Object)"users"), (String)Matchers.eq((Object)"theindex"), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[]{(Options.ReadOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(fakePartition, fakePartition, fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(0, 2)), (Object[])new ResultSet[]{ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(2, 4)), ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(4, 6))});
        PAssert.that((PCollection)one).containsInAnyOrder(FAKE_ROWS);
        this.pipeline.run();
    }

    @Test
    public void readPipeline() throws Exception {
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)12345L);
        TimestampBound timestampBound = TimestampBound.ofReadTimestamp((Timestamp)timestamp);
        SpannerConfig spannerConfig = this.getSpannerConfig();
        PCollection one = (PCollection)this.pipeline.apply("read q", (PTransform)SpannerIO.read().withSpannerConfig(spannerConfig).withQuery("SELECT * FROM users").withTimestampBound(timestampBound));
        FakeBatchTransactionId txId = new FakeBatchTransactionId("readPipelineTest");
        Mockito.when((Object)this.mockBatchTx.getBatchTransactionId()).thenReturn((Object)txId);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction(timestampBound)).thenReturn((Object)this.mockBatchTx);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction((BatchTransactionId)Matchers.any(BatchTransactionId.class))).thenReturn((Object)this.mockBatchTx);
        Partition fakePartition = FakePartitionFactory.createFakeQueryPartition(ByteString.copyFromUtf8((String)"one"));
        Mockito.when((Object)this.mockBatchTx.partitionQuery((PartitionOptions)Matchers.any(PartitionOptions.class), (Statement)Matchers.eq((Object)Statement.of((String)"SELECT * FROM users")), new Options.QueryOption[]{(Options.QueryOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(fakePartition, fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(0, 2)), (Object[])new ResultSet[]{ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(2, 6))});
        PAssert.that((PCollection)one).containsInAnyOrder(FAKE_ROWS);
        this.pipeline.run();
    }

    @Test
    public void readAllPipeline() throws Exception {
        Timestamp timestamp = Timestamp.ofTimeMicroseconds((long)12345L);
        TimestampBound timestampBound = TimestampBound.ofReadTimestamp((Timestamp)timestamp);
        SpannerConfig spannerConfig = this.getSpannerConfig();
        PCollectionView tx = (PCollectionView)this.pipeline.apply("tx", (PTransform)SpannerIO.createTransaction().withSpannerConfig(spannerConfig).withTimestampBound(timestampBound));
        PCollection reads = (PCollection)this.pipeline.apply((PTransform)Create.of((Object)ReadOperation.create().withQuery("SELECT * FROM users"), (Object[])new ReadOperation[]{ReadOperation.create().withTable("users").withColumns(new String[]{"id", "name"})}));
        PCollection one = (PCollection)reads.apply("read all", (PTransform)SpannerIO.readAll().withSpannerConfig(spannerConfig).withTransaction(tx));
        FakeBatchTransactionId txId = new FakeBatchTransactionId("tx");
        Mockito.when((Object)this.mockBatchTx.getBatchTransactionId()).thenReturn((Object)txId);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction(timestampBound)).thenReturn((Object)this.mockBatchTx);
        Mockito.when((Object)this.serviceFactory.mockBatchClient().batchReadOnlyTransaction((BatchTransactionId)Matchers.any(BatchTransactionId.class))).thenReturn((Object)this.mockBatchTx);
        Partition fakePartition = FakePartitionFactory.createFakeReadPartition(ByteString.copyFromUtf8((String)"partition"));
        Mockito.when((Object)this.mockBatchTx.partitionQuery((PartitionOptions)Matchers.any(PartitionOptions.class), (Statement)Matchers.eq((Object)Statement.of((String)"SELECT * FROM users")), new Options.QueryOption[]{(Options.QueryOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(fakePartition, fakePartition));
        Mockito.when((Object)this.mockBatchTx.partitionRead((PartitionOptions)Matchers.any(PartitionOptions.class), (String)Matchers.eq((Object)"users"), (KeySet)Matchers.eq((Object)KeySet.all()), (Iterable)Matchers.eq(Arrays.asList("id", "name")), new Options.ReadOption[]{(Options.ReadOption)Matchers.any(Options.ReadQueryUpdateTransactionOption.class)})).thenReturn(Arrays.asList(fakePartition));
        Mockito.when((Object)this.mockBatchTx.execute((Partition)Matchers.any(Partition.class))).thenReturn((Object)ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(0, 2)), (Object[])new ResultSet[]{ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(2, 4)), ResultSets.forRows((Type)FAKE_TYPE, FAKE_ROWS.subList(4, 6))});
        PAssert.that((PCollection)one).containsInAnyOrder(FAKE_ROWS);
        this.pipeline.run();
    }
}

