/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ServiceFactory;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Spanner;
import org.apache.beam.sdk.io.gcp.spanner.FakeServiceFactory;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.options.ValueProvider;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class SpannerAccessorTest {
    private FakeServiceFactory serviceFactory;

    @Before
    public void setUp() throws Exception {
        this.serviceFactory = new FakeServiceFactory();
    }

    @Test
    public void testCreateOnlyOnce() {
        SpannerConfig config1 = SpannerConfig.create().toBuilder().setServiceFactory((ServiceFactory)this.serviceFactory).setProjectId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"project")).setInstanceId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"test1")).setDatabaseId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"test1")).build();
        SpannerAccessor acc1 = SpannerAccessor.getOrCreate((SpannerConfig)config1);
        SpannerAccessor acc2 = SpannerAccessor.getOrCreate((SpannerConfig)config1);
        SpannerAccessor acc3 = SpannerAccessor.getOrCreate((SpannerConfig)config1);
        acc1.close();
        acc2.close();
        acc3.close();
        ((Spanner)Mockito.verify((Object)this.serviceFactory.mockSpanner(), (VerificationMode)Mockito.times((int)1))).getDatabaseClient(DatabaseId.of((String)"project", (String)"test1", (String)"test1"));
        ((Spanner)Mockito.verify((Object)this.serviceFactory.mockSpanner(), (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testRefCountedSpannerAccessorDifferentDbsOnlyOnce() {
        SpannerConfig config1 = SpannerConfig.create().toBuilder().setServiceFactory((ServiceFactory)this.serviceFactory).setProjectId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"project")).setInstanceId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"test1")).setDatabaseId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"test1")).build();
        SpannerConfig config2 = config1.toBuilder().setInstanceId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"test2")).setDatabaseId((ValueProvider)ValueProvider.StaticValueProvider.of((Object)"test2")).build();
        SpannerAccessor acc1a = SpannerAccessor.getOrCreate((SpannerConfig)config1);
        SpannerAccessor acc1b = SpannerAccessor.getOrCreate((SpannerConfig)config1);
        SpannerAccessor acc2a = SpannerAccessor.getOrCreate((SpannerConfig)config2);
        SpannerAccessor acc2b = SpannerAccessor.getOrCreate((SpannerConfig)config2);
        acc1a.close();
        acc2a.close();
        acc1b.close();
        acc2b.close();
        ((Spanner)Mockito.verify((Object)this.serviceFactory.mockSpanner(), (VerificationMode)Mockito.times((int)1))).getDatabaseClient((DatabaseId)ArgumentMatchers.eq((Object)DatabaseId.of((String)"project", (String)"test1", (String)"test1")));
        ((Spanner)Mockito.verify((Object)this.serviceFactory.mockSpanner(), (VerificationMode)Mockito.times((int)1))).getDatabaseClient((DatabaseId)ArgumentMatchers.eq((Object)DatabaseId.of((String)"project", (String)"test2", (String)"test2")));
        ((Spanner)Mockito.verify((Object)this.serviceFactory.mockSpanner(), (VerificationMode)Mockito.times((int)2))).close();
    }
}

